------------------------------------------------------------------------------
-- profiler.sql
--
-- This module, along with plugin_profiler.c, implement an Oracle-compatible
-- version of the DBMS_PROFILER built-in package.
--
-- The API (functions, procedures, types, and tables) is compatible 
-- with the DBMS_PROFILER packaged shipped with Oracle 10g.
--
-- In addition to the plsql_profiler_data table, we add a much more detailed
-- table named plsql_profiler_rawdata. 
--
-- plsql_profiler_data is Oracle compatible and contains the execution count,
-- total time consumed, longest, and short executions for each line of code
-- profiled.
--
-- plsql_profiler_rawdata contains all of the above, plus the complete set 
-- of DRITA counters and times (wait events and wait event times) for each
-- line of code profiled.

CREATE OR REPLACE PACKAGE SYS.DBMS_PROFILER AS
	error_version CONSTANT INTEGER := -1;
	success       CONSTANT INTEGER := 0;
	error_param   CONSTANT INTEGER := 1;
	error_io	  CONSTANT INTEGER := 2;

	table_name    CONSTANT TEXT    := 'sys.plsql_profiler_rawdata';
	sequence_name CONSTANT TEXT    := 'sys.plsql_profiler_runid';

    FUNCTION  start_profiler(run_comment IN TEXT := sysdate, run_comment1 IN TEXT := '', run_number OUT INTEGER) RETURN INTEGER;
    PROCEDURE start_profiler(run_comment IN TEXT := sysdate, run_comment1 IN TEXT := '', run_number OUT INTEGER);
    FUNCTION  start_profiler(run_comment IN TEXT := sysdate, run_comment1 IN TEXT := '') RETURN INTEGER;
    PROCEDURE start_profiler(run_comment IN TEXT := sysdate, run_comment1 IN TEXT := '');
  
    FUNCTION  stop_profiler RETURN INTEGER;
    PROCEDURE stop_profiler;

  	FUNCTION  pause_profiler RETURN INTEGER;
	PROCEDURE pause_profiler;

    FUNCTION  resume_profiler RETURN INTEGER;
    PROCEDURE resume_profiler;

    FUNCTION  flush_data RETURN INTEGER;
    PROCEDURE flush_data;

	PROCEDURE GET_VERSION(major OUT INTEGER, minor OUT INTEGER);
	FUNCTION INTERNAL_VERSION_CHECK RETURN INTEGER;

	-- API extensions

    PROCEDURE _install;
	PROCEDURE _reset;
END;
