--Adjust this setting to control where the objects get created.
SET search_path = sys;

CREATE OR REPLACE PACKAGE dbms_scheduler AUTHID DEFINER IS

  -- PROGRAM
  PROCEDURE create_program(
    program_name        IN VARCHAR2,
    program_type        IN VARCHAR2,
    program_action      IN VARCHAR2,
    number_of_arguments IN PLS_INTEGER DEFAULT 0,
    enabled             IN BOOLEAN DEFAULT FALSE,
    comments            IN VARCHAR2 DEFAULT NULL);

  PROCEDURE drop_program(
    program_name IN VARCHAR2,
    force        IN BOOLEAN DEFAULT FALSE);

  PROCEDURE define_program_argument(
    program_name      IN VARCHAR2,
    argument_position IN PLS_INTEGER,
    argument_name     IN VARCHAR2 DEFAULT NULL,
    argument_type     IN VARCHAR2,
    default_value     IN VARCHAR2,
    out_argument      IN BOOLEAN DEFAULT FALSE);

  PROCEDURE define_program_argument(
    program_name      IN VARCHAR2,
    argument_position IN PLS_INTEGER,
    argument_name     IN VARCHAR2 DEFAULT NULL,
    argument_type     IN VARCHAR2,
    out_argument      IN BOOLEAN DEFAULT FALSE);

  PROCEDURE drop_program_argument(
    program_name      IN VARCHAR2,
    argument_position IN PLS_INTEGER);

  PROCEDURE drop_program_argument(
    program_name  IN VARCHAR2,
    argument_name IN VARCHAR2);

  -- SCHEDULE
  PROCEDURE create_schedule(
    schedule_name   IN VARCHAR2,
    start_date      IN TIMESTAMP WITH TIME ZONE DEFAULT NULL,
    repeat_interval IN VARCHAR2,
    end_date        IN TIMESTAMP WITH TIME ZONE DEFAULT NULL,
    comments        IN VARCHAR2 DEFAULT NULL);

  PROCEDURE drop_schedule(
    schedule_name IN VARCHAR2,
    force         IN BOOLEAN DEFAULT FALSE);

  -- Returns next run date for given calender_string (or repeat_interval)
  PROCEDURE evaluate_calendar_string(
    calendar_string   IN VARCHAR2,
    start_date        IN TIMESTAMP WITH TIME ZONE,
    return_date_after IN TIMESTAMP WITH TIME ZONE,
    next_run_date     OUT TIMESTAMP WITH TIME ZONE);

  -- JOB
  PROCEDURE create_job(
    job_name            IN VARCHAR2,
    job_type            IN VARCHAR2,
    job_action          IN VARCHAR2,
    number_of_arguments IN PLS_INTEGER DEFAULT 0,
    start_date          IN TIMESTAMP WITH TIME ZONE DEFAULT NULL,
    repeat_interval     IN VARCHAR2 DEFAULT NULL,
    end_date            IN TIMESTAMP WITH TIME ZONE DEFAULT NULL,
    -- Not supported in this version
    job_class           IN VARCHAR2 DEFAULT 'DEFAULT_JOB_CLASS',
    enabled             IN BOOLEAN DEFAULT FALSE,
    -- Not supported in this version
    auto_drop           IN BOOLEAN DEFAULT TRUE,
    comments            IN VARCHAR2 DEFAULT NULL);

  PROCEDURE create_job(
    job_name      IN VARCHAR2,
    program_name  IN VARCHAR2,
    schedule_name IN VARCHAR2,
    -- Not supported in this version
    job_class     IN VARCHAR2 DEFAULT 'DEFAULT_JOB_CLASS',
    enabled       IN BOOLEAN DEFAULT FALSE,
    -- Not supported in this version
    auto_drop     IN BOOLEAN DEFAULT TRUE,
    comments      IN VARCHAR2 DEFAULT NULL);

  --PROCEDURE stop_job(
  --  job_name         IN VARCHAR2,
  --  force            IN BOOLEAN DEFAULT FALSE,
    -- In this phase, we are executing job as definer user
  --  commit_semantics IN VARCHAR2 DEFAULT 'STOP_ON_FIRST_ERROR');

  PROCEDURE run_job(
    job_name            IN VARCHAR2,
    -- In this phase, we are executing job as definer user
    use_current_session IN BOOLEAN DEFAULT TRUE,
    -- EDB: This column added into EDB version of dbms_scheduler, just to know
    -- whether run_job called manually or its part of pgAgent call.
    manually            IN BOOLEAN DEFAULT TRUE);

  PROCEDURE drop_job(
    job_name          IN VARCHAR2,
    force             IN BOOLEAN      DEFAULT FALSE,
    -- Not supported in this version
    defer             IN BOOLEAN      DEFAULT FALSE,
    -- Not supported in this version
     commit_semantics IN VARCHAR2 DEFAULT 'STOP_ON_FIRST_ERROR');

  PROCEDURE set_job_argument_value(
    job_name          IN VARCHAR2,
    argument_position IN PLS_INTEGER,
    argument_value    IN VARCHAR2);

  PROCEDURE set_job_argument_value(
    job_name       IN VARCHAR2,
    argument_name  IN VARCHAR2,
    argument_value IN VARCHAR2);

  -- Disable program or job
   PROCEDURE disable(
    name                   IN VARCHAR2,
    force                  IN BOOLEAN DEFAULT FALSE,
    commit_semantics       IN VARCHAR2 DEFAULT 'STOP_ON_FIRST_ERROR');

  -- Enable program or job
  PROCEDURE enable(
    name                  IN VARCHAR2,
    commit_semantics      IN VARCHAR2 DEFAULT 'STOP_ON_FIRST_ERROR');

END dbms_scheduler;
