--Adjust this setting to control where the objects get created.
SET search_path = sys;

CREATE OR REPLACE PACKAGE dbms_sql AUTHID CURRENT_USER IS
	NATIVE INTEGER 	:= 1;
	V6 INTEGER := 0;
	V7 INTEGER := 2;

	TYPE DESC_REC IS RECORD (
		col_type 			BINARY_INTEGER,
		col_max_len 		BINARY_INTEGER,
		col_name 			VARCHAR2(128),
		col_name_len 		BINARY_INTEGER,
		col_schema_name 	VARCHAR2(128),
		col_schema_name_len BINARY_INTEGER,
		col_precision 		BINARY_INTEGER,
		col_scale 			BINARY_INTEGER,
		col_charsetid 		BINARY_INTEGER,
		col_charsetform 	BINARY_INTEGER,
		col_null_ok 		BOOLEAN
	);

	TYPE DESC_TAB IS TABLE OF DESC_REC%rowtype INDEX BY BINARY_INTEGER;

	FUNCTION OPEN_CURSOR() RETURN INTEGER;
	FUNCTION IS_OPEN(c INTEGER) RETURN BOOLEAN;

	PROCEDURE PARSE(c INTEGER, statement VARCHAR(32672), language_flag integer);

	PROCEDURE BIND_VARIABLE(c INTEGER, name VARCHAR(128), value INTEGER);
    PROCEDURE BIND_VARIABLE(c INTEGER, name VARCHAR(128), value TEXT, outsize INTEGER);
    PROCEDURE BIND_VARIABLE_CHAR(c INTEGER, name VARCHAR(128), value CHAR, outsize INTEGER DEFAULT NULL);
    PROCEDURE BIND_VARIABLE(c INTEGER, name VARCHAR(128), value TIMESTAMP);
    PROCEDURE BIND_VARIABLE(c INTEGER, name VARCHAR(128), value	NUMBER);
    PROCEDURE BIND_VARIABLE(c INTEGER, name VARCHAR(128), value	FLOAT);
    PROCEDURE BIND_VARIABLE(c INTEGER, name VARCHAR(128), value BLOB, outsize INTEGER DEFAULT NULL);
	PROCEDURE BIND_VARIABLE(c INTEGER, name	VARCHAR(128), value CLOB, outsize INTEGER DEFAULT NULL);
    PROCEDURE BIND_VARIABLE_RAW(c INTEGER, name VARCHAR(128), value BLOB, outsize INTEGER DEFAULT NULL);

	PROCEDURE DEFINE_COLUMN(c INTEGER, pos INTEGER, col INTEGER);
	PROCEDURE DEFINE_COLUMN(c INTEGER, pos INTEGER, col TEXT, col_size INTEGER DEFAULT NULL);
	PROCEDURE DEFINE_COLUMN_CHAR(c INTEGER, pos INTEGER, col CHAR, col_size INTEGER DEFAULT NULL);
	PROCEDURE DEFINE_COLUMN(c INTEGER, pos INTEGER, col TIMESTAMP);
	PROCEDURE DEFINE_COLUMN(c INTEGER, pos INTEGER, col NUMBER);
	PROCEDURE DEFINE_COLUMN(c INTEGER, pos INTEGER, col FLOAT);
    PROCEDURE DEFINE_COLUMN(c INTEGER, pos INTEGER, col BLOB, col_size INTEGER);
--    PROCEDURE DEFINE_COLUMN(c INTEGER, pos INTEGER, col CLOB, col_size INTEGER);
    PROCEDURE DEFINE_COLUMN_RAW(c INTEGER, pos INTEGER, col BLOB, col_size INTEGER);

	PROCEDURE COLUMN_VALUE(c INTEGER, pos INTEGER, value OUT INTEGER);
	PROCEDURE COLUMN_VALUE(c INTEGER, pos INTEGER, value OUT INTEGER, column_error OUT NUMBER);
	PROCEDURE COLUMN_VALUE(c INTEGER, pos INTEGER, value OUT INTEGER, actual_length OUT INTEGER);
	PROCEDURE COLUMN_VALUE(c INTEGER, pos INTEGER, value OUT INTEGER, column_error OUT NUMBER, actual_length OUT INTEGER);

	PROCEDURE COLUMN_VALUE(c INTEGER, pos INTEGER, value OUT TEXT);
	PROCEDURE COLUMN_VALUE(c INTEGER, pos INTEGER, value OUT TEXT, column_error OUT NUMBER);
	PROCEDURE COLUMN_VALUE(c INTEGER, pos INTEGER, value OUT TEXT, actual_length OUT INTEGER);
	PROCEDURE COLUMN_VALUE(c INTEGER, pos INTEGER, value OUT TEXT, column_error OUT NUMBER, actual_length OUT INTEGER);

    PROCEDURE COLUMN_VALUE_CHAR(c INTEGER, pos INTEGER, value OUT CHAR);
    PROCEDURE COLUMN_VALUE_CHAR(c INTEGER, pos INTEGER, value OUT CHAR, column_error OUT NUMBER);
    PROCEDURE COLUMN_VALUE_CHAR(c INTEGER, pos INTEGER, value OUT CHAR, actual_length OUT INTEGER);
    PROCEDURE COLUMN_VALUE_CHAR(c INTEGER, pos INTEGER, value OUT CHAR, column_error OUT NUMBER, actual_length OUT INTEGER);

    PROCEDURE COLUMN_VALUE(c INTEGER, pos INTEGER, value OUT NUMBER);
    PROCEDURE COLUMN_VALUE(c INTEGER, pos INTEGER, value OUT NUMBER, column_error OUT NUMBER);
    PROCEDURE COLUMN_VALUE(c INTEGER, pos INTEGER, value OUT NUMBER, column_error OUT NUMBER, actual_length OUT INTEGER);
    PROCEDURE COLUMN_VALUE(c INTEGER, pos INTEGER, value OUT NUMBER, actual_length OUT INTEGER);

    PROCEDURE COLUMN_VALUE(c INTEGER, pos INTEGER, value OUT FLOAT);
    PROCEDURE COLUMN_VALUE(c INTEGER, pos INTEGER, value OUT FLOAT, column_error OUT NUMBER);
    PROCEDURE COLUMN_VALUE(c INTEGER, pos INTEGER, value OUT FLOAT, column_error OUT NUMBER, actual_length OUT INTEGER);
    PROCEDURE COLUMN_VALUE(c INTEGER, pos INTEGER, value OUT FLOAT, actual_length OUT INTEGER);

    PROCEDURE COLUMN_VALUE(c INTEGER, pos INTEGER, value OUT TIMESTAMP);
    PROCEDURE COLUMN_VALUE(c INTEGER, pos INTEGER, value OUT TIMESTAMP,	column_error OUT NUMBER);
    PROCEDURE COLUMN_VALUE(c INTEGER, pos INTEGER, value OUT TIMESTAMP,	column_error OUT NUMBER, actual_length OUT INTEGER);
    PROCEDURE COLUMN_VALUE(c INTEGER, pos INTEGER, value OUT TIMESTAMP,	actual_length OUT INTEGER);

    PROCEDURE COLUMN_VALUE(c INTEGER, pos INTEGER, value OUT BLOB);
    PROCEDURE COLUMN_VALUE(c INTEGER, pos INTEGER, value OUT BLOB, column_error OUT NUMBER);
    PROCEDURE COLUMN_VALUE(c INTEGER, pos INTEGER, value OUT BLOB, actual_length OUT INTEGER);
    PROCEDURE COLUMN_VALUE(c INTEGER, pos INTEGER, value OUT BLOB, column_error OUT NUMBER, actual_length OUT INTEGER);

--    PROCEDURE COLUMN_VALUE(c INTEGER, pos INTEGER, value OUT CLOB);
--    PROCEDURE COLUMN_VALUE(c INTEGER, pos INTEGER, value OUT CLOB, column_error OUT NUMBER);
--    PROCEDURE COLUMN_VALUE(c INTEGER, pos INTEGER, value OUT CLOB, actual_length OUT INTEGER);
--    PROCEDURE COLUMN_VALUE(c INTEGER, pos INTEGER, value OUT CLOB, column_error OUT NUMBER, actual_length OUT INTEGER);

    PROCEDURE COLUMN_VALUE_RAW(c INTEGER, pos INTEGER, value OUT BLOB);
    PROCEDURE COLUMN_VALUE_RAW(c INTEGER, pos INTEGER, value OUT BLOB, column_error OUT NUMBER);
    PROCEDURE COLUMN_VALUE_RAW(c INTEGER, pos INTEGER, value OUT BLOB, actual_length OUT INTEGER);
    PROCEDURE COLUMN_VALUE_RAW(c INTEGER, pos INTEGER, value OUT BLOB, column_error OUT NUMBER, actual_length OUT INTEGER);


	FUNCTION EXECUTE(c INTEGER) RETURN INTEGER;

	FUNCTION FETCH_ROWS (c INTEGER) RETURN INTEGER;

	FUNCTION EXECUTE_AND_FETCH (c IN INTEGER, exact IN BOOLEAN DEFAULT FALSE) RETURN INTEGER;

	FUNCTION LAST_ROW_COUNT() RETURN INTEGER;

	PROCEDURE CLOSE_CURSOR(c    IN OUT INTEGER);

	PROCEDURE BIND_VARIABLE(c INTEGER, name VARCHAR(128), value TEXT);

	PROCEDURE DESCRIBE_COLUMNS(c INTEGER, col_cnt OUT INTEGER, desc_t OUT DESC_TAB);

END;
