--Adjust this setting to control where the objects get created.
SET search_path = sys;

CREATE OR REPLACE PACKAGE dbms_utility  AUTHID CURRENT_USER IS

	STATE_START								CONSTANT SMALLINT := 0;
	STATE_QUOTE_START						CONSTANT SMALLINT := 1;
	STATE_QUOTE_END							CONSTANT SMALLINT := 2;
	STATE_STRING_START						CONSTANT SMALLINT := 3;
	STATE_SPACE_AT_END						CONSTANT SMALLINT := 4;
	STATE_UNDERSCORE						CONSTANT SMALLINT := 5;
	STATE_INT_START							CONSTANT SMALLINT := 6;

	DELIMITER_TYPE_EMPTY					CONSTANT SMALLINT := 0;
	DELIMITER_TYPE_INVALID					CONSTANT SMALLINT := 1;
	DELIMITER_TYPE_SPACE					CONSTANT SMALLINT := 2;
	DELIMITER_TYPE_END						CONSTANT SMALLINT := 3;
	DELIMITER_TYPE_DOT						CONSTANT SMALLINT := 4;
	DELIMITER_TYPE_AT						CONSTANT SMALLINT := 5;
	DELIMITER_TYPE_COMMA					CONSTANT SMALLINT := 6;

	TOKEN_TYPE_INVALID 						CONSTANT SMALLINT := 0;
	TOKEN_TYPE_INVALID_MISSING_DOUBLE_QUOTE CONSTANT SMALLINT := 1;
	TOKEN_TYPE_INVALID_MISSING_PERIOD 		CONSTANT SMALLINT := 2;
	TOKEN_TYPE_INVALID_CHARACTER 			CONSTANT SMALLINT := 3;
	TOKEN_TYPE_INVALID_IDENTIFIER_TOO_LONG 	CONSTANT SMALLINT := 4;
	TOKEN_TYPE_QUOTED 						CONSTANT SMALLINT := 5;
	TOKEN_TYPE_STRING 						CONSTANT SMALLINT := 6;
	TOKEN_TYPE_INTEGER 						CONSTANT SMALLINT := 7;

	OPTION_ENABLED							CONSTANT CHAR	  := 'E';
	OPTION_DISABLED							CONSTANT CHAR	  := 'D';
	OPTION_SET								CONSTANT CHAR	  := 'S';

	MAX_IDENTIFIER_LENGTH					CONSTANT SMALLINT := 128;

	TYPE dblink_array	  IS TABLE OF VARCHAR2(128) 	INDEX BY BINARY_INTEGER;
	TYPE index_table_type IS TABLE OF BINARY_INTEGER 	INDEX BY BINARY_INTEGER;
	TYPE instance_record  IS RECORD (inst_number NUMBER, inst_name VARCHAR2(60));
	TYPE instance_table	  IS TABLE OF instance_record 	INDEX BY BINARY_INTEGER;
	TYPE lname_array	  IS TABLE OF VARCHAR2(4000) 	INDEX BY BINARY_INTEGER;
	TYPE name_array		  IS TABLE OF VARCHAR2(30) 		INDEX BY BINARY_INTEGER;
	TYPE number_array	  IS TABLE OF NUMBER 			INDEX BY BINARY_INTEGER;
	TYPE uncl_array		  IS TABLE OF VARCHAR2(227) 	INDEX BY BINARY_INTEGER;

	FUNCTION GET_TIME() RETURN NUMBER;
	FUNCTION GET_CPU_TIME() RETURN NUMBER;
	FUNCTION GET_HASH_VALUE(name VARCHAR2, base NUMBER, hash_size NUMBER) RETURN NUMBER;

	PROCEDURE COMMA_TO_TABLE(list VARCHAR2, tablen OUT INTEGER, tab OUT LNAME_ARRAY);
	PROCEDURE COMMA_TO_TABLE(list VARCHAR2, tablen OUT INTEGER, tab OUT UNCL_ARRAY);
	PROCEDURE TABLE_TO_COMMA(tab DBMS_UTILITY.LNAME_ARRAY, tablen OUT INTEGER, list OUT VARCHAR2);
	PROCEDURE TABLE_TO_COMMA(tab DBMS_UTILITY.UNCL_ARRAY, tablen OUT INTEGER, list OUT VARCHAR2);
	PROCEDURE CANONICALIZE(name VARCHAR2, canon_name OUT VARCHAR2, canon_len INTEGER);
	PROCEDURE NAME_TOKENIZE(name VARCHAR2, a OUT VARCHAR2, b OUT VARCHAR2, c OUT VARCHAR2, dblink OUT VARCHAR2, nextPosition OUT INTEGER);
	PROCEDURE EXEC_DDL_STATEMENT (parse_string VARCHAR2);
	PROCEDURE GET_PARAMETER_VALUE(parname VARCHAR2, intval OUT INTEGER, strval OUT VARCHAR2);
	PROCEDURE DB_VERSION(version_l OUT VARCHAR2, compatibility OUT VARCHAR2);
	PROCEDURE GET_DEPENDENCY(objectType VARCHAR2, schemaName VARCHAR2, objectName VARCHAR2);
	PROCEDURE ANALYZE_DATABASE(method VARCHAR2, estimateRows NUMBER DEFAULT NULL, estimatePercent NUMBER DEFAULT NULL, methodOpt VARCHAR2 DEFAULT NULL);
	PROCEDURE ANALYZE_SCHEMA(schemaName VARCHAR2, method VARCHAR2, estimateRows NUMBER DEFAULT NULL, estimatePercent NUMBER DEFAULT NULL, methodOpt VARCHAR2 DEFAULT NULL);
	PROCEDURE ANALYZE_PART_OBJECT(schemaName VARCHAR2, objectName VARCHAR2, objectType CHAR DEFAULT 'T', commandType CHAR DEFAULT 'E', commandOpt VARCHAR2 DEFAULT NULL, sampleClause VARCHAR2 DEFAULT 'SAMPLE 5 PERCENT');
	FUNCTION format_call_stack() RETURN text;

END; 
-- END Package dbms_utility

