
-- Adjust this setting to control where the objects get created.
SET search_path = pg_catalog;

--
--	Input and output functions
--
CREATE OR REPLACE FUNCTION  get_env(ev text) RETURNS TEXT
AS '$libdir/edb_gen'
LANGUAGE C;

CREATE OR REPLACE FUNCTION  get_totmem() RETURNS FLOAT
AS '$libdir/edb_gen'
LANGUAGE C;

CREATE OR REPLACE FUNCTION edb_get_sys_info(
	OUT os                      TEXT,
	OUT number_of_processors    TEXT,
	OUT processor_architecture  TEXT,
	OUT processor_type          TEXT,
	OUT ram_gb                  float,
	OUT disk_gb                 float
) RETURNS RECORD AS $$

DECLARE
var number(6,1);

BEGIN
    os                      :=  get_env('OS');
    number_of_processors    :=  get_env('NUMBER_OF_PROCESSORS');
    processor_architecture  :=  get_env('PROCESSOR_ARCHITECTURE');
    processor_type          :=  get_env('PROCESSOR_IDENTIFIER');
    var                     :=  get_totmem(); 
	ram_gb := var;
    var                    :=  (SELECT NVL(SUM(pg_database_size(oid)),0)/(1024*1024*1024) + 0.05 FROM pg_database);
	disk_gb = var; 
	if disk_gb < 0.1 THEN disk_gb = 0.1; END IF;
END;
$$ LANGUAGE plpgsql;
							
CREATE OR REPLACE FUNCTION nvl2(anyelement, anyelement, anyelement) 
RETURNS anyelement
AS '$libdir/edb_gen','ora_nvl2' 
LANGUAGE C IMMUTABLE;
COMMENT ON FUNCTION nvl2(anyelement, anyelement, anyelement) IS '';

CREATE OR REPLACE FUNCTION pg_catalog.add_months(day timestamp, value number)
RETURNS timestamp
AS '$libdir/edb_gen'
LANGUAGE C IMMUTABLE STRICT;
COMMENT ON FUNCTION pg_catalog.add_months(timestamp, number) IS 'returns date plus n months';

CREATE OR REPLACE FUNCTION pg_catalog.last_day(value timestamp) 
RETURNS timestamp
AS '$libdir/edb_gen'
LANGUAGE C IMMUTABLE STRICT;
COMMENT ON FUNCTION pg_catalog.last_day(timestamp) IS 'returns last day of the month based on a date value';

CREATE OR REPLACE FUNCTION pg_catalog.months_between(date1 timestamp, date2 timestamp)
RETURNS numeric(9,0)
AS '$libdir/edb_gen'
LANGUAGE C IMMUTABLE STRICT;
COMMENT ON FUNCTION pg_catalog.months_between(timestamp, timestamp) IS 'returns the number of months between date1 and date2';

CREATE OR REPLACE FUNCTION pg_catalog.next_day(value timestamp, weekday text)
RETURNS timestamp
AS '$libdir/edb_gen'
LANGUAGE C IMMUTABLE STRICT;
COMMENT ON FUNCTION pg_catalog.next_day (timestamp, text) IS 'returns the first weekday that is greather than a date value';
