/*-------------------------------------------------------------------------
 * edb_infinitecache: edb_infinitecache.sql.in
 *
 * Copyright (c) 2008-2013, EnterpriseDB Corporation 
 * IDENTIFICATION
 *                      $PostgreSQL$
 *-------------------------------------------------------------------------
 */

-- Adjust this setting to control where the objects get created.
SET search_path = pg_catalog;

BEGIN;

CREATE OR REPLACE FUNCTION edb_icache_warm(rel regclass)
RETURNS VOID
LANGUAGE C STRICT
AS '$libdir/edb_infinitecache', 'edb_icache_warm_all';
COMMENT ON FUNCTION edb_icache_warm(regclass) IS 'add buffers belonging to a relation to icache servers';

CREATE OR REPLACE FUNCTION edb_icache_warm(rel regclass, startoff bigint, endoff bigint)
RETURNS VOID
LANGUAGE C STRICT
AS '$libdir/edb_infinitecache', 'edb_icache_warm_range';
COMMENT ON FUNCTION edb_icache_warm(regclass, bigint, bigint) IS 'add specified range of buffers belonging to a relation to icache servers';

-- Register the stats function.
CREATE OR REPLACE FUNCTION edb_icache_stats(OUT hostname TEXT, OUT port INT4,
	OUT state TEXT, OUT write_failures INT4, OUT bytes INT8, OUT bytes_read INT8, OUT bytes_written
	INT8, OUT cmd_get INT8, OUT cmd_set INT8, OUT connection_structures INT4,
	OUT curr_connections INT4, OUT curr_items INT4, OUT evictions INT8, OUT
	get_hits INT8, OUT get_misses INT8, OUT limit_maxbytes INT8, OUT pid INT4,
	OUT pointer_size INT4, OUT rusage_user FLOAT8, OUT rusage_system FLOAT8, OUT
	threads INT4, OUT total_time INT4, OUT total_connections INT4, OUT total_items INT4,
	OUT uptime INT4, OUT version TEXT)
RETURNS SETOF RECORD
LANGUAGE C STRICT
AS '$libdir/edb_infinitecache', 'edb_icache_stats';

CREATE OR REPLACE FUNCTION edb_icache_server_enable(hostname TEXT, port INT4, online BOOL)
RETURNS VOID 
LANGUAGE C STRICT
AS '$libdir/edb_infinitecache', 'edb_icache_server_enable';
COMMENT ON FUNCTION edb_icache_server_enable(TEXT, INT4, BOOL) IS 'enable or disable an icache server';

-- Create a view for convenient access.
CREATE OR REPLACE VIEW edb_icache_server_list AS 
	SELECT hostname, port, state, write_failures, limit_maxbytes total_memory,
		bytes memory_used, (limit_maxbytes - bytes) memory_free, 
		CAST((get_hits / (cmd_get+1.0) * 100.0) AS NUMBER(5,2)) hit_ratio
	FROM edb_icache_stats();

-- Don't want these to be available to public. Remove comments if needed
--REVOKE ALL ON FUNCTION edb_icache_stats() FROM PUBLIC;
--REVOKE ALL ON edb_icache_server_list FROM PUBLIC;
--REVOKE ALL ON FUNCTION edb_icache_warm(rel regclass) FROM PUBLIC;
--REVOKE ALL ON FUNCTION edb_icache_warm(rel regclass, startoff bigint, endoff bigint) FROM PUBLIC;
--REVOKE ALL ON FUNCTION edb_icache_server_enable(host text, port int4, online bool) FROM PUBLIC;

COMMIT;
