-- Adjust this setting to control where the objects get created.
SET search_path = sys;

-- First define a helper function, split_to_lines, which we will use
-- in the *_source views.

CREATE TYPE lineno_text AS
(
	line int,
	text text
);

CREATE OR REPLACE FUNCTION split_to_lines(src text)
RETURNS setof lineno_text
AS '$libdir/edb_gen','split_to_lines'
LANGUAGE C IMMUTABLE STRICT;

GRANT EXECUTE ON FUNCTION split_to_lines(src text) TO PUBLIC;	


CREATE OR REPLACE VIEW dba_source AS
SELECT quote_ident_upper(u.rolname) AS owner,
       quote_ident_upper(n.nspname) AS schema_name,
       quote_ident_upper(proname)   AS name,
       CASE WHEN protype = '0' THEN 'FUNCTION'::text
            ELSE 'PROCEDURE'::text
       END                          AS type,
       (p.lt).line                  AS line,
       (p.lt).text                  AS text
FROM   (SELECT proname, pronamespace, proowner, protype, prorettype,
               proargtypes, proisagg,
               split_to_lines(edb_get_functiondef(oid)) AS lt
         FROM   pg_proc
       ) p
       INNER JOIN pg_namespace n ON n.oid = p.pronamespace
       INNER JOIN pg_authid u ON u.oid = p.proowner
WHERE  n.nspparent = 0 AND               -- Filter out packaged functions/procs
       p.prorettype <> 'pg_catalog.cstring'::pg_catalog.regtype AND
       (p.proargtypes[0] IS NULL OR p.proargtypes[0] <> 'pg_catalog.cstring'::pg_catalog.regtype) AND
       NOT p.proisagg
UNION ALL
SELECT quote_ident_upper(u.rolname) AS owner,
       quote_ident_upper(s.nspname) AS schema_name,
       quote_ident_upper(n.nspname) AS name,
       'PACKAGE'::text              AS type,
       (n.lt).line                  AS line,
       (n.lt).text                  AS text
FROM   (SELECT nspname, nspowner, nspparent,
               split_to_lines(pg_catalog.edb_get_packageheaddef(oid)) AS lt
        FROM   pg_namespace
        WHERE  (nspparent <> 0) AND (nspobjecttype = 0)
       ) n
       INNER JOIN pg_namespace s ON s.oid = n.nspparent
       INNER JOIN pg_authid u ON u.oid = n.nspowner
UNION ALL
SELECT quote_ident_upper(u.rolname) AS owner,
       quote_ident_upper(s.nspname) AS schema_name,
       quote_ident_upper(n.nspname) AS name,
       'PACKAGE BODY'::text         AS type,
       (n.lt).line                  AS line,
       (n.lt).text                  AS text
FROM   (SELECT nspname, nspowner, nspparent,
               split_to_lines(pg_catalog.edb_get_packagebodydef(oid)) AS lt
        FROM   pg_namespace
        WHERE  nspparent <> 0 AND nspobjecttype = 0 AND nspbodysrc IS NOT NULL
       ) n
       INNER JOIN pg_namespace s ON s.oid = n.nspparent
       INNER JOIN pg_authid u ON u.oid = n.nspowner
UNION ALL
SELECT quote_ident_upper(u.rolname) AS owner,
       quote_ident_upper(s.nspname) AS schema_name,
       quote_ident_upper(n.nspname) AS name,
       'TYPE'::text                 AS type,
       (n.lt).line                  AS line,
       (n.lt).text                  AS text
FROM   (SELECT nspname, nspowner, nspparent,
               split_to_lines(pg_catalog.edb_get_objecttypeheaddef(pt.oid)) AS lt
        FROM   pg_namespace, pg_type pt
        WHERE  (nspobjecttype <> 0)
       ) n
       INNER JOIN pg_namespace s ON s.oid = n.nspparent
       INNER JOIN pg_authid u ON u.oid = n.nspowner
UNION ALL
SELECT quote_ident_upper(u.rolname) AS owner,
       quote_ident_upper(s.nspname) AS schema_name,
       quote_ident_upper(n.nspname) AS name,
       'TYPE BODY'::text            AS type,
       (n.lt).line                  AS line,
       (n.lt).text                  AS text
FROM   (SELECT nspname, nspowner, nspparent,
               split_to_lines(pg_catalog.edb_get_objecttypebodydef(pt.oid)) AS lt
        FROM   pg_namespace, pg_type pt
        WHERE  nspobjecttype <> 0 AND nspbodysrc IS NOT NULL
       ) n
       INNER JOIN pg_namespace s ON s.oid = n.nspparent
       INNER JOIN pg_authid u ON u.oid = n.nspowner
UNION ALL
SELECT quote_ident_upper(u.rolname) AS owner,
       quote_ident_upper(n.nspname) AS schema_name,
       quote_ident_upper(tgname)    AS name,
       'TRIGGER'::text              AS type,
       (p.lt).line                  AS line,
       (p.lt).text                  AS text
FROM   (SELECT tgname, pronamespace, proowner, protype, prorettype,
               proargtypes, proisagg,
               split_to_lines(edb_get_functiondef(p.oid)) AS lt
        FROM   pg_proc p, pg_trigger t
        WHERE  p.oid = t.tgfoid
       ) p
       INNER JOIN pg_namespace n ON n.oid = p.pronamespace
       INNER JOIN pg_authid u ON u.oid = p.proowner
WHERE  n.nspparent = 0 AND               -- Filter out packaged functions/procs
       p.prorettype <> 'pg_catalog.cstring'::pg_catalog.regtype AND
       (p.proargtypes[0] IS NULL OR p.proargtypes[0] <> 'pg_catalog.cstring'::pg_catalog.regtype) AND
       NOT p.proisagg
;

CREATE VIEW user_source AS 
SELECT schema_name, name, type, line, text
FROM   dba_source
WHERE  dba_source.owner = quote_ident_upper(current_user);

-- Our definition of all_source is actually not quite right. It's supposed
-- to return only stuff that's accessible to the current user.
CREATE VIEW all_source AS SELECT * FROM dba_source;

GRANT SELECT ON user_source TO PUBLIC;
GRANT SELECT ON all_source TO PUBLIC; 

-- disallow removal of system views
insert into pg_depend values (0,0,0,
    (select oid from pg_class where relname = 'pg_class'),
    (select oid from pg_class where relname = 'all_source'), 0, 'p');

insert into pg_depend values (0,0,0,
    (select oid from pg_class where relname = 'pg_class'),
    (select oid from pg_class where relname = 'user_source'), 0, 'p');

insert into pg_depend values (0,0,0,
    (select oid from pg_class where relname = 'pg_class'),
    (select oid from pg_class where relname = 'dba_source'), 0, 'p');
