-- 03/2008 - If creating these tables in a Postgres Plus database, comment out the following line.
SET search_path = sys;
--------------------------------------------------------------------------------------------------

CREATE SEQUENCE snapshot_num_seq
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1
  CACHE 1;

CREATE TABLE edb$snap (
     edb_id        bigint,
     dbname        name,
     snap_tm       timestamp without time zone,
     start_tm      timestamp without time zone,
     backend_id    bigint,
     comment       text,
     baseline_ind  character(1),
constraint snap_pk primary key (edb_id)
);

CREATE TABLE edb$system_waits (
     edb_id      bigint,
     dbname      name,
     wait_name   text,
     wait_count  bigint,
     avg_wait    numeric,
     max_wait    numeric(50,6),
     totalwait   numeric(50,6),
constraint system_waits_pk primary key (edb_id,dbname,wait_name)
);


CREATE TABLE edb$session_waits (
     edb_id           bigint,
     dbname           name,
     backend_id       bigint,
     wait_name        text,
     wait_count       bigint,
     avg_wait_time    numeric,
     max_wait_time    numeric(50,6),
     total_wait_time  numeric(50,6),
     usename          name,
     query    text,
constraint session_waits_pk primary key (edb_id,dbname,backend_id,wait_name)
);

CREATE TABLE edb$session_wait_history (
     edb_id      bigint,
     dbname      name,
     backend_id  bigint,
     seq         bigint,
     wait_name   text,
     elapsed     bigint,
     p1          bigint,
     p2          bigint,
     p3          bigint,
constraint session_waits_hist_pk primary key (edb_id,dbname,backend_id,seq)
);

-- Tables added Jan 2008
-- P. Steinheuser

CREATE TABLE edb$stat_all_indexes (
     edb_id         bigint NOT NULL,
     dbname         name NOT NULL,
     relid          oid NOT NULL,
     indexrelid     oid NOT NULL,
     schemaname     name,
     relname        name,
     indexrelname   name,
     idx_scan       bigint,
     idx_tup_read   bigint,
     idx_tup_fetch  bigint,
CONSTRAINT edb$stat_idx_pk PRIMARY KEY (edb_id, dbname, relid, indexrelid));

CREATE TABLE edb$stat_all_tables (
     edb_id            bigint NOT NULL,
     dbname            name NOT NULL,
     relid             oid NOT NULL,
     schemaname        name,
     relname           name,
     seq_scan          bigint,
     seq_tup_read      bigint,
     idx_scan          bigint,
     idx_tup_fetch     bigint,
     n_tup_ins         bigint,
     n_tup_upd         bigint,
     n_tup_del         bigint,
     last_vacuum       timestamp with time zone,
     last_autovacuum   timestamp with time zone,
     last_analyze      timestamp with time zone,
     last_autoanalyze  timestamp with time zone,
    CONSTRAINT edb$stat_tab_pk PRIMARY KEY (edb_id, dbname, relid));

CREATE TABLE edb$stat_database (
     edb_id         bigint NOT NULL,
     dbname         name NOT NULL,
     datid          oid NOT NULL,
     datname        name,
     numbackends    integer,
     xact_commit    bigint,
     xact_rollback  bigint,
     blks_read      bigint,
     blks_hit       bigint,
     blks_icache_hit bigint,
    CONSTRAINT edb$stat_db_pk PRIMARY KEY (edb_id, dbname, datid));

CREATE TABLE edb$statio_all_indexes (
     edb_id         bigint NOT NULL,
     dbname         name NOT NULL,
     relid          oid NOT NULL,
     indexrelid     oid NOT NULL,
     schemaname     name,
     relname        name,
     indexrelname   name,
     idx_blks_read  bigint,
     idx_blks_hit   bigint,
     idx_blks_icache_hit bigint,
    CONSTRAINT edb$statio_idx_pk PRIMARY KEY (edb_id, dbname, relid, indexrelid));

CREATE TABLE edb$statio_all_tables (
     edb_id           bigint NOT NULL,
     dbname           name NOT NULL,
     relid            oid NOT NULL,
     schemaname       name,
     relname          name,
     heap_blks_read   bigint,
     heap_blks_hit    bigint,
     heap_blks_icache_hit  bigint,
     idx_blks_read    bigint,
     idx_blks_hit     bigint,
     idx_blks_icache_hit   bigint,
     toast_blks_read  bigint,
     toast_blks_hit   bigint,
     toast_blks_icache_hit bigint,
     tidx_blks_read   bigint,
     tidx_blks_hit    bigint,
     tidx_blks_icache_hit  bigint,
    CONSTRAINT edb$statio_tab_pk PRIMARY KEY (edb_id, dbname, relid));



