

SET search_path = pg_catalog;

CREATE TYPE cpu_stats AS (user_cpu BIGINT, nice_cpu BIGINT, sys_cpu BIGINT,idle_cpu BIGINT,wait_cpu BIGINT);

CREATE TYPE stats_record AS (cpu_user BIGINT, cpu_nice BIGINT, cpu_sys BIGINT,cpu_idle BIGINT,cpu_wait BIGINT,ram_total BIGINT,ram_free BIGINT,ram_used BIGINT,ram_active BIGINT,physical_io BIGINT ,cached_io BIGINT );

CREATE TYPE process_info AS (pid INTEGER,username varchar,dbname varchar,host varchar, start_time varchar,cpu_utilization numeric , mem_utilization BIGINT, command text,active bool );

CREATE OR REPLACE FUNCTION edb_get_sys_stats()
    RETURNS stats_record
    AS '$libdir/sys_stats', 'edb_get_sys_stats'
    LANGUAGE C VOLATILE STRICT;

CREATE OR REPLACE FUNCTION edb_get_cpu_stats()
    RETURNS SETOF cpu_stats
    AS '$libdir/sys_stats', 'edb_get_cpu_stats'
    LANGUAGE C VOLATILE STRICT;

CREATE OR REPLACE FUNCTION edb_get_process_utilizations(pid OUT int4,  cpu_utilization OUT bigint,  mem_utilization OUT bigint)
    RETURNS record
    AS '$libdir/sys_stats', 'edb_get_process_utilizations'
    LANGUAGE C VOLATILE STRICT;

CREATE OR REPLACE FUNCTION edb_get_server_processes(
  pid OUT INTEGER,
  username OUT varchar,
  dbname OUT varchar,
  host OUT varchar,
  start_time OUT varchar,
  cpu_utilization OUT numeric,
  mem_utilization OUT BIGINT,
  command OUT text,
  active OUT bool)
    RETURNS SETOF record
    AS $$
 SELECT s.pid, s.usename::varchar, datname::varchar, COALESCE(s.client_addr::varchar, 'localhost'), backend_start::varchar, p.cpu_utilization::numeric, p.mem_utilization, s.query, p.pid IS NOT NULL
 FROM pg_catalog.pg_stat_activity s
 LEFT OUTER JOIN pg_catalog.edb_get_process_utilizations() p ON p.pid = s.pid
   $$
    LANGUAGE SQL;

CREATE OR REPLACE FUNCTION edb_get_server_os_version()
    RETURNS text 
    AS '$libdir/sys_stats', 'edb_get_osversion'
    LANGUAGE C VOLATILE STRICT;


