-- Adjust this setting to control where the objects get created.
SET search_path = sys;

--UTL_ENCODE PACKAGE

CREATE OR REPLACE PACKAGE UTL_ENCODE IS
	BASE64 CONSTANT INTEGER := 1;
	QUOTED_PRINTABLE CONSTANT INTEGER := 2;
	FUNCTION BASE64_ENCODE(r RAW) RETURN RAW;
	FUNCTION BASE64_ENCODE(loid OID) RETURN TEXT;
	FUNCTION BASE64_DECODE(r RAW) RETURN RAW;

	FUNCTION UUENCODE(r IN RAW, type IN INTEGER DEFAULT 1,
			filename IN VARCHAR2 DEFAULT NULL,
			permission IN VARCHAR2 DEFAULT NULL)
		RETURN RAW;

	FUNCTION UUDECODE(r IN RAW)
		RETURN RAW;

	FUNCTION QUOTED_PRINTABLE_ENCODE(r IN RAW) RETURN RAW;
	FUNCTION QUOTED_PRINTABLE_DECODE(r IN RAW) RETURN RAW;

	FUNCTION TEXT_ENCODE(buf IN VARCHAR2,
			encode_charset IN VARCHAR2 DEFAULT NULL,
			encoding IN INTEGER DEFAULT NULL)
	RETURN VARCHAR2;

	FUNCTION TEXT_DECODE(buf IN VARCHAR2,
			encode_charset IN  VARCHAR2 DEFAULT NULL,
			encoding IN INTEGER DEFAULT NULL)
	RETURN VARCHAR2;

	FUNCTION MIMEHEADER_ENCODE(buf IN VARCHAR2,
			encode_charset IN  VARCHAR2 DEFAULT NULL,
			encoding IN INTEGER DEFAULT NULL)
	RETURN VARCHAR2;

	FUNCTION MIMEHEADER_DECODE(buf IN VARCHAR2)
		RETURN VARCHAR2;
END;
