SET search_path = sys;

CREATE OR REPLACE PACKAGE utl_mail IS
  SMTP_OUT_SERVER   VARCHAR2;

  PROCEDURE SEND(sender IN VARCHAR2(256), recipients IN VARCHAR2, cc IN VARCHAR2, bcc IN VARCHAR2, subject IN VARCHAR2, message IN VARCHAR2, mime_type IN VARCHAR2(512) DEFAULT 'text/plain; charset=us-ascii', priority IN INTEGER DEFAULT 3);
  PROCEDURE SEND_ATTACH_VARCHAR2(sender IN VARCHAR2(256), recipients IN VARCHAR2, cc IN VARCHAR2, bcc IN VARCHAR2, subject IN VARCHAR, message IN VARCHAR2, mime_type IN VARCHAR2(512),  priority IN INTEGER, attachment IN VARCHAR2, att_inline IN BOOLEAN DEFAULT TRUE, att_mime_type IN VARCHAR2(512) DEFAULT 'text/plain; charset=us-ascii', att_filename IN VARCHAR2 DEFAULT NULL);

  PROCEDURE SEND_ATTACH_RAW(sender IN VARCHAR2(256), recipients IN VARCHAR2, cc IN VARCHAR2, bcc IN VARCHAR2, subject IN VARCHAR2, message IN VARCHAR2, mime_type IN VARCHAR2(512), priority IN INTEGER, attachment IN BYTEA, att_inline IN BOOLEAN DEFAULT TRUE, att_mime_type IN VARCHAR2(512) DEFAULT 'application/octet-stream', att_filename IN VARCHAR2 DEFAULT NULL);
  PROCEDURE SEND_ATTACH_RAW(sender IN VARCHAR2(256), recipients IN VARCHAR2, cc IN VARCHAR2, bcc IN VARCHAR2, subject IN VARCHAR2, message IN VARCHAR2, mime_type IN VARCHAR2(512), priority IN INTEGER, attachment IN OID, att_inline IN BOOLEAN DEFAULT TRUE, att_mime_type IN VARCHAR2(512) DEFAULT 'application/octet-stream', att_filename IN VARCHAR2 DEFAULT NULL);
END;
