SET search_path = sys;

CREATE OR REPLACE PACKAGE utl_tcp IS
  ------------------------------------------------------------------------------
  -- UTL_TCP package type and variable definitions
  ------------------------------------------------------------------------------

  TYPE connection IS RECORD
  (
    remote_host VARCHAR(255),  -- The name or IP address of the remote host
                               -- [src : RFC 2181 section 11 states that 
                               --  "A full domain name is limited to 255 octets (including the separators)"]
    remote_port INTEGER,       -- The port number on which the remote host is listening
    local_host  VARCHAR(255),  -- The name or IP address of the local host
                               -- [src : RFC 2181 section 11 states that 
                               --  "A full domain name is limited to 255 octets (including the separators)"]
    local_port  INTEGER,       -- The port number on which the local host is listening
    newline     VARCHAR(2),    -- WRITE_LINE uses this character sequence to terminate lines
    tx_timeout  INTEGER,       -- The read and write functions wait this much seconds before giving up
    private_sd  INTEGER        -- socket descriptor of the open connection
  );

  CRLF VARCHAR(2) := E'\r\n';

  FUNCTION open_connection(remote_host VARCHAR2(255) DEFAULT NULL, remote_port INTEGER, local_host VARCHAR2(255) DEFAULT NULL, local_port INTEGER DEFAULT NULL, in_buffer_size INTEGER DEFAULT NULL, out_buffer_size INTEGER DEFAULT NULL, charset VARCHAR2(30) DEFAULT NULL, newline VARCHAR2(2) DEFAULT NULL, tx_timeout INTEGER DEFAULT NULL) RETURN connection;

  PROCEDURE close_connection(c IN OUT connection);
  PROCEDURE close_all_connections();

  FUNCTION write_text(c connection, data text, len INTEGER) RETURN INTEGER;
  FUNCTION write_line(c connection, data text) RETURN INTEGER;
  FUNCTION write_raw(c connection, data bytea) RETURN INTEGER;

  PROCEDURE read_line(c connection, data IN OUT VARCHAR2);
END;

