-- Adjust this setting to control where the objects get created.
SET search_path = sys;

CREATE OR REPLACE PACKAGE UTL_URL IS
	/* Compatibility: Exceptions  */
	bad_url EXCEPTION;
	bad_fixed_width_charset EXCEPTION;

	/* Compatibility: Exception codes */
	PRAGMA EXCEPTION_INIT (bad_url, -29262);
	PRAGMA EXCEPTION_INIT (bad_fixed_width_charset, -29274);

	/*
	 * We use ISO-8859-1 as the default value for url_charset, since that's
	 * the default value of utl_http.body_charset package-variable in Redwood.
	 */

	FUNCTION ESCAPE(
		url VARCHAR2,
		escape_reserved_chars BOOLEAN DEFAULT FALSE,
		url_charset VARCHAR2 DEFAULT 'ISO-8859-1'
		) RETURN VARCHAR2;

	FUNCTION UNESCAPE(
		url VARCHAR2,
		url_charset VARCHAR2 DEFAULT 'ISO-8859-1'
		) RETURN VARCHAR2;
END;

