-- Adjust this setting to control where the objects get created.
SET search_path = pg_catalog;

BEGIN;

CREATE OR REPLACE FUNCTION edb_rita_session_waits()
  RETURNS SETOF RECORD
AS '$libdir/waitstates', 'edb_rita_session_waits'
LANGUAGE C;

CREATE OR REPLACE FUNCTION edb_rita_session_wait_history()
  RETURNS SETOF RECORD
AS '$libdir/waitstates', 'edb_rita_session_wait_history'
LANGUAGE C;

-- Create a view for convenient access.
CREATE OR REPLACE VIEW session_waits AS
	SELECT backend_id,
           num_waits AS wait_count,
           CASE WHEN num_waits > 0 THEN
                CAST(((total_wait/1E6)/num_waits) as NUMERIC(50,6))
           ELSE
                0.0
           END AS avg_wait_time,
           CAST(max_wait/1E6 as NUMERIC(50,6)) AS max_wait_time,
           CAST(total_wait/1E6 as NUMERIC(50,6)) AS total_wait_time,
           wait_name
      FROM edb_rita_session_waits() t1 (backend_id BIGINT, max_wait BIGINT, total_wait BIGINT, num_waits BIGINT, wait_name TEXT)
     WHERE num_waits > 0
     ORDER BY total_wait_time DESC, wait_count DESC;

CREATE OR REPLACE VIEW session_wait_history AS
	SELECT backend_id,
           seq,
           wait_name,
           elapsed,
           p1,
           p2,
           p3
      FROM edb_rita_session_wait_history() t1 (backend_id BIGINT, seq BIGINT, wait_name TEXT, elapsed BIGINT, p1 BIGINT, p2 BIGINT, p3 BIGINT)
    ;

CREATE OR REPLACE VIEW system_waits AS
    SELECT SUM(wait_count) as wait_count,
           CAST(AVG(avg_wait_time) AS numeric(50,6)) as avg_wait,
           MAX(max_wait_time) as max_wait,
           SUM(total_wait_time) as total_wait,
           wait_name
      FROM session_waits
     GROUP BY wait_name
     ORDER BY total_wait desc;
COMMIT;

-- Don't want these to be available at public.
--REVOKE ALL ON FUNCTION waitstates_pages() FROM PUBLIC;
--REVOKE ALL ON waitstates FROM PUBLIC;

