-- Put back implicit casts to text, the way they were in PG 8.2.

-- These casts are copy-pasted from Peter Eisentraut's blog post at:
-- http://people.planetpostgresql.org/peter/index.php?/archives/18-Readding-implicit-casts-in-PostgreSQL-8.3.html

CREATE CAST (integer AS text) WITH INOUT AS IMPLICIT;
CREATE CAST (smallint AS text) WITH INOUT AS IMPLICIT;
CREATE CAST (oid AS text) WITH INOUT AS IMPLICIT;
CREATE CAST (pg_catalog.date AS text) WITH INOUT AS IMPLICIT;
CREATE CAST (double precision AS text) WITH INOUT AS IMPLICIT;
CREATE CAST (real AS text) WITH INOUT AS IMPLICIT;
CREATE CAST (time with time zone AS text) WITH INOUT AS IMPLICIT;
CREATE CAST (time without time zone AS text) WITH INOUT AS IMPLICIT;
CREATE CAST (timestamp with time zone AS text) WITH INOUT AS IMPLICIT;
CREATE CAST (interval AS text) WITH INOUT AS IMPLICIT;
CREATE CAST (bigint AS text) WITH INOUT AS IMPLICIT;
CREATE CAST (numeric AS text) WITH INOUT AS IMPLICIT;
CREATE CAST (timestamp without time zone AS text) WITH INOUT AS IMPLICIT;

-- Restoring those casts brings collateral damage in the form of ambiguous
-- function calls.  Avoid some of that by marking certain functions "weak".
UPDATE pg_proc SET proisweak = true
WHERE oid IN (
	'anytextcat'::regproc,
	'textanycat'::regproc,
	'quote_literal(anyelement)'::regprocedure,
	'quote_nullable(anyelement)'::regprocedure
);

----- Extra casts, not in PG 8.2 but needed for Redwood-compatibility

-- This is is an INOUT cast (we can't declare it using CREATE CAST because
-- postgres refuses to create casts from pseudo types). This is better than the
-- old way of defining record_text and using that, but it still doesn't seem
-- like it ought to be necessary. Things like foo('bar'||tab) work fine in
-- Postgres. Why doesn't dbms_output.put_line('got'||tab) work?

INSERT INTO pg_cast VALUES ('record'::regtype, 'text'::regtype, 0, 'i','i');

-- Make cast boolean->text implicit as it was in EDBAS 8.2
UPDATE pg_cast SET castcontext='i' WHERE castsource = 'bool'::regtype AND casttarget = 'text'::regtype;

-- Make cast name->varchar implicit based on customer request (FB 13259).
-- In particular, this makes the rowtype of "SELECT USER" compatible with
-- varchar2.
UPDATE pg_cast SET castcontext='i' WHERE castsource = 'name'::regtype AND casttarget = 'varchar2'::regtype;

-- Make cast varchar->numeric implicit as it was in EDBAS 8.2
CREATE CAST (varchar AS numeric) WITH INOUT AS IMPLICIT;

-- We need a cast from bytea->text, because there's a corresponding cast
-- from RAW to VARCHAR on Oracle, and we map RAW to bytea.

-- TODO: Is this really how we want the cast to work? byteaout escapes
-- any non-ASCII characters, and textin won't interpret those escapes.
-- Shouldn't we rather do the opposite of text->bytea cast? This is what
-- we did in previous release, though...
CREATE CAST (bytea AS text) WITH INOUT AS IMPLICIT;


/* Redwood-style concatenation of CHAR (= bpchar) fields. */
CREATE OPERATOR pg_catalog.|| (PROCEDURE=bpcharcat, leftarg=bpchar, rightarg=bpchar);


-- Comparing pg_cast from EDBAS 8.2 to today we see the following casts missing
-- or changed (not all of these may really be necessary though!)

-- timestamptz->timestamp (was implicit, now assignment
-- 
-- refcursor->text
-- 
-- bool->bit
-- bit->bool
-- varchar->numeric

-- Make cast timestamptz->timestamp implicit as it was in EDBAS 8.2
UPDATE pg_cast SET castcontext='i'
  WHERE castsource = 'timestamp with time zone'::regtype AND casttarget = 'timestamp without time zone'::regtype;


-- We have our own versions of to_number(text, text), substr(text, number, number),
-- to_char(timestamp, varchar), to_date(varchar, varchar) in EDB. Mostly for
-- historical reasons, but they does behave slightly differently, with e.g
-- to_number('34,50','999,99')
--
-- We can't just UPDATE the old row, because we want the OID to change,
-- because built-in functions are hard-wired in fmgr according to OID,
-- and fmgr will ignore pg_proc altogether for such OIDs.
--
-- We won't do a straight DELETE+INSERT either, because the INSERTed
-- columns listed here would need to be kept with changes to pg_proc.
--
-- The row is uniquely identified by oid, the proname check is just paranoia
--
-- XXX: We blindly assume there's no dependencies on the function yet. Which
-- is not even correct; there is a dummy dependency to stop you from DROPping
-- it.
CREATE TEMPORARY TABLE to_number_temp AS
SELECT * FROM pg_proc WHERE oid = 1777 AND proname='to_number';
UPDATE to_number_temp SET prosrc = 'edb_to_number';
DELETE FROM pg_proc WHERE oid = 1777 AND proname='to_number';
INSERT INTO pg_proc SELECT * FROM to_number_temp;
DROP TABLE to_number_temp;
COMMENT ON FUNCTION pg_catalog.to_number(text, text) IS 'EnterpriseDB to_number(text, text): converts text to number using a default format mask';
-- Remove old comment.
DELETE FROM pg_description WHERE objoid=1777 AND classoid = 'pg_proc'::regclass;


-- three arguments substr(text, number, number)
CREATE TEMPORARY TABLE substr_temp AS
SELECT * FROM pg_proc WHERE oid = 877 AND proname='substr';
UPDATE substr_temp
SET prosrc = 'edb_ora_substr3', proargtypes= '25 1700 1700';
DELETE FROM pg_proc WHERE oid = 877 AND proname='substr';
INSERT INTO pg_proc SELECT * FROM substr_temp;
DROP TABLE substr_temp;
COMMENT ON FUNCTION pg_catalog.substr(text, number, number) IS 'EnterpriseDB substr function: extracts a substring from a string starting at the given position in terms of composed characters';
-- Remove old comment.
DELETE FROM pg_description WHERE objoid=877 AND classoid = 'pg_proc'::regclass;

-- two arguments substr(text, number)
CREATE TEMPORARY TABLE substr_temp AS
SELECT * FROM pg_proc WHERE oid = 883 AND proname='substr';
UPDATE substr_temp
SET prosrc = 'edb_ora_substr2', proargtypes= '25 1700';
DELETE FROM pg_proc WHERE oid = 883 AND proname='substr';
INSERT INTO pg_proc SELECT * FROM substr_temp;
DROP TABLE substr_temp;
COMMENT ON FUNCTION pg_catalog.substr(text, number) IS 'EnterpriseDB substr function: extracts a substring from a string starting at the given position in terms of composed characters';
-- Remove old comment.
DELETE FROM pg_description WHERE objoid=883 AND classoid = 'pg_proc'::regclass;

-- two arguments to_char(timestamp, varchar)
CREATE TEMPORARY TABLE to_char_temp AS
SELECT * FROM pg_proc WHERE oid = 2049 AND proname='to_char';
UPDATE to_char_temp
SET prosrc = 'edb_ora_timestamp_tochar', proargtypes= '1114 1043', prorettype='1043';
DELETE FROM pg_proc WHERE oid = 2049 AND proname='to_char';
INSERT INTO pg_proc SELECT * FROM to_char_temp;
DROP TABLE to_char_temp;
COMMENT ON FUNCTION pg_catalog.to_char(timestamp, varchar) IS 'EnterpriseDB to_char(timestamp, varchar) function: converts a timestamp to varchar according to a given format';
-- Remove old comment.
DELETE FROM pg_description WHERE objoid= 2049 AND classoid = 'pg_proc'::regclass;

-- two arguments to_date(varchar, varchar)
CREATE TEMPORARY TABLE to_date_temp AS
SELECT * FROM pg_proc WHERE oid = 1780 AND proname='to_date';
UPDATE to_date_temp
SET prosrc = 'edb_ora_char_totimestamp', proargtypes= '1043 1043', prorettype='1114';
DELETE FROM pg_proc WHERE oid = 1780 AND proname='to_date';
INSERT INTO pg_proc SELECT * FROM to_date_temp;
DROP TABLE to_date_temp;
COMMENT ON FUNCTION pg_catalog.to_date(varchar, varchar) IS 'EnterpriseDB to_date(varchar, varchar) function: converts a string to timestamp according to a given format';
-- Remove old comment.
DELETE FROM pg_description WHERE objoid= 1780 AND classoid = 'pg_proc'::regclass;

