%define name setuptools
%define version 18.1
%define unmangled_version 18.1
%define unmangled_version 18.1
%define release 1

Summary: Easily download, build, install, upgrade, and uninstall Python packages
Name: %{name}
Version: %{version}
Release: %{release}
Source0: %{name}-%{unmangled_version}.tar.gz
License: PSF or ZPL
Group: Development/Libraries
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-buildroot
Prefix: %{_prefix}
BuildArch: noarch
Vendor: Python Packaging Authority <distutils-sig@python.org>
Packager: Alex Rombro <alex.rombro@ericsson.com>
Url: https://bitbucket.org/pypa/setuptools

%description
===============================
Installing and Using Setuptools
===============================

.. contents:: **Table of Contents**


`Change History <https://pythonhosted.org/setuptools/history.html>`_.

-------------------------
Installation Instructions
-------------------------

The recommended way to bootstrap setuptools on any system is to download
`ez_setup.py`_ and run it using the target Python environment. Different
operating systems have different recommended techniques to accomplish this
basic routine, so below are some examples to get you started.

Setuptools requires Python 2.6 or later. To install setuptools
on Python 2.4 or Python 2.5, use the `bootstrap script for Setuptools 1.x
<https://bitbucket.org/pypa/setuptools/raw/bootstrap-py24/ez_setup.py>`_.

The link provided to ez_setup.py is a bookmark to bootstrap script for the
latest known stable release.

.. _ez_setup.py: https://bootstrap.pypa.io/ez_setup.py

Windows (Powershell 3 or later)
===============================

For best results, uninstall previous versions FIRST (see `Uninstalling`_).

Using Windows 8 (which includes PowerShell 3) or earlier versions of Windows
with PowerShell 3 installed, it's possible to install with one simple
Powershell command. Start up Powershell and paste this command::

    > (Invoke-WebRequest https://bootstrap.pypa.io/ez_setup.py).Content | python -

You must start the Powershell with Administrative privileges or you may choose
to install a user-local installation::

    > (Invoke-WebRequest https://bootstrap.pypa.io/ez_setup.py).Content | python - --user

If you have Python 3.3 or later, you can use the ``py`` command to install to
different Python versions. For example, to install to Python 3.3 if you have
Python 2.7 installed::

    > (Invoke-WebRequest https://bootstrap.pypa.io/ez_setup.py).Content | py -3 -

The recommended way to install setuptools on Windows is to download
`ez_setup.py`_ and run it. The script will download the appropriate
distribution file and install it for you.

Once installation is complete, you will find an ``easy_install`` program in
your Python ``Scripts`` subdirectory.  For simple invocation and best results,
add this directory to your ``PATH`` environment variable, if it is not already
present. If you did a user-local install, the ``Scripts`` subdirectory is
``$env:APPDATA\Python\Scripts``.


Windows (simplified)
====================

For Windows without PowerShell 3 or for installation without a command-line,
download `ez_setup.py`_ using your preferred web browser or other technique
and "run" that file.


Unix (wget)
===========

Most Linux distributions come with wget.

Download `ez_setup.py`_ and run it using the target Python version. The script
will download the appropriate version and install it for you::

    > wget https://bootstrap.pypa.io/ez_setup.py -O - | python

Note that you will may need to invoke the command with superuser privileges to
install to the system Python::

    > wget https://bootstrap.pypa.io/ez_setup.py -O - | sudo python

Alternatively, Setuptools may be installed to a user-local path::

    > wget https://bootstrap.pypa.io/ez_setup.py -O - | python - --user

Note that on some older systems (noted on Debian 6 and CentOS 5 installations),
`wget` may refuse to download `ez_setup.py`, complaining that the certificate common name `*.c.ssl.fastly.net`
does not match the host name `bootstrap.pypa.io`. In addition, the `ez_setup.py` script may then encounter similar problems using
`wget` internally to download `setuptools-x.y.zip`, complaining that the certificate common name of `www.python.org` does not match the
host name `pypi.python.org`. Those are known issues, related to a bug in the older versions of `wget`
(see `Issue 59 <https://bitbucket.org/pypa/pypi/issue/59#comment-5881915>`_). If you happen to encounter them,
install Setuptools as follows::

    > wget --no-check-certificate https://bootstrap.pypa.io/ez_setup.py
    > python ez_setup.py --insecure


Unix including Mac OS X (curl)
==============================

If your system has curl installed, follow the ``wget`` instructions but
replace ``wget`` with ``curl`` and ``-O`` with ``-o``. For example::

    > curl https://bootstrap.pypa.io/ez_setup.py -o - | python


Advanced Installation
=====================

For more advanced installation options, such as installing to custom
locations or prefixes, download and extract the source
tarball from `Setuptools on PyPI <https://pypi.python.org/pypi/setuptools>`_
and run setup.py with any supported distutils and Setuptools options.
For example::

    setuptools-x.x$ python setup.py install --single-version-externally-managed --prefix=/opt/setuptools

Use ``--help`` to get a full options list, but we recommend consulting
the `EasyInstall manual`_ for detailed instructions, especially `the section
on custom installation locations`_.

.. _EasyInstall manual: https://pythonhosted.org/setuptools/EasyInstall
.. _the section on custom installation locations: https://pythonhosted.org/setuptools/EasyInstall#custom-installation-locations


Downloads
=========

All setuptools downloads can be found at `the project's home page in the Python
Package Index`_.  Scroll to the very bottom of the page to find the links.

.. _the project's home page in the Python Package Index: https://pypi.python.org/pypi/setuptools

In addition to the PyPI downloads, the development version of ``setuptools``
is available from the `Bitbucket repo`_, and in-development versions of the
`0.6 branch`_ are available as well.

.. _Bitbucket repo: https://bitbucket.org/pypa/setuptools/get/default.tar.gz#egg=setuptools-dev
.. _0.6 branch: http://svn.python.org/projects/sandbox/branches/setuptools-0.6/#egg=setuptools-dev06

Uninstalling
============

On Windows, if Setuptools was installed using an ``.exe`` or ``.msi``
installer, simply use the uninstall feature of "Add/Remove Programs" in the
Control Panel.

Otherwise, to uninstall Setuptools or Distribute, regardless of the Python
version, delete all ``setuptools*`` and ``distribute*`` files and
directories from your system's ``site-packages`` directory
(and any other ``sys.path`` directories) FIRST.

If you are upgrading or otherwise plan to re-install Setuptools or Distribute,
nothing further needs to be done. If you want to completely remove Setuptools,
you may also want to remove the 'easy_install' and 'easy_install-x.x' scripts
and associated executables installed to the Python scripts directory.

--------------------------------
Using Setuptools and EasyInstall
--------------------------------

Here are some of the available manuals, tutorials, and other resources for
learning about Setuptools, Python Eggs, and EasyInstall:

* `The EasyInstall user's guide and reference manual`_
* `The setuptools Developer's Guide`_
* `The pkg_resources API reference`_
* `The Internal Structure of Python Eggs`_

Questions, comments, and bug reports should be directed to the `distutils-sig
mailing list`_.  If you have written (or know of) any tutorials, documentation,
plug-ins, or other resources for setuptools users, please let us know about
them there, so this reference list can be updated.  If you have working,
*tested* patches to correct problems or add features, you may submit them to
the `setuptools bug tracker`_.

.. _setuptools bug tracker: https://bitbucket.org/pypa/setuptools/issues
.. _The Internal Structure of Python Eggs: https://pythonhosted.org/setuptools/formats.html
.. _The setuptools Developer's Guide: https://pythonhosted.org/setuptools/setuptools.html
.. _The pkg_resources API reference: https://pythonhosted.org/setuptools/pkg_resources.html
.. _The EasyInstall user's guide and reference manual: https://pythonhosted.org/setuptools/easy_install.html
.. _distutils-sig mailing list: http://mail.python.org/pipermail/distutils-sig/


-------
Credits
-------

* The original design for the ``.egg`` format and the ``pkg_resources`` API was
  co-created by Phillip Eby and Bob Ippolito.  Bob also implemented the first
  version of ``pkg_resources``, and supplied the OS X operating system version
  compatibility algorithm.

* Ian Bicking implemented many early "creature comfort" features of
  easy_install, including support for downloading via Sourceforge and
  Subversion repositories.  Ian's comments on the Web-SIG about WSGI
  application deployment also inspired the concept of "entry points" in eggs,
  and he has given talks at PyCon and elsewhere to inform and educate the
  community about eggs and setuptools.

* Jim Fulton contributed time and effort to build automated tests of various
  aspects of ``easy_install``, and supplied the doctests for the command-line
  ``.exe`` wrappers on Windows.

* Phillip J. Eby is the seminal author of setuptools, and
  first proposed the idea of an importable binary distribution format for
  Python application plug-ins.

* Significant parts of the implementation of setuptools were funded by the Open
  Source Applications Foundation, to provide a plug-in infrastructure for the
  Chandler PIM application.  In addition, many OSAF staffers (such as Mike
  "Code Bear" Taylor) contributed their time and stress as guinea pigs for the
  use of eggs and setuptools, even before eggs were "cool".  (Thanks, guys!)

* Tarek Ziadé is the principal author of the Distribute fork, which
  re-invigorated the community on the project, encouraged renewed innovation,
  and addressed many defects.

* Since the merge with Distribute, Jason R. Coombs is the
  maintainer of setuptools.  The project is maintained in coordination with
  the Python Packaging Authority (PyPA) and the larger Python community.

.. _files:


%prep
%setup -n %{name}-%{unmangled_version} -n %{name}-%{unmangled_version}

%build
python setup.py build

%install
python setup.py install --single-version-externally-managed -O1 --root=$RPM_BUILD_ROOT --record=INSTALLED_FILES

%clean
rm -rf $RPM_BUILD_ROOT

#%files -f INSTALLED_FILES
%files
%defattr(-,root,root)
/setuptools-18.1/
/setuptools-18.1/_markerlib/
/setuptools-18.1/_markerlib/__init__.py
/setuptools-18.1/_markerlib/markers.py
/setuptools-18.1/bootstrap.py
/setuptools-18.1/CHANGES.txt
/setuptools-18.1/conftest.py
/setuptools-18.1/DEVGUIDE.txt
/setuptools-18.1/docs/
/setuptools-18.1/docs/_templates/
/setuptools-18.1/docs/_templates/indexsidebar.html
/setuptools-18.1/docs/_theme/
/setuptools-18.1/docs/_theme/nature/
/setuptools-18.1/docs/_theme/nature/static/
/setuptools-18.1/docs/_theme/nature/static/nature.css_t
/setuptools-18.1/docs/_theme/nature/static/pygments.css
/setuptools-18.1/docs/_theme/nature/theme.conf
/setuptools-18.1/docs/conf.py
/setuptools-18.1/docs/developer-guide.txt
/setuptools-18.1/docs/development.txt
/setuptools-18.1/docs/easy_install.txt
/setuptools-18.1/docs/formats.txt
/setuptools-18.1/docs/history.txt
/setuptools-18.1/docs/index.txt
/setuptools-18.1/docs/Makefile
/setuptools-18.1/docs/merge-faq.txt
/setuptools-18.1/docs/merge.txt
/setuptools-18.1/docs/pkg_resources.txt
/setuptools-18.1/docs/python3.txt
/setuptools-18.1/docs/releases.txt
/setuptools-18.1/docs/roadmap.txt
/setuptools-18.1/docs/setuptools.txt
/setuptools-18.1/easy_install.py
/setuptools-18.1/ez_setup.py
/setuptools-18.1/launcher.c
/setuptools-18.1/MANIFEST.in
/setuptools-18.1/msvc-build-launcher.cmd
/setuptools-18.1/PKG-INFO
/setuptools-18.1/pkg_resources/
/setuptools-18.1/pkg_resources/__init__.py
/setuptools-18.1/pkg_resources/_vendor/
/setuptools-18.1/pkg_resources/_vendor/__init__.py
/setuptools-18.1/pkg_resources/_vendor/packaging/
/setuptools-18.1/pkg_resources/_vendor/packaging/__about__.py
/setuptools-18.1/pkg_resources/_vendor/packaging/__init__.py
/setuptools-18.1/pkg_resources/_vendor/packaging/_compat.py
/setuptools-18.1/pkg_resources/_vendor/packaging/_structures.py
/setuptools-18.1/pkg_resources/_vendor/packaging/specifiers.py
/setuptools-18.1/pkg_resources/_vendor/packaging/version.py
/setuptools-18.1/pkg_resources/_vendor/vendored.txt
/setuptools-18.1/pkg_resources/api_tests.txt
/setuptools-18.1/pkg_resources/tests/
/setuptools-18.1/pkg_resources/tests/__init__.py
/setuptools-18.1/pkg_resources/tests/test_markers.py
/setuptools-18.1/pkg_resources/tests/test_pkg_resources.py
/setuptools-18.1/pkg_resources/tests/test_resources.py
/setuptools-18.1/pytest.ini
/setuptools-18.1/README.txt
/setuptools-18.1/release.py
/setuptools-18.1/setup.cfg
/setuptools-18.1/setup.py
/setuptools-18.1/setuptools/
/setuptools-18.1/setuptools/__init__.py
/setuptools-18.1/setuptools/archive_util.py
/setuptools-18.1/setuptools/cli-32.exe
/setuptools-18.1/setuptools/cli-64.exe
/setuptools-18.1/setuptools/cli-arm-32.exe
/setuptools-18.1/setuptools/cli.exe
/setuptools-18.1/setuptools/command/
/setuptools-18.1/setuptools/command/*
/setuptools-18.1/setuptools/command/alias.py
/setuptools-18.1/setuptools/command/bdist_egg.py
/setuptools-18.1/setuptools/command/bdist_rpm.py
/setuptools-18.1/setuptools/command/bdist_wininst.py
/setuptools-18.1/setuptools/command/build_ext.py
/setuptools-18.1/setuptools/command/build_py.py
/setuptools-18.1/setuptools/command/develop.py
/setuptools-18.1/setuptools/command/easy_install.py
/setuptools-18.1/setuptools/command/egg_info.py
/setuptools-18.1/setuptools/command/install.py
/setuptools-18.1/setuptools/command/install_egg_info.py
/setuptools-18.1/setuptools/command/install_lib.py
/setuptools-18.1/setuptools/command/install_scripts.py
/setuptools-18.1/setuptools/command/launcher*
/setuptools-18.1/setuptools/command/register.py
/setuptools-18.1/setuptools/command/rotate.py
/setuptools-18.1/setuptools/command/saveopts.py
/setuptools-18.1/setuptools/command/sdist.py
/setuptools-18.1/setuptools/command/setopt.py
/setuptools-18.1/setuptools/command/test.py
/setuptools-18.1/setuptools/command/upload_docs.py
/setuptools-18.1/setuptools/compat.py
/setuptools-18.1/setuptools/depends.py
/setuptools-18.1/setuptools/dist.py
/setuptools-18.1/setuptools/extension.py
/setuptools-18.1/setuptools/gui-32.exe
/setuptools-18.1/setuptools/gui-64.exe
/setuptools-18.1/setuptools/gui-arm-32.exe
/setuptools-18.1/setuptools/gui.exe
/setuptools-18.1/setuptools/lib2to3_ex.py
/setuptools-18.1/setuptools/msvc9_support.py
/setuptools-18.1/setuptools/package_index.py
/setuptools-18.1/setuptools/py26compat.py
/setuptools-18.1/setuptools/py27compat.py
/setuptools-18.1/setuptools/py31compat.py
/setuptools-18.1/setuptools/sandbox.py
/setuptools-18.1/setuptools/script*
/setuptools-18.1/setuptools/site-patch.py
/setuptools-18.1/setuptools/ssl_support.py
/setuptools-18.1/setuptools/tests/
/setuptools-18.1/setuptools/tests/__init__.py
/setuptools-18.1/setuptools/tests/contexts.py
/setuptools-18.1/setuptools/tests/environment.py
/setuptools-18.1/setuptools/tests/fixtures.py
/setuptools-18.1/setuptools/tests/indexes/
/setuptools-18.1/setuptools/tests/indexes/test_links_priority/
/setuptools-18.1/setuptools/tests/indexes/test_links_priority/external.html
/setuptools-18.1/setuptools/tests/indexes/test_links_priority/simple/
/setuptools-18.1/setuptools/tests/indexes/test_links_priority/simple/foobar/
/setuptools-18.1/setuptools/tests/indexes/test_links_priority/simple/foobar/index.html
/setuptools-18.1/setuptools/tests/py26compat.py
/setuptools-18.1/setuptools/tests/script-with-bom.py
/setuptools-18.1/setuptools/tests/server.py
/setuptools-18.1/setuptools/tests/test_bdist_egg.py
/setuptools-18.1/setuptools/tests/test_build_ext.py
/setuptools-18.1/setuptools/tests/test_develop.py
/setuptools-18.1/setuptools/tests/test_dist_info.py
/setuptools-18.1/setuptools/tests/test_easy_install.py
/setuptools-18.1/setuptools/tests/test_egg_info.py
/setuptools-18.1/setuptools/tests/test_find_packages.py
/setuptools-18.1/setuptools/tests/test_integration.py
/setuptools-18.1/setuptools/tests/test_markerlib.py
/setuptools-18.1/setuptools/tests/test_msvc9compiler.py
/setuptools-18.1/setuptools/tests/test_packageindex.py
/setuptools-18.1/setuptools/tests/test_sandbox.py
/setuptools-18.1/setuptools/tests/test_sdist.py
/setuptools-18.1/setuptools/tests/test_test.py
/setuptools-18.1/setuptools/tests/test_upload_docs.py
/setuptools-18.1/setuptools/tests/test_windows_wrappers.py
/setuptools-18.1/setuptools/tests/textwrap.py
/setuptools-18.1/setuptools/unicode_utils.py
/setuptools-18.1/setuptools/utils.py
/setuptools-18.1/setuptools/version.py
/setuptools-18.1/setuptools/windows_support.py
/setuptools-18.1/setuptools.egg-info/
/setuptools-18.1/setuptools.egg-info/dependency_links.txt
/setuptools-18.1/setuptools.egg-info/entry_points.txt
/setuptools-18.1/setuptools.egg-info/PKG-INFO
/setuptools-18.1/setuptools.egg-info/requires.txt
/setuptools-18.1/setuptools.egg-info/SOURCES.txt
/setuptools-18.1/setuptools.egg-info/top_level.txt
/setuptools-18.1/setuptools.egg-info/zip-safe
/setuptools-18.1/tests/
/setuptools-18.1/tests/manual_test.py

