/*
 * Decompiled with CFR 0.152.
 */
package com.mediakind.testwebserver.controller;

import com.mediakind.testwebserver.util.ContentFileUtil;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ImageContentController {
    private static final String DEFAULT_IMAGE_NAME = "default.jpg";
    private static final String DEFAULT_IMAGE_PATH = "src/main/resources/images/";
    private static final String IMAGE_PATH = "/content/test-webserver/images/";

    @GetMapping(value={"/content301/image/{name}", "/content301/image/", "/content301/image"})
    public void getImageWithPermanentRedirection(@PathVariable(name="name", required=false) String name, HttpServletResponse response) {
        response.setStatus(301);
        response.setHeader("Location", "/content/image/" + ContentFileUtil.setFileName((String)name, (String)DEFAULT_IMAGE_NAME));
    }

    @GetMapping(value={"/content302/image/{name}", "/content302/image/", "/content302/image"})
    public void getImageWithTemporaryRedirection(@PathVariable(name="name", required=false) String name, HttpServletResponse response) throws IOException {
        response.sendRedirect("/content/image/" + ContentFileUtil.setFileName((String)name, (String)DEFAULT_IMAGE_NAME));
    }

    @GetMapping(value={"/content/image/{name}"}, produces={"image/jpeg", "image/png", "image/gif"})
    public ResponseEntity<FileSystemResource> getImage(@PathVariable(value="name") String name) {
        String imagePath = name.equals(DEFAULT_IMAGE_NAME) ? "src/main/resources/images/default.jpg" : IMAGE_PATH + name;
        return new ResponseEntity((Object)new FileSystemResource(imagePath), HttpStatus.OK);
    }
}

