/*
 * Decompiled with CFR 0.152.
 */
package com.mediakind.testwebserver.controller;

import com.mediakind.testwebserver.util.ContentFileUtil;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class VideoContentController {
    private static final String DEFAULT_VIDEO_NAME = "default.mp4";
    private static final String DEFAULT_VIDEO_PATH = "src/main/resources/videos/";
    private static final String VIDEO_PATH = "/content/test-webserver/videos/";

    @GetMapping(value={"/content301/video/{name}", "/content301/video/", "/content301/video"})
    public void getVideoWithPermanentRedirection(@PathVariable(name="name", required=false) String name, HttpServletResponse response) {
        response.setStatus(301);
        response.setHeader("Location", "/content/video/" + ContentFileUtil.setFileName((String)name, (String)DEFAULT_VIDEO_NAME));
    }

    @GetMapping(value={"/content302/video/{name}", "/content302/video/", "/content302/video"})
    public void getVideoWithTemporaryRedirection(@PathVariable(name="name", required=false) String name, HttpServletResponse response) throws IOException {
        response.sendRedirect("/content/video/" + ContentFileUtil.setFileName((String)name, (String)DEFAULT_VIDEO_NAME));
    }

    @GetMapping(value={"/content/video/{name}"}, produces={"application/octet-stream"})
    public ResponseEntity<FileSystemResource> getVideo(@PathVariable(value="name") String name) {
        String videoPath = name.equals(DEFAULT_VIDEO_NAME) ? "src/main/resources/videos/default.mp4" : VIDEO_PATH + name;
        return new ResponseEntity((Object)new FileSystemResource(videoPath), HttpStatus.OK);
    }
}

