/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.LoggerModule.log4j;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.log4j.helpers.FormattingInfo;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.helpers.PatternParser;
import org.apache.log4j.spi.LoggingEvent;

public final class GMTLocalDatePatternParser
extends PatternParser {
    private static final char GMT_LOCAL = '@';
    private static final String GMT_DATE_FORMAT_DEFAULT = "yyyy/MM/dd HH:mm:ss.SSS 'GMT'";
    private static final String LOCAL_DATE_FORMAT_DEFAULT = "(MM/dd HH:mm:ss Z)";
    private static final String GMT_DELIMITER = "GMT::";
    private static final String LOCAL_DELIMITER = "LOC::";

    public GMTLocalDatePatternParser(String pattern) {
        super(pattern);
    }

    public void finalizeConverter(char c) {
        if (c == '@') {
            this.addConverter(new GMTLocalDatePatternConverter(this.formattingInfo, this.extractOption()));
            this.currentLiteral.setLength(0);
        } else {
            super.finalizeConverter(c);
        }
    }

    private static class GMTLocalDatePatternConverter
    extends PatternConverter {
        private SimpleDateFormat gmtSdf = null;
        private SimpleDateFormat localSdf = null;
        private boolean gmtFirst = true;
        private Date date = new Date();

        public GMTLocalDatePatternConverter(FormattingInfo formattingInfo, String gmtLocalStr) {
            super(formattingInfo);
            this.initFormatters(gmtLocalStr);
        }

        private void initFormatters(String gmtLocalStr) {
            this.gmtSdf = null;
            this.localSdf = null;
            this.gmtFirst = true;
            String gmtStr = null;
            String localStr = null;
            try {
                if (gmtLocalStr == null || gmtLocalStr.trim().equals("")) {
                    gmtStr = GMTLocalDatePatternParser.GMT_DATE_FORMAT_DEFAULT;
                    localStr = GMTLocalDatePatternParser.LOCAL_DATE_FORMAT_DEFAULT;
                    this.gmtFirst = true;
                } else {
                    gmtStr = this.textBetween(GMTLocalDatePatternParser.GMT_DELIMITER, GMTLocalDatePatternParser.LOCAL_DELIMITER, gmtLocalStr);
                    if (gmtStr == null || gmtStr.trim().equals("")) {
                        gmtStr = GMTLocalDatePatternParser.GMT_DATE_FORMAT_DEFAULT;
                    }
                    if ((localStr = this.textBetween(GMTLocalDatePatternParser.LOCAL_DELIMITER, GMTLocalDatePatternParser.GMT_DELIMITER, gmtLocalStr)) == null || localStr.trim().equals("")) {
                        localStr = GMTLocalDatePatternParser.LOCAL_DATE_FORMAT_DEFAULT;
                    }
                    int g = gmtLocalStr.indexOf(GMTLocalDatePatternParser.GMT_DELIMITER);
                    int l = gmtLocalStr.indexOf(GMTLocalDatePatternParser.LOCAL_DELIMITER);
                    if (l > -1 && g > -1 && g > l) {
                        this.gmtFirst = false;
                    }
                }
                this.gmtSdf = new SimpleDateFormat(gmtStr);
                this.gmtSdf.setTimeZone(TimeZone.getTimeZone("GMT"));
                this.localSdf = new SimpleDateFormat(localStr);
            }
            catch (Exception e) {
                LogLog.error((String)("Could not instantiate GMTLocalDatePatternConverter with " + gmtLocalStr), (Throwable)e);
                this.gmtSdf = new SimpleDateFormat(GMTLocalDatePatternParser.GMT_DATE_FORMAT_DEFAULT);
                this.gmtSdf.setTimeZone(TimeZone.getTimeZone("GMT"));
                this.localSdf = new SimpleDateFormat(GMTLocalDatePatternParser.LOCAL_DATE_FORMAT_DEFAULT);
            }
        }

        private String textBetween(String start, String end, String target) {
            int s = target.indexOf(start);
            if (s == -1) {
                return null;
            }
            int e = target.indexOf(end);
            if (s < e) {
                return target.substring(s + start.length(), e);
            }
            return target.substring(s + start.length());
        }

        public String convert(LoggingEvent event) {
            this.date.setTime(event.timeStamp);
            StringBuffer converted = new StringBuffer();
            try {
                if (this.gmtFirst) {
                    converted.append(this.gmtSdf.format(this.date));
                    converted.append(this.localSdf.format(this.date));
                } else {
                    converted.append(this.localSdf.format(this.date));
                    converted.append(this.gmtSdf.format(this.date));
                }
            }
            catch (Exception e) {
                LogLog.error((String)"Error occured while converting date.", (Throwable)e);
            }
            return converted.toString();
        }
    }
}

