/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.listener;

import java.io.IOException;
import java.util.EventObject;
import javax.security.cert.X509Certificate;

public class SSLSessionEvent
extends EventObject {
    private final String remoteIP;
    private final int remotePort;
    private final int localPort;
    private final String localIP;
    private String remoteDN = null;
    private final X509Certificate[] peerCerts;
    private final IOException ex;

    public SSLSessionEvent(Object object, String string, int n, X509Certificate[] x509CertificateArray, int n2, String string2, IOException iOException) {
        super(object);
        this.remoteIP = string;
        this.remotePort = n;
        this.peerCerts = x509CertificateArray;
        this.localPort = n2;
        this.localIP = string2;
        this.ex = iOException;
    }

    public String getRemoteIP() {
        return this.remoteIP;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public String getRemoteDN() {
        if (this.remoteDN == null && this.peerCerts != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.peerCerts.length; ++i) {
                stringBuffer.append(this.peerCerts[i].toString());
                stringBuffer.append("\n\n");
            }
            this.remoteDN = stringBuffer.toString();
        }
        if (this.remoteDN == null || this.remoteDN.length() == 0) {
            this.remoteDN = "[Unable to verify peer certificates]";
        }
        return this.remoteDN;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public String getLocalIP() {
        return this.localIP;
    }

    public X509Certificate[] getPeerCertificateChain() {
        return this.peerCerts;
    }

    public String toString() {
        String string = "";
        if (this.ex != null) {
            string = " and exception " + this.ex;
        }
        return super.toString() + " with local port " + this.localPort + " and local IP " + this.localIP + " and remote port " + this.remotePort + " and remote IP " + this.remoteIP + " and certificates " + this.getRemoteDN() + string;
    }

    public IOException getCause() {
        return this.ex;
    }
}

