/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.resource.security;

import com.ericsson.resource.security.SecurityAgent;
import com.ericsson.resource.security.SubjectActions;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.logging.Logger;
import org.jboss.resource.security.AbstractPasswordCredentialLoginModule;
import org.jboss.security.SimplePrincipal;

public class SecureIdentityLoginModule
extends AbstractPasswordCredentialLoginModule {
    private static final Logger log = Logger.getLogger(SecureIdentityLoginModule.class);
    private String username;
    private String password;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        super.initialize(subject, handler, sharedState, options);
        this.username = (String)options.get("username");
        if (this.username == null) {
            this.username = (String)options.get("userName");
            if (this.username == null) {
                throw new IllegalArgumentException("The user name is a required option");
            }
        }
        this.password = (String)options.get("password");
        if (this.password == null) {
            throw new IllegalArgumentException("The password is a required option");
        }
    }

    public boolean login() throws LoginException {
        log.trace((Object)"login called");
        if (super.login()) {
            return true;
        }
        this.loginOk = true;
        return true;
    }

    public boolean commit() throws LoginException {
        SimplePrincipal principal = new SimplePrincipal(this.username);
        SubjectActions.addPrincipals(this.subject, (Principal)principal);
        this.sharedState.put("javax.security.auth.login.name", this.username);
        try {
            char[] decodedPassword = SecurityAgent.decode(this.password);
            String decodedUsername = new String(SecurityAgent.decode(this.username));
            PasswordCredential cred = new PasswordCredential(decodedUsername, decodedPassword);
            cred.setManagedConnectionFactory(this.getMcf());
            SubjectActions.addCredentials(this.subject, cred);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to decode password", (Throwable)e);
            throw new LoginException("Failed to decode password: " + e.getMessage());
        }
        return true;
    }

    public boolean abort() {
        this.username = null;
        this.password = null;
        return true;
    }

    protected Principal getIdentity() {
        log.trace((Object)("getIdentity called, username=" + this.username));
        SimplePrincipal principal = new SimplePrincipal(this.username);
        return principal;
    }

    protected Group[] getRoleSets() throws LoginException {
        Group[] empty = new Group[]{};
        return empty;
    }

    private static String byteArrayToHexString(byte[] b) {
        StringBuffer sb = new StringBuffer(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            int v = b[i] & 0xFF;
            if (v < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(v));
        }
        return sb.toString().toUpperCase();
    }
}

