/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.impl;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jacorb.trading.db.TypeDatabase;
import org.omg.CORBA.Contained;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.Repository;
import org.omg.CORBA.SystemException;
import org.omg.CosTrading.DuplicatePropertyName;
import org.omg.CosTrading.IllegalPropertyName;
import org.omg.CosTrading.IllegalServiceType;
import org.omg.CosTrading.UnknownServiceType;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPOA;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.AlreadyMasked;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.DuplicateServiceTypeName;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.HasSubTypes;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.IncarnationNumber;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.InterfaceTypeMismatch;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.ListOption;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.NotMasked;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.PropStruct;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.PropertyMode;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.ServiceTypeExists;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.SpecifiedServiceTypes;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.TypeStruct;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.ValueTypeRedefinition;

public class RepositoryImpl
extends ServiceTypeRepositoryPOA {
    private TypeDatabase m_database;
    private Repository m_interfaceRepos;

    public RepositoryImpl(TypeDatabase typeDatabase, Repository repository) {
        this.m_database = typeDatabase;
        this.m_interfaceRepos = repository;
    }

    public IncarnationNumber incarnation() {
        this.m_database.begin(0);
        IncarnationNumber incarnationNumber = this.m_database.getIncarnation();
        this.m_database.end();
        return incarnationNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncarnationNumber add_type(String string, String string2, PropStruct[] propStructArray, String[] stringArray) throws IllegalServiceType, ServiceTypeExists, InterfaceTypeMismatch, IllegalPropertyName, DuplicatePropertyName, ValueTypeRedefinition, UnknownServiceType, DuplicateServiceTypeName {
        IncarnationNumber incarnationNumber = null;
        try {
            String[] stringArray2;
            int n;
            this.m_database.begin(1);
            this.checkTypeName(string);
            if (this.m_database.describeType(string) != null) {
                throw new ServiceTypeExists(string);
            }
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            for (n = 0; n < stringArray.length; ++n) {
                stringArray2 = this.findType(stringArray[n]);
                if (hashtable.containsKey(stringArray[n])) {
                    throw new DuplicateServiceTypeName(stringArray[n]);
                }
                hashtable.put(stringArray[n], stringArray2);
            }
            for (n = 0; n < stringArray.length; ++n) {
                stringArray2 = this.m_database.getAllSuperTypes(stringArray[n]);
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (hashtable.containsKey(stringArray2[i])) continue;
                    TypeStruct typeStruct = this.findType(stringArray2[i]);
                    if (typeStruct == null) {
                        throw new UnknownServiceType(stringArray2[i]);
                    }
                    hashtable.put(stringArray2[i], typeStruct);
                }
            }
            this.validateInterface(string, string2, stringArray, hashtable);
            this.validateProperties(string, propStructArray, stringArray, hashtable);
            incarnationNumber = this.m_database.createType(string, string2, propStructArray, stringArray);
        }
        finally {
            this.m_database.end();
        }
        return incarnationNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove_type(String string) throws IllegalServiceType, UnknownServiceType, HasSubTypes {
        try {
            this.m_database.begin(1);
            this.checkTypeName(string);
            String string2 = this.m_database.findSubType(string);
            if (string2 != null) {
                throw new HasSubTypes(string, string2);
            }
            if (!this.m_database.removeType(string)) {
                throw new UnknownServiceType(string);
            }
        }
        finally {
            this.m_database.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] list_types(SpecifiedServiceTypes specifiedServiceTypes) {
        String[] stringArray = null;
        try {
            this.m_database.begin(0);
            if (specifiedServiceTypes.discriminator() == ListOption.all) {
                stringArray = this.m_database.getTypes();
            } else {
                IncarnationNumber incarnationNumber = specifiedServiceTypes.incarnation();
                stringArray = this.m_database.getTypesSince(incarnationNumber);
            }
        }
        finally {
            this.m_database.end();
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeStruct describe_type(String string) throws IllegalServiceType, UnknownServiceType {
        TypeStruct typeStruct;
        try {
            this.m_database.begin(0);
            this.checkTypeName(string);
            typeStruct = this.findType(string);
        }
        finally {
            this.m_database.end();
        }
        return typeStruct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeStruct fully_describe_type(String string) throws IllegalServiceType, UnknownServiceType {
        TypeStruct typeStruct = null;
        try {
            this.m_database.begin(1);
            this.checkTypeName(string);
            TypeStruct typeStruct2 = typeStruct = this.findType(string);
            synchronized (typeStruct2) {
                String[] stringArray = this.m_database.getAllSuperTypes(string);
                typeStruct.super_types = stringArray;
                Vector<TypeStruct> vector = new Vector<TypeStruct>();
                for (int i = 0; i < stringArray.length; ++i) {
                    TypeStruct typeStruct3 = this.findType(stringArray[i]);
                    vector.addElement(typeStruct3);
                }
                Vector<PropStruct> vector2 = new Vector<PropStruct>();
                for (int i = 0; i < typeStruct.props.length; ++i) {
                    vector2.addElement(typeStruct.props[i]);
                }
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    TypeStruct typeStruct4 = (TypeStruct)enumeration.nextElement();
                    for (int i = 0; i < typeStruct4.props.length; ++i) {
                        boolean bl = false;
                        Enumeration enumeration2 = vector2.elements();
                        while (enumeration2.hasMoreElements() && !bl) {
                            PropStruct propStruct = (PropStruct)enumeration2.nextElement();
                            if (!typeStruct4.props[i].name.equals(propStruct.name)) continue;
                            bl = true;
                        }
                        if (bl) continue;
                        vector2.addElement(typeStruct4.props[i]);
                    }
                }
                typeStruct.props = new PropStruct[vector2.size()];
                vector2.copyInto(typeStruct.props);
            }
        }
        finally {
            this.m_database.end();
        }
        return typeStruct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mask_type(String string) throws IllegalServiceType, UnknownServiceType, AlreadyMasked {
        try {
            this.m_database.begin(1);
            this.checkTypeName(string);
            TypeStruct typeStruct = this.findType(string);
            if (typeStruct.masked) {
                throw new AlreadyMasked(string);
            }
            if (!this.m_database.maskType(string)) {
                throw new UnknownServiceType(string);
            }
        }
        finally {
            this.m_database.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unmask_type(String string) throws IllegalServiceType, UnknownServiceType, NotMasked {
        try {
            this.m_database.begin(1);
            this.checkTypeName(string);
            TypeStruct typeStruct = this.findType(string);
            if (!typeStruct.masked) {
                throw new NotMasked(string);
            }
            if (!this.m_database.unmaskType(string)) {
                throw new UnknownServiceType(string);
            }
        }
        finally {
            this.m_database.end();
        }
    }

    protected void checkTypeName(String string) throws IllegalServiceType {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalServiceType("");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":", true);
        boolean bl = false;
        String string2 = null;
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals(":")) {
                if (++n > 2) {
                    throw new IllegalServiceType(string);
                }
            } else {
                n = 0;
                bl = true;
                if (!Character.isLetter(string3.charAt(0))) {
                    throw new IllegalServiceType(string);
                }
                for (int i = 1; i < string3.length(); ++i) {
                    char c = string3.charAt(i);
                    if (Character.isLetterOrDigit(c) || c == '_') continue;
                    throw new IllegalServiceType(string);
                }
            }
            string2 = string3;
        }
        if (!bl) {
            throw new IllegalServiceType(string);
        }
        if (string2.equals(":")) {
            throw new IllegalServiceType(string);
        }
    }

    protected TypeStruct findType(String string) throws UnknownServiceType {
        TypeStruct typeStruct = this.m_database.describeType(string);
        if (typeStruct == null) {
            throw new UnknownServiceType(string);
        }
        return typeStruct;
    }

    protected void validateInterface(String string, String string2, String[] stringArray, Hashtable hashtable) throws InterfaceTypeMismatch {
        if (this.m_interfaceRepos != null) {
            InterfaceDef interfaceDef = null;
            try {
                Contained contained = this.m_interfaceRepos.lookup(string2);
                if (contained != null) {
                    interfaceDef = InterfaceDefHelper.narrow(contained);
                }
            }
            catch (SystemException systemException) {
                // empty catch block
            }
            if (interfaceDef != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        String string3;
                        TypeStruct typeStruct = (TypeStruct)hashtable.get(stringArray[i]);
                        Contained contained = this.m_interfaceRepos.lookup(typeStruct.if_name);
                        if (contained != null && !interfaceDef.is_a(string3 = contained.id())) {
                            throw new InterfaceTypeMismatch(stringArray[i], typeStruct.if_name, string, string2);
                        }
                        continue;
                    }
                    catch (SystemException systemException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected void validateProperties(String string, PropStruct[] propStructArray, String[] stringArray, Hashtable hashtable) throws IllegalPropertyName, DuplicatePropertyName, ValueTypeRedefinition {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < propStructArray.length; ++i) {
            if (vector.contains(propStructArray[i].name)) {
                throw new DuplicatePropertyName(propStructArray[i].name);
            }
            for (int j = 0; j < stringArray.length; ++j) {
                TypeStruct typeStruct = (TypeStruct)hashtable.get(stringArray[j]);
                Vector vector2 = new Vector();
                this.findProperties(typeStruct, propStructArray[i].name, vector2, hashtable);
                Enumeration enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    PropStruct propStruct = (PropStruct)enumeration.nextElement();
                    if (propStructArray[i].value_type.equal(propStruct.value_type) && this.validateMode(propStructArray[i].mode, propStruct.mode)) continue;
                    throw new ValueTypeRedefinition(string, propStructArray[i], stringArray[j], propStruct);
                }
            }
            vector.addElement(propStructArray[i].name);
        }
    }

    protected boolean validateMode(PropertyMode propertyMode, PropertyMode propertyMode2) {
        boolean bl = false;
        if (propertyMode2 == propertyMode) {
            bl = true;
        } else if (propertyMode2 == PropertyMode.PROP_NORMAL) {
            bl = true;
        } else if (propertyMode2 == PropertyMode.PROP_READONLY && (propertyMode == PropertyMode.PROP_READONLY || propertyMode == PropertyMode.PROP_MANDATORY_READONLY)) {
            bl = true;
        } else if (propertyMode2 == PropertyMode.PROP_MANDATORY && (propertyMode == PropertyMode.PROP_MANDATORY || propertyMode == PropertyMode.PROP_MANDATORY_READONLY)) {
            bl = true;
        } else if (propertyMode2 == PropertyMode.PROP_MANDATORY_READONLY && propertyMode == PropertyMode.PROP_MANDATORY_READONLY) {
            bl = true;
        }
        return bl;
    }

    protected void findProperties(TypeStruct typeStruct, String string, Vector vector, Hashtable hashtable) {
        PropStruct propStruct = this.findProperty(typeStruct, string);
        if (propStruct != null) {
            vector.addElement(propStruct);
        } else {
            for (int i = 0; i < typeStruct.super_types.length; ++i) {
                TypeStruct typeStruct2 = (TypeStruct)hashtable.get(typeStruct.super_types[i]);
                this.findProperties(typeStruct2, string, vector, hashtable);
            }
        }
    }

    protected PropStruct findProperty(TypeStruct typeStruct, String string) {
        PropStruct propStruct = null;
        for (int i = 0; i < typeStruct.props.length && propStruct == null; ++i) {
            if (!string.equals(typeStruct.props[i].name)) continue;
            propStruct = typeStruct.props[i];
        }
        return propStruct;
    }
}

