/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.jacorb.notification.MessageFactory;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.interfaces.MessageSupplier;
import org.jacorb.notification.servant.AbstractProxyConsumer;
import org.jacorb.notification.servant.ITypedAdmin;
import org.jacorb.notification.servant.ITypedProxy;
import org.jacorb.notification.servant.MessageSupplierDelegate;
import org.jacorb.notification.servant.PullMessagesOperation;
import org.jacorb.notification.servant.PullMessagesUtility;
import org.jacorb.notification.servant.TypedProxyPullConsumerImplMBean;
import org.omg.CORBA.Any;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.InterfaceDefPackage.FullInterfaceDescription;
import org.omg.CORBA.NVList;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.OperationDescription;
import org.omg.CORBA.Request;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventChannelAdmin.TypeError;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.CosNotifyChannelAdmin.SupplierAdmin;
import org.omg.CosTypedEventComm.TypedPullSupplier;
import org.omg.CosTypedNotifyChannelAdmin.TypedProxyPullConsumerOperations;
import org.omg.CosTypedNotifyChannelAdmin.TypedProxyPullConsumerPOATie;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class TypedProxyPullConsumerImpl
extends AbstractProxyConsumer
implements TypedProxyPullConsumerOperations,
MessageSupplier,
MessageSupplierDelegate,
ITypedProxy,
TypedProxyPullConsumerImplMBean {
    private String[] tryPullOperations_;
    private TypedPullSupplier pullSupplier_;
    private Object typedPullSupplier_;
    private InterfaceDef interfaceDef_;
    private final String supportedInterface_;
    private final Map operationDescriptions_ = new HashMap();
    private final Map fullQualifiedOperationNames_ = new HashMap();
    private final PullMessagesUtility pollUtil_;
    private long pollInterval_;
    private final PullMessagesOperation pullMessagesOperation_;

    public TypedProxyPullConsumerImpl(ITypedAdmin iTypedAdmin, SupplierAdmin supplierAdmin, ORB oRB, POA pOA, Configuration configuration, TaskProcessor taskProcessor, MessageFactory messageFactory, OfferManager offerManager, SubscriptionManager subscriptionManager) {
        super(iTypedAdmin, oRB, pOA, configuration, taskProcessor, messageFactory, supplierAdmin, offerManager, subscriptionManager);
        this.supportedInterface_ = iTypedAdmin.getSupportedInterface();
        this.pollUtil_ = new PullMessagesUtility(taskProcessor, this);
        this.pollInterval_ = configuration.getAttributeAsLong("jacorb.notification.supplier.poll_intervall", 1000L);
        this.pullMessagesOperation_ = new PullMessagesOperation(this);
    }

    public void connect_typed_pull_supplier(TypedPullSupplier typedPullSupplier) throws AlreadyConnected, TypeError {
        this.logger_.info("connect typed_pull_supplier");
        this.checkIsNotConnected();
        this.connectClient(typedPullSupplier);
        this.pullSupplier_ = typedPullSupplier;
        this.typedPullSupplier_ = this.pullSupplier_.get_typed_supplier();
        this.interfaceDef_ = InterfaceDefHelper.narrow(this.typedPullSupplier_._get_interface_def());
        if (this.interfaceDef_ == null) {
            throw new TypeError("Could not access Interface Definition for TypedPullSupplier [" + this.typedPullSupplier_ + "]");
        }
        if (!this.typedPullSupplier_._is_a(this.supportedInterface_)) {
            throw new TypeError();
        }
        this.pollUtil_.startTask(this.pollInterval_);
    }

    private String[] getTryPullOperations() {
        if (this.tryPullOperations_ == null) {
            FullInterfaceDescription fullInterfaceDescription = this.interfaceDef_.describe_interface();
            for (int i = 0; i < fullInterfaceDescription.operations.length; ++i) {
                if (!fullInterfaceDescription.operations[i].name.startsWith("try_")) continue;
                this.operationDescriptions_.put(fullInterfaceDescription.operations[i].name, fullInterfaceDescription.operations[i]);
            }
            this.tryPullOperations_ = this.operationDescriptions_.keySet().toArray(new String[this.operationDescriptions_.size()]);
        }
        return this.tryPullOperations_;
    }

    public MessageSupplierDelegate.PullResult pullMessages() {
        String[] stringArray = this.getTryPullOperations();
        HashMap<String, Request> hashMap = new HashMap<String, Request>();
        for (int i = 0; i < stringArray.length; ++i) {
            Request request = this.prepareRequest(stringArray[i]);
            if (this.logger_.isDebugEnabled()) {
                this.logger_.debug("invoke " + stringArray[i]);
            }
            try {
                request.invoke();
                Any any = request.result().value();
                boolean bl = any.extract_boolean();
                if (!bl) continue;
                String string = stringArray[i].substring(4);
                hashMap.put(string, request);
                continue;
            }
            catch (Exception exception) {
                if (!this.logger_.isInfoEnabled()) continue;
                String string = "Operation " + stringArray[i] + " failed: Ignore";
                if (this.logger_.isDebugEnabled()) {
                    this.logger_.debug(string, (Throwable)exception);
                    continue;
                }
                this.logger_.info(string);
            }
        }
        return new MessageSupplierDelegate.PullResult(Collections.unmodifiableMap(hashMap), true);
    }

    public void queueMessages(MessageSupplierDelegate.PullResult pullResult) {
        Map map = (Map)pullResult.data_;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Request request = (Request)map.get(string);
            String string2 = this.getFullQualifiedName(string);
            Message message = this.getMessageFactory().newMessage(this.supportedInterface_, string2, request.arguments(), this);
            this.checkMessageProperties(message);
            this.processMessage(message);
        }
    }

    private OperationDescription getOperationDescription(String string) {
        return (OperationDescription)this.operationDescriptions_.get(string);
    }

    private String getFullQualifiedName(String string) {
        String string2 = (String)this.fullQualifiedOperationNames_.get(string);
        if (string2 == null) {
            string2 = this.interfaceDef_.lookup(string).absolute_name();
            this.fullQualifiedOperationNames_.put(string, string2);
        }
        return string2;
    }

    private Request prepareRequest(String string) {
        Request request = this.typedPullSupplier_._request(string);
        NVList nVList = request.arguments();
        OperationDescription operationDescription = this.getOperationDescription(string);
        for (int i = 0; i < operationDescription.parameters.length; ++i) {
            Any any = this.getORB().create_any();
            any.type(operationDescription.parameters[i].type);
            nVList.add_value(operationDescription.parameters[i].name, any, 2);
        }
        request.set_return_type(operationDescription.result);
        return request;
    }

    public void disconnect_pull_consumer() {
        this.destroy();
    }

    public ProxyType MyType() {
        return ProxyType.PULL_TYPED;
    }

    public void disconnectClient() {
        this.pollUtil_.stopTask();
        if (this.pullSupplier_ != null) {
            this.pullSupplier_.disconnect_pull_supplier();
            this.pullSupplier_ = null;
        }
    }

    public Servant newServant() {
        return new TypedProxyPullConsumerPOATie(this);
    }

    public String getSupportedInterface() {
        return this.supportedInterface_;
    }

    public void runPullMessage() throws Disconnected {
        this.pullMessagesOperation_.runPull();
    }
}

