/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.LoggerModule;

import com.n2bb.LoggerModule.LocalLoggerListener;
import java.io.UnsupportedEncodingException;
import org.apache.log4j.Logger;

public class ISALogListener
extends LocalLoggerListener {
    public static final String BASE_LOGGER_NAME = "module.";
    public static final int LOG_EMERGENCY = 0;
    public static final int LOG_ALERT = 1;
    public static final int LOG_CRITICAL = 2;
    public static final int LOG_ERROR = 3;
    public static final int LOG_WARNING = 4;
    public static final int LOG_NOTICE = 5;
    public static final int LOG_INFO = 6;
    public static final int LOG_CORBAMETHOD = 7;
    public static final int LOG_STACKTRACE = 8;
    public static final int LOG_DEBUG = 9;
    public static final int LOG_ALL = 10;
    private Logger svrLogger;

    public ISALogListener(int listenPort, int rcvBufferSize) throws Exception {
        super(listenPort, rcvBufferSize);
    }

    protected void processMsg(byte[] b) {
        String origMsg;
        try {
            origMsg = new String(b, 0, b.length, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error processing UTF-8 log message! " + e.getMessage(), e);
        }
        int priorityFacilitySpace = origMsg.indexOf(" ");
        int priority = Integer.parseInt(origMsg.substring(0, priorityFacilitySpace));
        int facilityMsgSpace = origMsg.indexOf(" ", priorityFacilitySpace + 1);
        String facility = origMsg.substring(priorityFacilitySpace + 1, facilityMsgSpace);
        String msg = origMsg.substring(priorityFacilitySpace + 1);
        this.svrLogger = Logger.getLogger((String)(BASE_LOGGER_NAME + facility));
        switch (priority) {
            case 9: 
            case 10: {
                this.svrLogger.debug((Object)msg);
                break;
            }
            case 5: 
            case 6: {
                this.svrLogger.info((Object)msg);
                break;
            }
            case 4: {
                this.svrLogger.warn((Object)msg);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                this.svrLogger.error((Object)msg);
                break;
            }
            case 0: {
                this.svrLogger.fatal((Object)msg);
                break;
            }
            default: {
                logger.error((Object)("  unknown priority... " + priority + " for message... " + origMsg));
            }
        }
    }
}

