/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.metadatamanager.specimpl.series;

import com.ericsson.metadatamanager.specimpl.series.SeriesIdentifier;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.specimpl.IdentifierBase;
import com.tandbergtv.metadatamanager.specimpl.SingleTitleNewSpecHandler;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;

public class SeriesSpecHandler
extends SingleTitleNewSpecHandler {
    private static final String ROOTELEMENT_NAME = "Series";

    public SeriesSpecHandler() {
        this.alias = "series";
        this.rootElementName = ROOTELEMENT_NAME;
    }

    public IIdentifier extractId(Asset asset) {
        SeriesIdentifier id = new SeriesIdentifier();
        id.setSearchService(this.getSearchService());
        id.setMappingResourceUrl(this.getMappingResourceUrl());
        Map<String, String> idXPaths = id.getTTVPaths();
        HashMap<String, String> idValues = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : idXPaths.entrySet()) {
            Field f = asset.getFirstField(entry.getValue());
            if (f == null) continue;
            idValues.put(entry.getKey(), f.getValue());
        }
        id.setSpecIdentifiers(idValues);
        return id;
    }

    public IdentifierBase getIdentifier() {
        SeriesIdentifier identifier = new SeriesIdentifier();
        identifier.setSearchService(this.searchService);
        identifier.setMappingResourceUrl(this.mappingResourceUrl);
        return identifier;
    }

    public String getSpecDisplayName() {
        return ROOTELEMENT_NAME;
    }

    public String getSpecAlias(Document doc) {
        String name = doc.getDocumentElement().getNodeName();
        return name.equals(ROOTELEMENT_NAME) ? this.getAlias() : null;
    }
}

