/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.metadatamanager.specimpl.series;

import com.tandbergtv.metadatamanager.exception.TranslationException;
import com.tandbergtv.metadatamanager.spec.ITranslator;
import com.tandbergtv.metadatamanager.util.XmlUtil;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SeriesTranslator
implements ITranslator {
    private static String ECMF_ELEMENT = "ECMFSpec";
    private static String SERIES_ELEMENT = "Series";

    public Document translate(Document doc) throws TranslationException {
        Node seriesNode = null;
        DocumentBuilder dBuilder = null;
        try {
            dBuilder = XmlUtil.borrowDocumentBuilder();
            Document d = dBuilder.newDocument();
            Element e = d.createElement(ECMF_ELEMENT);
            seriesNode = doc.getElementsByTagName(SERIES_ELEMENT).item(0);
            Node copiedSeriesNode = d.importNode(seriesNode, true);
            e.appendChild(copiedSeriesNode);
            d.appendChild(e);
            Document document = d;
            return document;
        }
        catch (Exception e) {
            throw new TranslationException("Error when translating the series doc:", (Throwable)e);
        }
        finally {
            if (dBuilder != null) {
                XmlUtil.returnDocumentBuilder((DocumentBuilder)dBuilder);
            }
        }
    }

    public void setXslStream(InputStream xslStream) {
    }

    public void setClassLoader(ClassLoader loader) {
    }
}

