/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.dummy.provider.plugin;

import com.ericsson.epgmgr.plugin.EPGPluginException;
import com.ericsson.epgmgr.plugin.IEPGManagerProvider;
import com.ericsson.epgmgr.plugin.IEPGPluginLogger;
import com.ericsson.epgmgr.plugin.IEPGPluginSimpleLogger;
import com.ericsson.epgmgr.plugin.LicenseFeature;
import com.ericsson.epgmgr.plugin.ManagementFeature;
import com.ericsson.epgmgr.plugin.PluginAttribute;
import com.ericsson.epgmgr.plugin.PluginProperty;
import com.ericsson.epgmgr.plugin.StatusMonitor;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class DummyPlugin
implements IEPGManagerProvider,
ManagementFeature,
LicenseFeature {
    private static final Logger logger = Logger.getLogger(DummyPlugin.class);
    private IEPGPluginLogger pluginLogger;
    private Locale pluginLocale;
    public static final String VERSION = "3.1";
    public static final String FORMAT = "Dummy";
    private static final String DUMMY_PROPERTY_ERR_SUFFIX = ".error";
    private static final String DUMMY_PROPERTY_DOC_SUFFIX = ".doc";
    private static Properties properties;
    public static final String HISTORYPLUGINPROPERTY = "history";
    public static Integer toEtvCount;

    static {
        toEtvCount = 0;
    }

    public List<PluginProperty> getProperties() throws EPGPluginException {
        ArrayList<PluginProperty> dummyProperties = new ArrayList<PluginProperty>();
        if (properties == null) {
            this.initializeProperties();
        }
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (key.endsWith(DUMMY_PROPERTY_DOC_SUFFIX) || key.endsWith(DUMMY_PROPERTY_ERR_SUFFIX) || key.equals(HISTORYPLUGINPROPERTY)) continue;
            String labelToolTip = properties.getProperty(String.valueOf(key) + DUMMY_PROPERTY_DOC_SUFFIX);
            String uiLabel = labelToolTip.split(",")[0];
            String uiToolTip = labelToolTip.split(",")[1];
            dummyProperties.add(new PluginProperty(key, properties.getProperty(key), null, null, uiLabel, uiToolTip, null));
        }
        return dummyProperties;
    }

    public void setLogger(IEPGPluginLogger logger) {
        this.pluginLogger = logger;
    }

    public String getFormat() throws EPGPluginException {
        return FORMAT;
    }

    public void setLocale(Locale locale) {
        this.pluginLocale = locale;
    }

    public boolean toETVFormat(List<File> inputFiles, String etvEPGFileName, List<PluginProperty> pluginProperties) throws EPGPluginException {
        Integer localInteger1 = toEtvCount;
        Integer localInteger2 = toEtvCount = Integer.valueOf(toEtvCount + 1);
        return true;
    }

    public IEPGPluginLogger getPluginLogger() {
        return this.pluginLogger;
    }

    public Locale getPluginLocale() {
        return this.pluginLocale;
    }

    private void initializeProperties() throws EPGPluginException {
        properties = new Properties();
        try {
            properties.load(DummyPlugin.class.getClassLoader().getResourceAsStream("dummy.properties"));
        }
        catch (Exception ex) {
            throw new EPGPluginException("Unable to load dummy.properties files", (Throwable)ex);
        }
    }

    public String getVersion() {
        return VERSION;
    }

    public Map<PluginAttribute, String> getAttributes() {
        HashMap<PluginAttribute, String> attributeMap = new HashMap<PluginAttribute, String>(1);
        attributeMap.put(PluginAttribute.INFO, "DUMMY Provider Plug-in");
        attributeMap.put(PluginAttribute.FTP_TO_DATABASE, "false");
        attributeMap.put(PluginAttribute.INGEST, "false");
        attributeMap.put(PluginAttribute.VALIDATE, "false");
        return attributeMap;
    }

    public boolean validateProperties(List<PluginProperty> properties) throws EPGPluginException {
        boolean isValid = true;
        logger.info((Object)"Completed validation of Dummy properties");
        return isValid;
    }

    public boolean isLicenseMandatory() {
        return false;
    }

    public String getLicenseName() {
        return null;
    }

    public void setDataSource(DataSource ds) {
    }

    public void setJobId(long jobId) {
    }

    public void cancel() {
    }

    public void setStatusMonitor(StatusMonitor statusMonitor) {
    }

    public String[] getPluginFrameworkVersions() {
        return null;
    }

    public void setSimpleLogger(IEPGPluginSimpleLogger simpeLogger) {
    }

    public Map<String, Object> getPluginStatus() {
        return null;
    }

    public Map<String, Object> fileNameAttribute() {
        return null;
    }
}

