/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.custom.validation;

import com.tandbergtv.metadatamanager.model.FieldTree;
import com.tandbergtv.metadatamanager.model.FieldTreeNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FieldTreeHelper {
    public static String LAST_NAME = "/Fields/Sources/Source/Contact/LastName";
    public static String FIRST_NAME = "/Fields/Sources/Source/Contact/FirstName";
    public static String ROLE_NAME = "/Fields/Sources/Source/Role/Name";
    public static String SOURCE = "/Fields/Sources/Source";
    public static String PRODUCER = "PRODUCER";
    public static String DIRECTOR = "DIRECTOR";
    public static String ACTOR = "ACTOR";

    public static List<FieldTree> breakApartFieldTree(List<FieldTree> fieldTree, String xpath) {
        List<String> xpathTokens = Arrays.asList(xpath.split("/"));
        xpathTokens = xpathTokens.subList(1, xpathTokens.size());
        ArrayList<FieldTree> trees = new ArrayList<FieldTree>();
        for (FieldTree tree : fieldTree) {
            List<FieldTreeNode> newTreeNodes = FieldTreeHelper.breakApartFieldTreeHelper(tree.getRootElement().getChildren(), xpathTokens, 1);
            for (FieldTreeNode node : newTreeNodes) {
                FieldTree yeffedTree = new FieldTree();
                FieldTreeNode root = new FieldTreeNode();
                root.setName(tree.getRootElement().getName());
                root.addChild(node);
                yeffedTree.setRootElement(root);
                trees.add(yeffedTree);
            }
        }
        return trees;
    }

    private static List<FieldTreeNode> breakApartFieldTreeHelper(List<FieldTreeNode> nodes, List<String> xpathTokens, int pos) {
        ArrayList<FieldTreeNode> result = new ArrayList<FieldTreeNode>();
        for (FieldTreeNode node : nodes) {
            String xpathToken = xpathTokens.get(pos);
            if (node.isAttribute() && xpathToken.startsWith("@")) {
                xpathToken = xpathToken.substring(1);
            }
            if (node.getName().equals(xpathToken) && xpathTokens.size() > pos + 1) {
                List<FieldTreeNode> childNodes = FieldTreeHelper.breakApartFieldTreeHelper(node.getChildren(), xpathTokens, pos + 1);
                for (FieldTreeNode childNode : childNodes) {
                    FieldTreeNode brokenParent = new FieldTreeNode();
                    brokenParent.setAttribute(node.isAttribute());
                    brokenParent.setCurrentIndex(node.getCurrentIndex());
                    brokenParent.setField(node.getField());
                    brokenParent.setName(node.getName());
                    ArrayList<FieldTreeNode> newChildList = new ArrayList<FieldTreeNode>();
                    newChildList.add(childNode);
                    brokenParent.setChildren(newChildList);
                    result.add(brokenParent);
                }
                continue;
            }
            if (!node.getName().equals(xpathToken)) continue;
            result.add(node);
        }
        return result;
    }
}

