/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.license.utils;

import java.io.File;
import java.io.FileInputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.apache.log4j.Logger;

public class ValidateLicenseMonitorAudit {
    private static final Logger logger = Logger.getLogger(ValidateLicenseMonitorAudit.class);
    private static String url = null;
    private static String DATE_FORMAT = "MM-dd-yyyy HH:mm:ss";
    private static String PGSQL_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static Date startDate = null;
    private static Date endDate = null;
    private static String user;
    private static String pwd;
    private static String jdbcDriver;
    private static String dbInstance;
    private static List<Long> tamperedIds;
    private static String key;
    private static Cipher cipher;
    private static SecretKey desKey;
    private static int count;

    public ValidateLicenseMonitorAudit() {
        try {
            this.setUp();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private void setUp() throws Exception {
        this.readProperties("validate.properties");
        DESKeySpec dks = new DESKeySpec(key.getBytes());
        SecretKeyFactory skf = SecretKeyFactory.getInstance("DES");
        desKey = skf.generateSecret(dks);
        cipher = Cipher.getInstance("DES");
    }

    private void readProperties(String propertyFile) {
        Properties prop = new Properties();
        try {
            File f = new File(propertyFile);
            if (!f.exists()) {
                propertyFile = "conf/" + propertyFile;
            }
            FileInputStream fis = new FileInputStream(propertyFile);
            prop.load(fis);
            jdbcDriver = prop.getProperty("jdbc.driverClassName");
            if (url == null) {
                url = prop.getProperty("jdbc.connectionUrl");
            }
            user = prop.getProperty("jdbc.username");
            pwd = prop.getProperty("jdbc.password");
            dbInstance = prop.getProperty("jdbc.dbinstance");
            url = url.replace("ttv", dbInstance);
            logger.info((Object)("jdbcDriver=" + jdbcDriver));
            logger.info((Object)("url=" + url));
            logger.info((Object)("user=" + user));
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new RuntimeException("Error reading property file");
        }
    }

    private void validate() {
        Connection conn = null;
        try {
            conn = this.getConnection();
            String string = this.runValidation(conn);
        }
        finally {
            this.closeConnection(conn);
        }
    }

    private String runValidation(Connection conn) {
        String start_date = new SimpleDateFormat(PGSQL_DATE_FORMAT).format(startDate);
        String end_date = new SimpleDateFormat(PGSQL_DATE_FORMAT).format(endDate);
        Timestamp license_previouscreatedate = null;
        String audit_type = null;
        String audit_hash = null;
        String query_cms_license_audit = "Select * from wfs.cms_license_audit where createdate between '" + start_date + "' and '" + end_date + "' order by CREATEDATE asc";
        try {
            PreparedStatement stmt_license = conn.prepareStatement(query_cms_license_audit);
            ResultSet rset_license = stmt_license.executeQuery();
            count = 0;
            int audit_count = 0;
            while (rset_license.next()) {
                ++count;
                long license_id = 0L;
                String license_type = null;
                String license_usage = null;
                Timestamp license_createdate = null;
                Timestamp license_updatedate = null;
                long audit_id = 0L;
                audit_type = null;
                audit_hash = null;
                audit_count = 0;
                license_id = rset_license.getLong(1);
                license_type = rset_license.getString(2);
                license_usage = rset_license.getString(3);
                license_createdate = rset_license.getTimestamp(4);
                license_updatedate = rset_license.getTimestamp(5);
                if (license_previouscreatedate == null) {
                    license_previouscreatedate = license_createdate;
                }
                String query_cms_audit_trail = "Select * from wfs.cms_audit_trail where id_ = " + license_id;
                PreparedStatement stmt_audit = conn.prepareStatement(query_cms_audit_trail);
                ResultSet rset_audit = stmt_audit.executeQuery();
                while (rset_audit.next()) {
                    if (audit_count != 0) {
                        tamperedIds.add(license_id);
                    }
                    audit_id = rset_audit.getLong(1);
                    audit_type = rset_audit.getString(2);
                    audit_hash = rset_audit.getString(3);
                    ++audit_count;
                }
                if ((license_createdate.after((Date)license_previouscreatedate) || count == 1) && license_type.equals(audit_type) && Math.abs(((Date)license_updatedate).getTime() - ((Date)license_createdate).getTime()) < 360000L) {
                    if (this.decryptAndCompare(license_createdate, license_usage, audit_hash).booleanValue()) continue;
                    tamperedIds.add(license_id);
                    continue;
                }
                tamperedIds.add(license_id);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return null;
    }

    private Boolean decryptAndCompare(Date license_createdate, String license_usage, String audit_hash) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        cipher.init(2, desKey);
        String decrypt_usage = new String(cipher.doFinal(DatatypeConverter.parseBase64Binary((String)license_usage)));
        String encrypt_hash = this.encryptSha1(decrypt_usage + '-' + license_createdate.getTime());
        if (encrypt_hash.equals(audit_hash)) {
            return true;
        }
        return false;
    }

    private String encryptSha1(String source) {
        try {
            MessageDigest digest = null;
            digest = MessageDigest.getInstance("SHA-1");
            digest.reset();
            digest.update(source.getBytes("UTF-8"));
            return DatatypeConverter.printBase64Binary((byte[])digest.digest());
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    private void closeConnection(Connection conn) {
        try {
            if (conn != null) {
                conn.commit();
                conn.close();
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
    }

    private Connection getConnection() {
        Connection conn;
        try {
            conn = DriverManager.getConnection(url, user, pwd);
            conn.setAutoCommit(false);
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new RuntimeException("Error connecting to database");
        }
        return conn;
    }

    private static void parseCmdLineOptions(String[] args) throws ParseException {
        if (args.length > 1) {
            ValidateLicenseMonitorAudit.setUrl(args[0]);
            ValidateLicenseMonitorAudit.setStartDate(args[1]);
            if (args.length > 2) {
                ValidateLicenseMonitorAudit.setEndDate(args[2]);
            } else {
                ValidateLicenseMonitorAudit.setEndDate("12-31-9999");
            }
        } else if (args.length == 0) {
            System.out.println("Target DB was not specified. Exiting. Please refer readme file.");
            System.exit(0);
        } else {
            ValidateLicenseMonitorAudit.setUrl(args[0]);
            ValidateLicenseMonitorAudit.setStartDate("01-01-1970");
            ValidateLicenseMonitorAudit.setEndDate("12-31-9999");
        }
    }

    private static void setEndDate(String string) throws ParseException {
        endDate = new SimpleDateFormat(DATE_FORMAT).parse(string + " 23:59:59");
        System.out.println("End Date: " + endDate);
    }

    private static void setStartDate(String string) throws ParseException {
        startDate = new SimpleDateFormat(DATE_FORMAT).parse(string + " 00:00:00");
        System.out.println("Start Date: " + startDate);
    }

    private static void setUrl(String dbServer) {
        StringBuilder sb = new StringBuilder();
        sb.append("jdbc:postgresql://");
        sb.append(dbServer);
        sb.append(":5432/ttv");
        url = sb.toString();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Job started ....");
        if (args != null) {
            ValidateLicenseMonitorAudit.parseCmdLineOptions(args);
        }
        ValidateLicenseMonitorAudit loader = new ValidateLicenseMonitorAudit();
        loader.validate();
        System.out.println("Report: ");
        if (tamperedIds.size() != 0) {
            System.out.println("Following Ids are tampered with:");
            String tempId = tamperedIds.toString();
            System.out.println(tempId.substring(1, tempId.length() - 1).replaceAll(", ", "\n"));
        } else {
            System.out.println("No discrepancies found");
        }
        System.out.println("Total number of records processed: " + count);
        System.out.println("Job completed.");
        System.exit(0);
    }

    static {
        tamperedIds = new ArrayList<Long>();
        key = "F!FAF3VR";
        count = 0;
    }
}

