/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.client;

import com.tandbergtv.cms.services.resources.Errors;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.httpclient.HttpException;

public class AuthUtils {
    public static void handleResponse(int responseCode) throws IOException, HttpException {
        AuthUtils.handleResponse(responseCode, null, true);
    }

    public static void handleResponse(int responseCode, InputStream is, boolean exitOnFailure) throws IOException, HttpException {
        String errString = "Cannot Export/Import, ";
        switch (responseCode) {
            case 200: {
                return;
            }
            case 401: {
                errString = errString + "user is unauthorized";
                exitOnFailure = true;
                break;
            }
            case 403: {
                errString = errString + "user has insufficient permissions";
                exitOnFailure = true;
                break;
            }
            default: {
                Errors errors = null;
                String errList = "";
                try {
                    JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Errors.class});
                    Unmarshaller u = jc.createUnmarshaller();
                    errors = (Errors)u.unmarshal(is);
                    errList = errList + errors.getErrors();
                }
                catch (Exception jc) {
                    // empty catch block
                }
                Response.Status responseStatus = Response.Status.fromStatusCode((int)responseCode);
                errString = errString + (responseStatus == null ? "status code " + responseCode + " was returned" : "reason: " + responseStatus);
                if (errList.length() <= 0) break;
                errString = errString + "\nList of errors:" + errList;
            }
        }
        System.err.println(errString);
        if (exitOnFailure) {
            System.exit(1);
        }
    }
}

