/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.client;

import com.tandbergtv.cms.services.client.ContentClassServiceProxy;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CCImport {
    private static Set<String> restrictedCCTypes = new HashSet<String>(Arrays.asList("Offer", "Category", "Series"));
    private static final String XML_TAG_NAME = "<name>";
    private static final String XML_END_TAG_NAME = "</name>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleImport(ContentClassServiceProxy proxy, String fileName, String partner) {
        System.out.println("===> start import ...");
        Map<Integer, String> contentClassTypes = proxy.getContentClassTypes();
        BufferedReader reader = null;
        try {
            int len;
            reader = new BufferedReader(new FileReader(new File(fileName)));
            char[] cbuf = new char[10240];
            StringBuffer sbuf = new StringBuffer();
            while ((len = reader.read(cbuf)) > 0) {
                sbuf.append(cbuf, 0, len);
                int idxEnd = sbuf.indexOf("</contentClass>");
                if (idxEnd < 0) continue;
                int idxStart = sbuf.indexOf("<contentClass");
                if (idxStart >= 0) {
                    int metaDataIndex;
                    String xml = sbuf.substring(idxStart, idxEnd + "</contentClass>".length());
                    String searchLine = xml.substring(0, metaDataIndex = xml.indexOf("<metadata"));
                    if (CCImport.isValidContentCalss(contentClassTypes, searchLine)) {
                        String resp = proxy.importXml(xml, partner);
                        if (resp != null) {
                            System.out.println(resp);
                        }
                    } else {
                        System.out.println("Rejected: content class name is invalid : " + CCImport.getXmlContentClassName(searchLine) + " , allowed name for this type is : " + contentClassTypes.get(CCImport.getXmlContentClassTypeId(searchLine)));
                    }
                } else {
                    System.out.println("Error: missing <contentClass> tag.");
                }
                sbuf.delete(0, idxEnd + "</contentClass>".length());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
        System.out.println("===> end import...");
    }

    private static boolean isValidContentCalss(Map<Integer, String> contentClassTypes, String toSearch) {
        boolean isValidContentClassName = true;
        Integer ccTypeId = CCImport.getXmlContentClassTypeId(toSearch);
        String xmlCCName = CCImport.getXmlContentClassName(toSearch);
        String ccTypeName = contentClassTypes.get(ccTypeId);
        if (restrictedCCTypes.contains(ccTypeName) && !xmlCCName.equals(ccTypeName)) {
            isValidContentClassName = false;
        }
        return isValidContentClassName;
    }

    private static Integer getXmlContentClassTypeId(String toSearch) {
        int typeIndex = toSearch.indexOf("type");
        int quotationMarkIndex1 = toSearch.indexOf(34, typeIndex);
        int quotationMarkIndex2 = toSearch.indexOf(34, quotationMarkIndex1 + 1);
        return Integer.parseInt(toSearch.substring(quotationMarkIndex1 + 1, quotationMarkIndex2).replaceAll("\\s", ""));
    }

    private static String getXmlContentClassName(String toSearch) {
        int startIndex = toSearch.indexOf(XML_TAG_NAME);
        int endIndex = toSearch.indexOf(XML_END_TAG_NAME);
        String xmlCCName = toSearch.substring(startIndex, endIndex).replace(XML_TAG_NAME, "");
        return xmlCCName;
    }
}

