/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.client;

import com.tandbergtv.cms.services.client.AuthUtils;
import java.beans.XMLDecoder;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.contrib.ssl.EasySSLProtocolSocketFactory;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

public class ContentClassServiceProxy {
    private static final String DEFAULT_SERVICES_PATH_PREFIX = "/services";
    private static final String EXPORT_PATH = "/resteasy/contentclassservice/contentclassexport";
    private static final String IMPORT_PATH = "/resteasy/contentclassservice/contentclassimport";
    private static final String IDS_PATH = "/resteasy/contentclassservice/contentclassids";
    private static final String TYPES_PATH = "/resteasy/contentclassservice/contentclasstypes";
    private String serverURL;
    private HttpClient httpClient;

    public ContentClassServiceProxy(String serverURL, String userName, String password) {
        this.serverURL = serverURL;
        this.httpClient = this.createClient(userName, password);
    }

    public String importXml(String xml, String partner) {
        try {
            PostMethod post = new PostMethod(this.serverURL + DEFAULT_SERVICES_PATH_PREFIX + IMPORT_PATH);
            post.addParameter("partner", partner);
            post.addParameter("xml", xml);
            int responseCode = this.httpClient.executeMethod((HttpMethod)post);
            AuthUtils.handleResponse(responseCode);
            return post.getResponseBodyAsString();
        }
        catch (Exception ex) {
            System.out.println("Could not import XML.");
            System.out.println(xml);
            ex.printStackTrace();
            return null;
        }
    }

    public String exportXml(String contentClassId, boolean exportPartners) {
        try {
            PostMethod post = new PostMethod(this.serverURL + DEFAULT_SERVICES_PATH_PREFIX + EXPORT_PATH);
            post.addParameter("id", contentClassId);
            post.addParameter("partner", String.valueOf(exportPartners));
            int responseCode = this.httpClient.executeMethod((HttpMethod)post);
            AuthUtils.handleResponse(responseCode);
            return post.getResponseBodyAsString();
        }
        catch (Exception ex) {
            System.out.println("Could not export content class " + contentClassId);
            ex.printStackTrace();
            return null;
        }
    }

    public String getAllContentClassIds() {
        try {
            PostMethod post = new PostMethod(this.serverURL + DEFAULT_SERVICES_PATH_PREFIX + IDS_PATH);
            int responseCode = this.httpClient.executeMethod((HttpMethod)post);
            AuthUtils.handleResponse(responseCode);
            return post.getResponseBodyAsString();
        }
        catch (Exception ex) {
            System.out.println("Could not get all content class ids");
            return null;
        }
    }

    public Map<Integer, String> getContentClassTypes() {
        try {
            PostMethod post = new PostMethod(this.serverURL + DEFAULT_SERVICES_PATH_PREFIX + TYPES_PATH);
            int responseCode = this.httpClient.executeMethod((HttpMethod)post);
            AuthUtils.handleResponse(responseCode);
            String ccTypes = post.getResponseBodyAsString();
            XMLDecoder xmlDecoder = new XMLDecoder(new ByteArrayInputStream(ccTypes.getBytes()));
            Map ccTypesMap = (Map)xmlDecoder.readObject();
            return ccTypesMap;
        }
        catch (Exception ex) {
            System.out.println("Could not get all content class ids");
            return null;
        }
    }

    private HttpClient createClient(String userId, String password) {
        ArrayList<String> authPrefs = new ArrayList<String>(2);
        authPrefs.add("Digest");
        authPrefs.add("Basic");
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(userId, password);
        HttpClient httpClient = new HttpClient();
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        httpClient.getParams().setAuthenticationPreemptive(true);
        httpClient.getParams().setParameter("http.auth.scheme-priority", authPrefs);
        Protocol easyhttps = new Protocol("https", (SecureProtocolSocketFactory)new EasySSLProtocolSocketFactory(), 443);
        Protocol.registerProtocol((String)"https", (Protocol)easyhttps);
        return httpClient;
    }
}

