/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.client;

import com.tandbergtv.cms.data.RuleSetToSave;
import com.tandbergtv.cms.data.RuleSetsListing;
import com.tandbergtv.cms.services.client.AuthUtils;
import com.tandbergtv.cms.services.client.OrderBasedComparator;
import com.tandbergtv.marvin.udt.TreRuleSet;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Console;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.contrib.ssl.EasySSLProtocolSocketFactory;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesServiceClient {
    private static Logger logger = LoggerFactory.getLogger((String)RulesServiceClient.class.getName());
    public static final String PROGRAM_SHORT_NAME = "csc";
    public static final String PROGRAM_VERSION_NUMBER = "1.0";
    public static final String ACTION_IMPORT = "import";
    public static final String ACTION_EXPORT = "export";
    public static final String DEFAULT_RULE_SETS_EXPORT_FILE_NAME_PREFIX = "RuleSets";
    public static final String DEFAULT_RULE_SETS_EXPORT_FILE_NAME_EXTENSION = "xml";
    public static final String DEFAULT_DATE_TIME_FORMAT_STRING = "yyyyMMdd.HHmmss.SSS";
    public static final DateFormat DEFAULT_DATE_TIME_FORMAT = new SimpleDateFormat("yyyyMMdd.HHmmss.SSS");
    public static final String DEFAULT_SERVICES_PATH_PREFIX = "/services";
    public static final String UPGRADE_SUFFIX = "Upgraded";
    public static final String UPGRADE_MESSAGE = "Need Upgrading some rules. Generating Upgraded Rules File: ";
    private static int rulesToImport = 0;
    private static long startTime = 0L;
    private static HttpClient httpClient;
    private static String serverURL;
    private static final String SERVICES_PATH_RULESET_SAVE = "/rulesservice/saveRuleSet";
    private static final String SERVICES_PATH_RULESETS_EXPORT = "/rulesservice/getRuleSets";
    private static final String SERVICES_PATH_RULESETS_UUID = "/rulesservice/getRuleSetsByUuid";
    private static final String SERVICES_PATH_RELOAD_CACHE = "/rulesservice/reloadCache";
    private static final String XML_MEDIA = "application/xml";
    private static final String UTF_8 = "UTF-8";

    public static void main(String[] args) {
        startTime = new Date().getTime();
        GnuParser parser = new GnuParser();
        Options options = RulesServiceClient.createOptions();
        String userName = null;
        String password = null;
        String action = null;
        String fileName = null;
        HelpFormatter strRuleSetIds = null;
        boolean useEnabled = false;
        ArrayList<Integer> ruleSetIds = new ArrayList<Integer>();
        boolean overwrite = false;
        boolean reloadCache = false;
        boolean badInputs = false;
        boolean ignoreInvalidSchedule = false;
        try {
            HelpFormatter formatter;
            for (int num = 0; num < args.length; ++num) {
                logger.info("arg : " + args[num].toString());
            }
            CommandLine commandLine = parser.parse(options, args);
            Option[] optionsArray = commandLine.getOptions();
            int numOptions = optionsArray.length;
            if (numOptions < 1 || commandLine.hasOption("help") || commandLine.hasOption("usage")) {
                formatter = new HelpFormatter();
                formatter.printHelp(PROGRAM_SHORT_NAME, options);
            }
            if (commandLine.hasOption("version")) {
                logger.info("csc : 1.0");
            }
            if (commandLine.hasOption("action")) {
                action = commandLine.getOptionValue("action");
                logger.info("action : " + action);
                if (RulesServiceClient.isValidAction(action)) {
                    userName = commandLine.getOptionValue("username");
                    password = commandLine.getOptionValue("password");
                    fileName = commandLine.getOptionValue("file");
                    serverURL = commandLine.getOptionValue("serverURL");
                    strRuleSetIds = commandLine.getOptionValues("ruleSetIds");
                    overwrite = commandLine.hasOption("overwrite");
                    useEnabled = commandLine.hasOption("useEnabledFlag");
                    logger.debug("username : " + userName);
                    logger.debug("password : " + password);
                    logger.debug("fileName : " + fileName);
                    logger.debug("serverURL : " + serverURL);
                    logger.debug("strRuleSetIds : " + strRuleSetIds);
                    logger.debug("overwrite : " + overwrite);
                    if (userName == null) {
                        System.err.println("'username' is required.");
                        badInputs = true;
                    }
                    if (password == null) {
                        System.err.println("'password' is required.");
                        badInputs = true;
                    }
                    if (serverURL == null) {
                        System.err.println("'serverURL' is required.");
                        badInputs = true;
                    }
                    if (fileName == null) {
                        if (ACTION_EXPORT.equalsIgnoreCase(action)) {
                            fileName = RulesServiceClient.getDefaultRuleSetsExportFileName();
                        } else {
                            System.err.println("For 'import' action, a rule sets 'file' is required.");
                            badInputs = true;
                        }
                    }
                    if (strRuleSetIds == null || ((String[])strRuleSetIds).length < 1) {
                        if (ACTION_EXPORT.equalsIgnoreCase(action)) {
                            System.err.println("For 'export' action, one or more rule sets Ids are required.");
                            badInputs = true;
                        }
                    } else {
                        for (HelpFormatter strRuleSetId : strRuleSetIds) {
                            try {
                                ruleSetIds.add(Integer.parseInt((String)strRuleSetId));
                            }
                            catch (NumberFormatException e) {
                                String msg = "RuleSet Id needs to be an integer. " + (String)strRuleSetId + " would be ignored.";
                                logger.warn(msg);
                            }
                        }
                    }
                    if (!badInputs) {
                        String actionMsg = "csc 1.0 : Processing action=" + action + " with file=" + fileName;
                        logger.info(actionMsg);
                        RulesServiceClient.processAction(action, userName, password, fileName, overwrite, ruleSetIds, useEnabled, reloadCache, ignoreInvalidSchedule);
                    } else {
                        formatter = new HelpFormatter();
                        formatter.printHelp(PROGRAM_SHORT_NAME, options);
                    }
                }
            }
        }
        catch (Exception exp) {
            logger.error("Exception occurred: ", (Throwable)exp);
        }
    }

    private static void processAction(String action, String userName, String password, String fileName, boolean overwrite, List<Integer> ruleSetIds, boolean useEnabled, boolean reloadCache, boolean ignoreInvalidSchedule) {
        httpClient = RulesServiceClient.createClient(userName, password);
        try {
            if (reloadCache) {
                logger.info("Reloading Cache");
                RulesServiceClient.reloadCache();
                logger.info("Reloading Cache Finished");
            }
            if (ACTION_EXPORT.equalsIgnoreCase(action)) {
                if (ruleSetIds.size() > 0) {
                    logger.info("===> start export ...");
                    PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
                    RulesServiceClient.exportRuleSets(ruleSetIds, out);
                    logger.info("===> end export ...");
                } else {
                    logger.info("===> No rule set ids provided for export. Nothing will be exported ...");
                }
            } else if (ACTION_IMPORT.equalsIgnoreCase(action)) {
                RulesServiceClient.saveRuleSets(fileName, overwrite, useEnabled, ignoreInvalidSchedule);
            }
        }
        catch (Exception e) {
            logger.error("Exception occurred processing action=" + action + " with fileName=" + fileName, (Throwable)e);
        }
    }

    private static void reloadCache() throws HttpException, IOException {
        PostMethod postMethod = new PostMethod(serverURL + DEFAULT_SERVICES_PATH_PREFIX + SERVICES_PATH_RELOAD_CACHE);
        int responseCode = httpClient.executeMethod((HttpMethod)postMethod);
        AuthUtils.handleResponse(responseCode);
    }

    private static RuleSetsListing getRuleSetsByUuid(String uuid) throws HttpException, IOException, JAXBException {
        PostMethod postMethod = new PostMethod(serverURL + DEFAULT_SERVICES_PATH_PREFIX + SERVICES_PATH_RULESETS_UUID);
        postMethod.addParameter("uuid", uuid);
        int responseCode = httpClient.executeMethod((HttpMethod)postMethod);
        AuthUtils.handleResponse(responseCode);
        InputStream is = postMethod.getResponseBodyAsStream();
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{RuleSetsListing.class});
        Unmarshaller u = jc.createUnmarshaller();
        RuleSetsListing ruleSetsListing = (RuleSetsListing)u.unmarshal(is);
        return ruleSetsListing;
    }

    private static void exportRuleSets(List<Integer> ruleSetIds, PrintWriter out) throws HttpException, IOException, JAXBException {
        logger.info("Exporting rulesets, please wait... ");
        PostMethod postMethod = new PostMethod(serverURL + DEFAULT_SERVICES_PATH_PREFIX + SERVICES_PATH_RULESETS_EXPORT);
        postMethod.addParameter("ruleSetIds", StringUtils.join(ruleSetIds, (char)','));
        int responseCode = httpClient.executeMethod((HttpMethod)postMethod);
        AuthUtils.handleResponse(responseCode);
        InputStream is = postMethod.getResponseBodyAsStream();
        IOUtils.copy((InputStream)is, (Writer)out);
        out.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveRuleSets(String fileName, boolean defaultOverwrite, boolean useEnabled, boolean ignoreInvalidSchedule) {
        Object orderBasedComparator;
        logger.info("Saving ruleSets from fileName = " + fileName);
        List ruleSets = null;
        try {
            String upgradedRulesFileName;
            fileName = upgradedRulesFileName = RulesServiceClient.upgradeFields(fileName);
            if (!upgradedRulesFileName.equals(fileName)) {
                logger.info("Saving ruleSets from upgradedRulesFileName = " + upgradedRulesFileName);
            }
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{RuleSetsListing.class});
            Unmarshaller u = jc.createUnmarshaller();
            RuleSetsListing ruleSetsListing = (RuleSetsListing)u.unmarshal(new File(fileName));
            ruleSets = ruleSetsListing.getRuleSets();
            int numRuleSetsLoaded = ruleSets.size();
            logger.info("Loaded " + numRuleSetsLoaded + " rule sets from file : " + fileName);
            orderBasedComparator = new OrderBasedComparator();
            Collections.sort(ruleSets, orderBasedComparator);
        }
        catch (Exception e) {
            logger.error("Exception occured loading or ordering rule sets : ", (Throwable)e);
        }
        rulesToImport = ruleSets.size();
        Integer iRuleSet = 0;
        Iterator iterator = ruleSets.iterator();
        while (iterator.hasNext()) {
            TreRuleSet treRuleSet = (TreRuleSet)iterator.next();
            Integer ruleSetId = treRuleSet.getRuleSetId();
            treRuleSet.setIgnoreInvalidSchedule(ignoreInvalidSchedule);
            Integer numRuleSetsLoaded = iRuleSet;
            iRuleSet = iRuleSet + 1;
            orderBasedComparator = iRuleSet;
            try {
                boolean overwrite;
                boolean skipImport;
                block16: {
                    block17: {
                        logger.info("Got ruleSet with Id : " + ruleSetId);
                        skipImport = false;
                        overwrite = defaultOverwrite;
                        if (overwrite) break block16;
                        UUID uuid = treRuleSet.getUuid();
                        if (uuid == null) break block17;
                        RuleSetsListing ruleSetsListingByUuid = RulesServiceClient.getRuleSetsByUuid(uuid.toString());
                        List ruleSetsByUuid = ruleSetsListingByUuid.getRuleSets();
                        int numRuleSets = ruleSetsByUuid.size();
                        logger.debug("Got numRuleSets = " + numRuleSets + " by UUID : " + uuid + " in target system...");
                        if (numRuleSets != 0 && ((TreRuleSet)ruleSetsByUuid.get(0)).getEnabled().booleanValue()) {
                            logger.info("Cannot overwrite RuleSet [" + uuid + "] because it's currently enabled.");
                            continue;
                        }
                        if (numRuleSets > 1) {
                            logger.warn("Got more than 1 RuleSets by UUID : " + uuid + " from importing ruleSetId : " + ruleSetId + " in target system. Check target system.");
                            logger.warn("Skipping RuleSet import...");
                            skipImport = true;
                            break block16;
                        } else {
                            if (numRuleSets == 1) {
                                logger.info("Found 1 RuleSet by UUID : " + uuid + " from importing ruleSetId : " + ruleSetId + " in target system.");
                                Console console = System.console();
                                if (console != null) {
                                    String overwriteYN = console.readLine("RuleSet with UUID : " + uuid + " already exists in target system. Overwrite (Y/N): ", new Object[0]);
                                    boolean userConfirmedOverwrite = false;
                                    if (overwriteYN != null && "Y".equalsIgnoreCase(overwriteYN.trim())) {
                                        logger.info("RuleSet with UUID : " + uuid + " would be overwritten in the target system.");
                                        userConfirmedOverwrite = true;
                                    }
                                    if (userConfirmedOverwrite) {
                                        overwrite = true;
                                        break block16;
                                    } else {
                                        logger.info("User did not confirm ovewrite RuleSet with UUID : " + uuid + " in the target system. Skipping this RuleSet...");
                                        skipImport = true;
                                        continue;
                                    }
                                }
                                logger.error("No console. Cannot read user inputs. Hence skipping import of this ruleSet...");
                                skipImport = true;
                                continue;
                            }
                            logger.info("No Rule Sets found with importing RuleSet's UUID : " + uuid + ". Setting overwrite to true and import...");
                            overwrite = true;
                        }
                        break block16;
                    }
                    overwrite = true;
                }
                if (!useEnabled) {
                    treRuleSet.setEnabled(Boolean.valueOf(false));
                }
                if (skipImport) continue;
                RuleSetToSave ruleSetToSave = new RuleSetToSave();
                ruleSetToSave.setRuleSet(treRuleSet);
                ruleSetToSave.setOverwrite(overwrite);
                RuleSetTask task = new RuleSetTask(ruleSetToSave, iRuleSet, ruleSets.size());
                task.importRuleSet();
            }
            catch (Exception e) {
                logger.error("Exception occured importing rule set with Id : " + ruleSetId + " : " + e, (Throwable)e);
                continue;
            }
            break;
        }
        return;
    }

    private static HttpClient createClient(String userId, String password) {
        ArrayList<String> authPrefs = new ArrayList<String>(2);
        authPrefs.add("Digest");
        authPrefs.add("Basic");
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(userId, password);
        HttpClient httpClient = new HttpClient();
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        httpClient.getParams().setAuthenticationPreemptive(true);
        httpClient.getParams().setParameter("http.auth.scheme-priority", authPrefs);
        Protocol easyhttps = new Protocol("https", (SecureProtocolSocketFactory)new EasySSLProtocolSocketFactory(), 443);
        Protocol.registerProtocol((String)"https", (Protocol)easyhttps);
        return httpClient;
    }

    private static boolean isValidAction(String action) {
        boolean isValidAction = false;
        if (ACTION_IMPORT.equalsIgnoreCase(action) || ACTION_EXPORT.equalsIgnoreCase(action)) {
            isValidAction = true;
        }
        return isValidAction;
    }

    private static Options createOptions() {
        Options options = new Options();
        Option optionHelp = new Option("help", "print this message");
        Option optionVersion = new Option("version", "print the version information and exist");
        OptionBuilder.withArgName((String)"[import | export]");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"import/export action");
        Option optionAction = OptionBuilder.create((String)"action");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Import/export file path");
        Option optionFile = OptionBuilder.create((String)"file");
        OptionBuilder.withArgName((String)"serverURL");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Server Host URL, e.g., http://localhost:8080");
        Option optionServerURL = OptionBuilder.create((String)"serverURL");
        OptionBuilder.withArgName((String)"username");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"User Name");
        Option optionUserName = OptionBuilder.create((String)"username");
        OptionBuilder.withArgName((String)"password");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Password");
        Option optionPassword = OptionBuilder.create((String)"password");
        OptionBuilder.withArgName((String)"useEnabledFlag");
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"When this option is used the rule sets will be imported using the enabled status within the rule set xml.  When this option is not present the rule sets will be set to disabled upon import.");
        Option optionUseEnabledFlag = OptionBuilder.create((String)"useEnabledFlag");
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Overwrite (true/false) when the Rule Set with same UUID already exists in the system");
        Option optionOverwrite = OptionBuilder.create((String)"overwrite");
        OptionBuilder.withArgName((String)"ruleSetIds");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"One or more RuleSet Ids separated by spaces");
        Option ruleSetIds = OptionBuilder.create((String)"ruleSetIds");
        options.addOption(optionHelp);
        options.addOption(optionVersion);
        options.addOption(optionAction);
        options.addOption(optionOverwrite);
        options.addOption(optionFile);
        options.addOption(optionServerURL);
        options.addOption(optionUserName);
        options.addOption(optionPassword);
        options.addOption(ruleSetIds);
        options.addOption(optionUseEnabledFlag);
        return options;
    }

    private static String getDefaultRuleSetsExportFileName() {
        String defaultRuleSetsExportFileName = DEFAULT_RULE_SETS_EXPORT_FILE_NAME_PREFIX;
        Date now = new Date();
        String datePartString = DEFAULT_DATE_TIME_FORMAT.format(now);
        defaultRuleSetsExportFileName = defaultRuleSetsExportFileName + "." + datePartString + "." + DEFAULT_RULE_SETS_EXPORT_FILE_NAME_EXTENSION;
        return defaultRuleSetsExportFileName;
    }

    private static String upgradeFields(String filename) throws Exception {
        String resultFile = filename;
        File xmlFile = new File(filename);
        String upgradedRulesFileName = filename;
        StringBuffer sb = new StringBuffer();
        BufferedReader br = null;
        BufferedWriter bw = null;
        try {
            br = new BufferedReader(new FileReader(xmlFile));
            String line = null;
            boolean needsUpgrade = false;
            while ((line = br.readLine()) != null) {
                if (line.contains("<fieldLeft>/Fields/OSVOD/AssociationId</fieldLeft>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<fieldLeft>/Fields/OSVOD/AssociationId</fieldLeft>", "<fieldLeft>/Fields/OSVOD/AssociationIds/AssociationId</fieldLeft>");
                }
                if (line.contains("<value>/Fields/OSVOD/AssociationId</value>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<value>/Fields/OSVOD/AssociationId</value>", "<value>/Fields/OSVOD/AssociationIds/AssociationId</value>");
                }
                if (line.contains("<fieldLeft>/Fields/OSVOD/ViewingWindow</fieldLeft>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<fieldLeft>/Fields/OSVOD/ViewingWindow</fieldLeft>", "<fieldLeft>/Fields/OSVOD/ViewingWindows/ViewingWindow</fieldLeft>");
                }
                if (line.contains("<value>/Fields/OSVOD/ViewingWindow</value>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<value>/Fields/OSVOD/ViewingWindow</value>", "<value>/Fields/OSVOD/ViewingWindows/ViewingWindow</value>");
                }
                if (line.contains("<fieldLeft>/Fields/Avail</fieldLeft>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<fieldLeft>/Fields/Avail</fieldLeft>", "<fieldLeft>/Fields/Avails/Avail</fieldLeft>");
                }
                if (line.contains("<value>/Fields/Avail</value>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<value>/Fields/Avail</value>", "<value>/Fields/Avails/Avail</value>");
                }
                if (line.contains("<fieldLeft>/Fields/Avail/TimeCodeOne</fieldLeft>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<fieldLeft>/Fields/Avail/TimeCodeOne</fieldLeft>", "<fieldLeft>/Fields/Avails/Avail/TimeCodeOne</fieldLeft>");
                }
                if (line.contains("<value>/Fields/Avail/TimeCodeOne</value>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<value>/Fields/Avail/TimeCodeOne</value>", "<value>/Fields/Avails/Avail/TimeCodeOne</value>");
                }
                if (line.contains("<fieldLeft>/Fields/Avail/TimeCodeTwo</fieldLeft>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<fieldLeft>/Fields/Avail/TimeCodeTwo</fieldLeft>", "<fieldLeft>/Fields/Avails/Avail/TimeCodeTwo</fieldLeft>");
                }
                if (line.contains("<value>/Fields/Avail/TimeCodeTwo</value>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<value>/Fields/Avail/TimeCodeTwo</value>", "<value>/Fields/Avails/Avail/TimeCodeTwo</value>");
                }
                if (line.contains("<fieldLeft>/Fields/Avail/TimeCodeThree</fieldLeft>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<fieldLeft>/Fields/Avail/TimeCodeThree</fieldLeft>", "<fieldLeft>/Fields/Avails/Avail/TimeCodeThree</fieldLeft>");
                }
                if (line.contains("<value>/Fields/Avail/TimeCodeThree</value>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<value>/Fields/Avail/TimeCodeThree</value>", "<value>/Fields/Avails/Avail/TimeCodeThree</value>");
                }
                if (line.contains("<fieldLeft>/Fields/Avail/TimeCodeFour</fieldLeft>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<fieldLeft>/Fields/Avail/TimeCodeFour</fieldLeft>", "<fieldLeft>/Fields/Avails/Avail/TimeCodeFour</fieldLeft>");
                }
                if (line.contains("<value>/Fields/Avail/TimeCodeFour</value>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<value>/Fields/Avail/TimeCodeFour</value>", "<value>/Fields/Avails/Avail/TimeCodeFour</value>");
                }
                if (line.contains("<fieldLeft>/Fields/Avail/Id</fieldLeft>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<fieldLeft>/Fields/Avail/Id</fieldLeft>", "<fieldLeft>/Fields/Avails/Avail/Id</fieldLeft>");
                }
                if (line.contains("<value>/Fields/Avail/Id</value>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<value>/Fields/Avail/Id</value>", "<value>/Fields/Avails/Avail/Id</value>");
                }
                if (line.contains("<fieldLeft>/Fields/Avail/Scope</fieldLeft>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<fieldLeft>/Fields/Avail/Scope</fieldLeft>", "<fieldLeft>/Fields/Avails/Avail/Scope</fieldLeft>");
                }
                if (line.contains("<value>/Fields/Avail/Scope</value>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<value>/Fields/Avail/Scope</value>", "<value>/Fields/Avails/Avail/Scope</value>");
                }
                if (line.contains("<fieldLeft>/Fields/Avail/Type</fieldLeft>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<fieldLeft>/Fields/Avail/Type</fieldLeft>", "<fieldLeft>/Fields/Avails/Avail/Type</fieldLeft>");
                }
                if (line.contains("<value>/Fields/Avail/Type</value>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<value>/Fields/Avail/Type</value>", "<value>/Fields/Avails/Avail/Type</value>");
                }
                if (line.contains("<fieldLeft>/Fields/Avail/Position</fieldLeft>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<fieldLeft>/Fields/Avail/Position</fieldLeft>", "<fieldLeft>/Fields/Avails/Avail/Position</fieldLeft>");
                }
                if (line.contains("<value>/Fields/Avail/Position</value>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<value>/Fields/Avail/Position</value>", "<value>/Fields/Avails/Avail/Position</value>");
                }
                if (line.contains("<fieldLeft>/Fields/Language/@value</fieldLeft>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<fieldLeft>/Fields/Language/@value</fieldLeft>", "<fieldLeft>/Fields/Languages/Language/@value</fieldLeft>");
                }
                if (line.contains("<value>/Fields/Language/@value</value>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<value>/Fields/Language/@value</value>", "<value>/Fields/Languages/Language/@value</value>");
                }
                sb.append(line);
            }
            if (needsUpgrade) {
                upgradedRulesFileName = RulesServiceClient.getUpgradedRulesFileName(filename);
                logger.info(UPGRADE_MESSAGE + upgradedRulesFileName);
                xmlFile = new File(upgradedRulesFileName);
                resultFile = upgradedRulesFileName;
            }
            bw = new BufferedWriter(new FileWriter(xmlFile));
            bw.write(sb.toString());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (bw != null) {
                    bw.close();
                }
            }
            catch (Exception e) {
                logger.error("Exception occurred closing BufferedReader or BufferedWriter: ", (Throwable)e);
            }
        }
        return resultFile;
    }

    private static String getUpgradedRulesFileName(String fileName) {
        String extension;
        int indexOfDotXML;
        String upgradedRulesFileName = fileName;
        if (fileName != null && (indexOfDotXML = fileName.lastIndexOf(extension = ".xml")) > 0) {
            String fileNamePreExtension = fileName.substring(0, indexOfDotXML);
            upgradedRulesFileName = fileNamePreExtension + "." + UPGRADE_SUFFIX + extension;
        }
        return upgradedRulesFileName;
    }

    static class RuleSetTask {
        private RuleSetToSave ruleSetToSave;
        private int index;
        private int totalRuleSets;

        public RuleSetTask(RuleSetToSave ruleSetToSave, int index, int totalRuleSets) {
            this.ruleSetToSave = ruleSetToSave;
            this.index = index;
            this.totalRuleSets = totalRuleSets;
        }

        public void importRuleSet() {
            logger.info("Saving Rule Set with Id : " + this.ruleSetToSave.getRuleSet().getRuleSetId() + " UUID : " + this.ruleSetToSave.getRuleSet().getUuid() + " overwrite : " + this.ruleSetToSave.isOverwrite() + " - ignoreSchedule: " + this.ruleSetToSave.getRuleSet().isIgnoreInvalidSchedule());
            long ruleStartTime = new Date().getTime();
            int ruleSetId = this.ruleSetToSave.getRuleSet().getRuleSetId();
            try {
                this.saveRuleSet(this.ruleSetToSave);
                logger.info("Done saving ruleSet " + this.index + " of " + this.totalRuleSets + ". Duration: " + (new Date().getTime() - ruleStartTime) + " MS. Remaining RuleSets: " + (rulesToImport - 1));
            }
            catch (Exception e) {
                logger.error("Exception occured importing rule set with Id : " + ruleSetId + " : " + e, (Throwable)e);
            }
            rulesToImport--;
            if (rulesToImport == 0) {
                long seconds = (new Date().getTime() - startTime) / 1000L;
                long remain = (new Date().getTime() - startTime) % 1000L;
                logger.info("===> end import. Completed in [" + seconds + "." + remain + "] seconds. ");
            }
        }

        private void saveRuleSet(RuleSetToSave ruleSetToSave) throws HttpException, IOException, JAXBException {
            PostMethod postMethod = new PostMethod(serverURL + RulesServiceClient.DEFAULT_SERVICES_PATH_PREFIX + RulesServiceClient.SERVICES_PATH_RULESET_SAVE);
            StringWriter strWriter = new StringWriter();
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{RuleSetToSave.class});
            Marshaller m = jc.createMarshaller();
            m.marshal((Object)ruleSetToSave, (Writer)strWriter);
            StringRequestEntity entity = new StringRequestEntity(strWriter.toString(), RulesServiceClient.XML_MEDIA, RulesServiceClient.UTF_8);
            postMethod.setRequestEntity((RequestEntity)entity);
            int responseCode = httpClient.executeMethod((HttpMethod)postMethod);
            if (responseCode == 403) {
                logger.error("Skipping saving Rule Set with Id : " + ruleSetToSave.getRuleSet().getRuleSetId() + " UUID : " + ruleSetToSave.getRuleSet().getUuid() + " since the user has insufficient permissions. ");
            } else {
                AuthUtils.handleResponse(responseCode, postMethod.getResponseBodyAsStream(), false);
            }
        }
    }
}

