/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services;

import com.ericsson.cms.scheduler.InvalidScheduleException;
import com.ericsson.cms.scheduler.SchedulerException;
import com.ericsson.cms.scheduler.entities.ScheduleRule;
import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.LogicalSite;
import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.cms.sites.core.entities.SiteType;
import com.ericsson.cms.sites.core.entities.mediapath.MSO;
import com.ericsson.cms.sites.core.mediapath.IMSOManager;
import com.ericsson.neptune.security.audit.AbstractAuditManager;
import com.tandbergtv.cms.data.RuleSetToSave;
import com.tandbergtv.cms.data.RuleSetsListing;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.cms.rules.service.audit.RulesetStatusAuditor;
import com.tandbergtv.cms.rules.service.category.IPackageManager;
import com.tandbergtv.cms.rules.service.category.IRuleManager;
import com.tandbergtv.cms.rules.service.category.IRuleManagerCache;
import com.tandbergtv.cms.rules.service.category.TreRuleSetCachable;
import com.tandbergtv.cms.services.AuthorizationException;
import com.tandbergtv.cms.services.Daily;
import com.tandbergtv.cms.services.EveryNDays;
import com.tandbergtv.cms.services.EveryNHourMins;
import com.tandbergtv.cms.services.IRulesService;
import com.tandbergtv.cms.services.OnDate;
import com.tandbergtv.cms.services.OnDayEveryNWeeks;
import com.tandbergtv.cms.services.RulesServiceUtils;
import com.tandbergtv.cms.services.ScheduleExpiredException;
import com.tandbergtv.cms.services.ScheduleTime;
import com.tandbergtv.cms.services.resources.Errors;
import com.tandbergtv.cms.util.EndpointsAuthorizationUtil;
import com.tandbergtv.marvin.udt.TreMsoOverrrideRuleSet;
import com.tandbergtv.marvin.udt.TrePackage;
import com.tandbergtv.marvin.udt.TreRuleSet;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.ejb.EJBTransactionRolledbackException;
import javax.naming.InitialContext;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.TransactionManager;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.springframework.util.CollectionUtils;

public class RulesService
implements IRulesService {
    private static final Logger logger = Logger.getLogger((String)RulesService.class.getName());
    private IRuleManagerCache ruleCache;
    private static final String PERMISSION_RULES_EXPORT = "RulesManagement_View";
    private static final String PERMISSION_RULES_CREATE = "RulesManagement_Create";
    private static final String PERMISSION_RULES_MODIFY = "RulesManagement_Modify";
    private static final String PERMISSION_SITES_MODIFY = "Sites_Modify";
    private static final String RULESET_IMPORT_BY_REST_API = "ruleset.importby.restapi";
    private static final String XML_MEDIA = "application/xml";
    private IRuleManager ruleManager;
    private static final int RULESET_ID_FOR_ALL = -101;
    private Set<TreRuleSet> rulesets = new HashSet<TreRuleSet>();
    private RulesetStatusAuditor auditor = RulesetStatusAuditor.getInstance();
    private AbstractAuditManager auditManager = AbstractAuditManager.getInstance();
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ Annotation ajc$anno$3;

    public RulesService() {
        this.ruleCache = (IRuleManagerCache)InjectionUtil.injectInstance((String)"cms/RuleManagerCache/local", IRuleManagerCache.class);
        this.ruleManager = (IRuleManager)InjectionUtil.injectInstance((String)"cms/RuleManagerImpl/local", IRuleManager.class);
    }

    @Override
    public Response getRuleSets(HttpServletRequest servletRequest) {
        Response.ResponseBuilder builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, null, PERMISSION_RULES_EXPORT);
        if (builder != null) {
            return builder.build();
        }
        List<String> ids = Arrays.asList(servletRequest.getParameter("ruleSetIds").split(","));
        ArrayList<Integer> ruleSetIds = new ArrayList<Integer>();
        for (String id : ids) {
            ruleSetIds.add(Integer.parseInt(id));
        }
        return this.getRuleSetsListingWithLogin(ruleSetIds);
    }

    @Override
    public Response getRuleSetsByUuid(HttpServletRequest servletRequest) {
        Response.ResponseBuilder builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, null, PERMISSION_RULES_CREATE, PERMISSION_RULES_MODIFY);
        if (builder != null) {
            return builder.build();
        }
        Errors errors = new Errors();
        String uuid = servletRequest.getParameter("uuid");
        ArrayList<TreRuleSet> treRuleSetsList = new ArrayList<TreRuleSet>();
        treRuleSetsList.addAll(this.rulesets);
        try {
            TreRuleSetCachable rsc = this.ruleCache.getRuleSet(uuid);
            if (rsc != null) {
                treRuleSetsList.add(rsc.getRuleSet());
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Exception occurred getting rule sets from RuleManager : " + e), (Throwable)e);
        }
        logger.info((Object)("Finished getting ruleSets for uuid : " + uuid));
        RuleSetsListing ruleSetsListing = new RuleSetsListing(treRuleSetsList);
        StringWriter strWriter = new StringWriter();
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{RuleSetsListing.class});
            Marshaller m = jc.createMarshaller();
            m.marshal((Object)ruleSetsListing, (Writer)strWriter);
        }
        catch (JAXBException jAXBException) {
            errors.getErrors().add("Error: cannot get ruleset with uuid " + uuid);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errors).build();
        }
        return Response.ok((Object)strWriter.toString()).type(XML_MEDIA).build();
    }

    @Override
    public Response saveRuleSet(HttpServletRequest servletRequest) {
        Response.ResponseBuilder builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, null, PERMISSION_RULES_CREATE, PERMISSION_RULES_MODIFY);
        if (builder != null) {
            return builder.build();
        }
        builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, null, PERMISSION_SITES_MODIFY);
        boolean hasSiteModifyPermission = builder == null;
        Errors errors = new Errors();
        RuleSetToSave rs = null;
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{RuleSetToSave.class});
            Unmarshaller u = jc.createUnmarshaller();
            rs = (RuleSetToSave)u.unmarshal((InputStream)servletRequest.getInputStream());
        }
        catch (Exception e) {
            logger.error((Object)"Cannot unmarshal rulese ", (Throwable)e);
            errors.getErrors().add("Cannot unmarshal ruleset");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errors).build();
        }
        TreRuleSet treRuleSet = rs.getRuleSet();
        TreRuleSet existingRuleSet = this.getExistingRuleSet(treRuleSet);
        Response response = this.saveRuleSetWithLogin(treRuleSet, rs.isOverwrite(), hasSiteModifyPermission);
        try {
            IPackageManager packageManager = (IPackageManager)InjectionUtil.injectInstance((String)"cms/PackageManagerImpl/local", IPackageManager.class);
            TrePackage tpackage = packageManager.getPackageById(treRuleSet.getPackId().intValue());
            treRuleSet.setTpackage(tpackage);
        }
        catch (Exception e) {
            logger.error((Object)("Cannot set package for ruleset " + treRuleSet.getRuleSetId()), (Throwable)e);
        }
        if (response.getStatus() == Response.Status.OK.getStatusCode() && treRuleSet.statusChanges(existingRuleSet)) {
            if (existingRuleSet != null) {
                treRuleSet.setRuleSetId(existingRuleSet.getRuleSetId());
            }
            this.auditManager.logAudit(this.auditor.audit((Object)existingRuleSet, (Object)treRuleSet), servletRequest);
        }
        return response;
    }

    private TreRuleSet getExistingRuleSet(TreRuleSet treRuleSet) {
        if (treRuleSet == null || treRuleSet.getRuleSetId() == null) {
            return null;
        }
        List ruleSets = this.ruleManager.getRuleSets(Arrays.asList(treRuleSet.getRuleSetId()));
        if (CollectionUtils.isEmpty((Collection)ruleSets)) {
            return null;
        }
        return (TreRuleSet)ruleSets.get(0);
    }

    private Response getRuleSetsListingWithLogin(List<Integer> ruleSetIds) {
        ArrayList<TreRuleSet> treRuleSetsList = new ArrayList<TreRuleSet>();
        treRuleSetsList.addAll(this.rulesets);
        Errors errors = new Errors();
        try {
            treRuleSetsList.addAll(this.getRuleSetsFromRuleManager(this.ruleManager, ruleSetIds));
        }
        catch (Exception e) {
            logger.warn((Object)("Exception occurred getting rule sets from RuleManager : " + e), (Throwable)e);
            errors.getErrors().add("Exception occurred getting rule sets from RuleManager : " + e.getMessage());
            return Response.serverError().entity((Object)errors).build();
        }
        logger.info((Object)("Finished getting ruleSets for ruleSetIds : " + ruleSetIds));
        for (TreRuleSet treRuleSet : treRuleSetsList) {
            RulesServiceUtils.renameContentClass(treRuleSet);
        }
        RuleSetsListing ruleSetsListing = new RuleSetsListing(treRuleSetsList);
        StringWriter strWriter = new StringWriter();
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{RuleSetsListing.class});
            Marshaller m = jc.createMarshaller();
            m.marshal((Object)ruleSetsListing, (Writer)strWriter);
        }
        catch (JAXBException e) {
            errors.getErrors().add("Cannot marshal ruleset listing: " + e.getMessage());
            return Response.serverError().entity((Object)errors).build();
        }
        return Response.ok((Object)strWriter.toString()).type(XML_MEDIA).build();
    }

    @Transactional
    private List<TreRuleSet> getRuleSetsFromRuleManager(IRuleManager ruleManager, List<Integer> ruleSetIds) {
        IRuleManager iRuleManager = ruleManager;
        List<Integer> list = ruleSetIds;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = RulesService.class.getDeclaredMethod("getRuleSetsFromRuleManager", IRuleManager.class, List.class).getAnnotation(Transactional.class);
        }
        return (List)RulesService.getRuleSetsFromRuleManager_aroundBody1$advice(this, iRuleManager, list, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    private List<TreRuleSet> getRuleSetsByUuidFromRuleManager(IRuleManager ruleManager, String uuid) {
        IRuleManager iRuleManager = ruleManager;
        String string = uuid;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = RulesService.class.getDeclaredMethod("getRuleSetsByUuidFromRuleManager", IRuleManager.class, String.class).getAnnotation(Transactional.class);
        }
        return (List)RulesService.getRuleSetsByUuidFromRuleManager_aroundBody3$advice(this, iRuleManager, string, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    private synchronized List<TreRuleSet> getRuleSetsByUuidFromRuleManager(IRuleManager ruleManager, String uuid, boolean noInitialize) {
        IRuleManager iRuleManager = ruleManager;
        String string = uuid;
        boolean bl = noInitialize;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = RulesService.class.getDeclaredMethod("getRuleSetsByUuidFromRuleManager", IRuleManager.class, String.class, Boolean.TYPE).getAnnotation(Transactional.class);
        }
        return (List)RulesService.getRuleSetsByUuidFromRuleManager_aroundBody5$advice(this, iRuleManager, string, bl, transactionEnforcer, (Transactional)annotation, null);
    }

    private Response saveRuleSetWithLogin(TreRuleSet ruleSet, boolean overwrite, boolean hasSiteModifyPermission) {
        Errors errors = new Errors();
        logger.info((Object)("In saveRuleSetWithLogin with ruleSet : " + ruleSet.getUuid() + ", overwrite : " + overwrite));
        try {
            TreRuleSetCachable treRsc;
            IPackageManager packageManager = (IPackageManager)InjectionUtil.injectInstance((String)"cms/PackageManagerImpl/local", IPackageManager.class);
            ISiteManager siteManager = (ISiteManager)InjectionUtil.injectInstance((String)"cms/SiteManager/local", ISiteManager.class);
            UUID uuid = ruleSet.getUuid();
            boolean foundRuleSetWithUuid = false;
            if (uuid != null && !overwrite && (treRsc = this.ruleCache.getRuleSet(uuid.toString())) != null) {
                foundRuleSetWithUuid = true;
            }
            if (foundRuleSetWithUuid) {
                logger.info((Object)("Skipping saveRuleSet with uuid: " + uuid.toString() + ". RuleSet exists in DB and overwrite option is false. "));
            } else {
                logger.info((Object)("Saving TreRuleSet with Package Manager : " + ruleSet));
                this.saveRuleSetWithPackageManager(packageManager, this.ruleManager, siteManager, ruleSet, overwrite, hasSiteModifyPermission);
                logger.info((Object)("Finished saving TreRuleSet with RuleManager : " + ruleSet));
            }
        }
        catch (AuthorizationException ae) {
            errors.getErrors().add("Insufficient Permissions for ruleset with uuid " + ruleSet.getUuid() + " : " + ae.getMessage());
            Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)errors);
            return builder.build();
        }
        catch (ScheduleExpiredException see) {
            errors.getErrors().add("Schedule has expired for ruleset with uuid " + ruleSet.getUuid() + " : " + see.getMessage());
            Response.ResponseBuilder builder = Response.status((int)476).entity((Object)errors);
            return builder.build();
        }
        catch (EJBTransactionRolledbackException etre) {
            logger.warn((Object)"Exception occurred saving ruleSet with login : ", (Throwable)etre);
            Throwable cause = etre.getCause();
            if (cause instanceof InvalidScheduleException) {
                errors.getErrors().add("Invalid Schedule for ruleset with uuid " + ruleSet.getUuid() + " : " + cause);
                Response.ResponseBuilder builder = Response.status((int)475).entity((Object)errors);
                return builder.build();
            }
            errors.getErrors().add("Exception occurred saving ruleset with uuid " + ruleSet.getUuid() + " : " + etre.getMessage());
            Response.ResponseBuilder builder = Response.serverError().entity((Object)errors);
            return builder.build();
        }
        catch (RuntimeException re) {
            errors.getErrors().add("Exception occurred saving ruleset with uuid " + ruleSet.getUuid() + " : " + re.getMessage());
            Response.ResponseBuilder builder = Response.serverError().entity((Object)errors);
            return builder.build();
        }
        catch (Exception e) {
            logger.warn((Object)("Exception occurred saving ruleSet : " + e), (Throwable)e);
            errors.getErrors().add("Exception occurred savingruleset with uuid " + ruleSet.getUuid() + " : " + e.getMessage());
            Response.ResponseBuilder builder = Response.serverError().entity((Object)errors);
            return builder.build();
        }
        return Response.ok().build();
    }

    @Transactional
    private void saveRuleSetWithPackageManager(IPackageManager packageManager, IRuleManager ruleManager, ISiteManager siteManager, TreRuleSet ruleSet, boolean overwrite, boolean hasSiteModifyPermission) {
        IPackageManager iPackageManager = packageManager;
        IRuleManager iRuleManager = ruleManager;
        ISiteManager iSiteManager = siteManager;
        TreRuleSet treRuleSet = ruleSet;
        boolean bl = overwrite;
        boolean bl2 = hasSiteModifyPermission;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = RulesService.class.getDeclaredMethod("saveRuleSetWithPackageManager", IPackageManager.class, IRuleManager.class, ISiteManager.class, TreRuleSet.class, Boolean.TYPE, Boolean.TYPE).getAnnotation(Transactional.class);
        }
        RulesService.saveRuleSetWithPackageManager_aroundBody7$advice(this, iPackageManager, iRuleManager, iSiteManager, treRuleSet, bl, bl2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    public Response reloadCache(HttpServletRequest servletRequest) {
        Response.ResponseBuilder builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, null, PERMISSION_RULES_EXPORT);
        if (builder != null && (builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, null, PERMISSION_RULES_CREATE, PERMISSION_RULES_MODIFY)) != null) {
            return builder.build();
        }
        this.ruleCache.load();
        return Response.status((Response.Status)Response.Status.OK).type("text/plain").build();
    }

    private void updateMsos(TreMsoOverrrideRuleSet ruleSet) {
        IMSOManager msoManager = (IMSOManager)InjectionUtil.injectInstance((String)"cms/MSOManager/local", IMSOManager.class);
        HashSet<MSO> msosToSave = new HashSet<MSO>();
        Set dirtyMsos = ruleSet.getMsos();
        for (MSO dmso : dirtyMsos) {
            MSO mso = msoManager.getMSOByName(dmso.getMsoName());
            if (mso == null) {
                dmso.setId(null);
                mso = dmso;
                try {
                    msoManager.saveMSO(mso);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            msosToSave.add(mso);
        }
        ruleSet.setMsos(msosToSave);
    }

    private boolean hasExpiredSchedule(TreRuleSet ruleSet) {
        ScheduleRule scheduleRule;
        boolean hasExpiredSchedule = false;
        if (ruleSet != null && (scheduleRule = ruleSet.getScheduleRule()) != null) {
            Date endDate = scheduleRule.getEndDate();
            Date now = new Date();
            if (endDate != null && endDate.before(now)) {
                hasExpiredSchedule = true;
            }
        }
        return hasExpiredSchedule;
    }

    private ScheduleTime getScheduleTime(ScheduleRule rule) {
        switch (rule.getType()) {
            case ON_DATE: {
                return OnDate.getTime(rule);
            }
            case EVERY_N_DAYS: {
                return EveryNDays.getTime(rule);
            }
            case ON_DAY_EVERY_N_WEEKS: {
                return OnDayEveryNWeeks.getTime(rule);
            }
            case N_DAYS_FROM_METADATA: {
                return Daily.getTime(rule);
            }
            case EVERY_N_HOURMINS: {
                return EveryNHourMins.getTime(rule);
            }
        }
        throw new SchedulerException("Unknown Schedule Rule Type: " + rule.getType());
    }

    private static final /* synthetic */ List getRuleSetsFromRuleManager_aroundBody0(RulesService ajc$this, IRuleManager ruleManager, List ruleSetIds) {
        logger.info((Object)("Getting ruleSets from RuleManager for ruleSetIds : " + ruleSetIds));
        List treRuleSets = new ArrayList();
        if (ruleSetIds.contains(-101)) {
            logger.info((Object)"Getting ALL ruleSets in the system...");
            String[] stringArray = TrePackage.RULE_TYPES;
            int n = TrePackage.RULE_TYPES.length;
            int n2 = 0;
            while (n2 < n) {
                String packType = stringArray[n2];
                treRuleSets.addAll(ruleManager.getRuleSetsByPackageWithSchedule(packType));
                ++n2;
            }
        } else {
            treRuleSets = ruleManager.getRuleSetsWithSchedule(ruleSetIds);
        }
        for (TreRuleSet treRuleSet : treRuleSets) {
            RulesServiceUtils.initializeRuleSet(treRuleSet);
        }
        logger.info((Object)("Finished getting ruleSets from RuleManager for ruleSetIds : " + ruleSetIds));
        return treRuleSets;
    }

    private static final /* synthetic */ Object getRuleSetsFromRuleManager_aroundBody1$advice(RulesService ajc$this, IRuleManager ruleManager, List ruleSetIds, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return RulesService.getRuleSetsFromRuleManager_aroundBody0(ajc$this, ruleManager, ruleSetIds);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = RulesService.getRuleSetsFromRuleManager_aroundBody0(ajc$this, ruleManager, ruleSetIds);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getRuleSetsByUuidFromRuleManager_aroundBody2(RulesService ajc$this, IRuleManager ruleManager, String uuid) {
        logger.info((Object)("Getting ruleSets from RuleManager for uuid : " + uuid));
        List treRuleSets = ruleManager.getRuleSetsByUuid(uuid);
        for (TreRuleSet treRuleSet : treRuleSets) {
            RulesServiceUtils.initializeRuleSet(treRuleSet);
        }
        logger.info((Object)("Finished getting ruleSets from RuleManager for uuid : " + uuid));
        return treRuleSets;
    }

    private static final /* synthetic */ Object getRuleSetsByUuidFromRuleManager_aroundBody3$advice(RulesService ajc$this, IRuleManager ruleManager, String uuid, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return RulesService.getRuleSetsByUuidFromRuleManager_aroundBody2(ajc$this, ruleManager, uuid);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = RulesService.getRuleSetsByUuidFromRuleManager_aroundBody2(ajc$this, ruleManager, uuid);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getRuleSetsByUuidFromRuleManager_aroundBody4(RulesService ajc$this, IRuleManager ruleManager, String uuid, boolean noInitialize) {
        logger.info((Object)("Getting ruleSets from RuleManager for uuid : " + uuid));
        List treRuleSets = ruleManager.getRuleSetsByUuid(uuid);
        logger.info((Object)("Finished getting ruleSets from RuleManager for uuid : " + uuid));
        return treRuleSets;
    }

    private static final /* synthetic */ Object getRuleSetsByUuidFromRuleManager_aroundBody5$advice(RulesService ajc$this, IRuleManager ruleManager, String uuid, boolean noInitialize, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return RulesService.getRuleSetsByUuidFromRuleManager_aroundBody4(ajc$this, ruleManager, uuid, noInitialize);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = RulesService.getRuleSetsByUuidFromRuleManager_aroundBody4(ajc$this, ruleManager, uuid, noInitialize);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void saveRuleSetWithPackageManager_aroundBody6(RulesService ajc$this, IPackageManager packageManager, IRuleManager ruleManager, ISiteManager siteManager, TreRuleSet ruleSet, boolean overwrite, boolean hasSiteModifyPermission) {
        TreRuleSetCachable rsc;
        logger.info((Object)("Saving TreRuleSet with PackageManager : " + ruleSet.getUuid() + ", overwrite : " + overwrite + " - Ignore Schedule: " + ruleSet.isIgnoreInvalidSchedule()));
        boolean hasExpiredSchedule = ajc$this.hasExpiredSchedule(ruleSet);
        if (hasExpiredSchedule && !ruleSet.isIgnoreInvalidSchedule()) {
            throw new ScheduleExpiredException("Ruleset is schedulable but it's schedule has expired.");
        }
        UUID uuid = ruleSet.getUuid();
        boolean foundRuleSetWithUuid = false;
        String packageName = ruleSet.getTpackage().getName().trim();
        logger.info((Object)("Got packageName : " + packageName));
        logger.info((Object)("Cleansing ruleSet : " + ruleSet));
        ruleSet = RulesServiceUtils.cleanseRuleSet(ruleSet);
        if (packageName.equals("MSOOVERRIDE")) {
            ajc$this.updateMsos((TreMsoOverrrideRuleSet)ruleSet);
        }
        Set importingSites = ruleSet.getSites();
        logger.info((Object)("Got importingSites : " + importingSites));
        HashSet<LogicalSite> filteredImportingSites = new HashSet<LogicalSite>();
        for (Site importingSite : importingSites) {
            String importingSiteName = importingSite.getName();
            SiteType importingSiteType = importingSite.getType();
            Site targetSystemSite = siteManager.getSiteByName(importingSiteName);
            logger.info((Object)("Got targetSystemSite : " + targetSystemSite + " for importingSiteName : " + importingSiteName));
            if (targetSystemSite != null) {
                SiteType targetSystemSiteType = targetSystemSite.getType();
                if (targetSystemSiteType.equals((Object)importingSiteType)) {
                    LogicalSite s = null;
                    if (SiteType.LOGICAL.equals((Object)targetSystemSiteType)) {
                        s = new LogicalSite();
                    } else if (SiteType.DISTRIBUTION.equals((Object)targetSystemSiteType)) {
                        s = new DistributionSite();
                    }
                    if (s == null) continue;
                    s.setId(targetSystemSite.getId());
                    filteredImportingSites.add(s);
                    continue;
                }
                logger.warn((Object)("targetSystemSiteType differs from importingSiteType. Site will not be associated with Rule Set being imported. importingSite : " + importingSite + ", targetSystemSite : " + targetSystemSite));
                continue;
            }
            logger.error((Object)("No target system site found for importingSiteName : " + importingSiteName));
        }
        logger.info((Object)("Got filteredImportingSites : " + filteredImportingSites));
        ruleSet.getSites().clear();
        ruleSet.getSites().addAll(filteredImportingSites);
        int numFilteredImportingSites = filteredImportingSites.size();
        if (numFilteredImportingSites > 0 && !hasSiteModifyPermission) {
            throw new AuthorizationException("The importing ruleSet is associated with a site, while the caller does not have permissions to modify Site.");
        }
        ScheduleRule scheduleRule = ruleSet.getScheduleRule();
        if (scheduleRule != null) {
            Date startDate = scheduleRule.getStartDate();
            Date endDate = scheduleRule.getEndDate();
            Date now = new Date();
            if ((endDate == null || endDate.after(now)) && startDate != null && startDate.before(now)) {
                ScheduleTime scheduleTime = ajc$this.getScheduleTime(scheduleRule);
                scheduleRule.setStartDate(scheduleTime.getStartDate());
            }
        }
        if (overwrite && uuid != null && (rsc = ajc$this.ruleCache.getRuleSet(uuid.toString())) != null) {
            foundRuleSetWithUuid = true;
            rsc.getRuleSet();
        }
        try {
            TrePackage pack = packageManager.getPackageByNameFirstMatching(packageName);
            if (foundRuleSetWithUuid) {
                logger.info((Object)("Looking for RuleSet: " + uuid.toString()));
                TreRuleSetCachable rsc2 = ajc$this.ruleCache.getRuleSet(uuid.toString());
                if (rsc2 != null) {
                    ruleSet = RulesServiceUtils.copyRuleSetDetails(rsc2.getRuleSet(), ruleSet);
                    ruleSet.setUiUpdate(false);
                }
            } else {
                pack.getRuleSets().add(ruleSet);
                ruleSet.setOrder_(Integer.valueOf(pack.getRuleSets().size() - 1));
            }
            ruleSet.setTpackage(pack);
            ruleSet.setPackId(pack.getPackageId());
            logger.info((Object)("Saving RuleSet [" + ruleSet.getRuleName() + " (" + ruleSet.getRuleSetId() + ")] - " + ruleSet.isIgnoreInvalidSchedule()));
            ruleManager.saveRuleSet(ruleSet, RULESET_IMPORT_BY_REST_API);
        }
        catch (RuntimeException e) {
            logger.error((Object)("Exception occurred adding/updating ruleSet : " + ruleSet + " : " + e), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)("Exception occurred adding/updating ruleSet : " + ruleSet + " : " + e), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ Object saveRuleSetWithPackageManager_aroundBody7$advice(RulesService ajc$this, IPackageManager packageManager, IRuleManager ruleManager, ISiteManager siteManager, TreRuleSet ruleSet, boolean overwrite, boolean hasSiteModifyPermission, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            RulesService.saveRuleSetWithPackageManager_aroundBody6(ajc$this, packageManager, ruleManager, siteManager, ruleSet, overwrite, hasSiteModifyPermission);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            RulesService.saveRuleSetWithPackageManager_aroundBody6(ajc$this, packageManager, ruleManager, siteManager, ruleSet, overwrite, hasSiteModifyPermission);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

