/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.filter;

import com.tandbergtv.cms.services.RESTAuthentication;
import com.tandbergtv.neptune.sso.model.NeptuneSSOPrincipal;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class BasicAuthFilter
implements Filter {
    private final String NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL = "neptune_sso_oauth2_principal";
    private final Logger logger = Logger.getLogger(BasicAuthFilter.class);

    public void init(FilterConfig arg0) throws ServletException {
        this.logger.debug((Object)"Init called - nothing to do in here!");
    }

    public void destroy() {
        this.logger.debug((Object)"Destroy called - nothing to do in here!");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        this.logger.debug((Object)"Begin of basic auth filter");
        RESTAuthentication auth = null;
        try {
            auth = this.getAuth(request);
        }
        catch (Exception ex) {
            this.setUnauthorizedResponse(response, ex);
            return;
        }
        HttpSession session = ((HttpServletRequest)request).getSession(true);
        NeptuneSSOPrincipal orignalNSP = this.getNSP(session);
        try {
            if (auth != null) {
                this.setOauthPass(session);
            }
            this.logger.debug((Object)"Continuing with rest of the filters in the filter chain");
            filterChain.doFilter(request, response);
        }
        finally {
            this.logger.debug((Object)"End of basic auth filter");
            if (auth != null) {
                this.recoverNSP(session, orignalNSP);
                auth.logout();
            }
        }
    }

    private NeptuneSSOPrincipal getNSP(HttpSession session) {
        return (NeptuneSSOPrincipal)session.getAttribute("neptune_sso_oauth2_principal");
    }

    private void setOauthPass(HttpSession session) {
        NeptuneSSOPrincipal nsp = new NeptuneSSOPrincipal();
        nsp.setExpiryLimit(200);
        session.setAttribute("neptune_sso_oauth2_principal", (Object)nsp);
    }

    private void recoverNSP(HttpSession session, NeptuneSSOPrincipal originalNSP) {
        if (originalNSP == null) {
            session.removeAttribute("neptune_sso_oauth2_principal");
        } else {
            session.setAttribute("neptune_sso_oauth2_principal", (Object)originalNSP);
        }
    }

    private RESTAuthentication getAuth(ServletRequest request) {
        String authorizationHeader = ((HttpServletRequest)request).getHeader("Authorization");
        if (authorizationHeader == null) {
            return null;
        }
        return RESTAuthentication.loginIfHasAnyOfThePermissions(authorizationHeader, "AssetManagement_View", "WorkOrderManagement_View", "ResourceManagement_View");
    }

    private void setUnauthorizedResponse(ServletResponse response, Exception ex) throws IOException {
        HttpServletResponse resp = (HttpServletResponse)response;
        resp.setStatus(401);
        resp.getWriter().write(ex.getMessage());
        resp.setContentType("text/plain");
    }
}

