/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.mso;

import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.entities.mediapath.MSO;
import com.ericsson.cms.sites.core.entities.mediapath.MediapathDistributionSite;
import com.ericsson.cms.sites.core.mediapath.IMSOManager;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.cms.services.mso.IMSOService;
import com.tandbergtv.cms.services.resources.Errors;
import com.tandbergtv.cms.services.resources.Mso;
import com.tandbergtv.cms.services.resources.ResourceList;
import com.tandbergtv.cms.services.resources.Site;
import com.tandbergtv.cms.util.EndpointsAuthorizationUtil;
import com.tandbergtv.cms.util.ResponseTypeUtilities;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.naming.InitialContext;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.TransactionManager;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamReader;
import org.aspectj.runtime.internal.AroundClosure;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.mapped.Configuration;
import org.codehaus.jettison.mapped.MappedNamespaceConvention;
import org.codehaus.jettison.mapped.MappedXMLStreamReader;

public class MSOService
implements IMSOService {
    private static final String DEFAULT_MEDIA = "application/xml";
    private static final String JSON_MEDIA = "application/json";
    private static final String PERMISSION_SITES_CREATE = "Sites_Create";
    private static final String PERMISSION_SITES_UPDATE = "Sites_Modify";
    private static final String PERMISSION_SITES_VIEW = "Sites_View";
    private static final String PERMISSION_SITES_DELETE = "Sites_Delete";
    private IMSOManager msoManager = (IMSOManager)InjectionUtil.injectInstance((String)"cms/MSOManager/local", IMSOManager.class);
    private ISiteManager siteManager = (ISiteManager)InjectionUtil.injectInstance((String)"cms/SiteManager/local", ISiteManager.class);
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ Annotation ajc$anno$6;

    @Override
    public Response createMSO(HttpServletRequest servletRequest, String authorizationHeader, String contentType, Request request, UriInfo uriInfo, SecurityContext sec, Mso metadata) {
        Response.ResponseBuilder builder = null;
        Errors errors = new Errors();
        MSO mso = null;
        if (!this.validContentType(contentType)) {
            errors.getErrors().add("Invalid Content Type.");
            builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
        } else {
            try {
                builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, PERMISSION_SITES_CREATE, PERMISSION_SITES_UPDATE);
                if (builder != null) {
                    return builder.build();
                }
                try {
                    mso = this.convertMso(metadata);
                    this.msoManager.saveMSO(mso);
                }
                catch (Exception e) {
                    errors.getErrors().add(e.getLocalizedMessage());
                    builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
            catch (Exception exception) {
                errors.getErrors().add("Caller is unauthorized to execute operation.");
                builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(contentType);
            }
        }
        if (errors.getErrors().size() > 0) {
            builder.entity((Object)errors);
        } else {
            builder = Response.ok((Object)this.convertMSO(mso, uriInfo)).type(contentType);
        }
        return builder.build();
    }

    private MSO convertMso(Mso mso) {
        MSO response = new MSO();
        if (mso.getName() != null) {
            response.setMsoName(mso.getName());
        }
        if (mso.getDescription() != null) {
            response.setMsoDescription(mso.getDescription());
        }
        return response;
    }

    @Override
    @Transactional
    public Response deleteMSO(HttpServletRequest servletRequest, String authorizationHeader, String accept, String msoId, Request request, UriInfo uriInfo, SecurityContext sec) {
        HttpServletRequest httpServletRequest = servletRequest;
        String string = authorizationHeader;
        String string2 = accept;
        String string3 = msoId;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        SecurityContext securityContext = sec;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = MSOService.class.getDeclaredMethod("deleteMSO", HttpServletRequest.class, String.class, String.class, String.class, Request.class, UriInfo.class, SecurityContext.class).getAnnotation(Transactional.class);
        }
        return (Response)MSOService.deleteMSO_aroundBody1$advice(this, httpServletRequest, string, string2, string3, request2, uriInfo2, securityContext, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public Response getAssociatedSites(HttpServletRequest servletRequest, String authorizationHeader, String accept, String msoId, Date expires, Request request, UriInfo uriInfo, SecurityContext sec) {
        HttpServletRequest httpServletRequest = servletRequest;
        String string = authorizationHeader;
        String string2 = accept;
        String string3 = msoId;
        Date date = expires;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        SecurityContext securityContext = sec;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = MSOService.class.getDeclaredMethod("getAssociatedSites", HttpServletRequest.class, String.class, String.class, String.class, Date.class, Request.class, UriInfo.class, SecurityContext.class).getAnnotation(Transactional.class);
        }
        return (Response)MSOService.getAssociatedSites_aroundBody3$advice(this, httpServletRequest, string, string2, string3, date, request2, uriInfo2, securityContext, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public Response getMSO(HttpServletRequest servletRequest, String authorizationHeader, String accept, String msoId, Date lastModified, Request request, UriInfo uriInfo, SecurityContext sec) {
        HttpServletRequest httpServletRequest = servletRequest;
        String string = authorizationHeader;
        String string2 = accept;
        String string3 = msoId;
        Date date = lastModified;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        SecurityContext securityContext = sec;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = MSOService.class.getDeclaredMethod("getMSO", HttpServletRequest.class, String.class, String.class, String.class, Date.class, Request.class, UriInfo.class, SecurityContext.class).getAnnotation(Transactional.class);
        }
        return (Response)MSOService.getMSO_aroundBody5$advice(this, httpServletRequest, string, string2, string3, date, request2, uriInfo2, securityContext, transactionEnforcer, (Transactional)annotation, null);
    }

    private Mso convertMSO(MSO mso, UriInfo request) {
        Mso response = new Mso();
        response.setDescription(mso.getMsoDescription());
        response.setName(mso.getMsoName());
        String slash = "/";
        if (request.getPath().endsWith("/")) {
            slash = "";
        }
        String href = request.getBaseUri() + request.getPath().substring(1) + slash + mso.getId();
        response.setHref(href);
        return response;
    }

    private Mso convertMsoSlashEnd(MSO mso, UriInfo request) {
        Mso response = new Mso();
        response.setDescription(mso.getMsoDescription());
        response.setName(mso.getMsoName());
        String slash = "/";
        if (request.getPath().endsWith("/")) {
            slash = "";
        }
        String href = request.getBaseUri() + request.getPath().substring(1) + slash;
        response.setHref(href);
        return response;
    }

    @Override
    @Transactional
    public Response updateMSO(HttpServletRequest servletRequest, String authorizationHeader, String accept, Date lastModified, String msoId, Request request, UriInfo uriInfo, SecurityContext sec, Mso mso) {
        HttpServletRequest httpServletRequest = servletRequest;
        String string = authorizationHeader;
        String string2 = accept;
        Date date = lastModified;
        String string3 = msoId;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        SecurityContext securityContext = sec;
        Mso mso2 = mso;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = MSOService.class.getDeclaredMethod("updateMSO", HttpServletRequest.class, String.class, String.class, Date.class, String.class, Request.class, UriInfo.class, SecurityContext.class, Mso.class).getAnnotation(Transactional.class);
        }
        return (Response)MSOService.updateMSO_aroundBody7$advice(this, httpServletRequest, string, string2, date, string3, request2, uriInfo2, securityContext, mso2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public Response updateMSO(HttpServletRequest servletRequest, String authorizationHeader, String accept, Date lastModified, String msoId, Request request, UriInfo uriInfo, SecurityContext sec, String jsonString) {
        HttpServletRequest httpServletRequest = servletRequest;
        String string = authorizationHeader;
        String string2 = accept;
        Date date = lastModified;
        String string3 = msoId;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        SecurityContext securityContext = sec;
        String string4 = jsonString;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = MSOService.class.getDeclaredMethod("updateMSO", HttpServletRequest.class, String.class, String.class, Date.class, String.class, Request.class, UriInfo.class, SecurityContext.class, String.class).getAnnotation(Transactional.class);
        }
        return (Response)MSOService.updateMSO_aroundBody9$advice(this, httpServletRequest, string, string2, date, string3, request2, uriInfo2, securityContext, string4, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public Response associateSite(HttpServletRequest servletRequest, String authorizationHeader, String accept, String msoId, String siteId, Request request, UriInfo uriInfo, SecurityContext sec) {
        HttpServletRequest httpServletRequest = servletRequest;
        String string = authorizationHeader;
        String string2 = accept;
        String string3 = msoId;
        String string4 = siteId;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        SecurityContext securityContext = sec;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = MSOService.class.getDeclaredMethod("associateSite", HttpServletRequest.class, String.class, String.class, String.class, String.class, Request.class, UriInfo.class, SecurityContext.class).getAnnotation(Transactional.class);
        }
        return (Response)MSOService.associateSite_aroundBody11$advice(this, httpServletRequest, string, string2, string3, string4, request2, uriInfo2, securityContext, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public Response deleteSiteAssociation(HttpServletRequest servletRequest, String authorizationHeader, String accept, String msoId, String siteId, Request request, UriInfo uriInfo, SecurityContext sec) {
        HttpServletRequest httpServletRequest = servletRequest;
        String string = authorizationHeader;
        String string2 = accept;
        String string3 = msoId;
        String string4 = siteId;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        SecurityContext securityContext = sec;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = MSOService.class.getDeclaredMethod("deleteSiteAssociation", HttpServletRequest.class, String.class, String.class, String.class, String.class, Request.class, UriInfo.class, SecurityContext.class).getAnnotation(Transactional.class);
        }
        return (Response)MSOService.deleteSiteAssociation_aroundBody13$advice(this, httpServletRequest, string, string2, string3, string4, request2, uriInfo2, securityContext, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    public Response getList(HttpServletRequest servletRequest, String authorizationHeader, Date expires, String accept, Request request, UriInfo uriInfo, SecurityContext sec) {
        Response.ResponseBuilder builder = null;
        ResourceList list = new ResourceList();
        Errors errors = new Errors();
        String jsonResponse = null;
        String mediaType = this.defineMediaType(accept);
        try {
            builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, PERMISSION_SITES_VIEW);
            if (builder != null) {
                return builder.build();
            }
            try {
                List msoList = this.msoManager.getAllMSOs();
                for (MSO mso : msoList) {
                    list.getMsos().add(this.convertMSO(mso, uriInfo));
                }
            }
            catch (Exception e) {
                errors.getErrors().add(e.getLocalizedMessage());
                builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
            }
            if (mediaType.contains(JSON_MEDIA)) {
                jsonResponse = ResponseTypeUtilities.toJSON(list);
            }
        }
        catch (Exception exception) {
            errors.getErrors().add("Caller is unauthorized to execute operation.");
            builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(mediaType);
        }
        if (errors.getErrors().size() > 0) {
            builder.entity((Object)errors);
        } else {
            builder = Response.ok((Object)(jsonResponse == null ? list : jsonResponse)).type(mediaType);
        }
        return builder.build();
    }

    @Override
    public Response getSite(HttpServletRequest servletRequest, String authorizationHeader, String accept, String siteName, Date lastModified, Request request, UriInfo uriInfo, SecurityContext sec) {
        com.ericsson.cms.sites.core.entities.Site site = null;
        Site resp = null;
        Response.ResponseBuilder builder = null;
        Errors errors = new Errors();
        Object jsonResponse = null;
        String mediaType = this.defineMediaType(accept);
        try {
            builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, PERMISSION_SITES_VIEW);
            if (builder != null) {
                return builder.build();
            }
            try {
                site = this.siteManager.getSiteByName(siteName);
                resp = this.convertSite(site, uriInfo);
            }
            catch (Exception e) {
                errors.getErrors().add(e.getLocalizedMessage());
                builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
            }
            if (mediaType.contains(JSON_MEDIA)) {
                jsonResponse = ResponseTypeUtilities.toJSON(resp);
            }
        }
        catch (Exception exception) {
            errors.getErrors().add("Caller is unauthorized to execute operation.");
            builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(mediaType);
        }
        if (site != null) {
            builder = Response.ok(jsonResponse == null ? resp : jsonResponse).type(mediaType);
        } else {
            errors.getErrors().add("Site not found");
            builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
        }
        if (errors.getErrors().size() > 0) {
            builder.entity((Object)errors);
        }
        return builder.build();
    }

    private Site convertSite(com.ericsson.cms.sites.core.entities.Site site, UriInfo request) {
        Site response = new Site();
        response.setName(site.getName());
        String href = request.getBaseUri() + "sites/" + site.getId();
        response.setHref(href);
        return response;
    }

    @Override
    public Response createMSO(HttpServletRequest servletRequest, String authorizationHeader, String contentType, Request request, UriInfo uriInfo, SecurityContext sec, String jsonString) {
        Response.ResponseBuilder builder = null;
        Errors errors = new Errors();
        MSO mso = null;
        Mso serviceMso = null;
        ObjectMapper mapper = new ObjectMapper();
        Mso responseMso = null;
        String jsonResponse = null;
        if (!this.validContentType(contentType)) {
            errors.getErrors().add("Invalid Content Type.");
            builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
        } else {
            try {
                builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, PERMISSION_SITES_CREATE, PERMISSION_SITES_UPDATE);
                if (builder != null) {
                    return builder.build();
                }
                try {
                    JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Site.class});
                    mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                    mapper.configure(DeserializationFeature.UNWRAP_ROOT_VALUE, true);
                    mapper.configure(MapperFeature.USE_ANNOTATIONS, false);
                    mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                    JSONObject obj = new JSONObject(jsonString);
                    HashMap<String, String> xmlToJsonNamespaces = new HashMap<String, String>();
                    xmlToJsonNamespaces.put("http://satv.ericsson.org/cms/services", "");
                    Configuration config = new Configuration(xmlToJsonNamespaces);
                    MappedNamespaceConvention con = new MappedNamespaceConvention(config);
                    MappedXMLStreamReader xmlStreamReader = new MappedXMLStreamReader(obj, con);
                    Unmarshaller unmarshaller = jc.createUnmarshaller();
                    serviceMso = (Mso)unmarshaller.unmarshal((XMLStreamReader)xmlStreamReader, Mso.class).getValue();
                    mso = this.convertMso(serviceMso);
                    this.msoManager.saveMSO(mso);
                    responseMso = this.convertMSO(mso, uriInfo);
                    jsonResponse = ResponseTypeUtilities.toJSON(responseMso);
                }
                catch (Exception e) {
                    errors.getErrors().add(e.getLocalizedMessage());
                    builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
            catch (Exception exception) {
                errors.getErrors().add("Caller is unauthorized to execute operation.");
                builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(contentType);
            }
        }
        if (errors.getErrors().size() > 0) {
            builder.entity((Object)errors);
        } else {
            builder = Response.ok(jsonResponse).type(contentType);
        }
        return builder.build();
    }

    private boolean validContentType(String contentType) {
        if (contentType == null) {
            return false;
        }
        String cType = contentType.toLowerCase();
        return cType.startsWith(JSON_MEDIA) || cType.startsWith(DEFAULT_MEDIA);
    }

    private String defineMediaType(String accept) {
        if (accept != null && (accept.toLowerCase().equals(JSON_MEDIA) || accept.toLowerCase().equals(DEFAULT_MEDIA))) {
            return accept;
        }
        return DEFAULT_MEDIA;
    }

    private static final /* synthetic */ Response deleteMSO_aroundBody0(MSOService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, String accept, String msoId, Request request, UriInfo uriInfo, SecurityContext sec) {
        String mediaType;
        Errors errors;
        Response.ResponseBuilder builder;
        block8: {
            builder = null;
            errors = new Errors();
            MSO mso = null;
            mediaType = ajc$this.defineMediaType(accept);
            try {
                builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, PERMISSION_SITES_DELETE, PERMISSION_SITES_UPDATE);
                if (builder != null) {
                    return builder.build();
                }
                try {
                    mso = ajc$this.msoManager.getMSOById(new Integer(msoId).intValue());
                    if (mso == null) {
                        errors.getErrors().add("MSO not found");
                        builder = Response.status((Response.Status)Response.Status.NOT_FOUND).type(mediaType);
                        break block8;
                    }
                    ajc$this.msoManager.deleteMSO(mso);
                }
                catch (Exception e) {
                    errors.getErrors().add(e.getLocalizedMessage());
                    builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
            catch (Exception exception) {
                errors.getErrors().add("Caller is unauthorized to execute operation.");
                builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(mediaType);
            }
        }
        if (errors.getErrors().size() > 0) {
            builder.entity((Object)errors);
        } else {
            builder = Response.ok().type(mediaType);
        }
        return builder.build();
    }

    private static final /* synthetic */ Object deleteMSO_aroundBody1$advice(MSOService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, String accept, String msoId, Request request, UriInfo uriInfo, SecurityContext sec, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return MSOService.deleteMSO_aroundBody0(ajc$this, servletRequest, authorizationHeader, accept, msoId, request, uriInfo, sec);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = MSOService.deleteMSO_aroundBody0(ajc$this, servletRequest, authorizationHeader, accept, msoId, request, uriInfo, sec);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Response getAssociatedSites_aroundBody2(MSOService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, String accept, String msoId, Date expires, Request request, UriInfo uriInfo, SecurityContext sec) {
        Response.ResponseBuilder builder = null;
        Errors errors = new Errors();
        MSO mso = null;
        ResourceList resourceList = new ResourceList();
        String jsonResponse = null;
        String mediaType = ajc$this.defineMediaType(accept);
        try {
            builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, PERMISSION_SITES_CREATE, PERMISSION_SITES_UPDATE);
            if (builder != null) {
                return builder.build();
            }
            try {
                mso = ajc$this.msoManager.getMSOById(new Integer(msoId).intValue());
                if (mso == null) {
                    errors.getErrors().add("MSO not found");
                    builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
                } else {
                    for (MediapathDistributionSite site : mso.getMediaPathSiteSet()) {
                        Site siteResponse = new Site();
                        siteResponse.setName(site.getName());
                        siteResponse.setHref(uriInfo.getBaseUri() + "sites/" + site.getId());
                        resourceList.getSites().add(siteResponse);
                    }
                }
            }
            catch (Exception e) {
                errors.getErrors().add(e.getLocalizedMessage());
                builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
            }
            if (mediaType.contains(JSON_MEDIA)) {
                jsonResponse = ResponseTypeUtilities.toJSON(resourceList);
            }
        }
        catch (Exception exception) {
            errors.getErrors().add("Caller is unauthorized to execute operation.");
            builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(mediaType);
        }
        if (errors.getErrors().size() > 0) {
            builder.entity((Object)errors);
        } else {
            builder = Response.ok((Object)(jsonResponse == null ? resourceList : jsonResponse)).type(mediaType);
        }
        return builder.build();
    }

    private static final /* synthetic */ Object getAssociatedSites_aroundBody3$advice(MSOService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, String accept, String msoId, Date expires, Request request, UriInfo uriInfo, SecurityContext sec, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return MSOService.getAssociatedSites_aroundBody2(ajc$this, servletRequest, authorizationHeader, accept, msoId, expires, request, uriInfo, sec);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = MSOService.getAssociatedSites_aroundBody2(ajc$this, servletRequest, authorizationHeader, accept, msoId, expires, request, uriInfo, sec);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Response getMSO_aroundBody4(MSOService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, String accept, String msoId, Date lastModified, Request request, UriInfo uriInfo, SecurityContext sec) {
        Errors errors;
        Response.ResponseBuilder builder;
        block9: {
            MSO mso = null;
            Mso resp = null;
            builder = null;
            String jsonResponse = null;
            errors = new Errors();
            String mediaType = ajc$this.defineMediaType(accept);
            try {
                builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, PERMISSION_SITES_VIEW);
                if (builder != null) {
                    return builder.build();
                }
                try {
                    mso = ajc$this.msoManager.getMSOById(new Integer(msoId).intValue());
                    if (mso != null) {
                        resp = ajc$this.convertMsoSlashEnd(mso, uriInfo);
                        if (mediaType.contains(JSON_MEDIA)) {
                            jsonResponse = ResponseTypeUtilities.toJSON(resp);
                        }
                        builder = Response.ok((Object)(jsonResponse == null ? resp : jsonResponse)).type(mediaType);
                        break block9;
                    }
                    errors.getErrors().add("MSO not found");
                    builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
                }
                catch (NumberFormatException numberFormatException) {
                    errors.getErrors().add("Invalid msoId");
                    builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
                }
                catch (Exception e) {
                    errors.getErrors().add(e.getLocalizedMessage());
                    builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
            catch (Exception exception) {
                errors.getErrors().add("Caller is unauthorized to execute operation.");
                builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(mediaType);
            }
        }
        if (errors.getErrors().size() > 0) {
            builder.entity((Object)errors);
        }
        return builder.build();
    }

    private static final /* synthetic */ Object getMSO_aroundBody5$advice(MSOService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, String accept, String msoId, Date lastModified, Request request, UriInfo uriInfo, SecurityContext sec, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return MSOService.getMSO_aroundBody4(ajc$this, servletRequest, authorizationHeader, accept, msoId, lastModified, request, uriInfo, sec);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = MSOService.getMSO_aroundBody4(ajc$this, servletRequest, authorizationHeader, accept, msoId, lastModified, request, uriInfo, sec);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Response updateMSO_aroundBody6(MSOService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, String accept, Date lastModified, String msoId, Request request, UriInfo uriInfo, SecurityContext sec, Mso mso) {
        String mediaType;
        MSO msoObj;
        Errors errors;
        Response.ResponseBuilder builder;
        block10: {
            builder = null;
            errors = new Errors();
            msoObj = null;
            mediaType = ajc$this.defineMediaType(accept);
            try {
                builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, PERMISSION_SITES_UPDATE);
                if (builder != null) {
                    return builder.build();
                }
                try {
                    msoObj = ajc$this.msoManager.getMSOById(new Integer(msoId).intValue());
                    if (msoObj == null) {
                        errors.getErrors().add("MSO not found");
                        builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
                        break block10;
                    }
                    if (mso.getDescription() != null) {
                        msoObj.setMsoDescription(mso.getDescription());
                    }
                    if (mso.getName() != null) {
                        msoObj.setMsoName(mso.getName());
                    }
                    ajc$this.msoManager.saveMSO(msoObj);
                }
                catch (Exception e) {
                    errors.getErrors().add(e.getLocalizedMessage());
                    builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
            catch (Exception exception) {
                errors.getErrors().add("Caller is unauthorized to execute operation.");
                builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(mediaType);
            }
        }
        if (errors.getErrors().size() > 0) {
            builder.entity((Object)errors);
        } else {
            builder = Response.ok((Object)ajc$this.convertMsoSlashEnd(msoObj, uriInfo)).type(mediaType);
        }
        return builder.build();
    }

    private static final /* synthetic */ Object updateMSO_aroundBody7$advice(MSOService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, String accept, Date lastModified, String msoId, Request request, UriInfo uriInfo, SecurityContext sec, Mso mso, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return MSOService.updateMSO_aroundBody6(ajc$this, servletRequest, authorizationHeader, accept, lastModified, msoId, request, uriInfo, sec, mso);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = MSOService.updateMSO_aroundBody6(ajc$this, servletRequest, authorizationHeader, accept, lastModified, msoId, request, uriInfo, sec, mso);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Response updateMSO_aroundBody8(MSOService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, String accept, Date lastModified, String msoId, Request request, UriInfo uriInfo, SecurityContext sec, String jsonString) {
        String mediaType;
        String jsonResponse;
        Errors errors;
        Response.ResponseBuilder builder;
        block10: {
            builder = null;
            errors = new Errors();
            MSO msoObj = null;
            Mso serviceMso = null;
            ObjectMapper mapper = new ObjectMapper();
            jsonResponse = "";
            mediaType = ajc$this.defineMediaType(accept);
            try {
                builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, PERMISSION_SITES_UPDATE);
                if (builder != null) {
                    return builder.build();
                }
                try {
                    msoObj = ajc$this.msoManager.getMSOById(new Integer(msoId).intValue());
                    if (msoObj == null) {
                        errors.getErrors().add("MSO not found");
                        builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
                        break block10;
                    }
                    JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Mso.class});
                    mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                    mapper.configure(DeserializationFeature.UNWRAP_ROOT_VALUE, true);
                    mapper.configure(MapperFeature.USE_ANNOTATIONS, false);
                    mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                    JSONObject obj = new JSONObject(jsonString);
                    HashMap<String, String> xmlToJsonNamespaces = new HashMap<String, String>();
                    xmlToJsonNamespaces.put("http://satv.ericsson.org/cms/services", "");
                    Configuration config = new Configuration(xmlToJsonNamespaces);
                    MappedNamespaceConvention con = new MappedNamespaceConvention(config);
                    MappedXMLStreamReader xmlStreamReader = new MappedXMLStreamReader(obj, con);
                    Unmarshaller unmarshaller = jc.createUnmarshaller();
                    serviceMso = (Mso)unmarshaller.unmarshal((XMLStreamReader)xmlStreamReader, Mso.class).getValue();
                    if (serviceMso.getDescription() != null) {
                        msoObj.setMsoDescription(serviceMso.getDescription());
                    }
                    if (serviceMso.getName() != null) {
                        msoObj.setMsoName(serviceMso.getName());
                    }
                    ajc$this.msoManager.saveMSO(msoObj);
                    Mso responseMso = ajc$this.convertMsoSlashEnd(msoObj, uriInfo);
                    jsonResponse = ResponseTypeUtilities.toJSON(responseMso);
                }
                catch (Exception e) {
                    errors.getErrors().add(e.getLocalizedMessage());
                    builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(mediaType);
                }
            }
            catch (Exception exception) {
                errors.getErrors().add("Caller is unauthorized to execute operation.");
                builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(mediaType);
            }
        }
        if (errors.getErrors().size() > 0) {
            builder.entity((Object)errors);
        } else {
            builder = Response.ok((Object)jsonResponse).type(mediaType);
        }
        return builder.build();
    }

    private static final /* synthetic */ Object updateMSO_aroundBody9$advice(MSOService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, String accept, Date lastModified, String msoId, Request request, UriInfo uriInfo, SecurityContext sec, String jsonString, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return MSOService.updateMSO_aroundBody8(ajc$this, servletRequest, authorizationHeader, accept, lastModified, msoId, request, uriInfo, sec, jsonString);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = MSOService.updateMSO_aroundBody8(ajc$this, servletRequest, authorizationHeader, accept, lastModified, msoId, request, uriInfo, sec, jsonString);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Response associateSite_aroundBody10(MSOService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, String accept, String msoId, String siteId, Request request, UriInfo uriInfo, SecurityContext sec) {
        Response.ResponseBuilder builder = null;
        Errors errors = new Errors();
        MSO mso = null;
        MediapathDistributionSite site = null;
        ResourceList resourceList = new ResourceList();
        String jsonResponse = null;
        String mediaType = ajc$this.defineMediaType(accept);
        try {
            builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, PERMISSION_SITES_UPDATE);
            if (builder != null) {
                return builder.build();
            }
            try {
                mso = ajc$this.msoManager.getMSOById(new Integer(msoId).intValue());
                if (mso == null) {
                    errors.getErrors().add("MSO not found");
                    builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
                } else {
                    site = (MediapathDistributionSite)ajc$this.siteManager.getSite(new Integer(siteId).intValue());
                    if (site == null) {
                        errors.getErrors().add("Site not found");
                        builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
                    } else {
                        mso.getMediaPathSiteSet().add(site);
                        ajc$this.msoManager.saveMSO(mso);
                        resourceList.getMsos().add(ajc$this.convertMsoSlashEnd(mso, uriInfo));
                    }
                }
            }
            catch (Exception e) {
                errors.getErrors().add(e.getLocalizedMessage());
                builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
            }
            if (mediaType.contains(JSON_MEDIA)) {
                jsonResponse = ResponseTypeUtilities.toJSON(resourceList);
            }
        }
        catch (Exception exception) {
            errors.getErrors().add("Caller is unauthorized to execute operation.");
            builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(mediaType);
        }
        if (errors.getErrors().size() > 0) {
            builder.entity((Object)errors);
        } else {
            builder = Response.ok((Object)(jsonResponse == null ? resourceList : jsonResponse)).type(mediaType);
        }
        return builder.build();
    }

    private static final /* synthetic */ Object associateSite_aroundBody11$advice(MSOService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, String accept, String msoId, String siteId, Request request, UriInfo uriInfo, SecurityContext sec, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return MSOService.associateSite_aroundBody10(ajc$this, servletRequest, authorizationHeader, accept, msoId, siteId, request, uriInfo, sec);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = MSOService.associateSite_aroundBody10(ajc$this, servletRequest, authorizationHeader, accept, msoId, siteId, request, uriInfo, sec);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Response deleteSiteAssociation_aroundBody12(MSOService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, String accept, String msoId, String siteId, Request request, UriInfo uriInfo, SecurityContext sec) {
        Response.ResponseBuilder builder = null;
        Errors errors = new Errors();
        MSO mso = null;
        MediapathDistributionSite site = null;
        ResourceList resourceList = new ResourceList();
        String jsonResponse = null;
        String mediaType = ajc$this.defineMediaType(accept);
        try {
            builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, PERMISSION_SITES_UPDATE, PERMISSION_SITES_DELETE);
            if (builder != null) {
                return builder.build();
            }
            try {
                mso = ajc$this.msoManager.getMSOById(new Integer(msoId).intValue());
                if (mso == null) {
                    errors.getErrors().add("MSO not found");
                    builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
                } else {
                    site = (MediapathDistributionSite)ajc$this.siteManager.getSite(new Integer(siteId).intValue());
                    if (site == null) {
                        errors.getErrors().add("Site not found");
                        builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
                    } else {
                        mso.getMediaPathSiteSet().remove(site);
                        ajc$this.msoManager.saveMSO(mso);
                        resourceList.getMsos().add(ajc$this.convertMsoSlashEnd(mso, uriInfo));
                    }
                }
            }
            catch (Exception e) {
                errors.getErrors().add(e.getLocalizedMessage());
                builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
            }
            if (mediaType.contains(JSON_MEDIA)) {
                jsonResponse = ResponseTypeUtilities.toJSON(resourceList);
            }
        }
        catch (Exception exception) {
            errors.getErrors().add("Caller is unauthorized to execute operation.");
            builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(mediaType);
        }
        if (errors.getErrors().size() > 0) {
            builder.entity((Object)errors);
        } else {
            builder = Response.ok((Object)(jsonResponse == null ? resourceList : jsonResponse)).type(mediaType);
        }
        return builder.build();
    }

    private static final /* synthetic */ Object deleteSiteAssociation_aroundBody13$advice(MSOService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, String accept, String msoId, String siteId, Request request, UriInfo uriInfo, SecurityContext sec, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return MSOService.deleteSiteAssociation_aroundBody12(ajc$this, servletRequest, authorizationHeader, accept, msoId, siteId, request, uriInfo, sec);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = MSOService.deleteSiteAssociation_aroundBody12(ajc$this, servletRequest, authorizationHeader, accept, msoId, siteId, request, uriInfo, sec);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

