/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.partner;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.cms.services.AuthorizationException;
import com.tandbergtv.cms.services.exception.BadRequestException;
import com.tandbergtv.cms.services.exception.NotFoundException;
import com.tandbergtv.cms.services.exception.UnsupportedMediaTypeException;
import com.tandbergtv.cms.services.partner.ContentClassServiceHelper;
import com.tandbergtv.cms.services.partner.IPartnerService;
import com.tandbergtv.cms.services.partner.PartnerServiceHelper;
import com.tandbergtv.cms.services.resources.ContentClass;
import com.tandbergtv.cms.services.resources.Errors;
import com.tandbergtv.cms.services.resources.Partner;
import com.tandbergtv.cms.services.resources.ResourceList;
import com.tandbergtv.cms.services.util.ContentTypeUtil;
import com.tandbergtv.cms.util.EndpointsAuthorizationUtil;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.PartnerType;
import com.tandbergtv.watchpoint.pmm.entities.PartnerUser;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerUserManager;
import com.tandbergtv.watchpoint.pmm.util.DataOperationException;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.naming.InitialContext;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.TransactionManager;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.BooleanUtils;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.mapped.Configuration;
import org.codehaus.jettison.mapped.MappedNamespaceConvention;
import org.codehaus.jettison.mapped.MappedXMLStreamReader;
import org.codehaus.jettison.mapped.MappedXMLStreamWriter;

public class PartnerService
implements IPartnerService {
    private static final Logger logger = Logger.getLogger(PartnerService.class);
    public static final String PARTNERS_VIEW = "Partners_View";
    public static final String PARTNERS_CREATE = "Partners_Create";
    public static final String PARTNERS_MODIFY = "Partners_Modify";
    private static final String PARTNERS_DELETE = "Partners_Delete";
    private static final String JSON_MEDIA = "application/json";
    private IPartnerManagement partnerManager = (IPartnerManagement)ServiceRegistry.getDefault().lookup(IPartnerManagement.class);
    private IPartnerUserManager partnerUserManager = (IPartnerUserManager)InjectionUtil.injectInstance((String)"cms/PartnerUserManager/local", IPartnerUserManager.class);
    private IContentClassService contentClassService = (IContentClassService)ServiceRegistry.getDefault().lookup(IContentClassService.class);
    private ObjectMapper mapper = new ObjectMapper();
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ Annotation ajc$anno$6;
    private static /* synthetic */ Annotation ajc$anno$7;
    private static /* synthetic */ Annotation ajc$anno$8;
    private static /* synthetic */ Annotation ajc$anno$9;
    private static /* synthetic */ Annotation ajc$anno$10;
    private static /* synthetic */ Annotation ajc$anno$11;
    private static /* synthetic */ Annotation ajc$anno$12;

    @Override
    @Transactional
    public Response create(HttpServletRequest servletRequest, String authorizationHeader, String accept, Request request, UriInfo uriInfo, String jsonString) {
        HttpServletRequest httpServletRequest = servletRequest;
        String string = authorizationHeader;
        String string2 = accept;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        String string3 = jsonString;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = PartnerService.class.getDeclaredMethod("create", HttpServletRequest.class, String.class, String.class, Request.class, UriInfo.class, String.class).getAnnotation(Transactional.class);
        }
        return (Response)PartnerService.create_aroundBody1$advice(this, httpServletRequest, string, string2, request2, uriInfo2, string3, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public Response create(HttpServletRequest servletRequest, String authorizationHeader, String accept, Request request, UriInfo uriInfo, Partner metadata) {
        HttpServletRequest httpServletRequest = servletRequest;
        String string = authorizationHeader;
        String string2 = accept;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        Partner partner = metadata;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = PartnerService.class.getDeclaredMethod("create", HttpServletRequest.class, String.class, String.class, Request.class, UriInfo.class, Partner.class).getAnnotation(Transactional.class);
        }
        return (Response)PartnerService.create_aroundBody3$advice(this, httpServletRequest, string, string2, request2, uriInfo2, partner, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public Response get(HttpServletRequest servletRequest, Long partnerId, String authorizationHeader, String accept, Request request, UriInfo uriInfo) {
        HttpServletRequest httpServletRequest = servletRequest;
        Long l = partnerId;
        String string = authorizationHeader;
        String string2 = accept;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = PartnerService.class.getDeclaredMethod("get", HttpServletRequest.class, Long.class, String.class, String.class, Request.class, UriInfo.class).getAnnotation(Transactional.class);
        }
        return (Response)PartnerService.get_aroundBody5$advice(this, httpServletRequest, l, string, string2, request2, uriInfo2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public Response listAssociatedPartners(HttpServletRequest servletRequest, String authorizationHeader, String accept, Request request, UriInfo uriInfo) {
        HttpServletRequest httpServletRequest = servletRequest;
        String string = authorizationHeader;
        String string2 = accept;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = PartnerService.class.getDeclaredMethod("listAssociatedPartners", HttpServletRequest.class, String.class, String.class, Request.class, UriInfo.class).getAnnotation(Transactional.class);
        }
        return (Response)PartnerService.listAssociatedPartners_aroundBody7$advice(this, httpServletRequest, string, string2, request2, uriInfo2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public Response list(HttpServletRequest servletRequest, String authorizationHeader, String accept, String tenants, String filter, Request request, UriInfo uriInfo) {
        HttpServletRequest httpServletRequest = servletRequest;
        String string = authorizationHeader;
        String string2 = accept;
        String string3 = tenants;
        String string4 = filter;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = PartnerService.class.getDeclaredMethod("list", HttpServletRequest.class, String.class, String.class, String.class, String.class, Request.class, UriInfo.class).getAnnotation(Transactional.class);
        }
        return (Response)PartnerService.list_aroundBody9$advice(this, httpServletRequest, string, string2, string3, string4, request2, uriInfo2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public Response update(HttpServletRequest servletRequest, Long partnerId, String authorizationHeader, String accept, Request request, UriInfo uriInfo, String jsonString) {
        HttpServletRequest httpServletRequest = servletRequest;
        Long l = partnerId;
        String string = authorizationHeader;
        String string2 = accept;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        String string3 = jsonString;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = PartnerService.class.getDeclaredMethod("update", HttpServletRequest.class, Long.class, String.class, String.class, Request.class, UriInfo.class, String.class).getAnnotation(Transactional.class);
        }
        return (Response)PartnerService.update_aroundBody11$advice(this, httpServletRequest, l, string, string2, request2, uriInfo2, string3, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public Response update(HttpServletRequest servletRequest, Long partnerId, String authorizationHeader, String accept, Request request, UriInfo uriInfo, Partner metadata) {
        HttpServletRequest httpServletRequest = servletRequest;
        Long l = partnerId;
        String string = authorizationHeader;
        String string2 = accept;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        Partner partner = metadata;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = PartnerService.class.getDeclaredMethod("update", HttpServletRequest.class, Long.class, String.class, String.class, Request.class, UriInfo.class, Partner.class).getAnnotation(Transactional.class);
        }
        return (Response)PartnerService.update_aroundBody13$advice(this, httpServletRequest, l, string, string2, request2, uriInfo2, partner, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public Response disassociateUserFromPartner(HttpServletRequest servletRequest, String authorizationHeader, Long partnerId, String userName, Request request, UriInfo uriInfo, SecurityContext sec) {
        HttpServletRequest httpServletRequest = servletRequest;
        String string = authorizationHeader;
        Long l = partnerId;
        String string2 = userName;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        SecurityContext securityContext = sec;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$7;
        if (annotation == null) {
            annotation = ajc$anno$7 = PartnerService.class.getDeclaredMethod("disassociateUserFromPartner", HttpServletRequest.class, String.class, Long.class, String.class, Request.class, UriInfo.class, SecurityContext.class).getAnnotation(Transactional.class);
        }
        return (Response)PartnerService.disassociateUserFromPartner_aroundBody15$advice(this, httpServletRequest, string, l, string2, request2, uriInfo2, securityContext, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public Response associateChildToPartner(HttpServletRequest servletRequest, String authorizationHeader, Long partnerId, String childId, Request request, UriInfo uriInfo, SecurityContext sec) {
        HttpServletRequest httpServletRequest = servletRequest;
        String string = authorizationHeader;
        Long l = partnerId;
        String string2 = childId;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        SecurityContext securityContext = sec;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$8;
        if (annotation == null) {
            annotation = ajc$anno$8 = PartnerService.class.getDeclaredMethod("associateChildToPartner", HttpServletRequest.class, String.class, Long.class, String.class, Request.class, UriInfo.class, SecurityContext.class).getAnnotation(Transactional.class);
        }
        return (Response)PartnerService.associateChildToPartner_aroundBody17$advice(this, httpServletRequest, string, l, string2, request2, uriInfo2, securityContext, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public Response disAssociateChildFromPartner(HttpServletRequest servletRequest, String authorizationHeader, Long partnerId, String childId, Request request, UriInfo uriInfo, SecurityContext sec) {
        HttpServletRequest httpServletRequest = servletRequest;
        String string = authorizationHeader;
        Long l = partnerId;
        String string2 = childId;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        SecurityContext securityContext = sec;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$9;
        if (annotation == null) {
            annotation = ajc$anno$9 = PartnerService.class.getDeclaredMethod("disAssociateChildFromPartner", HttpServletRequest.class, String.class, Long.class, String.class, Request.class, UriInfo.class, SecurityContext.class).getAnnotation(Transactional.class);
        }
        return (Response)PartnerService.disAssociateChildFromPartner_aroundBody19$advice(this, httpServletRequest, string, l, string2, request2, uriInfo2, securityContext, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public Response associateUserToPartner(HttpServletRequest servletRequest, String authorizationHeader, Long partnerId, String userName, Request request, UriInfo uriInfo, SecurityContext sec) {
        HttpServletRequest httpServletRequest = servletRequest;
        String string = authorizationHeader;
        Long l = partnerId;
        String string2 = userName;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        SecurityContext securityContext = sec;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$10;
        if (annotation == null) {
            annotation = ajc$anno$10 = PartnerService.class.getDeclaredMethod("associateUserToPartner", HttpServletRequest.class, String.class, Long.class, String.class, Request.class, UriInfo.class, SecurityContext.class).getAnnotation(Transactional.class);
        }
        return (Response)PartnerService.associateUserToPartner_aroundBody21$advice(this, httpServletRequest, string, l, string2, request2, uriInfo2, securityContext, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public Response delete(HttpServletRequest servletRequest, Long partnerId, String authorizationHeader, Request request, UriInfo uriInfo) {
        HttpServletRequest httpServletRequest = servletRequest;
        Long l = partnerId;
        String string = authorizationHeader;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$11;
        if (annotation == null) {
            annotation = ajc$anno$11 = PartnerService.class.getDeclaredMethod("delete", HttpServletRequest.class, Long.class, String.class, Request.class, UriInfo.class).getAnnotation(Transactional.class);
        }
        return (Response)PartnerService.delete_aroundBody23$advice(this, httpServletRequest, l, string, request2, uriInfo2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public Response listContentClasses(HttpServletRequest servletRequest, Long partnerId, String authorizationHeader, String accept, Request request, UriInfo uriInfo) {
        HttpServletRequest httpServletRequest = servletRequest;
        Long l = partnerId;
        String string = authorizationHeader;
        String string2 = accept;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$12;
        if (annotation == null) {
            annotation = ajc$anno$12 = PartnerService.class.getDeclaredMethod("listContentClasses", HttpServletRequest.class, Long.class, String.class, String.class, Request.class, UriInfo.class).getAnnotation(Transactional.class);
        }
        return (Response)PartnerService.listContentClasses_aroundBody25$advice(this, httpServletRequest, l, string, string2, request2, uriInfo2, transactionEnforcer, (Transactional)annotation, null);
    }

    static <T> T[] append(T[] arr, T element) {
        int N = arr.length;
        arr = Arrays.copyOf(arr, N + 1);
        arr[N] = element;
        return arr;
    }

    private static final /* synthetic */ Response create_aroundBody0(PartnerService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, String accept, Request request, UriInfo uriInfo, String jsonString) {
        Partner partner = null;
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Partner.class});
            ajc$this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            ajc$this.mapper.configure(DeserializationFeature.UNWRAP_ROOT_VALUE, true);
            ajc$this.mapper.configure(MapperFeature.USE_ANNOTATIONS, false);
            ajc$this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            JSONObject obj = new JSONObject(jsonString);
            HashMap<String, String> xmlToJsonNamespaces = new HashMap<String, String>();
            xmlToJsonNamespaces.put("http://satv.ericsson.org/cms/services", "");
            Configuration config = new Configuration(xmlToJsonNamespaces);
            MappedNamespaceConvention con = new MappedNamespaceConvention(config);
            MappedXMLStreamReader xmlStreamReader = new MappedXMLStreamReader(obj, con);
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            partner = (Partner)unmarshaller.unmarshal((XMLStreamReader)xmlStreamReader);
        }
        catch (Exception e) {
            Response.ResponseBuilder builder = null;
            Errors errors = new Errors();
            errors.getErrors().add(e.getLocalizedMessage());
            builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
            builder.entity((Object)errors);
            logger.error((Object)e.getLocalizedMessage());
            return builder.build();
        }
        return ajc$this.create(servletRequest, authorizationHeader, accept, request, uriInfo, partner);
    }

    private static final /* synthetic */ Object create_aroundBody1$advice(PartnerService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, String accept, Request request, UriInfo uriInfo, String jsonString, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerService.create_aroundBody0(ajc$this, servletRequest, authorizationHeader, accept, request, uriInfo, jsonString);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = PartnerService.create_aroundBody0(ajc$this, servletRequest, authorizationHeader, accept, request, uriInfo, jsonString);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Response create_aroundBody2(PartnerService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, String accept, Request request, UriInfo uriInfo, Partner metadata) {
        Response.ResponseBuilder builder = null;
        Errors errors = new Errors();
        try {
            builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, PARTNERS_VIEW);
            if (builder != null) {
                return builder.build();
            }
            if (!ContentTypeUtil.validContentType(accept)) {
                throw new UnsupportedMediaTypeException("Unsupported media type: " + accept + ".");
            }
            if (!metadata.getType().equals(PartnerType.SOURCE.toString())) {
                throw new BadRequestException("Partner is not a SOURCE partner.");
            }
            PartnerServiceHelper.validatePartner(metadata, null);
            com.tandbergtv.watchpoint.pmm.entities.Partner partner = ajc$this.partnerManager.createPartner(PartnerServiceHelper.convertToBackendPartner(null, metadata));
            String affiliationCode = partner.createAffiliationCode();
            partner.setAffiliationCode(affiliationCode);
            partner = ajc$this.partnerManager.updatePartner(partner);
            if (partner == null) {
                throw new BadRequestException("Partner was not created.");
            }
            Partner partnerToReturn = PartnerServiceHelper.convertFromBackendPartner(partner, uriInfo, false);
            builder = Response.ok((Object)partnerToReturn).type(accept.toLowerCase());
            logger.debug((Object)"Partner CREATE successful.");
        }
        catch (BadRequestException bre) {
            errors.getErrors().add(bre.getMessage());
            builder = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("application/xml");
            logger.error((Object)bre.getMessage());
        }
        catch (AuthorizationException ae) {
            errors.getErrors().add("Caller is unauthorized to execute operation:" + ae.getMessage());
            builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type("application/xml");
            logger.error((Object)("Caller is unauthorized to execute operation:" + ae.getMessage()));
        }
        catch (UnsupportedMediaTypeException umte) {
            errors.getErrors().add(umte.getMessage());
            builder = Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).type("application/xml");
            logger.error((Object)umte.getMessage());
        }
        catch (Exception e) {
            errors.getErrors().add(e.getLocalizedMessage());
            builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
            logger.error((Object)e.getLocalizedMessage());
        }
        if (errors.getErrors().size() > 0) {
            builder.entity((Object)errors);
        }
        return builder.build();
    }

    private static final /* synthetic */ Object create_aroundBody3$advice(PartnerService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, String accept, Request request, UriInfo uriInfo, Partner metadata, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerService.create_aroundBody2(ajc$this, servletRequest, authorizationHeader, accept, request, uriInfo, metadata);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = PartnerService.create_aroundBody2(ajc$this, servletRequest, authorizationHeader, accept, request, uriInfo, metadata);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Response get_aroundBody4(PartnerService ajc$this, HttpServletRequest servletRequest, Long partnerId, String authorizationHeader, String accept, Request request, UriInfo uriInfo) {
        Response.ResponseBuilder builder = null;
        Errors errors = new Errors();
        try {
            builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, PARTNERS_VIEW);
            if (builder != null) {
                return builder.build();
            }
            if (!ContentTypeUtil.validContentType(accept)) {
                throw new UnsupportedMediaTypeException("Unsupported media type: " + accept + ".");
            }
            com.tandbergtv.watchpoint.pmm.entities.Partner partner = ajc$this.partnerManager.getPartner(partnerId.longValue());
            if (partner == null) {
                throw new NotFoundException("Partner not found.");
            }
            if (!partner.getIsActive().booleanValue()) {
                throw new NotFoundException("Partner not active.");
            }
            if (!partner.getType().equals((Object)PartnerType.SOURCE) && !partner.getType().equals((Object)PartnerType.SELF)) {
                throw new BadRequestException("Partner is not a SOURCE or SELF partner.");
            }
            Partner partnerToReturn = PartnerServiceHelper.convertFromBackendPartner(partner, uriInfo, false);
            builder = Response.ok((Object)partnerToReturn).type(accept.toLowerCase());
            logger.debug((Object)"Partner GET successful.");
        }
        catch (BadRequestException bre) {
            errors.getErrors().add(bre.getMessage());
            builder = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("application/xml");
            logger.error((Object)bre.getMessage());
        }
        catch (AuthorizationException ae) {
            errors.getErrors().add("Caller is unauthorized to execute operation:" + ae.getMessage());
            builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type("application/xml");
            logger.error((Object)("Caller is unauthorized to execute operation:" + ae.getMessage()));
        }
        catch (NotFoundException nfe) {
            errors.getErrors().add(nfe.getMessage());
            builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
            logger.error((Object)nfe.getMessage());
        }
        catch (UnsupportedMediaTypeException umte) {
            errors.getErrors().add(umte.getMessage());
            builder = Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).type("application/xml");
            logger.error((Object)umte.getMessage());
        }
        catch (Exception e) {
            errors.getErrors().add(e.getLocalizedMessage());
            builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
            logger.error((Object)e.getLocalizedMessage());
        }
        if (errors.getErrors().size() > 0) {
            builder.entity((Object)errors);
        }
        return builder.build();
    }

    private static final /* synthetic */ Object get_aroundBody5$advice(PartnerService ajc$this, HttpServletRequest servletRequest, Long partnerId, String authorizationHeader, String accept, Request request, UriInfo uriInfo, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerService.get_aroundBody4(ajc$this, servletRequest, partnerId, authorizationHeader, accept, request, uriInfo);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = PartnerService.get_aroundBody4(ajc$this, servletRequest, partnerId, authorizationHeader, accept, request, uriInfo);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Response listAssociatedPartners_aroundBody6(PartnerService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, String accept, Request request, UriInfo uriInfo) {
        Response.ResponseBuilder builder = null;
        ResourceList resourceList = new ResourceList();
        Errors errors = new Errors();
        try {
            if (!ContentTypeUtil.validContentType(accept)) {
                throw new UnsupportedMediaTypeException("Unsupported media type: " + accept + ".");
            }
            long t1 = System.currentTimeMillis();
            List partnerList = ajc$this.partnerManager.getAllActivePartnersForCurrentUserWithChildren();
            if (partnerList == null) {
                throw new BadRequestException("Partner query returned no partners.");
            }
            long t2 = System.currentTimeMillis();
            logger.debug((Object)("Time to get partners from partnerManager:" + (t2 - t1)));
            for (com.tandbergtv.watchpoint.pmm.entities.Partner partner : partnerList) {
                Partner partnerToReturn = PartnerServiceHelper.convertFromBackendPartner(partner, uriInfo, false);
                resourceList.getPartners().add(partnerToReturn);
            }
            long t3 = System.currentTimeMillis();
            logger.debug((Object)("Time to convert partners from partnerManager:" + (t3 - t2)));
            if (accept != null && accept.toLowerCase().startsWith(JSON_MEDIA)) {
                JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ResourceList.class});
                HashMap<String, String> xmlToJsonNamespaces = new HashMap<String, String>();
                xmlToJsonNamespaces.put("http://satv.ericsson.org/cms/services", "");
                xmlToJsonNamespaces.put("http://www.w3.org/2001/XMLSchema-instance", "");
                Configuration config = new Configuration(xmlToJsonNamespaces);
                config.setSupressAtAttributes(true);
                MappedNamespaceConvention con = new MappedNamespaceConvention(config);
                StringWriter writer = new StringWriter();
                MappedXMLStreamWriter xmlStreamWriter = new MappedXMLStreamWriter(con, (Writer)writer);
                Marshaller marshaller = jc.createMarshaller();
                marshaller.marshal((Object)resourceList, (XMLStreamWriter)xmlStreamWriter);
                builder = Response.ok((Object)writer.toString()).type(JSON_MEDIA);
            } else {
                builder = Response.ok((Object)resourceList).type(accept.toLowerCase());
            }
            logger.debug((Object)"Partners GET successful.");
        }
        catch (BadRequestException bre) {
            errors.getErrors().add(bre.getMessage());
            builder = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("application/xml");
            logger.error((Object)bre.getMessage());
        }
        catch (UnsupportedMediaTypeException umte) {
            errors.getErrors().add(umte.getMessage());
            builder = Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).type("application/xml");
            logger.error((Object)umte.getMessage());
        }
        catch (Exception e) {
            errors.getErrors().add(e.getLocalizedMessage());
            builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
            logger.error((Object)e.getLocalizedMessage());
        }
        if (errors.getErrors().size() > 0) {
            builder.entity((Object)errors);
        }
        return builder.build();
    }

    private static final /* synthetic */ Object listAssociatedPartners_aroundBody7$advice(PartnerService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, String accept, Request request, UriInfo uriInfo, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerService.listAssociatedPartners_aroundBody6(ajc$this, servletRequest, authorizationHeader, accept, request, uriInfo);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = PartnerService.listAssociatedPartners_aroundBody6(ajc$this, servletRequest, authorizationHeader, accept, request, uriInfo);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Response list_aroundBody8(PartnerService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, String accept, String tenants, String filter, Request request, UriInfo uriInfo) {
        Response.ResponseBuilder builder = null;
        ResourceList resourceList = new ResourceList();
        Errors errors = new Errors();
        try {
            List partners;
            Boolean isTenants;
            builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, PARTNERS_VIEW);
            if (builder != null) {
                return builder.build();
            }
            if (!ContentTypeUtil.validContentType(accept)) {
                throw new UnsupportedMediaTypeException("Unsupported media type: " + accept + ".");
            }
            SearchCriteria criteria = new SearchCriteria();
            ValueParameter filterParameter = PartnerServiceHelper.convertFilterToValueParameter(filter);
            if (filterParameter != null) {
                criteria.addParameter((SearchParameterBase)filterParameter);
            }
            if ((isTenants = BooleanUtils.toBooleanObject((String)tenants)) != null) {
                criteria.addParameter((SearchParameterBase)new ValueParameter("isTenant", SearchType.STRING, (Object)BooleanUtils.toString((boolean)isTenants, (String)"1", (String)"0")));
            }
            if ((partners = ajc$this.partnerManager.getPartnersBySearchCriteriaForCurrentUser(criteria, new PartnerType[]{PartnerType.SELF, PartnerType.SOURCE})) == null) {
                throw new BadRequestException("Partner query returned no partners.");
            }
            for (com.tandbergtv.watchpoint.pmm.entities.Partner partner : partners) {
                Partner partnerToReturn = PartnerServiceHelper.convertFromBackendPartner(partner, uriInfo, false);
                resourceList.getPartners().add(partnerToReturn);
            }
            builder = Response.ok((Object)resourceList).type(accept.toLowerCase());
            logger.debug((Object)"Partners GET successful.");
        }
        catch (BadRequestException bre) {
            errors.getErrors().add(bre.getMessage());
            builder = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("application/xml");
            logger.error((Object)bre.getMessage());
        }
        catch (AuthorizationException ae) {
            errors.getErrors().add("Caller is unauthorized to execute operation:" + ae.getMessage());
            builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type("application/xml");
            logger.error((Object)("Caller is unauthorized to execute operation:" + ae.getMessage()));
        }
        catch (UnsupportedMediaTypeException umte) {
            errors.getErrors().add(umte.getMessage());
            builder = Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).type("application/xml");
            logger.error((Object)umte.getMessage());
        }
        catch (Exception e) {
            errors.getErrors().add(e.getLocalizedMessage());
            builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
            logger.error((Object)e.getLocalizedMessage());
        }
        if (errors.getErrors().size() > 0) {
            builder.entity((Object)errors);
        }
        return builder.build();
    }

    private static final /* synthetic */ Object list_aroundBody9$advice(PartnerService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, String accept, String tenants, String filter, Request request, UriInfo uriInfo, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerService.list_aroundBody8(ajc$this, servletRequest, authorizationHeader, accept, tenants, filter, request, uriInfo);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = PartnerService.list_aroundBody8(ajc$this, servletRequest, authorizationHeader, accept, tenants, filter, request, uriInfo);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Response update_aroundBody10(PartnerService ajc$this, HttpServletRequest servletRequest, Long partnerId, String authorizationHeader, String accept, Request request, UriInfo uriInfo, String jsonString) {
        Partner partner = null;
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Partner.class});
            ajc$this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            ajc$this.mapper.configure(DeserializationFeature.UNWRAP_ROOT_VALUE, true);
            ajc$this.mapper.configure(MapperFeature.USE_ANNOTATIONS, false);
            ajc$this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            JSONObject obj = new JSONObject(jsonString);
            HashMap<String, String> xmlToJsonNamespaces = new HashMap<String, String>();
            xmlToJsonNamespaces.put("http://satv.ericsson.org/cms/services", "");
            Configuration config = new Configuration(xmlToJsonNamespaces);
            MappedNamespaceConvention con = new MappedNamespaceConvention(config);
            MappedXMLStreamReader xmlStreamReader = new MappedXMLStreamReader(obj, con);
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            partner = (Partner)unmarshaller.unmarshal((XMLStreamReader)xmlStreamReader);
        }
        catch (Exception e) {
            Response.ResponseBuilder builder = null;
            Errors errors = new Errors();
            errors.getErrors().add(e.getLocalizedMessage());
            builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
            builder.entity((Object)errors);
            logger.error((Object)e.getLocalizedMessage());
            return builder.build();
        }
        return ajc$this.update(servletRequest, partnerId, authorizationHeader, accept, request, uriInfo, partner);
    }

    private static final /* synthetic */ Object update_aroundBody11$advice(PartnerService ajc$this, HttpServletRequest servletRequest, Long partnerId, String authorizationHeader, String accept, Request request, UriInfo uriInfo, String jsonString, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerService.update_aroundBody10(ajc$this, servletRequest, partnerId, authorizationHeader, accept, request, uriInfo, jsonString);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = PartnerService.update_aroundBody10(ajc$this, servletRequest, partnerId, authorizationHeader, accept, request, uriInfo, jsonString);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Response update_aroundBody12(PartnerService ajc$this, HttpServletRequest servletRequest, Long partnerId, String authorizationHeader, String accept, Request request, UriInfo uriInfo, Partner metadata) {
        Response.ResponseBuilder builder = null;
        Errors errors = new Errors();
        try {
            builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, PARTNERS_MODIFY);
            if (builder != null) {
                return builder.build();
            }
            com.tandbergtv.watchpoint.pmm.entities.Partner partner = ajc$this.partnerManager.getPartner(partnerId.longValue());
            if (partner == null) {
                throw new NotFoundException("Partner not found.");
            }
            if (!partner.getIsActive().booleanValue()) {
                throw new NotFoundException("Partner not active.");
            }
            if (!ContentTypeUtil.validContentType(accept)) {
                throw new UnsupportedMediaTypeException("Unsupported media type: " + accept + ".");
            }
            if (!metadata.getType().equals(PartnerType.SOURCE.toString()) && !metadata.getType().equals(PartnerType.SELF.toString())) {
                throw new BadRequestException("Partner is not a SOURCE or SELF partner.");
            }
            PartnerServiceHelper.validatePartner(metadata, partnerId);
            partner = PartnerServiceHelper.convertToBackendPartner(partner, metadata);
            partner.setId(partnerId.longValue());
            partner = ajc$this.partnerManager.updatePartner(partner);
            if (partner == null) {
                throw new BadRequestException("Partner was not updated.");
            }
            Partner partnerToReturn = PartnerServiceHelper.convertFromBackendPartner(partner, uriInfo, false);
            builder = Response.ok((Object)partnerToReturn).type(accept.toLowerCase());
            logger.debug((Object)"Partner UPDATE successful.");
        }
        catch (BadRequestException bre) {
            errors.getErrors().add(bre.getMessage());
            builder = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("application/xml");
            logger.error((Object)bre.getMessage());
        }
        catch (AuthorizationException ae) {
            errors.getErrors().add("Caller is unauthorized to execute operation:" + ae.getMessage());
            builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type("application/xml");
            logger.error((Object)("Caller is unauthorized to execute operation:" + ae.getMessage()));
        }
        catch (NotFoundException nfe) {
            errors.getErrors().add(nfe.getMessage());
            builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
            logger.error((Object)nfe.getMessage());
        }
        catch (UnsupportedMediaTypeException umte) {
            errors.getErrors().add(umte.getMessage());
            builder = Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).type("application/xml");
            logger.error((Object)umte.getMessage());
        }
        catch (Exception e) {
            errors.getErrors().add(e.getLocalizedMessage());
            builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
            logger.error((Object)e.getLocalizedMessage());
        }
        if (errors.getErrors().size() > 0) {
            builder.entity((Object)errors);
        }
        return builder.build();
    }

    private static final /* synthetic */ Object update_aroundBody13$advice(PartnerService ajc$this, HttpServletRequest servletRequest, Long partnerId, String authorizationHeader, String accept, Request request, UriInfo uriInfo, Partner metadata, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerService.update_aroundBody12(ajc$this, servletRequest, partnerId, authorizationHeader, accept, request, uriInfo, metadata);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = PartnerService.update_aroundBody12(ajc$this, servletRequest, partnerId, authorizationHeader, accept, request, uriInfo, metadata);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Response disassociateUserFromPartner_aroundBody14(PartnerService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, Long partnerId, String userName, Request request, UriInfo uriInfo, SecurityContext sec) {
        Response.ResponseBuilder builder = null;
        Errors errors = new Errors();
        try {
            builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, PARTNERS_MODIFY);
            if (builder != null) {
                return builder.build();
            }
            com.tandbergtv.watchpoint.pmm.entities.Partner partner = ajc$this.partnerManager.getPartner(partnerId.longValue());
            if (partner == null) {
                throw new NotFoundException("Partner not found.");
            }
            if (!partner.getIsActive().booleanValue()) {
                throw new NotFoundException("Partner not active.");
            }
            PartnerUser pUser = ajc$this.partnerUserManager.getByPartnerAndUserName(partnerId, userName);
            if (pUser == null) {
                throw new NotFoundException("Associated Partner User not found.");
            }
            if (!ajc$this.partnerUserManager.delete(pUser.getId())) {
                throw new BadRequestException("Error while deleting partner user associationg (id: " + partnerId + "), username:  " + userName);
            }
            builder = Response.noContent();
            logger.debug((Object)"Partner disassociate successful.");
        }
        catch (AuthorizationException ae) {
            errors.getErrors().add("Caller is unauthorized to execute operation:" + ae.getMessage());
            builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type("application/xml");
            logger.error((Object)("Caller is unauthorized to execute operation:" + ae.getMessage()));
        }
        catch (NotFoundException nfe) {
            errors.getErrors().add(nfe.getMessage());
            builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
            logger.error((Object)nfe.getMessage());
        }
        catch (BadRequestException bre) {
            errors.getErrors().add(bre.getMessage());
            builder = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("application/xml");
            logger.error((Object)bre.getMessage());
        }
        catch (Exception e) {
            errors.getErrors().add(e.getLocalizedMessage());
            builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
            logger.error((Object)e.getLocalizedMessage());
        }
        if (errors.getErrors().size() > 0) {
            builder.entity((Object)errors);
        }
        return builder.build();
    }

    private static final /* synthetic */ Object disassociateUserFromPartner_aroundBody15$advice(PartnerService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, Long partnerId, String userName, Request request, UriInfo uriInfo, SecurityContext sec, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerService.disassociateUserFromPartner_aroundBody14(ajc$this, servletRequest, authorizationHeader, partnerId, userName, request, uriInfo, sec);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = PartnerService.disassociateUserFromPartner_aroundBody14(ajc$this, servletRequest, authorizationHeader, partnerId, userName, request, uriInfo, sec);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Response associateChildToPartner_aroundBody16(PartnerService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, Long partnerId, String childId, Request request, UriInfo uriInfo, SecurityContext sec) {
        Response.ResponseBuilder builder = null;
        Errors errors = new Errors();
        String[] partnersIds = new String[]{};
        try {
            builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, PARTNERS_MODIFY);
            if (builder != null) {
                return builder.build();
            }
            com.tandbergtv.watchpoint.pmm.entities.Partner partner = ajc$this.partnerManager.getPartner(partnerId.longValue());
            if (partner == null) {
                throw new NotFoundException("Partner not found.");
            }
            com.tandbergtv.watchpoint.pmm.entities.Partner childPartner = ajc$this.partnerManager.getPartner(Long.valueOf(childId).longValue());
            if (partner.getType() == PartnerType.SELF || childPartner.getType() == PartnerType.SELF) {
                throw new BadRequestException("SELF Partner cannot have assosiation with another partner");
            }
            if (!partner.getIsActive().booleanValue()) {
                throw new NotFoundException("Partner not active.");
            }
            if (childId == null) {
                throw new BadRequestException("Child Id not specified");
            }
            partnersIds = PartnerService.append(partnersIds, childId);
            ajc$this.partnerManager.associateChildrenPartners(partnersIds, String.valueOf(partner.getContainerContextId()));
            builder = Response.noContent();
            logger.debug((Object)"Partner associate successful.");
        }
        catch (AuthorizationException ae) {
            errors.getErrors().add("Caller is unauthorized to execute operation:" + ae.getMessage());
            builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type("application/xml");
            logger.error((Object)("Caller is unauthorized to execute operation:" + ae.getMessage()));
        }
        catch (BadRequestException bre) {
            errors.getErrors().add(bre.getMessage());
            builder = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("application/xml");
            logger.error((Object)bre.getMessage());
        }
        catch (NotFoundException nfe) {
            errors.getErrors().add(nfe.getMessage());
            builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
            logger.error((Object)nfe.getMessage());
        }
        catch (Exception e) {
            errors.getErrors().add(e.getLocalizedMessage());
            builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
            logger.error((Object)e.getLocalizedMessage());
        }
        if (errors.getErrors().size() > 0) {
            builder.entity((Object)errors);
        }
        return builder.build();
    }

    private static final /* synthetic */ Object associateChildToPartner_aroundBody17$advice(PartnerService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, Long partnerId, String childId, Request request, UriInfo uriInfo, SecurityContext sec, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerService.associateChildToPartner_aroundBody16(ajc$this, servletRequest, authorizationHeader, partnerId, childId, request, uriInfo, sec);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = PartnerService.associateChildToPartner_aroundBody16(ajc$this, servletRequest, authorizationHeader, partnerId, childId, request, uriInfo, sec);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Response disAssociateChildFromPartner_aroundBody18(PartnerService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, Long partnerId, String childId, Request request, UriInfo uriInfo, SecurityContext sec) {
        Response.ResponseBuilder builder = null;
        Errors errors = new Errors();
        String[] partnersIds = new String[]{};
        try {
            builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, PARTNERS_MODIFY);
            if (builder != null) {
                return builder.build();
            }
            com.tandbergtv.watchpoint.pmm.entities.Partner partner = ajc$this.partnerManager.getPartner(partnerId.longValue());
            if (partner == null) {
                throw new NotFoundException("Partner not found.");
            }
            if (!partner.getIsActive().booleanValue()) {
                throw new NotFoundException("Partner not active.");
            }
            if (childId == null) {
                throw new BadRequestException("Child Id not specified");
            }
            partnersIds = PartnerService.append(partnersIds, childId);
            ajc$this.partnerManager.disassociateChildrenPartners(partnersIds, String.valueOf(partner.getContainerContextId()));
            builder = Response.noContent();
            logger.debug((Object)"Partner associate successful.");
        }
        catch (AuthorizationException ae) {
            errors.getErrors().add("Caller is unauthorized to execute operation:" + ae.getMessage());
            builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type("application/xml");
            logger.error((Object)("Caller is unauthorized to execute operation:" + ae.getMessage()));
        }
        catch (BadRequestException bre) {
            errors.getErrors().add(bre.getMessage());
            builder = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("application/xml");
            logger.error((Object)bre.getMessage());
        }
        catch (NotFoundException nfe) {
            errors.getErrors().add(nfe.getMessage());
            builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
            logger.error((Object)nfe.getMessage());
        }
        catch (Exception e) {
            errors.getErrors().add(e.getLocalizedMessage());
            builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
            logger.error((Object)e.getLocalizedMessage());
        }
        if (errors.getErrors().size() > 0) {
            builder.entity((Object)errors);
        }
        return builder.build();
    }

    private static final /* synthetic */ Object disAssociateChildFromPartner_aroundBody19$advice(PartnerService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, Long partnerId, String childId, Request request, UriInfo uriInfo, SecurityContext sec, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerService.disAssociateChildFromPartner_aroundBody18(ajc$this, servletRequest, authorizationHeader, partnerId, childId, request, uriInfo, sec);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = PartnerService.disAssociateChildFromPartner_aroundBody18(ajc$this, servletRequest, authorizationHeader, partnerId, childId, request, uriInfo, sec);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Response associateUserToPartner_aroundBody20(PartnerService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, Long partnerId, String userName, Request request, UriInfo uriInfo, SecurityContext sec) {
        Response.ResponseBuilder builder = null;
        Errors errors = new Errors();
        try {
            builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, PARTNERS_MODIFY);
            if (builder != null) {
                return builder.build();
            }
            com.tandbergtv.watchpoint.pmm.entities.Partner partner = ajc$this.partnerManager.getPartner(partnerId.longValue());
            if (partner == null) {
                throw new NotFoundException("Partner not found.");
            }
            if (!partner.getIsActive().booleanValue()) {
                throw new NotFoundException("Partner not active.");
            }
            PartnerUser pUser = new PartnerUser();
            pUser.setPartnerId(partnerId);
            pUser.setUserName(userName);
            List pList = ajc$this.partnerUserManager.getByUserName(userName);
            if (pList != null && !pList.isEmpty()) {
                for (PartnerUser existingPUser : pList) {
                    if (existingPUser.getPartnerId().doubleValue() != partnerId.doubleValue()) continue;
                    throw new BadRequestException("Corresponding Partner User already exists.");
                }
            }
            ajc$this.partnerUserManager.create(pUser);
            builder = Response.noContent();
            logger.debug((Object)"Partner associate successful.");
        }
        catch (AuthorizationException ae) {
            errors.getErrors().add("Caller is unauthorized to execute operation:" + ae.getMessage());
            builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type("application/xml");
            logger.error((Object)("Caller is unauthorized to execute operation:" + ae.getMessage()));
        }
        catch (BadRequestException bre) {
            errors.getErrors().add(bre.getMessage());
            builder = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("application/xml");
            logger.error((Object)bre.getMessage());
        }
        catch (NotFoundException nfe) {
            errors.getErrors().add(nfe.getMessage());
            builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
            logger.error((Object)nfe.getMessage());
        }
        catch (Exception e) {
            errors.getErrors().add(e.getLocalizedMessage());
            builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
            logger.error((Object)e.getLocalizedMessage());
        }
        if (errors.getErrors().size() > 0) {
            builder.entity((Object)errors);
        }
        return builder.build();
    }

    private static final /* synthetic */ Object associateUserToPartner_aroundBody21$advice(PartnerService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, Long partnerId, String userName, Request request, UriInfo uriInfo, SecurityContext sec, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerService.associateUserToPartner_aroundBody20(ajc$this, servletRequest, authorizationHeader, partnerId, userName, request, uriInfo, sec);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = PartnerService.associateUserToPartner_aroundBody20(ajc$this, servletRequest, authorizationHeader, partnerId, userName, request, uriInfo, sec);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Response delete_aroundBody22(PartnerService ajc$this, HttpServletRequest servletRequest, Long partnerId, String authorizationHeader, Request request, UriInfo uriInfo) {
        Response.ResponseBuilder builder = null;
        Errors errors = new Errors();
        try {
            builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, PARTNERS_DELETE);
            if (builder != null) {
                return builder.build();
            }
            com.tandbergtv.watchpoint.pmm.entities.Partner partner = ajc$this.partnerManager.getPartner(partnerId.longValue());
            if (partner == null) {
                throw new NotFoundException("Partner not found.");
            }
            if (!partner.getIsActive().booleanValue()) {
                throw new NotFoundException("Partner not active.");
            }
            if (!partner.getType().equals((Object)PartnerType.SOURCE)) {
                throw new BadRequestException("Partner is not a SOURCE partner.");
            }
            if (!ajc$this.partnerManager.findAllChildPartners(partner.getAffiliationCode()).isEmpty()) {
                throw new BadRequestException("Parent partner cannot be deleted. Please delete child partners and try again.");
            }
            if (!ajc$this.partnerManager.deletePartner(partnerId.longValue())) {
                throw new BadRequestException("Error while deleting partner (id: " + partnerId + "): ");
            }
            builder = Response.noContent();
            logger.debug((Object)"Partner DELETE successful.");
        }
        catch (BadRequestException bre) {
            errors.getErrors().add(bre.getMessage());
            builder = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("application/xml");
            logger.error((Object)bre.getMessage(), (Throwable)bre);
        }
        catch (DataOperationException doe) {
            errors.getErrors().add(doe.getMessage());
            builder = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("application/xml");
            logger.error((Object)doe.getMessage(), (Throwable)doe);
        }
        catch (AuthorizationException ae) {
            errors.getErrors().add("Caller is unauthorized to execute operation:" + ae.getMessage());
            builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type("application/xml");
            logger.error((Object)("Caller is unauthorized to execute operation:" + ae.getMessage()), (Throwable)ae);
        }
        catch (NotFoundException nfe) {
            errors.getErrors().add(nfe.getMessage());
            builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
            logger.error((Object)nfe.getMessage(), (Throwable)nfe);
        }
        catch (Exception e) {
            errors.getErrors().add(e.getLocalizedMessage());
            builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
            logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        if (errors.getErrors().size() > 0) {
            builder.entity((Object)errors);
        }
        return builder.build();
    }

    private static final /* synthetic */ Object delete_aroundBody23$advice(PartnerService ajc$this, HttpServletRequest servletRequest, Long partnerId, String authorizationHeader, Request request, UriInfo uriInfo, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerService.delete_aroundBody22(ajc$this, servletRequest, partnerId, authorizationHeader, request, uriInfo);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = PartnerService.delete_aroundBody22(ajc$this, servletRequest, partnerId, authorizationHeader, request, uriInfo);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Response listContentClasses_aroundBody24(PartnerService ajc$this, HttpServletRequest servletRequest, Long partnerId, String authorizationHeader, String accept, Request request, UriInfo uriInfo) {
        Response.ResponseBuilder builder = null;
        ResourceList resourceList = new ResourceList();
        Errors errors = new Errors();
        try {
            builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, PARTNERS_VIEW);
            if (builder != null) {
                return builder.build();
            }
            try {
                if (!ContentTypeUtil.validContentType(accept)) {
                    throw new UnsupportedMediaTypeException("Unsupported media type: " + accept + ".");
                }
                com.tandbergtv.watchpoint.pmm.entities.Partner partner = ajc$this.partnerManager.getPartner(partnerId.longValue());
                if (partner == null || partner.getProviderId() == null || partner.getProviderId().equals("")) {
                    throw new NotFoundException("Partner with id " + partnerId + " wasn't found");
                }
                ArrayList contentClasses = ajc$this.contentClassService.getPartnerContentClassesWithoutMetadata(partnerId.longValue());
                if (contentClasses == null) {
                    contentClasses = new ArrayList();
                }
                for (com.tandbergtv.content.contentclass.entities.ContentClass contentClass : contentClasses) {
                    ContentClass contentClassToReturn = ContentClassServiceHelper.convertFromBackendContentClass(contentClass, uriInfo);
                    resourceList.getContentClasses().add(contentClassToReturn);
                }
                builder = Response.ok((Object)resourceList).type(accept.toLowerCase());
                logger.debug((Object)"Partners GET successful.");
            }
            catch (UnsupportedMediaTypeException umte) {
                errors.getErrors().add(umte.getMessage());
                builder = Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).type("application/xml");
                logger.error((Object)umte.getMessage());
            }
            catch (NotFoundException ex) {
                errors.getErrors().add(ex.getMessage());
                builder = Response.status((Response.Status)Response.Status.NOT_FOUND).type("application/xml");
                logger.error((Object)ex.getMessage());
            }
            catch (Exception e) {
                errors.getErrors().add(e.getLocalizedMessage());
                builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
                logger.error((Object)e.getLocalizedMessage());
            }
        }
        catch (Exception exception) {
            errors.getErrors().add("Caller is unauthorized to execute operation.");
            builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED);
        }
        if (errors.getErrors().size() > 0) {
            builder.entity((Object)errors);
        }
        return builder.build();
    }

    private static final /* synthetic */ Object listContentClasses_aroundBody25$advice(PartnerService ajc$this, HttpServletRequest servletRequest, Long partnerId, String authorizationHeader, String accept, Request request, UriInfo uriInfo, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return PartnerService.listContentClasses_aroundBody24(ajc$this, servletRequest, partnerId, authorizationHeader, accept, request, uriInfo);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = PartnerService.listContentClasses_aroundBody24(ajc$this, servletRequest, partnerId, authorizationHeader, accept, request, uriInfo);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

