/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.resourcemanagement;

import com.tandbergtv.cms.services.AuthorizationException;
import com.tandbergtv.cms.services.resourcemanagement.IResourceService;
import com.tandbergtv.cms.services.util.ConversionUtil;
import com.tandbergtv.cms.util.EndpointsAuthorizationUtil;
import com.tandbergtv.cms.util.ResponseTypeUtilities;
import com.tandbergtv.workflow.api.API;
import com.tandbergtv.workflow.api.Resources;
import com.tandbergtv.workflow.api.model.resource.Resource;
import com.tandbergtv.workflow.api.model.resource.ResourceListResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.EJBAccessException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;

public class ResourceService
implements IResourceService {
    private static final String NO_CACHE = "NO-CACHE";
    public static final String RESOURCEMANAGEMENT_VIEW = "ResourceManagement_View";
    private static Logger logger = Logger.getLogger(ResourceService.class);

    @Override
    public Response getResources(HttpServletRequest servletRequest, Request request, String authorizationHeader) {
        try {
            Response.ResponseBuilder builder = null;
            builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, RESOURCEMANAGEMENT_VIEW);
            if (builder != null) {
                return builder.build();
            }
            List<Resource> resources = this.getAllResources();
            MediaType type = ResponseTypeUtilities.getMediaTypeFromRequest(request);
            if (type == MediaType.APPLICATION_JSON_TYPE) {
                return Response.ok((Object)ConversionUtil.getJSONforResources(resources), (String)"application/json").header("Cache-Control", (Object)NO_CACHE).build();
            }
            return Response.ok((Object)ConversionUtil.getXMLforResources(resources), (String)"application/xml").header("Cache-Control", (Object)NO_CACHE).build();
        }
        catch (AuthorizationException e) {
            logger.error((Object)"error", (Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type("text/plain").build();
        }
        catch (EJBAccessException e) {
            logger.error((Object)"error", (Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type("text/plain").build();
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).type("text/plain").build();
        }
    }

    private List<Resource> getAllResources() throws IOException {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        int start = 0;
        int total = 0;
        int count = 10;
        while (total < 100) {
            List<Resource> data = this.getPage(start, count);
            resources.addAll(data);
            if (data.size() < count) break;
            start += count;
            total += data.size();
        }
        return resources;
    }

    private List<Resource> getPage(int start, int count) throws IOException {
        Resources client = this.resources();
        client.query().detail("full").start(start).count(count);
        ResourceListResponse response = client.execute();
        return response.getItems();
    }

    private Resources resources() {
        return new API.Builder().build().resources();
    }
}

