/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.snmp;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tandbergtv.cms.services.snmp.ISnmpSubagentService;
import com.tandbergtv.cms.services.snmp.JMXClient;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;

public class SnmpSubagentService
implements ISnmpSubagentService {
    private static final Logger logger = Logger.getLogger(SnmpSubagentService.class);

    @Override
    public Response getAttributeByMbeanName(HttpServletRequest servletRequest, Request request, String authorizationHeader, String mbeanName, String attribute) {
        logger.debug((Object)("MBean: " + mbeanName + " attribute: " + attribute));
        Object obj = JMXClient.getInstance().getMbeanAttribute(mbeanName, attribute);
        ObjectMapper mapper = new ObjectMapper();
        String json = "";
        try {
            if (obj != null) {
                logger.debug((Object)("Mbean attribute value: " + obj.toString()));
                json = mapper.writeValueAsString(obj);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error parsing MBean attribute value", (Throwable)ex);
        }
        if (!json.isEmpty()) {
            return Response.ok((Object)json, (String)"application/json").build();
        }
        logger.debug((Object)"JMXClient did not return valid value");
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
    }
}

