/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.titles;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.ParamType;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.tandbergtv.cms.services.titles.FieldAlias;
import com.tandbergtv.cms.services.titles.FieldAliases;
import com.tandbergtv.cms.services.titles.SearchHelper;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class ExpListBuilder {
    private static final String ECMF_SPEC_PREFIX = "/ECMFSpec/";
    private static final Pattern DATE_PATTERN = Pattern.compile("^(20|19)[\\d]{2}-(0[1-9]|[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|[1-9]|3[0-1])$");
    private static final Pattern TIME_PATTERN = Pattern.compile("^([0-9]|[0-1][0-9]|2[0-3])(:([0-9]|[0-5][0-9])){2}(\\.[\\d]{3}){0,1}$");
    private List<String> andFilters;
    private List<String> orFilters;
    private String modifiedAfter;
    private List<Integer> siteIds;
    private List<Integer> trackingSiteIds;

    public ExpList build() {
        ExpList andList = ExpListBuilder.createListNode(this.andFilters, "AND");
        andList = ExpListBuilder.addModifiedAfterPredicate(andList, this.modifiedAfter);
        andList = this.addSiteIds(andList);
        ExpList orList = ExpListBuilder.createListNode(this.orFilters, "OR");
        ExpList rootList = SearchHelper.joinFilters(andList, orList);
        return rootList;
    }

    public void setAndFilters(List<String> andFilters) {
        this.andFilters = andFilters;
    }

    public void setOrFilters(List<String> orFilters) {
        this.orFilters = orFilters;
    }

    public void setModifiedAfter(String modifiedAfter) throws ParseException {
        if (StringUtils.isNotBlank((String)modifiedAfter)) {
            ExpListBuilder.validateDate(modifiedAfter);
        }
        this.modifiedAfter = modifiedAfter;
    }

    public void setSiteIds(List<Integer> ids) {
        this.siteIds = ids;
    }

    public void setTrackingSiteIds(List<Integer> trackingSiteIds) {
        this.trackingSiteIds = trackingSiteIds;
    }

    private static ExpList createListNode(List<String> filters, String listOperator) {
        if (filters == null || filters.isEmpty()) {
            return null;
        }
        ExpList expList = new ExpList(listOperator);
        for (String filter : filters) {
            String fieldLeft;
            String fieldLeftSectionType;
            FieldType fieldType;
            LogicalOperator operator;
            int fieldEnd = filter.indexOf(":");
            int operatorEnd = filter.indexOf(":", fieldEnd + 1);
            if (fieldEnd < 1) {
                throw new IllegalArgumentException("Invalid condition string: " + filter);
            }
            String lhs = filter.substring(0, fieldEnd);
            String value = null;
            if (operatorEnd < 0) {
                operator = LogicalOperator.lookUp((String)filter.substring(fieldEnd + 1));
            } else {
                operator = LogicalOperator.lookUp((String)filter.substring(fieldEnd + 1, operatorEnd));
                if (operatorEnd < filter.length()) {
                    value = filter.substring(operatorEnd + 1, filter.length());
                }
            }
            if (lhs.startsWith(ECMF_SPEC_PREFIX)) {
                fieldType = FieldType.ASSET;
                String xpath = lhs.substring(ECMF_SPEC_PREFIX.length());
                int startOfFields = xpath.indexOf("/Fields/");
                fieldLeftSectionType = xpath.substring(0, startOfFields).toUpperCase();
                fieldLeft = xpath.substring(startOfFields);
            } else {
                FieldAliases aliases = FieldAliases.getInstance();
                if (!aliases.containsAlias(lhs)) {
                    throw new IllegalArgumentException("Unsupported alias: " + lhs);
                }
                FieldAlias fieldAlias = aliases.getFieldAlias(lhs);
                fieldType = fieldAlias.getFieldType();
                fieldLeftSectionType = StringUtils.upperCase((String)fieldAlias.getAssetType());
                fieldLeft = fieldAlias.getField();
            }
            String dataType = SearchHelper.dataTypeLookup(fieldType, "", fieldLeft);
            if (!operator.getParamType().equals((Object)ParamType.NONE) && value == null) {
                throw new IllegalArgumentException("Invalid condition string: " + filter);
            }
            if (!operator.getParamType().equals((Object)ParamType.NONE)) {
                List<String> values = operator.getParamType().equals((Object)ParamType.LIST) ? Arrays.asList(value.split(",")) : Arrays.asList(value);
                try {
                    ExpListBuilder.validateParameter(dataType, values);
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
                if (LogicalOperator.NOTEQUAL.equals((Object)operator)) {
                    expList.addItem((ExpNode)new ExpValue((Predicate)new PredicateRightValue(fieldLeft, fieldLeftSectionType, fieldType, values, LogicalOperator.EQUAL, dataType, Boolean.valueOf(true))));
                    continue;
                }
                if (LogicalOperator.NOTIN.equals((Object)operator)) {
                    expList.addItem((ExpNode)new ExpValue((Predicate)new PredicateRightValue(fieldLeft, fieldLeftSectionType, fieldType, values, LogicalOperator.IN, dataType, Boolean.valueOf(true))));
                    continue;
                }
                expList.addItem((ExpNode)new ExpValue((Predicate)new PredicateRightValue(fieldLeft, fieldLeftSectionType, fieldType, values, operator, dataType, Boolean.valueOf(false))));
                continue;
            }
            expList.addItem((ExpNode)new ExpValue(new Predicate(fieldLeft, fieldLeftSectionType, fieldType, operator, dataType, Boolean.valueOf(false))));
        }
        return expList;
    }

    private static void validateParameter(String dataType, List<String> values) throws ParseException {
        block7: {
            block10: {
                block9: {
                    block8: {
                        block6: {
                            if ("string".equalsIgnoreCase(dataType)) {
                                return;
                            }
                            if (!"date".equalsIgnoreCase(dataType)) break block6;
                            for (String value : values) {
                                ExpListBuilder.validateDate(value);
                            }
                            break block7;
                        }
                        if (!"boolean".equalsIgnoreCase(dataType)) break block8;
                        for (String value : values) {
                            if (value != null && (value.equalsIgnoreCase("TRUE") || value.equalsIgnoreCase("FALSE"))) continue;
                            throw new ParseException("Unable to parse the boolean:" + value, -1);
                        }
                        break block7;
                    }
                    if (!"integer".equalsIgnoreCase(dataType)) break block9;
                    for (String value : values) {
                        Long.parseLong(value);
                    }
                    break block7;
                }
                if (!"float".equalsIgnoreCase(dataType)) break block10;
                for (String value : values) {
                    Double.parseDouble(value);
                }
                break block7;
            }
            if (!"time".equalsIgnoreCase(dataType)) break block7;
            for (String value : values) {
                ExpListBuilder.validateTime(value);
            }
        }
    }

    private static void validateTime(String value) throws ParseException {
        if (!TIME_PATTERN.matcher(value).find()) {
            throw new ParseException("Unable to parse the time:" + value, -1);
        }
    }

    private static void validateDate(String value) throws ParseException {
        if (!DATE_PATTERN.matcher(value).find()) {
            throw new ParseException("Unable to parse the date:" + value, -1);
        }
    }

    private static ExpList addModifiedAfterPredicate(ExpList expList, String modifiedAfter) {
        if (modifiedAfter == null || modifiedAfter.isEmpty()) {
            return expList;
        }
        if (expList == null) {
            expList = new ExpList();
        }
        PredicateRightValue predicate = new PredicateRightValue();
        predicate.setFieldLeft("lastModifiedTime");
        predicate.setFieldTypeLhs(FieldType.PMM_TITLE);
        predicate.setDataType("date");
        predicate.setOperator(LogicalOperator.GREATERTHANEQUAL);
        predicate.setValue(modifiedAfter);
        expList.addItem((ExpNode)new ExpValue((Predicate)predicate));
        return expList;
    }

    private ExpList addSiteIds(ExpList expList) {
        if ((this.siteIds == null || this.siteIds.isEmpty()) && (this.trackingSiteIds == null || this.trackingSiteIds.isEmpty())) {
            return expList;
        }
        ExpList l = expList == null ? new ExpList() : expList;
        ExpNode dExpValue = this.getExpForDistributeSiteIds();
        ExpNode tExpValue = this.getExpForTrackingSiteIds();
        if (dExpValue != null && tExpValue != null) {
            l.addItem((ExpNode)new ExpList("OR", Arrays.asList(dExpValue, tExpValue)));
        } else if (dExpValue != null && tExpValue == null) {
            l.addItem(dExpValue);
        } else if (dExpValue == null && tExpValue != null) {
            l.addItem(tExpValue);
        }
        return l;
    }

    private ExpNode getExpForDistributeSiteIds() {
        if (this.siteIds == null || this.siteIds.isEmpty()) {
            return null;
        }
        PredicateRightValue predicate = new PredicateRightValue();
        predicate.setFieldLeft("distributionSiteId");
        predicate.setFieldTypeLhs(FieldType.PMM_TITLE);
        predicate.setDataType("integer");
        if (this.siteIds.size() == 1) {
            predicate.setOperator(LogicalOperator.EQUAL);
            predicate.setValue(String.valueOf(this.siteIds.get(0)));
        } else {
            predicate.setOperator(LogicalOperator.IN);
            ArrayList<String> siteIdsList = new ArrayList<String>();
            for (int siteId : this.siteIds) {
                siteIdsList.add(String.valueOf(siteId));
            }
            predicate.setValue(siteIdsList);
        }
        return new ExpValue((Predicate)predicate);
    }

    private ExpNode getExpForTrackingSiteIds() {
        if (this.trackingSiteIds == null || this.trackingSiteIds.isEmpty()) {
            return null;
        }
        ArrayList<ExpNode> l = new ArrayList<ExpNode>(50);
        for (Integer id : this.trackingSiteIds) {
            l.add(ExpListBuilder.getExpNodeForTrackingSite(id));
        }
        if (l.size() == 1) {
            return (ExpNode)l.get(0);
        }
        return new ExpList("OR", l);
    }

    private static ExpNode getExpNodeForTrackingSite(Integer siteId) {
        PredicateRightValue predicate = new PredicateRightValue();
        predicate.setFieldLeft("/siteStatus/" + siteId);
        predicate.setFieldTypeLhs(FieldType.PMM_TITLE);
        predicate.setDataType("integer");
        predicate.setOperator(LogicalOperator.ISNOTEMPTY);
        return new ExpValue((Predicate)predicate);
    }
}

