/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.titles;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.codehaus.jettison.json.JSONException;
import org.jboss.resteasy.annotations.providers.multipart.MultipartForm;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;

@Path(value="/titles")
public interface ITitleServiceNG {
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public Response create(@Context HttpServletRequest var1, @HeaderParam(value="Authorization") String var2, @QueryParam(value="providerId") String var3, @QueryParam(value="contentClass") String var4);

    @Path(value="/{id}")
    @PUT
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public Response update(@Context HttpServletRequest var1, @HeaderParam(value="Authorization") String var2, @PathParam(value="id") Long var3, @DefaultValue(value="") @QueryParam(value="sendEvent") String var4);

    @Path(value="/{id}")
    @GET
    @Produces(value={"application/xml"})
    public Response getTitle(@HeaderParam(value="Authorization") String var1, @Context Request var2, @Context HttpServletRequest var3, @PathParam(value="id") Long var4, @DefaultValue(value="TTV") @QueryParam(value="specification") String var5);

    @GET
    @Produces(value={"application/xml", "application/json"})
    public Response list(@Context HttpServletRequest var1, @Context Request var2, @HeaderParam(value="Authorization") String var3, @DefaultValue(value="0") @QueryParam(value="start") Integer var4, @DefaultValue(value="100") @QueryParam(value="count") Integer var5, @DefaultValue(value="") @QueryParam(value="modifiedAfter") String var6, @DefaultValue(value="list") @QueryParam(value="detail") String var7, @DefaultValue(value="lastModified") @QueryParam(value="sort") String var8, @DefaultValue(value="desc") @QueryParam(value="order") String var9, @QueryParam(value="siteId") List<Integer> var10, @QueryParam(value="siteHref") List<String> var11, @QueryParam(value="filter") List<String> var12, @QueryParam(value="partnerId") List<Long> var13, @QueryParam(value="fields") String var14, @QueryParam(value="orFilter") List<String> var15);

    @GET
    @Path(value="/countBySite")
    @Produces(value={"application/json"})
    public Response countBySite(@Context HttpServletRequest var1, @Context Request var2, @HeaderParam(value="Authorization") String var3, @QueryParam(value="partnerId") List<Long> var4, @QueryParam(value="filter") List<String> var5, @QueryParam(value="orFilter") List<String> var6);

    @Path(value="/{id}")
    @DELETE
    @Produces(value={"text/plain"})
    public Response delete(@Context HttpServletRequest var1, @HeaderParam(value="Authorization") String var2, @Context Request var3, @PathParam(value="id") Long var4, @DefaultValue(value="false") @QueryParam(value="retire") Boolean var5);

    @Path(value="/{id}/target")
    @PUT
    public Response targetTitle(@HeaderParam(value="Authorization") String var1, @Context HttpServletRequest var2, @PathParam(value="id") Long var3, @QueryParam(value="siteId") List<Integer> var4);

    @Path(value="/{id}/siteTitles")
    @Produces(value={"application/xml", "application/json"})
    @GET
    public Response getChildTitles(@Context Request var1, @Context HttpServletRequest var2, @HeaderParam(value="Authorization") String var3, @PathParam(value="id") Long var4, @QueryParam(value="type") @DefaultValue(value="distribution") String var5);

    @Path(value="/ingest")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public Response ingest(@Context HttpServletRequest var1, @HeaderParam(value="Authorization") String var2, @QueryParam(value="providerId") String var3, @QueryParam(value="contentClass") String var4);

    @Path(value="/{id}{assetId : (/\\d+)?}/thumbnail")
    @GET
    @Produces(value={"image/*"})
    public Response getThumbnail(@Context HttpServletRequest var1, @PathParam(value="id") long var2, @PathParam(value="assetId") String var4, @QueryParam(value="size") String var5);

    @Path(value="/{id}/{assetId}/file")
    @POST
    @Consumes(value={"multipart/form-data"})
    public Response uploadFile(@Context HttpServletRequest var1, @PathParam(value="id") long var2, @PathParam(value="assetId") long var4, @QueryParam(value="sendEvent") String var6, @MultipartForm MultipartFormDataInput var7) throws JSONException;

    @Path(value="/dueStatusSummary")
    @GET
    @Produces(value={"application/json", "application/xml"})
    public Response getDueStatusSummary(@Context HttpServletRequest var1, @Context Request var2, @QueryParam(value="dueDate") String var3, @QueryParam(value="partnerId") List<Long> var4);

    @PUT
    @Path(value="/{id}/purgesitetitle")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response purgeSiteTitle(@Context HttpServletRequest var1, @Context Request var2, @PathParam(value="id") Long var3);

    @Path(value="/{id}/{assetId}/qcreport")
    @GET
    @Produces(value={"application/xml"})
    public Response getQcReport(@Context HttpServletRequest var1, @HeaderParam(value="Authorization") String var2, @PathParam(value="id") long var3, @PathParam(value="assetId") long var5);

    @GET
    @Path(value="/{id}/workOrders")
    @Produces(value={"application/json", "application/xml"})
    public Response getWorkorders(@Context HttpServletRequest var1, @Context Request var2, @Context UriInfo var3, @PathParam(value="id") long var4, @QueryParam(value="start") @DefaultValue(value="0") int var6, @QueryParam(value="count") @DefaultValue(value="100") int var7);

    @Path(value="/{offerId}/referenced/{titleId}")
    @PUT
    public Response addTitleToOffer(@Context HttpServletRequest var1, @Context Request var2, @HeaderParam(value="Authorization") String var3, @PathParam(value="offerId") Long var4, @PathParam(value="titleId") Long var5);

    @Path(value="/{offerId}/referenced")
    @GET
    @Produces(value={"application/json", "application/xml"})
    public Response getOfferReferencedTitles(@Context HttpServletRequest var1, @Context Request var2, @HeaderParam(value="Authorization") String var3, @PathParam(value="offerId") Long var4);

    @Path(value="/{offerId}/referenced/{titleId}")
    @DELETE
    public Response removeTitleFromOffer(@Context HttpServletRequest var1, @Context Request var2, @HeaderParam(value="Authorization") String var3, @PathParam(value="offerId") Long var4, @PathParam(value="titleId") Long var5);

    @GET
    @Path(value="/savedSearches")
    @Produces(value={"application/xml", "application/json"})
    public Response getSavedSearches(@Context HttpServletRequest var1, @Context Request var2, @HeaderParam(value="Authorization") String var3);

    @GET
    @Path(value="/savedSearches/{searchId}")
    @Produces(value={"application/xml", "application/json"})
    public Response executeSavedSearch(@Context HttpServletRequest var1, @Context Request var2, @HeaderParam(value="Authorization") String var3, @PathParam(value="searchId") Integer var4, @DefaultValue(value="0") @QueryParam(value="start") Integer var5, @DefaultValue(value="100") @QueryParam(value="count") Integer var6, @DefaultValue(value="list") @QueryParam(value="detail") String var7, @QueryParam(value="fields") String var8, @QueryParam(value="sortBy") String var9, @QueryParam(value="order") String var10);

    @Path(value="/{titleId}/status/{status}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateProcessingStatus(@Context HttpServletRequest var1, @Context Request var2, @HeaderParam(value="Authorization") String var3, @PathParam(value="titleId") Long var4, @PathParam(value="status") Integer var5);

    @Path(value="/{titleId}/workorderid/{workOrderId}/eventtype/{eventType}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response notifyDistributionRetry(@Context HttpServletRequest var1, @Context Request var2, @HeaderParam(value="Authorization") String var3, @PathParam(value="titleId") Long var4, @PathParam(value="workOrderId") Long var5, @PathParam(value="eventType") String var6);

    @GET
    @Path(value="/{titleId}/users")
    @Produces(value={"application/xml", "application/json"})
    public Response listUsers(@Context HttpServletRequest var1, @Context Request var2, @HeaderParam(value="Authorization") String var3, @DefaultValue(value="0") @QueryParam(value="start") Integer var4, @DefaultValue(value="100") @QueryParam(value="count") Integer var5, @DefaultValue(value="true") @QueryParam(value="includeSelfPartnerUsers") Boolean var6, @PathParam(value="titleId") Long var7);
}

