/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.titles;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.ParamType;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.ericsson.cms.criteria.SearchColumn;
import com.ericsson.cms.criteria.info.SortOrder;
import com.ericsson.cms.criteria.info.SortingInfo;
import com.ericsson.cms.search.ElasticSearchIndexType;
import com.ericsson.cms.search.IElasticSearchService;
import com.ericsson.cms.search.SearchParameters;
import com.ericsson.cms.search.TitleSearchResult;
import com.ericsson.cms.sites.core.SiteManagementException;
import com.tandbergtv.cms.contentmgmt.service.specification.IAssetSpecificationManager;
import com.tandbergtv.cms.services.titles.FieldAlias;
import com.tandbergtv.cms.services.titles.FieldAliases;
import com.tandbergtv.cms.services.titles.ListDetail;
import com.tandbergtv.cms.services.titles.SearchColumnExt;
import com.tandbergtv.cms.services.util.ConversionUtil;
import com.tandbergtv.metadatamanager.exception.SearchValidationException;
import com.tandbergtv.metadatamanager.search.SearchSchemaHelper;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.web.table.Column;
import com.tandbergtv.workflow.web.table.Table;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.CollectionUtils;

public class SearchHelper {
    private static final String ECMF_SPEC_PREFIX = "/ECMFSpec/";
    private static final int ECMF_SPEC_PREFIX_LEN = "/ECMFSpec/".length();
    private static final String SEARCH_RESULTS_DISPLAY_COL_TABLE = "SearchResultsColumns";
    private static final String VERSION_MINOR_KEY = "versionMinor";
    private static final String VERSION_MAJOR_KEY = "versionMajor";
    private static final String PROVIDER_NAME_KEY = "providerName";
    private static final String REMOVE_CONTENT_ON_DELETE_KEY = "removeContentOnDelete";
    private static final String EXPIRATION_KEY = "expiration";
    private static final String INGEST_TAG_KEY = "ingestTag";
    private static final String ENCRYPT_FILTER_KEY = "encryptFilter";
    private static final String ENCRYPT_KEY = "encrypt";
    private static final String PACKAGE = "PACKAGE";
    private static final String PACKAGE_TITLE = "PACKAGE/TITLE";
    private static final String LIC_WINDOW_END = "/Fields/Rights/LicensingWindowEnd";
    private static final String LIC_WINDOW_START = "/Fields/Rights/LicensingWindowStart";
    private static final String TITLE_NAME = "/Fields/Title/ShortTitle/Value";
    private static final String LAST_MODIFIED_TIME = "lastModifiedTime";
    private static final String TITLE_ID = "id";
    private static final String CREATE_DATE = "createDate";
    private static final String TITLE_STATUS = "status";
    private static final String TITLE_PROCESSING_STATUS = "processingStatus";
    private static final String CONTENT_CLASS = "contentClassId";
    private static final String VERSION_MINOR = "/Fields/Version/Minor";
    private static final String VERSION_MAJOR = "/Fields/Version/Major";
    private static final String PROVIDER_NAME = "/Fields/ProviderInfo/Name";
    private static final String LICENSE_START_KEY = "licenseStart";
    private static final String LICENSE_END_KEY = "licenseEnd";
    private static final String TITLE_NAME_KEY = "titleName";
    private static final String LAST_MODIFIED_KEY = "lastModified";
    private static final String DISTRIBUTION_STATUS = "distributionStatus";
    private static final String DISTRIBUTION_DATE = "distributionDate";
    private static final String RETIREMENT_DATE = "retirementDate";
    private static final String MISSING_CONTENT = "missingContent";
    private static final String SHORT_TITLE = "/PACKAGE/TITLE/Fields/Title/ShortTitle/Value";

    public static List<SearchColumn> buildSearchColumns(ListDetail listDetail, String fields) throws IOException {
        ArrayList<SearchColumn> searchcols = new ArrayList<SearchColumn>();
        switch (listDetail) {
            case list: {
                searchcols.add(new SearchColumnExt(PACKAGE_TITLE, TITLE_NAME, FieldType.ASSET, "string", false, TITLE_NAME_KEY));
                break;
            }
            case searchResults: {
                IAssetSpecificationManager assetSpecManager = (IAssetSpecificationManager)InjectionUtil.injectInstance((String)"cms/AssetSpecificationManager/local", IAssetSpecificationManager.class);
                Table table = assetSpecManager.getTableConfiguration(SEARCH_RESULTS_DISPLAY_COL_TABLE);
                for (Column col : table.getColumns()) {
                    String field;
                    FieldType fieldType;
                    String methodName = col.getMethodName();
                    if (methodName != null && (methodName.equals("quickInfo") || methodName.equals("thumbnail")) || !col.isSelectedByDefault()) continue;
                    String sectionType = null;
                    String display = String.valueOf(col.getColumnName().substring(0, 1).toLowerCase()) + col.getColumnName().substring(1).replace(" ", "");
                    if (col.getTitleSection() != null && !col.getTitleSection().isEmpty()) {
                        fieldType = FieldType.ASSET;
                        sectionType = col.getTitleSection();
                        field = col.getParameter();
                    } else {
                        fieldType = FieldType.PMM_TITLE;
                        field = methodName;
                    }
                    String dataType = SearchHelper.dataTypeLookup(fieldType, sectionType, field);
                    searchcols.add(new SearchColumnExt(sectionType, field, fieldType, dataType, col.isMultiValued(), display));
                }
                break;
            }
            case summary: {
                searchcols.add(new SearchColumnExt(PACKAGE_TITLE, TITLE_NAME, FieldType.ASSET, "string", false, TITLE_NAME_KEY));
                searchcols.add(new SearchColumnExt(null, LAST_MODIFIED_TIME, FieldType.PMM_TITLE, "date", false, LAST_MODIFIED_KEY));
                searchcols.add(new SearchColumnExt(PACKAGE_TITLE, LIC_WINDOW_START, FieldType.ASSET, "date", false, LICENSE_START_KEY));
                searchcols.add(new SearchColumnExt(PACKAGE_TITLE, LIC_WINDOW_END, FieldType.ASSET, "date", false, LICENSE_END_KEY));
                break;
            }
            case distribution: {
                searchcols.add(new SearchColumnExt(null, TITLE_ID, FieldType.PMM_TITLE, "integer", false, TITLE_ID));
                searchcols.add(new SearchColumnExt(PACKAGE, PROVIDER_NAME, FieldType.ASSET, "string", false, PROVIDER_NAME_KEY));
                searchcols.add(new SearchColumnExt(PACKAGE_TITLE, VERSION_MAJOR, FieldType.ASSET, "string", false, VERSION_MAJOR_KEY));
                searchcols.add(new SearchColumnExt(PACKAGE_TITLE, VERSION_MINOR, FieldType.ASSET, "string", false, VERSION_MINOR_KEY));
                searchcols.add(new SearchColumnExt(PACKAGE_TITLE, LIC_WINDOW_START, FieldType.ASSET, "date", false, LICENSE_START_KEY));
                searchcols.add(new SearchColumnExt(PACKAGE_TITLE, LIC_WINDOW_END, FieldType.ASSET, "date", false, LICENSE_END_KEY));
                searchcols.add(new SearchColumnExt(PACKAGE, "/Fields/DistributionInfo/Encrypt", FieldType.ASSET, "boolean", false, ENCRYPT_KEY));
                searchcols.add(new SearchColumnExt(PACKAGE, "/Fields/DistributionInfo/EncryptFilter", FieldType.ASSET, "string", false, ENCRYPT_FILTER_KEY));
                searchcols.add(new SearchColumnExt(PACKAGE, "/Fields/DistributionInfo/IngestTag", FieldType.ASSET, "string", false, INGEST_TAG_KEY));
                searchcols.add(new SearchColumnExt(PACKAGE, "/Fields/DistributionInfo/Expiration", FieldType.ASSET, "date", false, EXPIRATION_KEY));
                searchcols.add(new SearchColumnExt(PACKAGE, "/Fields/DistributionInfo/RemoveContentOnDelete", FieldType.ASSET, "boolean", false, REMOVE_CONTENT_ON_DELETE_KEY));
                break;
            }
            case portal: {
                searchcols.add(new SearchColumnExt(null, TITLE_ID, FieldType.PMM_TITLE, "integer", false, TITLE_ID));
                searchcols.add(new SearchColumnExt(PACKAGE_TITLE, TITLE_NAME, FieldType.ASSET, "string", false, TITLE_NAME_KEY));
                searchcols.add(new SearchColumnExt(PACKAGE_TITLE, LIC_WINDOW_START, FieldType.ASSET, "date", false, LICENSE_START_KEY));
                searchcols.add(new SearchColumnExt(PACKAGE_TITLE, LIC_WINDOW_END, FieldType.ASSET, "date", false, LICENSE_END_KEY));
                searchcols.add(new SearchColumnExt(PACKAGE, PROVIDER_NAME, FieldType.ASSET, "string", false, PROVIDER_NAME_KEY));
                searchcols.add(new SearchColumnExt(null, CREATE_DATE, FieldType.PMM_TITLE, "date", false, CREATE_DATE));
                searchcols.add(new SearchColumnExt(null, LAST_MODIFIED_TIME, FieldType.PMM_TITLE, "date", false, LAST_MODIFIED_KEY));
                searchcols.add(new SearchColumnExt(null, TITLE_STATUS, FieldType.PMM_TITLE, "string", false, TITLE_STATUS));
                searchcols.add(new SearchColumnExt(null, DISTRIBUTION_STATUS, FieldType.PMM_TITLE, "string", false, DISTRIBUTION_STATUS));
                searchcols.add(new SearchColumnExt(null, DISTRIBUTION_DATE, FieldType.PMM_TITLE, "date", false, DISTRIBUTION_DATE));
                searchcols.add(new SearchColumnExt(null, TITLE_PROCESSING_STATUS, FieldType.PMM_TITLE, "string", false, TITLE_PROCESSING_STATUS));
                searchcols.add(new SearchColumnExt(null, MISSING_CONTENT, FieldType.PMM_TITLE, "string", true, MISSING_CONTENT));
                searchcols.add(new SearchColumnExt(null, CONTENT_CLASS, FieldType.PMM_TITLE, "integer", false, CONTENT_CLASS));
                if (StringUtils.isBlank((String)fields)) break;
                SearchHelper.addFields(searchcols, fields.split(","));
            }
        }
        return searchcols;
    }

    private static void addFields(List<SearchColumn> searchcols, String[] fields) throws IOException {
        SearchSchemaHelper ssh = new SearchSchemaHelper();
        FieldAliases aliases = FieldAliases.getInstance();
        int i = 0;
        while (i < fields.length) {
            String field = fields[i];
            if (!field.startsWith(ECMF_SPEC_PREFIX)) {
                if (!aliases.containsAlias(field)) {
                    throw new IllegalArgumentException("Unsupported alias: " + field);
                }
                field = aliases.getFieldAlias(field).getField();
            }
            if (!field.startsWith(ECMF_SPEC_PREFIX)) {
                throw new IllegalArgumentException("Invalid xpath " + field);
            }
            String xpath = field.substring(ECMF_SPEC_PREFIX_LEN);
            int startOfFields = xpath.indexOf("/Fields/");
            if (startOfFields == -1) {
                throw new IllegalArgumentException("Invalid xpath " + field);
            }
            String assetType = xpath.substring(0, startOfFields).toUpperCase();
            String fieldXPath = xpath.substring(startOfFields);
            try {
                ssh.getXpathCardinality(assetType, fieldXPath);
            }
            catch (SearchValidationException searchValidationException) {
                throw new IllegalArgumentException("Invalid xpath " + field);
            }
            String dataType = SearchHelper.dataTypeLookup(FieldType.ASSET, "", fieldXPath);
            if (StringUtils.isBlank((String)dataType)) {
                throw new IllegalArgumentException("Invalid xpath " + field);
            }
            searchcols.add(new SearchColumnExt(assetType, fieldXPath, FieldType.ASSET, dataType, false, field));
            ++i;
        }
    }

    public static String dataTypeLookup(FieldType type, String assetPath, String xpath) {
        if (type.equals((Object)FieldType.ASSET)) {
            DataTypeMappingReader dtr = DataTypeMappingReader.getInstance();
            return dtr.determineDataType(xpath);
        }
        if (type.equals((Object)FieldType.PMM_TITLE)) {
            if (xpath.equalsIgnoreCase(TITLE_ID)) {
                return "integer";
            }
            if (xpath.equalsIgnoreCase(TITLE_STATUS)) {
                return "string";
            }
            if (xpath.equalsIgnoreCase(TITLE_PROCESSING_STATUS)) {
                return "string";
            }
            if (xpath.equalsIgnoreCase(CONTENT_CLASS)) {
                return "integer";
            }
            if (xpath.equalsIgnoreCase(CREATE_DATE)) {
                return "date";
            }
            if (xpath.equalsIgnoreCase(RETIREMENT_DATE)) {
                return "date";
            }
            if (xpath.equalsIgnoreCase(DISTRIBUTION_DATE)) {
                return "date";
            }
        }
        return "string";
    }

    public static SortingInfo buildSortInfo(String sort, SortOrder sortOrder) {
        SortingInfo sortingInfo = null;
        FieldAliases aliases = FieldAliases.getInstance();
        if (sort.startsWith(ECMF_SPEC_PREFIX)) {
            sortingInfo = SearchHelper.buildSortingInfoFromECMFXPath(sort, sortOrder);
        } else if (aliases.containsAlias(sort)) {
            FieldAlias alias = aliases.getFieldAlias(sort);
            sortingInfo = new SortingInfo(alias.getField(), sortOrder, alias.getAssetType(), alias.getFieldType());
        } else {
            throw new IllegalArgumentException("Invalid sort option " + sort);
        }
        return sortingInfo;
    }

    private static SortingInfo buildSortingInfoFromECMFXPath(String ecmfXpath, SortOrder sortOrder) {
        SearchSchemaHelper ssh = new SearchSchemaHelper();
        String xpath = ecmfXpath.substring(ECMF_SPEC_PREFIX_LEN);
        int startOfFields = xpath.indexOf("/Fields/");
        if (startOfFields == -1) {
            throw new IllegalArgumentException("Invalid xpath " + ecmfXpath);
        }
        String assetType = xpath.substring(0, startOfFields).toUpperCase();
        String fieldItem = xpath.substring(startOfFields);
        try {
            ssh.getXpathCardinality(assetType, fieldItem);
        }
        catch (SearchValidationException searchValidationException) {
            throw new IllegalArgumentException("Invalid xpath " + ecmfXpath);
        }
        return new SortingInfo(fieldItem, sortOrder, assetType, FieldType.ASSET);
    }

    public static ExpList filterItems(List<String> filters, String modifiedAfter) throws IOException {
        return SearchHelper.filterItems(filters, modifiedAfter, "AND");
    }

    public static ExpList filterItems(List<String> filters, String modifiedAfter, String logical) throws IOException {
        if ((modifiedAfter == null || modifiedAfter.isEmpty()) && (filters == null || filters.isEmpty())) {
            return null;
        }
        ExpList list = new ExpList(logical);
        if (modifiedAfter != null && !modifiedAfter.isEmpty()) {
            PredicateRightValue prv = new PredicateRightValue(LAST_MODIFIED_TIME, "", FieldType.PMM_TITLE, Arrays.asList(modifiedAfter), LogicalOperator.GREATERTHAN, Boolean.valueOf(false));
            prv.setDataType("date");
            list.addItem((ExpNode)new ExpValue((Predicate)prv));
        }
        if (filters == null && list.isEmpty()) {
            return null;
        }
        if (filters == null) {
            return list;
        }
        for (String filter : filters) {
            String fieldLeft;
            String fieldLeftSectionType;
            FieldType fieldType;
            LogicalOperator operator;
            int fieldEnd = filter.indexOf(":");
            int operatorEnd = filter.indexOf(":", fieldEnd + 1);
            if (fieldEnd < 1) {
                throw new IllegalArgumentException("Invalid condition string: " + filter);
            }
            String lhs = filter.substring(0, fieldEnd);
            String value = null;
            if (operatorEnd < 0) {
                operator = LogicalOperator.lookUp((String)filter.substring(fieldEnd + 1));
            } else {
                operator = LogicalOperator.lookUp((String)filter.substring(fieldEnd + 1, operatorEnd));
                if (operatorEnd < filter.length()) {
                    value = filter.substring(operatorEnd + 1, filter.length());
                }
            }
            SearchSchemaHelper ssh = new SearchSchemaHelper();
            if (lhs.startsWith(ECMF_SPEC_PREFIX)) {
                fieldType = FieldType.ASSET;
                String xpath = lhs.substring(ECMF_SPEC_PREFIX.length());
                int startOfFields = xpath.indexOf("/Fields/");
                fieldLeftSectionType = xpath.substring(0, startOfFields).toUpperCase();
                fieldLeft = xpath.substring(startOfFields);
                try {
                    ssh.getXpathCardinality(fieldLeftSectionType, fieldLeft);
                }
                catch (SearchValidationException searchValidationException) {
                    throw new IllegalArgumentException("Invalid xpath " + lhs);
                }
            } else {
                FieldAliases aliases = FieldAliases.getInstance();
                if (!aliases.containsAlias(lhs)) {
                    throw new IllegalArgumentException("Unsupported alias: " + lhs);
                }
                FieldAlias fieldAlias = aliases.getFieldAlias(lhs);
                fieldType = fieldAlias.getFieldType();
                fieldLeftSectionType = StringUtils.upperCase((String)fieldAlias.getAssetType());
                fieldLeft = fieldAlias.getField();
            }
            String dataType = SearchHelper.dataTypeLookup(fieldType, "", fieldLeft);
            if (!operator.getParamType().equals((Object)ParamType.NONE) && value == null) {
                throw new IllegalArgumentException("Invalid condition string: " + filter);
            }
            if (!operator.getParamType().equals((Object)ParamType.NONE)) {
                List<String> values = Arrays.asList(value);
                if (LogicalOperator.NOTEQUAL.equals((Object)operator)) {
                    list.addItem((ExpNode)new ExpValue((Predicate)new PredicateRightValue(fieldLeft, fieldLeftSectionType, fieldType, values, LogicalOperator.EQUAL, dataType, Boolean.valueOf(true))));
                    continue;
                }
                list.addItem((ExpNode)new ExpValue((Predicate)new PredicateRightValue(fieldLeft, fieldLeftSectionType, fieldType, values, operator, dataType, Boolean.valueOf(false))));
                continue;
            }
            list.addItem((ExpNode)new ExpValue(new Predicate(fieldLeft, fieldLeftSectionType, fieldType, operator, dataType, Boolean.valueOf(false))));
        }
        return list;
    }

    public static ExpList joinFilters(ExpList first, ExpList second) {
        if (second == null) {
            return first;
        }
        if (first == null) {
            return second;
        }
        first.addItem((ExpNode)second);
        return first;
    }

    public static List<TitleSearchResult.SearchRow> getReferencedTitlesForOffer(Title offer) {
        IElasticSearchService service = (IElasticSearchService)ServiceRegistry.getDefault().lookup(IElasticSearchService.class);
        SearchParameters params = new SearchParameters();
        params.setPageSize(1000);
        params.setFields(Arrays.asList(new SearchParameters.FieldInfo(TITLE_ID, "long"), new SearchParameters.FieldInfo(SHORT_TITLE, "string")));
        PredicateRightValue predicate = new PredicateRightValue();
        predicate.setFieldLeft(TITLE_ID);
        predicate.setDataType("long");
        if (offer.getOriginalId() != null) {
            predicate.setFieldTypeLhs(FieldType.SITE);
            params.setTitleIndexType(ElasticSearchIndexType.SITE);
        } else {
            predicate.setFieldTypeLhs(FieldType.PMM_TITLE);
            params.setTitleIndexType(ElasticSearchIndexType.MASTER);
        }
        ArrayList<String> offerTitleValue = new ArrayList<String>();
        HashSet<Long> referencedTitleIds = new HashSet<Long>(ConversionUtil.getReferencedTitles(offer));
        if (CollectionUtils.isEmpty(referencedTitleIds)) {
            return new ArrayList<TitleSearchResult.SearchRow>();
        }
        for (Long refTitleId : referencedTitleIds) {
            offerTitleValue.add(refTitleId.toString());
        }
        predicate.setOperator(LogicalOperator.IN);
        predicate.setValue(offerTitleValue);
        ExpList rootNode = new ExpList();
        ExpValue valNode = new ExpValue((Predicate)predicate);
        rootNode.addItem((ExpNode)valNode);
        TitleSearchResult esResult = null;
        try {
            esResult = service.advancedSearch((ExpNode)rootNode, params);
        }
        catch (Exception e) {
            throw new SiteManagementException((Throwable)e);
        }
        return esResult.getRows();
    }
}

