/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.titles;

import com.tandbergtv.cms.services.titles.ImageUtil;
import com.tandbergtv.cms.services.titles.ThumbnailMd5Util;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleAssetProperty;
import com.tandbergtv.watchpoint.pmm.title.ITitleAssetPropertyManager;
import com.tandbergtv.watchpoint.pmm.title.ITitleAssetResourceManager;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ServiceThumbnailHandler {
    private static final String POSTER_ASSET_TYPE = "POSTER";
    private static final String BOX_COVER_ASSET_TYPE = "BOXCOVER";
    private static final Logger logger = Logger.getLogger(ServiceThumbnailHandler.class);
    private ITitleAssetResourceManager titleAssetSourceManager = (ITitleAssetResourceManager)ServiceRegistry.getDefault().lookup(ITitleAssetResourceManager.class);
    private ITitleAssetPropertyManager titleAssetPropertyManager = (ITitleAssetPropertyManager)ServiceRegistry.getDefault().lookup(ITitleAssetPropertyManager.class);
    private ITitleManager titleManager = (ITitleManager)ServiceRegistry.getDefault().lookup(ITitleManager.class);
    private final long titleId;
    private final String size;
    private Long inputAssetId;

    public ServiceThumbnailHandler(long titleId, String assetIdStr, String size) {
        this.titleId = titleId;
        this.inputAssetId = this.parseAssetId(assetIdStr);
        this.size = size;
    }

    public File getResizeImageFile() throws IOException {
        boolean isPosterOrBoxCoverAssetType;
        Long assetId = this.inputAssetId;
        String originFilename = null;
        if (assetId != null) {
            originFilename = this.getOriginalPosterFilePath(this.titleId, assetId);
        } else {
            assetId = this.findAssetId(POSTER_ASSET_TYPE);
            originFilename = this.getOriginalPosterFilePath(this.titleId, assetId);
            if (StringUtils.isBlank((String)originFilename)) {
                assetId = this.findAssetId(BOX_COVER_ASSET_TYPE);
                originFilename = this.getOriginalPosterFilePath(this.titleId, assetId);
            }
        }
        if (assetId == null || StringUtils.isBlank((String)originFilename)) {
            return null;
        }
        String assetTyle = this.getAssetType(assetId);
        boolean bl = isPosterOrBoxCoverAssetType = POSTER_ASSET_TYPE.equalsIgnoreCase(assetTyle) || BOX_COVER_ASSET_TYPE.equalsIgnoreCase(assetTyle);
        if (assetTyle == null || !isPosterOrBoxCoverAssetType) {
            return null;
        }
        ImageUtil imageUtil = new ImageUtil(this.size, originFilename);
        if (!imageUtil.isCanReadImage()) {
            return null;
        }
        ThumbnailMd5Util md5Util = new ThumbnailMd5Util(originFilename, imageUtil.getStoredOriginMd5FilePath());
        File resizedImageFile = new File(imageUtil.getResizedImageFilePath());
        if (md5Util.isEqual() && resizedImageFile.isFile()) {
            logger.debug((Object)"Use cached resized image file.");
            return resizedImageFile;
        }
        logger.debug((Object)"Generating cached resized image file.");
        md5Util.save();
        resizedImageFile = imageUtil.generateResizedFile();
        if (resizedImageFile != null) {
            this.titleAssetSourceManager.registerThumbnail(this.titleId, assetId.longValue(), assetTyle, resizedImageFile.getPath());
        }
        return resizedImageFile;
    }

    private String getAssetType(Long assetId) {
        List assetProperties = this.titleAssetPropertyManager.getByTitleAsset(this.titleId, assetId.longValue());
        if (assetProperties.size() == 0) {
            return null;
        }
        return ((TitleAssetProperty)assetProperties.get(0)).getAssetType();
    }

    private Long findAssetId(String assetTyle) {
        Long assetId = null;
        List assetProperties = this.titleAssetPropertyManager.getByTitle(this.titleId);
        for (TitleAssetProperty assetProperty : assetProperties) {
            if (!assetTyle.equalsIgnoreCase(assetProperty.getAssetType())) continue;
            assetId = assetProperty.getAssetId();
            break;
        }
        return assetId;
    }

    private String getOriginalPosterFilePath(long titleId, Long assetId) {
        File originFile;
        Title title = this.titleManager.get(Long.valueOf(titleId));
        Asset asset = null;
        try {
            asset = title.getAsset(assetId.longValue());
        }
        catch (Exception exception) {
            return null;
        }
        if (asset == null) {
            return null;
        }
        String filename = null;
        for (com.tandbergtv.metadatamanager.model.File file : asset.getDirectDescendantFiles()) {
            if (!file.isOriginal()) continue;
            filename = file.getURL();
            break;
        }
        if (filename != null && !(originFile = new File(filename)).isFile()) {
            return null;
        }
        return filename;
    }

    private Long parseAssetId(String assetIdStr) {
        if (StringUtils.isBlank((String)assetIdStr)) {
            return null;
        }
        String[] assets = assetIdStr.split("/");
        if (assets.length != 2) {
            return null;
        }
        return Long.parseLong(assets[1]);
    }
}

