/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.titles;

import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.SearchColumn;
import com.ericsson.cms.criteria.info.InvalidSortException;
import com.ericsson.cms.criteria.info.PagingInfo;
import com.ericsson.cms.criteria.info.SortOrder;
import com.ericsson.cms.criteria.info.SortingInfo;
import com.tandbergtv.cms.services.titles.ListDetail;
import com.tandbergtv.cms.services.titles.ResponseUtil;
import com.tandbergtv.cms.services.titles.SearchColumnExt;
import com.tandbergtv.cms.services.titles.SearchHelper;
import com.tandbergtv.cms.title.search.entities.UnauthorizedUserException;
import com.tandbergtv.cms.util.PartnerUtils;
import com.tandbergtv.cms.util.ResponseTypeUtilities;
import com.tandbergtv.metadatamanager.util.DateParseException;
import com.tandbergtv.metadatamanager.util.DateUtil;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;

public class TitleListParameterBuilder {
    private static final String TITLE_VIEW = "AssetManagement_View";
    private static final String ECMF_DOC = "doc";
    private Response errorResponse;
    private List<Long> partnerIds;
    private List<Integer> siteIds;
    private ListDetail listDetail;
    private PagingInfo pagingInfo;
    private SortingInfo sortInfo;
    private MediaType mediaType;

    public Response getErrorResponse() {
        return this.errorResponse;
    }

    public List<Long> getPartnerIds() {
        return this.partnerIds;
    }

    public List<Integer> getSiteIds() {
        return this.siteIds;
    }

    public ListDetail getListDetail() {
        return this.listDetail;
    }

    public PagingInfo getPagingInfo() {
        return this.pagingInfo;
    }

    public SortingInfo getSortInfo() {
        return this.sortInfo;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public boolean setPartnerIds(List<Long> partnerIds) {
        try {
            this.partnerIds = PartnerUtils.getAuthorizedPartnerIds(partnerIds);
            return true;
        }
        catch (UnauthorizedUserException ex) {
            this.errorResponse = ResponseUtil.createUnauthorizedResponse(ex.getMessage());
            return false;
        }
    }

    public boolean setDetailAndPageInfo(String detail, Integer start, Integer count) {
        try {
            this.listDetail = ListDetail.valueOf(detail);
        }
        catch (Exception exception) {
            this.errorResponse = ResponseUtil.createBadRequestResponse("Invalid detail value: " + detail);
            return false;
        }
        if (start < 0) {
            this.errorResponse = ResponseUtil.createBadRequestResponse("The start can't be less than 0.");
            return false;
        }
        if (count < 1) {
            this.errorResponse = ResponseUtil.createBadRequestResponse("The count can't be less than 1 and greater than 100.");
            return false;
        }
        if (this.listDetail.equals((Object)ListDetail.full) && count > 10) {
            count = 10;
        } else if (count > 100) {
            count = 100;
        }
        this.pagingInfo = new PagingInfo(start.intValue(), count.intValue());
        return true;
    }

    public boolean setSiteIds(List<Integer> siteIds, List<String> siteHrefs) {
        if (siteIds != null && !siteIds.isEmpty() && siteHrefs != null && !siteHrefs.isEmpty()) {
            this.errorResponse = ResponseUtil.createBadRequestResponse("Please provide either siteIds or siteHrefs, not both.");
            return false;
        }
        if (siteIds != null && !siteIds.isEmpty()) {
            this.siteIds = siteIds;
        }
        if (siteHrefs != null && !siteHrefs.isEmpty()) {
            siteIds = new ArrayList<Integer>();
            for (String href : siteHrefs) {
                String[] split = href.split(".+/services/sites/");
                try {
                    siteIds.add(Integer.parseInt(split[1]));
                    this.siteIds = siteIds;
                }
                catch (Exception exception) {
                    this.errorResponse = ResponseUtil.createBadRequestResponse("Error parsing siteHref: " + href);
                    return false;
                }
            }
        }
        return true;
    }

    public boolean setModifiedAfter(String modifiedAfter) {
        if (modifiedAfter != null && !modifiedAfter.isEmpty()) {
            try {
                DateUtil.convertDate((String)modifiedAfter);
            }
            catch (DateParseException dateParseException) {
                String msg = "Could not parse date \"" + modifiedAfter + "\". Date should be in format yyyy-MM-dd'T'HH:mm:ss";
                this.errorResponse = ResponseUtil.createBadRequestResponse(msg);
                return false;
            }
        }
        return true;
    }

    public boolean setSortInfo(String sort, String order) {
        SortOrder sortOrder;
        try {
            sortOrder = SortOrder.lookup((String)order);
        }
        catch (InvalidSortException invalidSortException) {
            this.errorResponse = ResponseUtil.createBadRequestResponse("Invalid sort order: " + order);
            return false;
        }
        try {
            this.sortInfo = SearchHelper.buildSortInfo(sort, sortOrder);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.errorResponse = ResponseUtil.createBadRequestResponse("Invalid sort value: " + sort);
            return false;
        }
        return true;
    }

    public boolean setMediaType(Request rsRequest) {
        this.mediaType = ResponseTypeUtilities.getMediaTypeFromRequest(rsRequest);
        return true;
    }

    public List<SearchColumn> buildSearchColumns(String fields) {
        List<SearchColumn> searchColumns;
        if (this.listDetail == ListDetail.full) {
            if (this.mediaType.equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
                this.errorResponse = ResponseUtil.createBadRequestResponse("JSON not supported for full");
                return null;
            }
            searchColumns = new ArrayList<SearchColumn>();
            searchColumns.add(new SearchColumnExt(null, ECMF_DOC, FieldType.PMM_TITLE, "", false, "metadata"));
        } else {
            try {
                searchColumns = SearchHelper.buildSearchColumns(this.listDetail, fields);
            }
            catch (Exception ex) {
                this.errorResponse = ResponseUtil.createBadRequestResponse(ex.getMessage());
                return null;
            }
        }
        return searchColumns;
    }
}

