/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.titles;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.ericsson.cms.criteria.SearchColumn;
import com.ericsson.cms.criteria.info.SortOrder;
import com.ericsson.cms.criteria.info.SortingInfo;
import com.ericsson.cms.search.IElasticSearchService;
import com.ericsson.cms.search.SearchParameters;
import com.ericsson.cms.search.SearchParametersBuilder;
import com.ericsson.cms.search.TitleSearchResult;
import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.ISiteTitleManager;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.DistributionSiteTitle;
import com.ericsson.cms.sites.core.entities.DistributionStatus;
import com.ericsson.cms.sites.core.entities.SiteType;
import com.ericsson.cms.sites.core.entities.TrackingSiteTitle;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.cms.services.AuthorizationException;
import com.tandbergtv.cms.services.RESTAuthentication;
import com.tandbergtv.cms.services.data.CMSTitle;
import com.tandbergtv.cms.services.data.Site;
import com.tandbergtv.cms.services.data.TrackingSite;
import com.tandbergtv.cms.services.exception.NotFoundException;
import com.tandbergtv.cms.services.titles.ExpListBuilder;
import com.tandbergtv.cms.services.titles.FileUploadUtil;
import com.tandbergtv.cms.services.titles.HrefHelper;
import com.tandbergtv.cms.services.titles.ITitleServiceNG;
import com.tandbergtv.cms.services.titles.JsonMarshaller;
import com.tandbergtv.cms.services.titles.JsonResponseBuilder;
import com.tandbergtv.cms.services.titles.ResponseUtil;
import com.tandbergtv.cms.services.titles.SearchColumnExt;
import com.tandbergtv.cms.services.titles.SearchHelper;
import com.tandbergtv.cms.services.titles.ServiceThumbnailHandler;
import com.tandbergtv.cms.services.titles.TitleListParameterBuilder;
import com.tandbergtv.cms.services.titles.TitleUtil;
import com.tandbergtv.cms.services.titles.XmlMarshaller;
import com.tandbergtv.cms.services.titles.XmlUtil;
import com.tandbergtv.cms.services.util.ConversionUtil;
import com.tandbergtv.cms.services.util.PaginableUrlBuilder;
import com.tandbergtv.cms.title.search.ITitleSearchPersistenceService;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.cms.title.search.entities.TitleSearch;
import com.tandbergtv.cms.title.search.entities.UnauthorizedUserException;
import com.tandbergtv.cms.titlefilter.CriteriaMode;
import com.tandbergtv.cms.titlefilter.TitleFilter;
import com.tandbergtv.cms.util.EndpointsAuthorizationUtil;
import com.tandbergtv.cms.util.PartnerUtils;
import com.tandbergtv.cms.util.ResponseTypeUtilities;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.marvin.udt.TreEvent;
import com.tandbergtv.metadatamanager.exception.TranslationException;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.util.binder.ECMFDocToAssetConverter;
import com.tandbergtv.neptune.authorization.service.IAuthorizationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.core.IPMMUIService;
import com.tandbergtv.watchpoint.pmm.core.ITitleStatusService;
import com.tandbergtv.watchpoint.pmm.core.PMMException;
import com.tandbergtv.watchpoint.pmm.core.TitlePersistenceException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.entities.ISavedTitle;
import com.tandbergtv.watchpoint.pmm.entities.ITitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.PartnerUser;
import com.tandbergtv.watchpoint.pmm.entities.SaveResult;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.TitleDistributionStatus;
import com.tandbergtv.watchpoint.pmm.entities.TitleProcessingStatus;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerUserManager;
import com.tandbergtv.watchpoint.pmm.title.ITitleFileManager;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.TitleFileRequest;
import com.tandbergtv.watchpoint.pmm.title.TitleOperationTypeEnum;
import com.tandbergtv.watchpoint.pmm.title.TitleSearchNotFoundException;
import com.tandbergtv.watchpoint.pmm.title.TitleStatusService;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.pmm.title.ingest.ITitleIngestService;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleIngestException;
import com.tandbergtv.watchpoint.pmm.title.license.LicenseFilter;
import com.tandbergtv.watchpoint.pmm.title.license.LicenseManager;
import com.tandbergtv.watchpoint.pmm.util.NormalizedItem;
import com.tandbergtv.watchpoint.pmm.util.ProcessingStatusUpdater;
import com.tandbergtv.workflow.api.API;
import com.tandbergtv.workflow.api.Processes;
import com.tandbergtv.workflow.api.model.process.ProcessListResponse;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.ejb.EJBAccessException;
import javax.ejb.EJBException;
import javax.naming.InitialContext;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.TransactionManager;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;
import org.springframework.util.CollectionUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TitleServiceNG
implements ITitleServiceNG {
    @Context
    private UriInfo uri;
    private static final Logger logger = Logger.getLogger(TitleServiceNG.class);
    private static final SimpleDateFormat webDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
    private static final String LIC_WINDOW_START = "/Fields/Rights/LicensingWindowStart";
    private static final String PACKAGE_TITLE = "PACKAGE/TITLE";
    public static final String TITLE_VIEW = "AssetManagement_View";
    public static final String TITLE_CREATE = "AssetManagement_Create";
    public static final String TITLE_MODIFY = "AssetManagement_Modify";
    private static final String TITLE_DELETE = "AssetManagement_Delete";
    private static final String SITES_VIEW = "Sites_View";
    private static final String SITE_TARGET = "Sites_Target";
    public static final String WORKORDER_VIEW = "WorkOrderManagement_View";
    private static final String NO_CACHE = "NO-CACHE";
    private static final String LATEST_HISTORICAL_ASSET_FILE_IDS_PROPERTY = "LATEST_HISTORICAL_ASSET_FILE_IDS_PROPERTY";
    private static final String LAST_MODIFIED = "Last-Modified";
    private static final String CACHE_CONTROL = "Cache-Control";
    private static final String MISSING_CONTENT = "missingContent";
    private static final String ERROR_HAPPENED = "error happened";
    private static final String CONTENT_MANAGEMENT = "Content Management";
    private static final String LOCATION = "Location";
    private static final String UNABLE_TO_PARSE_REQUEST_BODY = "Unable to parse request body as xml.";
    private static final String ERROR = "Error";
    private static final String TITLE_ID_IS_NULL = "Title id is null.";
    private static final String TITLE_ID_IS_ZERO_OR_NEGATIVE = "Title id is 0 or negative.";
    private JsonMarshaller jsonMarshaller = new JsonMarshaller();
    private XmlMarshaller xmlMarshaller = new XmlMarshaller();
    private ISiteManager siteManager;
    private ISiteTitleManager siteTitleManager;
    private ITitleSearchService searchService;
    private ITitleManager titleManager;
    private ITitleFileManager titleFileManager;
    private ITitleIngestService titleIngestServiceInstance = (ITitleIngestService)ServiceRegistry.getDefault().lookup(ITitleIngestService.class);
    private ISpecificationManager specManager = (ISpecificationManager)ServiceRegistry.getDefault().lookup(ISpecificationManager.class);
    private IPartnerManagement partnerManagement = (IPartnerManagement)ServiceRegistry.getDefault().lookup(IPartnerManagement.class);
    private IContentClassService contentClassService = (IContentClassService)ServiceRegistry.getDefault().lookup(IContentClassService.class);
    private IElasticSearchService elasticSearchService = (IElasticSearchService)ServiceRegistry.getDefault().lookup(IElasticSearchService.class);
    private ITitleSearchPersistenceService titleSearchService = (ITitleSearchPersistenceService)ServiceRegistry.getDefault().lookup(ITitleSearchPersistenceService.class);
    private IPMMUIService pmmUIService = (IPMMUIService)ServiceRegistry.getDefault().lookup(IPMMUIService.class);
    private ITitleStatusService statusService = new TitleStatusService();
    private IPartnerUserManager partnerService;
    private IAuthorizationService authorizationService;
    private ECMFDocToAssetConverter binder = new ECMFDocToAssetConverter();
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ Annotation ajc$anno$5;

    private ISiteManager getSiteManager() {
        if (this.siteManager == null) {
            this.siteManager = (ISiteManager)InjectionUtil.injectInstance((String)"cms/SiteManager/local", ISiteManager.class);
        }
        return this.siteManager;
    }

    private ISiteTitleManager getSiteTitleManager() {
        if (this.siteTitleManager == null) {
            this.siteTitleManager = (ISiteTitleManager)InjectionUtil.injectInstance((String)"cms/SiteTitleManager/local", ISiteTitleManager.class);
        }
        return this.siteTitleManager;
    }

    private ITitleSearchService getTitleSearchService() {
        if (this.searchService == null) {
            this.searchService = (ITitleSearchService)InjectionUtil.injectInstance((String)"cms/TitleSearchServiceProxy/local", ITitleSearchService.class);
        }
        return this.searchService;
    }

    private ITitleManager getTitleManager() {
        if (this.titleManager == null) {
            this.titleManager = (ITitleManager)InjectionUtil.injectInstance((String)"cms/TitleManagerProxy/local", ITitleManager.class);
        }
        return this.titleManager;
    }

    private ITitleFileManager getTitleFileManager() {
        if (this.titleFileManager == null) {
            this.titleFileManager = (ITitleFileManager)InjectionUtil.injectInstance((String)"cms/TitleFileManagerProxy/local", ITitleFileManager.class);
        }
        return this.titleFileManager;
    }

    private IPartnerUserManager getPartnerService() {
        if (this.partnerService == null) {
            this.partnerService = (IPartnerUserManager)InjectionUtil.injectInstance((String)"cms/PartnerUserManager/local", IPartnerUserManager.class);
        }
        return this.partnerService;
    }

    private IAuthorizationService getAuthorizationService() {
        if (this.authorizationService == null) {
            this.authorizationService = (IAuthorizationService)InjectionUtil.injectInstance((String)"cms/AuthorizationService/local", IAuthorizationService.class);
        }
        return this.authorizationService;
    }

    @Override
    public Response getTitle(String authorizationHeader, Request request, HttpServletRequest servletReq, Long titleId, String specification) {
        try {
            Response.ResponseBuilder builder = null;
            builder = EndpointsAuthorizationUtil.authorizePermissions(servletReq, builder, TITLE_VIEW);
            if (builder != null) {
                return builder.build();
            }
            if ("ECMF".equalsIgnoreCase(specification)) {
                specification = "TTV";
            }
            if (!this.getTitleManager().isActive(titleId)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).header(CACHE_CONTROL, (Object)NO_CACHE).type("text/plain").build();
            }
            Specification spec = this.specManager.getInternalSpecification().getAlias().equals(specification) ? this.specManager.getInternalSpecification() : this.specManager.getSpecificationByAlias(specification);
            if (spec == null) {
                return ResponseUtil.createBadRequestResponse("Unsupported spec: " + specification);
            }
            Title title = this.getTitleManager().get(titleId);
            Document document = XmlUtil.convertTitle(spec, servletReq, title, null);
            if ("TTV".equals(specification)) {
                Node metadataNode = document.getElementsByTagName("metadata").item(0);
                this.addMissingContent(title, document, metadataNode);
                if (title.getOriginalId() != null) {
                    TitleServiceNG.addMasterTitleHref(servletReq, title, document, metadataNode);
                    this.addSiteInfo(servletReq, title, document, metadataNode);
                    this.addDistributionStatus(title, document, metadataNode);
                }
            }
            if (!PartnerUtils.checkAuthorization(title.getPartnerId())) {
                return ResponseUtil.createUnauthorizedResponse();
            }
            builder = request.evaluatePreconditions(title.getLastModifiedTime());
            if (builder != null) {
                return Response.status((Response.Status)Response.Status.NOT_MODIFIED).header(CACHE_CONTROL, (Object)NO_CACHE).build();
            }
            String docContents = XmlUtil.getDocumentContents(document);
            webDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            return Response.status((Response.Status)Response.Status.OK).header(LAST_MODIFIED, (Object)webDateFormat.format(title.getLastModifiedTime())).header(CACHE_CONTROL, (Object)NO_CACHE).entity((Object)docContents).header("ETag", (Object)title.getLastModifiedTime().getTime()).build();
        }
        catch (AuthorizationException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (EJBAccessException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (TranslationException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createBadRequestResponse(ex.getMessage());
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return ResponseUtil.createInternalServerErrorResponse(ex.getMessage());
        }
    }

    private void addMissingContent(Title title, Document document, Node metadataNode) throws Exception {
        List<String> missingContent;
        ExpListBuilder expListBuilder = new ExpListBuilder();
        expListBuilder.setAndFilters(Arrays.asList("id:EQUAL:" + title.getId()));
        ExpList rootNode = expListBuilder.build();
        ArrayList<SearchColumnExt> searchcols = new ArrayList<SearchColumnExt>();
        searchcols.add(new SearchColumnExt(null, MISSING_CONTENT, FieldType.PMM_TITLE, "string", true, MISSING_CONTENT));
        SearchParametersBuilder bld = new SearchParametersBuilder();
        if (title.getOriginalId() != null) {
            bld.setCriteriaMode(CriteriaMode.SITE);
        } else {
            bld.setCriteriaMode(CriteriaMode.MASTER);
        }
        bld.setSearchColumns(searchcols);
        SearchParameters params = bld.build();
        TitleSearchResult result = this.elasticSearchService.advancedSearch((ExpNode)rootNode, params);
        if (result.getCount() > 0L) {
            Object value = result.getRow(title.getId().longValue()).getValue(0);
            if (value instanceof List) {
                missingContent = (List)value;
            } else if (value instanceof String) {
                missingContent = new ArrayList();
                if (!"".equals(((String)value).trim())) {
                    missingContent.add((String)value);
                }
            } else {
                missingContent = new ArrayList();
            }
        } else {
            missingContent = new ArrayList();
        }
        for (String item : missingContent) {
            Element missingContentNode = document.createElement(MISSING_CONTENT);
            missingContentNode.setTextContent(item);
            metadataNode.getParentNode().insertBefore(missingContentNode, metadataNode);
        }
    }

    private void addDistributionStatus(Title title, Document document, Node metadataNode) {
        DistributionSiteTitle distSiteTitle = this.getSiteManager().getDistributionSiteTitle(title.getId().longValue());
        Element distributionStatus = document.createElement("distributionStatus");
        distributionStatus.setTextContent(distSiteTitle.getStatus().name());
        metadataNode.getParentNode().insertBefore(distributionStatus, metadataNode);
    }

    private void addSiteInfo(HttpServletRequest servletReq, Title title, Document document, Node metadataNode) {
        DistributionSiteTitle distTitle = this.getSiteManager().getDistributionSiteTitle(title.getId().longValue());
        DistributionSite distSite = this.getSiteManager().getAssociatedDistributionSite(distTitle.getTitle().getId().longValue());
        Element siteHref = document.createElement("siteHref");
        Element siteName = document.createElement("siteName");
        siteHref.setTextContent(HrefHelper.buildSiteHref(distSite.getId(), servletReq));
        siteName.setTextContent(distSite.getName());
        metadataNode.getParentNode().insertBefore(siteHref, metadataNode);
        metadataNode.getParentNode().insertBefore(siteName, metadataNode);
    }

    private static void addMasterTitleHref(HttpServletRequest servletReq, Title title, Document document, Node metadataNode) {
        Element masterTitleHref = document.createElement("masterTitleHref");
        masterTitleHref.setTextContent(HrefHelper.buildGetHref(servletReq, title.getOriginalId()));
        metadataNode.getParentNode().insertBefore(masterTitleHref, metadataNode);
    }

    private String getCurrentUser() {
        return this.getAuthorizationService().getUserName();
    }

    @Override
    public Response list(HttpServletRequest httpRequest, Request rsRequest, String authorizationHeader, Integer start, Integer count, String modifiedAfter, String detail, String sort, String order, List<Integer> siteIds, List<String> siteHrefs, List<String> filters, List<Long> partners, String fields, List<String> orFilters) {
        Response.ResponseBuilder builder = null;
        if ((builder = EndpointsAuthorizationUtil.authorizePermissions(httpRequest, builder, TITLE_VIEW)) != null) {
            return builder.build();
        }
        TitleListParameterBuilder paramBld = new TitleListParameterBuilder();
        if (!paramBld.setPartnerIds(partners)) {
            return paramBld.getErrorResponse();
        }
        try {
            ExpList rootNode;
            if (!paramBld.setDetailAndPageInfo(detail, start, count)) {
                return paramBld.getErrorResponse();
            }
            if (!paramBld.setSiteIds(siteIds, siteHrefs)) {
                return paramBld.getErrorResponse();
            }
            if (!paramBld.setModifiedAfter(modifiedAfter)) {
                return paramBld.getErrorResponse();
            }
            if (!paramBld.setSortInfo(sort, order)) {
                return paramBld.getErrorResponse();
            }
            paramBld.setMediaType(rsRequest);
            ArrayList<com.ericsson.cms.sites.core.entities.Site> sites = new ArrayList<com.ericsson.cms.sites.core.entities.Site>();
            if (!this.validateSiteFilter(paramBld.getSiteIds(), sites)) {
                return ResponseUtil.createNotFountErrorWithJsonResponse("Site(s) not found");
            }
            try {
                ExpListBuilder expListBuilder = new ExpListBuilder();
                expListBuilder.setAndFilters(filters);
                expListBuilder.setOrFilters(orFilters);
                expListBuilder.setModifiedAfter(modifiedAfter);
                List<List<Integer>> siteList = this.differentiateSites(sites);
                expListBuilder.setSiteIds(siteList.get(0));
                expListBuilder.setTrackingSiteIds(siteList.get(1));
                rootNode = expListBuilder.build();
            }
            catch (ParseException ex) {
                logger.error((Object)ERROR, (Throwable)ex);
                return ResponseUtil.createBadRequestResponse(ex.getMessage());
            }
            catch (RuntimeException ex) {
                logger.error((Object)ERROR, (Throwable)ex);
                return ResponseUtil.createBadRequestResponse(ex.getMessage());
            }
            TitleFilter titleFilter = new TitleFilter((ExpNode)rootNode, paramBld.getSortInfo(), paramBld.getPagingInfo());
            List<SearchColumn> searchColumns = paramBld.buildSearchColumns(fields);
            if (searchColumns == null) {
                return paramBld.getErrorResponse();
            }
            if (paramBld.getSiteIds() == null || paramBld.getSiteIds().isEmpty()) {
                titleFilter.setCriteriaMode(CriteriaMode.MASTER);
            } else {
                titleFilter.setCriteriaMode(CriteriaMode.SITE);
            }
            TitleSearchResult searchResults = this.getTitleSearchService().getSearchResults(titleFilter, paramBld.getPartnerIds(), searchColumns);
            String hrefStub = HrefHelper.buildHrefToPageStub(httpRequest, count, detail, sort, order, modifiedAfter, siteIds, filters, fields);
            String output = paramBld.getMediaType().equals((Object)MediaType.APPLICATION_JSON_TYPE) ? this.jsonMarshaller.getResultsAsJson(searchResults, httpRequest, searchColumns, start, count, hrefStub, paramBld.getListDetail()) : this.xmlMarshaller.getResultsAsXml(searchResults, httpRequest, searchColumns, start, count, hrefStub, paramBld.getListDetail());
            return Response.status((Response.Status)Response.Status.OK).header(CACHE_CONTROL, (Object)NO_CACHE).type(paramBld.getMediaType()).entity((Object)output).build();
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)ERROR, (Throwable)e);
            return ResponseUtil.createBadRequestResponse(e.getMessage());
        }
        catch (AuthorizationException e1) {
            logger.error((Object)ERROR, (Throwable)e1);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (EJBAccessException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof IllegalArgumentException) {
                return ResponseUtil.createBadRequestResponse(ex.getMessage());
            }
            logger.error((Object)ERROR_HAPPENED, (Throwable)ex);
            return ResponseUtil.createInternalServerErrorResponse(ex.getMessage());
        }
    }

    private List<List<Integer>> differentiateSites(List<com.ericsson.cms.sites.core.entities.Site> sites) {
        ArrayList<Integer> dSites = new ArrayList<Integer>(50);
        ArrayList<Integer> tSites = new ArrayList<Integer>(50);
        if (sites.isEmpty()) {
            return Arrays.asList(dSites, tSites);
        }
        this.filterSites(dSites, tSites, sites);
        return Arrays.asList(dSites, tSites);
    }

    @Transactional
    private void filterSites(List<Integer> dSites, List<Integer> tSites, List<com.ericsson.cms.sites.core.entities.Site> sites) {
        List<Integer> list = dSites;
        List<Integer> list2 = tSites;
        List<com.ericsson.cms.sites.core.entities.Site> list3 = sites;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = TitleServiceNG.class.getDeclaredMethod("filterSites", List.class, List.class, List.class).getAnnotation(Transactional.class);
        }
        TitleServiceNG.filterSites_aroundBody1$advice(this, list, list2, list3, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    public Response countBySite(HttpServletRequest httpRequest, Request rsRequest, String authorizationHeader, List<Long> partners, List<String> filters, List<String> orFilters) {
        Response.ResponseBuilder builder = null;
        if ((builder = EndpointsAuthorizationUtil.authorizePermissions(httpRequest, builder, TITLE_VIEW, SITES_VIEW)) != null) {
            return builder.build();
        }
        TitleListParameterBuilder paramBld = new TitleListParameterBuilder();
        if (!paramBld.setPartnerIds(partners)) {
            return paramBld.getErrorResponse();
        }
        try {
            ExpList rootNode;
            try {
                ExpListBuilder expListBuilder = new ExpListBuilder();
                expListBuilder.setAndFilters(filters);
                expListBuilder.setOrFilters(orFilters);
                rootNode = expListBuilder.build();
            }
            catch (RuntimeException ex) {
                return ResponseUtil.createBadRequestResponse(ex.getMessage());
            }
            TitleFilter titleFilter = new TitleFilter((ExpNode)rootNode);
            titleFilter.setCriteriaMode(CriteriaMode.SITE);
            Map searchResults = this.getTitleSearchService().getCountBySite(titleFilter, paramBld.getPartnerIds());
            logger.debug((Object)("SearchResults: " + searchResults));
            ArrayList<SiteTitleCount> siteCountSummary = new ArrayList<SiteTitleCount>();
            for (Map.Entry entry : searchResults.entrySet()) {
                int siteId = ((Long)entry.getKey()).intValue();
                int titleCount = ((Long)entry.getValue()).intValue();
                logger.debug((Object)(String.valueOf(siteId) + "/" + titleCount));
                SiteTitleCount siteTitleCount = new SiteTitleCount();
                com.ericsson.cms.sites.core.entities.Site site = this.getSiteManager().getSite(siteId);
                String siteType = site.getClass().getSimpleName();
                siteType = "MediapathDistributionSite".equals(siteType) ? "cmsSenderSite" : String.valueOf(Character.toLowerCase(siteType.charAt(0))) + siteType.substring(1);
                siteTitleCount.type = siteType;
                siteTitleCount.name = site.getName();
                siteTitleCount.titleCount = titleCount;
                siteTitleCount.siteHref = HrefHelper.buildServiceHref(httpRequest, "sites/" + siteId);
                siteTitleCount.titleHref = HrefHelper.buildServiceHref(httpRequest, "titles/?siteId=" + siteId);
                siteCountSummary.add(siteTitleCount);
            }
            String output = this.jsonMarshaller.getResultsAsJson(siteCountSummary);
            return Response.status((Response.Status)Response.Status.OK).header(CACHE_CONTROL, (Object)NO_CACHE).type(paramBld.getMediaType()).entity((Object)output).build();
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)ERROR, (Throwable)e);
            return ResponseUtil.createBadRequestResponse(e.getMessage());
        }
        catch (AuthorizationException e1) {
            logger.error((Object)ERROR, (Throwable)e1);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (EJBAccessException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof IllegalArgumentException) {
                return ResponseUtil.createBadRequestResponse(ex.getMessage());
            }
            logger.error((Object)ERROR_HAPPENED, (Throwable)ex);
            return ResponseUtil.createInternalServerErrorResponse(ex.getMessage());
        }
    }

    @Override
    public Response delete(HttpServletRequest servletRequest, String authorizationHeader, Request request, Long titleId, Boolean retire) {
        try {
            Response.ResponseBuilder builder = null;
            builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, TITLE_DELETE);
            if (builder != null) {
                return builder.build();
            }
            if (!this.getTitleManager().isActive(titleId)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).header(CACHE_CONTROL, (Object)NO_CACHE).type("text/plain").build();
            }
            Title title = this.getTitleManager().get(titleId);
            if (!PartnerUtils.checkAuthorization(title.getPartnerId())) {
                return ResponseUtil.createUnauthorizedResponse();
            }
            builder = request.evaluatePreconditions(title.getLastModifiedTime());
            if (builder != null) {
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).header(CACHE_CONTROL, (Object)NO_CACHE).build();
            }
            if (retire.booleanValue()) {
                this.getTitleManager().retire(titleId, (ITitleActionSource)new TitleActionSource(CONTENT_MANAGEMENT, "Title Web Service", this.getCurrentUser()));
            } else if (title.isCopy()) {
                this.getSiteTitleManager().deleteTitle(titleId.longValue());
            } else {
                this.getTitleManager().delete(titleId);
            }
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (AuthorizationException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (EJBAccessException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return ResponseUtil.createInternalServerErrorResponse(ex.getMessage());
        }
    }

    @Override
    public Response targetTitle(String authorizationHeader, HttpServletRequest request, Long titleId, List<Integer> siteIds) {
        try {
            Response.ResponseBuilder builder = null;
            builder = EndpointsAuthorizationUtil.authorizePermissions(request, builder, SITE_TARGET);
            if (builder != null) {
                return builder.build();
            }
            String contentType = request.getContentType();
            int length = request.getContentLength();
            if (length > 0 && contentType != null && contentType.contains("application/xml")) {
                if (siteIds == null) {
                    siteIds = new ArrayList<Integer>();
                }
                DocumentBuilder db = com.tandbergtv.metadatamanager.util.XmlUtil.borrowDocumentBuilder();
                Document doc = db.parse((InputStream)request.getInputStream());
                XPathFactory factory = XPathFactory.newInstance();
                XPath xpath = factory.newXPath();
                NodeList nodes = (NodeList)xpath.evaluate("/resourceList/site/@href", doc, XPathConstants.NODESET);
                int i = 0;
                while (i < nodes.getLength()) {
                    String href = nodes.item(i).getTextContent();
                    siteIds.add(Integer.parseInt(href.substring(href.lastIndexOf(47) + 1)));
                    ++i;
                }
            } else if (length > 0 && contentType != null && contentType.contains("application/json")) {
                if (siteIds == null) {
                    siteIds = new ArrayList<Integer>();
                }
                JsonFactory factory = new JsonFactory();
                ObjectMapper mapper = new ObjectMapper(factory);
                TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};
                Map o = (Map)mapper.readValue((InputStream)request.getInputStream(), (TypeReference)typeRef);
                Map resourceList = (Map)o.get("resourceList");
                if (resourceList.containsKey("site") && resourceList.get("site") instanceof Map) {
                    Map siteEntry = (Map)resourceList.get("site");
                    String href = siteEntry.get("@href").toString();
                    siteIds.add(Integer.parseInt(href.substring(href.lastIndexOf(47) + 1)));
                } else if (resourceList.containsKey("site") && resourceList.get("site") instanceof List) {
                    List sites = (List)resourceList.get("site");
                    for (Map site : sites) {
                        String href = site.get("@href").toString();
                        siteIds.add(Integer.parseInt(href.substring(href.lastIndexOf(47) + 1)));
                    }
                }
            } else if (length > 0) {
                return ResponseUtil.createBadRequestResponse("Oh snap, you appear to have a body but didn't declare the content type as either xml or json.");
            }
            String acceptHeader = request.getHeader("Accept");
            MediaType mediaType = acceptHeader != null && acceptHeader.contains("application/xml") ? MediaType.APPLICATION_XML_TYPE : MediaType.APPLICATION_JSON_TYPE;
            Set sitesTargeted = siteIds != null && !siteIds.isEmpty() ? this.getSiteManager().target(titleId.longValue(), siteIds) : this.getSiteManager().targetWithRules(titleId.longValue()).getActiveSites();
            String output = mediaType.equals((Object)MediaType.APPLICATION_XML_TYPE) ? XmlMarshaller.buildSiteXml(sitesTargeted, request) : JsonMarshaller.buildSiteJson(sitesTargeted, request);
            return Response.status((Response.Status)Response.Status.ACCEPTED).type(mediaType).entity((Object)output).build();
        }
        catch (AuthorizationException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (EJBAccessException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            if (ex.getMessage() != null && ex.getMessage().contains("No site found")) {
                return ResponseUtil.createBadRequestResponse(ex.getMessage());
            }
            return ResponseUtil.createInternalServerErrorResponse(ex.getMessage());
        }
    }

    @Override
    public Response getChildTitles(Request rsRequest, HttpServletRequest request, String authorizationHeader, Long titleId, String type) {
        try {
            Response.ResponseBuilder builder = null;
            builder = EndpointsAuthorizationUtil.authorizePermissions(request, builder, TITLE_VIEW);
            if (builder != null) {
                return builder.build();
            }
            Title masterTitle = this.getTitleManager().get(titleId);
            if (masterTitle == null || masterTitle.getStatus() == TitleStatus.DELETED) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").build();
            }
            List<CMSTitle> cmsTitles = this.getCMSTitleList(titleId, type);
            MediaType mediaType = ResponseTypeUtilities.getMediaTypeFromRequest(rsRequest);
            String result = mediaType.equals((Object)MediaType.APPLICATION_JSON_TYPE) ? JsonMarshaller.getSiteTitlesResultAsJson(cmsTitles, request, type) : XmlMarshaller.getSiteTitlesResultAsXML(cmsTitles, request, type);
            return Response.ok().entity((Object)result).type(mediaType).build();
        }
        catch (AuthorizationException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (EJBAccessException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (Exception ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createInternalServerErrorResponse(ex.getMessage());
        }
    }

    @Transactional
    private List<CMSTitle> getCMSTitleList(Long titleId, String type) {
        Long l = titleId;
        String string = type;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = TitleServiceNG.class.getDeclaredMethod("getCMSTitleList", Long.class, String.class).getAnnotation(Transactional.class);
        }
        return (List)TitleServiceNG.getCMSTitleList_aroundBody3$advice(this, l, string, transactionEnforcer, (Transactional)annotation, null);
    }

    private List<CMSTitle> getCMSTitles(List<DistributionSiteTitle> distributeTitles, String type) {
        if (distributeTitles == null || distributeTitles.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CMSTitle> cmsTitles = new ArrayList<CMSTitle>(distributeTitles.size());
        for (DistributionSiteTitle distTitle : distributeTitles) {
            List tTitles;
            CMSTitle siteTitle = new CMSTitle();
            cmsTitles.add(siteTitle);
            siteTitle.setId(distTitle.getTitle().getId()).setDistributionStatus(distTitle.getStatus().name());
            siteTitle.setSite(new Site(distTitle.getDistributionSite().getId(), distTitle.getDistributionSite().getName()));
            if (!StringUtils.equals((String)"all", (String)type) || (tTitles = this.getSiteManager().getTrackingSiteTitles(distTitle.getTitle().getId().longValue())) == null || tTitles.isEmpty()) continue;
            for (TrackingSiteTitle tt : tTitles) {
                TrackingSite ts = new TrackingSite();
                ts.setId(tt.getTrackingSite().getId()).setName(tt.getTrackingSite().getName()).setStatus(tt.getStatus().name());
                siteTitle.getTrackingSite().add(ts);
            }
        }
        return cmsTitles;
    }

    @Override
    public Response ingest(HttpServletRequest request, String authorizationHeader, String providerId, String contentClassName) {
        try {
            List messages;
            ISavedTitle savedTitle;
            Document document;
            Partner partnerId;
            Response.ResponseBuilder builder = null;
            builder = EndpointsAuthorizationUtil.authorizePermissions(request, builder, TITLE_CREATE);
            if (builder != null) {
                return builder.build();
            }
            try {
                partnerId = this.partnerManagement.getSourceOrSelfPartner(providerId);
            }
            catch (PMMException pmme) {
                logger.error((Object)ERROR, (Throwable)pmme);
                return ResponseUtil.createBadRequestResponse(pmme.getMessage());
            }
            if (!PartnerUtils.checkAuthorization(partnerId.getId())) {
                return ResponseUtil.createUnauthorizedResponse();
            }
            try {
                document = com.tandbergtv.metadatamanager.util.XmlUtil.borrowDocumentBuilder().parse((InputStream)request.getInputStream());
            }
            catch (Exception ex) {
                logger.error((Object)ERROR, (Throwable)ex);
                return ResponseUtil.createBadRequestResponse(UNABLE_TO_PARSE_REQUEST_BODY);
            }
            List ids = this.getTitleManager().getTitleIDs(document);
            if (ids.size() > 1) {
                return ResponseUtil.createInternalServerErrorResponse("multiple entries for asset identifier");
            }
            ITitleActionSource source = this.newTitleActionSource();
            if (ids.size() == 1 && ids.get(0) != null) {
                savedTitle = this.titleIngestServiceInstance.updateTitleForMetadata(document, (Long)ids.get(0), source);
            } else {
                this.checkLicense(contentClassName);
                savedTitle = this.titleIngestServiceInstance.createTitleForMetadata(document, providerId, contentClassName, source);
            }
            NormalizedItem normalizedItem = this.getTitleManager().normalizeTitle(savedTitle.getTitle(), TreEvent.INGESTED.name());
            try {
                savedTitle = this.getTitleManager().update(savedTitle.getTitle(), false, source);
                messages = savedTitle.getValidationMessages();
            }
            catch (TitleValidationException e) {
                logger.info((Object)e);
                messages = e.getMessages();
                savedTitle = this.getTitleManager().update(savedTitle.getTitle(), true, source);
            }
            this.statusService.sendStatus(savedTitle.getTitle(), "NORMALIZED", normalizedItem.getNormalizationChangeInfo(), true, source.getComponentName(), source.getEntityName(), source.getID());
            document = com.tandbergtv.metadatamanager.util.XmlUtil.borrowDocumentBuilder().newDocument();
            Element e = XmlUtil.getValidationErrorMessages(messages, document);
            document.appendChild(e);
            String docContents = XmlUtil.getDocumentContents(document);
            return Response.ok().entity((Object)docContents).header(LAST_MODIFIED, (Object)webDateFormat.format(savedTitle.getTitle().getLastModifiedTime())).header(LOCATION, (Object)HrefHelper.buildGetHref(request, savedTitle.getTitle().getId())).build();
        }
        catch (TitleIngestException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createBadRequestResponse(ex.getMessage());
        }
        catch (AuthorizationException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (EJBAccessException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof TitleIngestException) {
                logger.warn((Object)ex);
                return ResponseUtil.createBadRequestResponse(ex.getMessage());
            }
            logger.error((Object)ex);
            return ResponseUtil.createInternalServerErrorResponse(ex.getMessage());
        }
    }

    @Override
    public Response update(HttpServletRequest request, String authorizationHeader, Long titleId, String sendEvent) {
        try {
            int revision;
            Document document;
            Response.ResponseBuilder builder = null;
            builder = EndpointsAuthorizationUtil.authorizePermissions(request, builder, TITLE_MODIFY);
            if (builder != null) {
                return builder.build();
            }
            try {
                String hrefStr;
                int start;
                document = com.tandbergtv.metadatamanager.util.XmlUtil.borrowDocumentBuilder().parse((InputStream)request.getInputStream());
                Node cmsTitle = XmlUtil.findFirstChildNode("cmsTitle", document);
                Node ecmfSpec = XmlUtil.findFirstChildNode("metadata/ECMFSpec", cmsTitle);
                Node href = cmsTitle.getAttributes().getNamedItem("href");
                Node revisionStr = ecmfSpec.getAttributes().getNamedItem("revision");
                if (revisionStr == null || revisionStr.getTextContent().isEmpty()) {
                    return ResponseUtil.createBadRequestResponse("You need to provide a revision number.");
                }
                revision = Integer.parseInt(revisionStr.getTextContent());
                if (href != null && (start = (hrefStr = href.getTextContent()).lastIndexOf(47) + 1) > 0 && !titleId.equals(Long.parseLong(hrefStr.substring(start)))) {
                    return ResponseUtil.createBadRequestResponse("TitleId doesn't match xml contents.");
                }
                document.removeChild(cmsTitle);
                document.appendChild(ecmfSpec);
            }
            catch (Exception ex) {
                logger.error((Object)ERROR, (Throwable)ex);
                return ResponseUtil.createBadRequestResponse(UNABLE_TO_PARSE_REQUEST_BODY);
            }
            Title origTitle = this.getTitleManager().get(titleId);
            String etag = request.getHeader("ETag");
            if (etag == null) {
                return ResponseUtil.createBadRequestResponse("please provide ETag.");
            }
            if (!etag.equals(String.valueOf(origTitle.getLastModifiedTime().getTime()))) {
                return ResponseUtil.createBadRequestResponse("Invalid ETag: " + etag);
            }
            Integer sysRevisionNumber = origTitle.getAsset().getLatestRevisionNumber();
            HashMap<Long, String> assetMap = new HashMap<Long, String>();
            TitleUtil.getAllAssetIds(assetMap, origTitle.getAsset());
            if (!PartnerUtils.checkAuthorization(origTitle.getPartnerId())) {
                return ResponseUtil.createUnauthorizedResponse();
            }
            if (revision != sysRevisionNumber) {
                return ResponseUtil.createBadRequestResponse("Revision collision detected. The current revision is: " + sysRevisionNumber);
            }
            Specification spec = this.specManager.getInternalSpecification();
            List assets = this.binder.convert(document);
            for (Asset asset : assets) {
                if (TitleUtil.isValidateAgainstMap(assetMap, asset)) continue;
                return ResponseUtil.createBadRequestResponse("Asset Ids don't match up with existing content. ");
            }
            origTitle.setAsset((Asset)assets.get(0));
            String userName = EndpointsAuthorizationUtil.getUserName(request);
            ISavedTitle savedTitle = sendEvent != null && sendEvent.equalsIgnoreCase("UIUPDATED") ? this.uiUpdateTitle(userName, origTitle) : this.updateTitle(origTitle);
            Document result = XmlUtil.convertTitle(spec, request, savedTitle.getTitle(), savedTitle.getValidationMessages());
            String docContents = XmlUtil.getDocumentContents(result);
            return Response.ok().entity((Object)docContents).header(LAST_MODIFIED, (Object)webDateFormat.format(savedTitle.getTitle().getLastModifiedTime())).header(LOCATION, (Object)HrefHelper.buildGetHref(request, savedTitle.getTitle().getId())).header("ETag", (Object)savedTitle.getTitle().getLastModifiedTime().getTime()).build();
        }
        catch (AuthorizationException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (EJBAccessException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return ResponseUtil.createInternalServerErrorResponse(ex.getMessage());
        }
    }

    @Transactional
    private ISavedTitle updateTitle(Title titleToSave) throws Exception {
        Title title = titleToSave;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = TitleServiceNG.class.getDeclaredMethod("updateTitle", Title.class).getAnnotation(Transactional.class);
        }
        return (ISavedTitle)TitleServiceNG.updateTitle_aroundBody5$advice(this, title, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    private ISavedTitle uiUpdateTitle(String userName, Title titleToSave) throws Exception {
        String string = userName;
        Title title = titleToSave;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = TitleServiceNG.class.getDeclaredMethod("uiUpdateTitle", String.class, Title.class).getAnnotation(Transactional.class);
        }
        return (ISavedTitle)TitleServiceNG.uiUpdateTitle_aroundBody7$advice(this, string, title, transactionEnforcer, (Transactional)annotation, null);
    }

    private ITitleActionSource newTitleActionSource() {
        return new TitleActionSource(CONTENT_MANAGEMENT, "Metadata Title Service", this.getCurrentUser());
    }

    @Override
    public Response create(HttpServletRequest request, String authorizationHeader, String providerId, String contentClassName) {
        try {
            this.checkLicense(contentClassName);
            Response.ResponseBuilder builder = null;
            builder = EndpointsAuthorizationUtil.authorizePermissions(request, builder, TITLE_CREATE);
            if (builder != null) {
                return builder.build();
            }
        }
        catch (Exception ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).type("text/plain").entity((Object)ex.getMessage()).build();
        }
        try {
            List messages;
            Partner partnerId;
            Document document;
            try {
                document = com.tandbergtv.metadatamanager.util.XmlUtil.borrowDocumentBuilder().parse((InputStream)request.getInputStream());
                Node cmsTitle = XmlUtil.findFirstChildNode("cmsTitle", document);
                Node ecmfSpec = XmlUtil.findFirstChildNode("metadata/ECMFSpec", cmsTitle);
                document.removeChild(cmsTitle);
                document.appendChild(ecmfSpec);
                XmlUtil.stripOutEcmfIdentifiers(document);
            }
            catch (Exception ex) {
                logger.error((Object)ERROR, (Throwable)ex);
                return ResponseUtil.createBadRequestResponse(UNABLE_TO_PARSE_REQUEST_BODY);
            }
            Specification spec = this.specManager.getInternalSpecification();
            Title title = new Title();
            try {
                partnerId = this.partnerManagement.getSourceOrSelfPartner(providerId);
            }
            catch (PMMException pmme) {
                logger.error((Object)ERROR, (Throwable)pmme);
                return ResponseUtil.createBadRequestResponse(pmme.getMessage());
            }
            title.setPartnerId(Long.valueOf(partnerId.getId()));
            if (!PartnerUtils.checkAuthorization(title.getPartnerId())) {
                return ResponseUtil.createUnauthorizedResponse();
            }
            try {
                title.setContentClassId(this.getContentClassId(contentClassName));
            }
            catch (Exception ex) {
                logger.error((Object)ERROR, (Throwable)ex);
                return ResponseUtil.createBadRequestResponse("Invalid Content Class: " + contentClassName);
            }
            List assets = this.binder.convert(document);
            title.setAsset((Asset)assets.get(0));
            ContentClass contentClass = null;
            try {
                Group rootAsset;
                contentClass = this.contentClassService.getContentClassById(title.getContentClassId().longValue());
                if (contentClass.getType() == ContentClass.Type.Offer && (rootAsset = (Group)title.getAsset()).getReferencedTitleIds() == null) {
                    rootAsset.setReferencedTitleIds(new ArrayList());
                }
            }
            catch (Exception e) {
                logger.error((Object)("Exception while trying to add referencetitle element to the title" + e.getMessage()));
                throw e;
            }
            try {
                this.contentClassService.applyContentClassMetadataForIngest(title);
            }
            catch (Exception ex) {
                if (ex.getCause() instanceof ContentClassPersistenceException) {
                    logger.warn((Object)ex);
                    return ResponseUtil.createBadRequestResponse(ex.getMessage());
                }
                throw ex;
            }
            NormalizedItem normalizedItem = this.getTitleManager().normalizeTitle(title, TreEvent.INGESTED.name());
            title = normalizedItem.getTitle();
            ISavedTitle savedTitle = null;
            ITitleActionSource source = this.newTitleActionSource();
            try {
                savedTitle = this.getTitleManager().create(title, false, source);
                com.tandbergtv.watchpoint.pmm.title.TitleUtil.buildTitleMetricsLog((Title)title, (TitleOperationTypeEnum)TitleOperationTypeEnum.Ingested);
                messages = savedTitle.getValidationMessages();
            }
            catch (TitleValidationException ex) {
                logger.warn((Object)ex);
                messages = ex.getMessages();
                savedTitle = this.getTitleManager().create(title, true, source);
                com.tandbergtv.watchpoint.pmm.title.TitleUtil.buildTitleMetricsLog((Title)title, (TitleOperationTypeEnum)TitleOperationTypeEnum.Ingested);
            }
            catch (EJBException ex) {
                if (ex.getCause() instanceof TitlePersistenceException) {
                    logger.warn((Object)ex);
                    return ResponseUtil.createBadRequestResponse(ex.getMessage());
                }
                throw ex;
            }
            this.statusService.sendStatus(title, "NORMALIZED", normalizedItem.getNormalizationChangeInfo(), true, source.getComponentName(), source.getEntityName(), source.getID());
            Document result = XmlUtil.convertTitle(spec, request, savedTitle.getTitle(), messages);
            String docContents = XmlUtil.getDocumentContents(result);
            return Response.ok().entity((Object)docContents).header(LAST_MODIFIED, (Object)webDateFormat.format(savedTitle.getTitle().getLastModifiedTime())).header(LOCATION, (Object)HrefHelper.buildGetHref(request, savedTitle.getTitle().getId())).header("ETag", (Object)savedTitle.getTitle().getLastModifiedTime().getTime()).build();
        }
        catch (AuthorizationException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (EJBAccessException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return ResponseUtil.createInternalServerErrorResponse(ex.getMessage());
        }
    }

    private Long getContentClassId(String contentClassName) {
        try {
            if (contentClassName == null || contentClassName.isEmpty()) {
                return this.contentClassService.getDefaultContentClassId();
            }
            Long id = this.contentClassService.getContentClassIdByName(contentClassName);
            if (id == null) {
                String msg = "The content class[" + contentClassName + "] was not found.";
                throw new IllegalArgumentException(msg);
            }
            return id;
        }
        catch (ContentClassPersistenceException e) {
            String msg = "Failed to get content class[" + contentClassName + "], error: " + e.getLocalizedMessage();
            throw new RuntimeException(msg, e);
        }
    }

    @Override
    public Response getThumbnail(HttpServletRequest request, long titleId, String assetId, String size) {
        try {
            Response.ResponseBuilder builder = null;
            builder = EndpointsAuthorizationUtil.authorizePermissions(request, builder, TITLE_VIEW);
            if (builder != null) {
                return builder.build();
            }
            if (!this.getTitleManager().isActive(Long.valueOf(titleId))) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).header(CACHE_CONTROL, (Object)NO_CACHE).type("text/plain").build();
            }
            if (StringUtils.isEmpty((String)size)) {
                size = "large";
            }
            if (!"large".equalsIgnoreCase(size) && !"medium".equalsIgnoreCase(size)) {
                return ResponseUtil.createBadRequestResponse("Invalid size : " + size + ". The valid size param shall be \"large\" or \"medium\". ");
            }
            ServiceThumbnailHandler sth = new ServiceThumbnailHandler(titleId, assetId, size);
            File resizedImageFile = sth.getResizeImageFile();
            if (resizedImageFile == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).header(CACHE_CONTROL, (Object)NO_CACHE).type("text/plain").build();
            }
            Response response = this.thumbnailModifiedChecker(request, resizedImageFile);
            if (response != null) {
                return response;
            }
            webDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            return Response.ok((Object)resizedImageFile).header(LAST_MODIFIED, (Object)webDateFormat.format(resizedImageFile.lastModified())).header(CACHE_CONTROL, (Object)NO_CACHE).header("ETag", (Object)resizedImageFile.lastModified()).build();
        }
        catch (AuthorizationException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (EJBAccessException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to get a thumbnail.", (Throwable)ex);
            return ResponseUtil.createInternalServerErrorResponse(ex.getMessage());
        }
    }

    @Override
    public Response uploadFile(HttpServletRequest request, long titleId, long assetId, String sendEvent, MultipartFormDataInput input) throws JSONException {
        Response response;
        Response.ResponseBuilder builder = null;
        if ((builder = EndpointsAuthorizationUtil.authorizePermissions(request, builder, TITLE_MODIFY)) != null) {
            response = ResponseUtil.createUnauthorizedResponse("User must have permission to modify a title in order to upload a file for an asset.");
        } else if (this.getTitleManager().isExisting(Long.valueOf(titleId)) && this.getTitleManager().isActive(Long.valueOf(titleId))) {
            Title title = this.getTitleManager().get(Long.valueOf(titleId));
            Asset asset = title.getAsset(assetId);
            if (asset == null) {
                response = ResponseUtil.createNotFountErrorWithJsonResponse("Asset not found.");
            } else {
                FileUploadUtil fileUploadUtil = new FileUploadUtil();
                String providerId = this.getProviderId(title);
                File uploadedFile = fileUploadUtil.uploadFile(providerId, titleId, assetId, input);
                if (uploadedFile != null) {
                    try {
                        RESTAuthentication.LoginInfo loginInfo = RESTAuthentication.getLoginInfoForAuthorizationHeader(request.getHeader("Authorization"));
                        TitleFileRequest fileRequest = new TitleFileRequest().setAssetId(assetId).setTitleId(titleId).setFilePath(uploadedFile.getAbsolutePath()).setUsername(loginInfo.getUsername()).setEvent(sendEvent);
                        this.getTitleFileManager().registerFile(fileRequest);
                    }
                    catch (Exception e) {
                        response = ResponseUtil.createInternalServerErrorWithJsonResponse("Something went wrong trying to register the file");
                        logger.error((Object)e);
                    }
                    response = ResponseUtil.createJsonOkResponse("File uploaded and registered to titleId: " + titleId + " on the asset + " + assetId);
                } else {
                    response = ResponseUtil.createInternalServerErrorWithJsonResponse("Something went wrong trying to upload the file");
                }
            }
        } else {
            response = ResponseUtil.createNotFountErrorWithJsonResponse("Title not found.");
        }
        return response;
    }

    private String getProviderId(Title title) {
        Long partnerId = title.getPartnerId();
        Partner partner = this.partnerManagement.getPartner(partnerId.longValue());
        return partner.getProviderId();
    }

    private Response thumbnailModifiedChecker(HttpServletRequest request, File resizedImageFile) {
        String ifModifiedSince;
        block4: {
            try {
                ifModifiedSince = request.getHeader("If-Modified-Since");
                if (!StringUtils.isEmpty((String)ifModifiedSince)) break block4;
                return null;
            }
            catch (ParseException parseException) {
                return ResponseUtil.createBadRequestResponse("Format of \"If-Modified-Since\" parameter in http request head is incorrect.");
            }
        }
        Date ifModifiedSinceDate = webDateFormat.parse(ifModifiedSince);
        if (new Date(resizedImageFile.lastModified()).compareTo(ifModifiedSinceDate) <= 0) {
            return Response.status((Response.Status)Response.Status.NOT_MODIFIED).header(CACHE_CONTROL, (Object)NO_CACHE).type("text/plain").build();
        }
        return null;
    }

    @Override
    public Response getDueStatusSummary(HttpServletRequest servletRequest, Request request, String dueDate, List<Long> partners) {
        try {
            List<Long> partnerIds;
            Response.ResponseBuilder builder = null;
            builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, TITLE_VIEW);
            if (builder != null) {
                return builder.build();
            }
            try {
                partnerIds = PartnerUtils.getAuthorizedPartnerIds(partners);
            }
            catch (UnauthorizedUserException ex) {
                logger.warn((Object)ex);
                return ResponseUtil.createUnauthorizedResponse(ex.getMessage());
            }
            if (dueDate == null || dueDate.isEmpty()) {
                return ResponseUtil.createBadRequestResponse("Please enter the dueDate parameter.");
            }
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                dateFormat.parse(dueDate);
            }
            catch (ParseException parseException) {
                return ResponseUtil.createBadRequestResponse("The dueDate format should be yyyy-MM-dd.");
            }
            long[] results = new long[3];
            SortingInfo sortInfo = new SortingInfo(LIC_WINDOW_START, SortOrder.ASCENDING, PACKAGE_TITLE, FieldType.ASSET);
            ArrayList<String> dueDateFilters = new ArrayList<String>();
            dueDateFilters.add("licenseStart:lessthanequal:" + dueDate);
            dueDateFilters.add("licenseEnd:greaterthanequal:" + dueDate);
            TitleFilter titleFilter = new TitleFilter();
            titleFilter.setSortInfo(sortInfo);
            titleFilter.setCriteriaMode(CriteriaMode.MASTER);
            ArrayList<String> filters = new ArrayList<String>();
            filters.addAll(dueDateFilters);
            filters.add("processingStatus:equal:" + TitleProcessingStatus.COMPLETED.toString());
            filters.add("distributionStatus:equal:" + TitleDistributionStatus.DISTRIBUTED.toString());
            titleFilter.setRootNode((ExpNode)SearchHelper.filterItems(filters, ""));
            results[0] = this.getTitleSearchService().getTitleCount(titleFilter, partnerIds);
            filters.clear();
            filters.addAll(dueDateFilters);
            filters.add("status:equal:" + TitleStatus.COMMITTED.toString());
            filters.add("processingStatus:notequal:" + TitleProcessingStatus.FAILED.toString());
            filters.add("distributionStatus:notequal:" + TitleDistributionStatus.FAILED.toString());
            titleFilter.setRootNode((ExpNode)SearchHelper.filterItems(filters, ""));
            results[1] = this.getTitleSearchService().getTitleCount(titleFilter, partnerIds);
            filters.clear();
            filters.add("processingStatus:equal:" + TitleProcessingStatus.FAILED.toString());
            filters.add("distributionStatus:equal:" + TitleDistributionStatus.FAILED.toString());
            ExpList failedStatusNode = SearchHelper.filterItems(filters, "", "OR");
            ExpList dateExpNode = SearchHelper.filterItems(dueDateFilters, "");
            ExpList rootNode = new ExpList("AND");
            rootNode.addItem((ExpNode)dateExpNode);
            rootNode.addItem((ExpNode)failedStatusNode);
            titleFilter.setRootNode((ExpNode)rootNode);
            results[2] = this.getTitleSearchService().getTitleCount(titleFilter, partnerIds);
            MediaType mediaType = ResponseTypeUtilities.getMediaTypeFromRequest(request);
            String output = mediaType == MediaType.APPLICATION_JSON_TYPE ? JsonMarshaller.buildDueJson(results) : XmlMarshaller.buildDueXml(results);
            return Response.status((Response.Status)Response.Status.OK).header(CACHE_CONTROL, (Object)NO_CACHE).type(mediaType).entity((Object)output).build();
        }
        catch (IllegalArgumentException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createBadRequestResponse(ex.getMessage());
        }
        catch (AuthorizationException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (EJBAccessException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof IllegalArgumentException) {
                return ResponseUtil.createBadRequestResponse(ex.getMessage());
            }
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createInternalServerErrorResponse(ex.getMessage());
        }
    }

    @Override
    public Response purgeSiteTitle(HttpServletRequest servletRequest, Request request, Long titleId) {
        try {
            Response.ResponseBuilder builder = null;
            builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, TITLE_MODIFY);
            if (builder != null) {
                return builder.build();
            }
            if (titleId == null) {
                return ResponseUtil.createBadRequestResponse(TITLE_ID_IS_NULL);
            }
            Map result = this.getSiteTitleManager().purgeSiteTitles(titleId.longValue());
            if (result == null || result.isEmpty()) {
                return Response.ok().header(CACHE_CONTROL, (Object)NO_CACHE).build();
            }
            MediaType mediaType = ResponseTypeUtilities.getMediaTypeFromRequest(request);
            String output = mediaType == MediaType.APPLICATION_JSON_TYPE ? this.jsonMarshaller.createPurgeErrorJson(result) : ConversionUtil.serialize(XmlUtil.createPurgeErrorDoc(result));
            return Response.serverError().entity((Object)output).type(mediaType).header(CACHE_CONTROL, (Object)NO_CACHE).build();
        }
        catch (AuthorizationException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (EJBAccessException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof IllegalArgumentException) {
                return ResponseUtil.createBadRequestResponse(ex.getMessage());
            }
            logger.error((Object)ERROR, (Throwable)ex);
            return Response.serverError().entity((Object)ex.getMessage()).type("text/plain").build();
        }
    }

    @Override
    public Response getQcReport(HttpServletRequest request, String authorizationHeader, long titleId, long assetId) {
        try {
            Response.ResponseBuilder responseBuilder = null;
            responseBuilder = EndpointsAuthorizationUtil.authorizePermissions(request, responseBuilder, TITLE_VIEW);
            if (responseBuilder != null) {
                return responseBuilder.build();
            }
            Title title = null;
            try {
                title = this.getTitleManager().get(Long.valueOf(titleId));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            if (title == null || !title.getIsActive().booleanValue()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).header(CACHE_CONTROL, (Object)NO_CACHE).type("text/plain").build();
            }
            if (!PartnerUtils.checkAuthorization(title.getPartnerId())) {
                return ResponseUtil.createUnauthorizedResponse();
            }
            String assetName = this.getAssetName(titleId, assetId);
            if (assetName == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Invalid assetId: " + assetId)).type("text/plain").build();
            }
            URL reportUrl = this.getQcReportUri(titleId, assetName);
            if (reportUrl == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).header(CACHE_CONTROL, (Object)NO_CACHE).type("text/plain").build();
            }
            DocumentBuilder builder = com.tandbergtv.metadatamanager.util.XmlUtil.borrowDocumentBuilder();
            URLConnection conn = reportUrl.openConnection();
            Document doc = builder.parse(conn.getInputStream());
            String docContents = XmlUtil.getDocumentContents(doc);
            webDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            return Response.status((Response.Status)Response.Status.OK).header(LAST_MODIFIED, (Object)webDateFormat.format(title.getLastModifiedTime())).header(CACHE_CONTROL, (Object)NO_CACHE).entity((Object)docContents).header("ETag", (Object)title.getLastModifiedTime().getTime()).build();
        }
        catch (AuthorizationException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (EJBAccessException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (Exception ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createInternalServerErrorResponse(ex.getMessage());
        }
    }

    private String getAssetName(Long titleId, long assetId) {
        String[] nameAndIdPairs;
        String assetIdStr = String.valueOf(assetId);
        String property = this.getTitleManager().getProperty(titleId, LATEST_HISTORICAL_ASSET_FILE_IDS_PROPERTY);
        String[] stringArray = nameAndIdPairs = property.split(";");
        int n = nameAndIdPairs.length;
        int n2 = 0;
        while (n2 < n) {
            String pair = stringArray[n2];
            String[] items = pair.split(":");
            if (items.length != 2) {
                logger.error((Object)("invalid name and asset id pair :" + pair));
            }
            if (items[1].equals(assetIdStr)) {
                return items[0];
            }
            ++n2;
        }
        return null;
    }

    private URL getQcReportUri(Long titleId, String assetName) {
        Map properties = this.getTitleManager().getProperties(titleId);
        for (String propertyName : properties.keySet()) {
            if (!propertyName.contains(assetName) || !propertyName.toLowerCase().contains("report")) continue;
            try {
                return new URL((String)properties.get(propertyName));
            }
            catch (MalformedURLException e) {
                logger.error((Object)("malformaed url, error:" + e.getMessage()));
            }
        }
        return null;
    }

    @Override
    public Response getWorkorders(HttpServletRequest servletRequest, Request request, UriInfo uriInfo, long titleId, int start, int count) {
        try {
            Response.ResponseBuilder builder = null;
            builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, WORKORDER_VIEW);
            if (builder != null) {
                return builder.build();
            }
            if (start < 0) {
                return ResponseUtil.createBadRequestResponse("The start can't be less than 0.");
            }
            if (count < 0 || count > 100) {
                return ResponseUtil.createBadRequestResponse("The count must be postive and less than 100.");
            }
            if (!this.getTitleManager().isExisting(Long.valueOf(titleId))) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).header(CACHE_CONTROL, (Object)NO_CACHE).build();
            }
            Processes processes = this.createRequest();
            processes.query().titleId(String.valueOf(titleId)).detail("summary").start(start).count(count);
            ProcessListResponse response = processes.execute();
            int total = response.getTotal();
            List list = response.getItems();
            MediaType meidaType = ResponseTypeUtilities.getMediaTypeFromRequest(request);
            if (MediaType.APPLICATION_JSON_TYPE.equals((Object)meidaType)) {
                JSONObject obj = ConversionUtil.getJSONforWorkorders(list, uriInfo.getBaseUriBuilder().clone());
                obj = this.addPageInfo(obj, uriInfo, total, start, list.size());
                return Response.ok((Object)obj.toString(), (String)"application/json").header(CACHE_CONTROL, (Object)NO_CACHE).build();
            }
            Document doc = ConversionUtil.getWorkorderListDoc(list, uriInfo.getBaseUriBuilder().clone());
            doc = this.addPageInfo(doc, uriInfo, total, start, list.size());
            return Response.ok((Object)ConversionUtil.serialize(doc), (String)"application/xml").header(CACHE_CONTROL, (Object)NO_CACHE).build();
        }
        catch (AuthorizationException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (EJBAccessException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (Exception ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createInternalServerErrorResponse(ex.getMessage());
        }
    }

    @Override
    public Response getSavedSearches(HttpServletRequest httpRequest, Request rsRequest, String authorizationHeader) {
        List searches = this.titleSearchService.getTitleSearchByUserName(this.getCurrentUser(), true, CriteriaMode.MASTER, 0, 0);
        searches.add(0, new TitleSearch(Integer.valueOf(0), "Show all", "", Boolean.valueOf(true), null));
        MediaType mediaType = ResponseTypeUtilities.getMediaTypeFromRequest(rsRequest);
        try {
            if (MediaType.APPLICATION_JSON_TYPE.equals((Object)mediaType)) {
                JSONObject obj = ConversionUtil.getJSONforTitleSearchList(searches, httpRequest);
                return Response.ok((Object)obj.toString(), (String)"application/json").header(CACHE_CONTROL, (Object)NO_CACHE).build();
            }
            Document doc = ConversionUtil.getXMLforTitleSearchList(searches, httpRequest);
            return Response.ok((Object)ConversionUtil.serialize(doc), (String)"application/xml").header(CACHE_CONTROL, (Object)NO_CACHE).build();
        }
        catch (Exception ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createInternalServerErrorResponse(ex.getMessage());
        }
    }

    @Override
    @Transactional
    public Response executeSavedSearch(HttpServletRequest httpRequest, Request rsRequest, String authorizationHeader, Integer searchId, Integer start, Integer count, String detail, String fields, String sortColumnName, String sortOrder) {
        HttpServletRequest httpServletRequest = httpRequest;
        Request request = rsRequest;
        String string = authorizationHeader;
        Integer n = searchId;
        Integer n2 = start;
        Integer n3 = count;
        String string2 = detail;
        String string3 = fields;
        String string4 = sortColumnName;
        String string5 = sortOrder;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = TitleServiceNG.class.getDeclaredMethod("executeSavedSearch", HttpServletRequest.class, Request.class, String.class, Integer.class, Integer.class, Integer.class, String.class, String.class, String.class, String.class).getAnnotation(Transactional.class);
        }
        return (Response)TitleServiceNG.executeSavedSearch_aroundBody9$advice(this, httpServletRequest, request, string, n, n2, n3, string2, string3, string4, string5, transactionEnforcer, (Transactional)annotation, null);
    }

    private JSONObject addPageInfo(JSONObject obj, UriInfo uriInfo, int total, int start, int count) throws Exception {
        JSONObject list = (JSONObject)obj.get("resourceList");
        list.put("start", start);
        list.put("count", count);
        list.put("total", total);
        PaginableUrlBuilder urlBuilder = new PaginableUrlBuilder(uriInfo.getAbsolutePathBuilder()).total(total).start(start).count(count).build();
        if (!urlBuilder.isFirst()) {
            list.put("first", (Object)urlBuilder.first());
            list.put("prev", (Object)urlBuilder.prev());
        }
        if (!urlBuilder.isLast()) {
            list.put("next", (Object)urlBuilder.next());
            list.put("last", (Object)urlBuilder.last());
        }
        return obj;
    }

    private Document addPageInfo(Document doc, UriInfo uriInfo, int total, int start, int count) {
        doc.getDocumentElement().setAttribute("start", String.valueOf(start));
        doc.getDocumentElement().setAttribute("count", String.valueOf(count));
        doc.getDocumentElement().setAttribute("total", String.valueOf(total));
        PaginableUrlBuilder urlBuilder = new PaginableUrlBuilder(uriInfo.getAbsolutePathBuilder()).total(total).start(start).count(count).build();
        if (!urlBuilder.isFirst()) {
            doc.getDocumentElement().setAttribute("first", urlBuilder.first());
            doc.getDocumentElement().setAttribute("prev", urlBuilder.prev());
        }
        if (!urlBuilder.isLast()) {
            doc.getDocumentElement().setAttribute("next", urlBuilder.next());
            doc.getDocumentElement().setAttribute("last", urlBuilder.last());
        }
        return doc;
    }

    @Override
    public Response addTitleToOffer(HttpServletRequest httpRequest, Request rsRequest, String authorizationHeader, Long offerId, Long titleId) {
        try {
            Response.ResponseBuilder builder = null;
            builder = EndpointsAuthorizationUtil.authorizePermissions(httpRequest, builder, TITLE_MODIFY);
            if (builder != null) {
                return builder.build();
            }
            PartnerUtils.getAuthorizedPartnerIds();
            if (!this.getTitleManager().isActive(offerId)) {
                throw new NotFoundException("The given offer title Id is not active  [" + offerId + "]");
            }
            if (!this.getTitleManager().isActive(titleId)) {
                throw new NotFoundException("The given reference title Id is not active  [" + titleId + "]");
            }
            if (!this.getTitleManager().isOffer(offerId)) {
                return ResponseUtil.createBadRequestResponse("The given title Id is not an offer  [" + offerId + "]");
            }
            if (this.getTitleManager().isOffer(titleId)) {
                return ResponseUtil.createBadRequestResponse("The given reference title Id is an offer  [" + titleId + "]");
            }
            this.getTitleManager().addTitleToOffer(titleId, offerId, this.newTitleActionSource());
            return ResponseUtil.createOKResponse();
        }
        catch (AuthorizationException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (TitleValidationException tex) {
            logger.error((Object)tex);
            return ResponseUtil.createBadRequestResponse(tex.getMessage());
        }
        catch (TitlePersistenceException tvex) {
            logger.error((Object)tvex);
            return ResponseUtil.createBadRequestResponse(tvex.getMessage());
        }
        catch (EJBAccessException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (EJBException e) {
            logger.error((Object)e);
            return ResponseUtil.createBadRequestResponse(e.getCause().getLocalizedMessage());
        }
        catch (NotFoundException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createNotFoundResponse(ex.getMessage());
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return ResponseUtil.createInternalServerErrorResponse(ex.getMessage());
        }
    }

    @Override
    public Response getOfferReferencedTitles(HttpServletRequest httpRequest, Request request, String authorizationHeader, Long offerId) {
        try {
            Response.ResponseBuilder builder = null;
            builder = EndpointsAuthorizationUtil.authorizePermissions(httpRequest, builder, TITLE_VIEW);
            if (builder != null) {
                return builder.build();
            }
            PartnerUtils.getAuthorizedPartnerIds();
            if (!this.getTitleManager().isActive(offerId)) {
                throw new NotFoundException("The given offer Id is not active  [" + offerId + "]");
            }
            if (!this.getTitleManager().isOffer(offerId)) {
                return ResponseUtil.createBadRequestResponse("The given title Id is not an offer  [" + offerId + "]");
            }
            Title offer = this.getTitleManager().get(offerId);
            MediaType mediaType = ResponseTypeUtilities.getMediaTypeFromRequestJSONDefault(httpRequest);
            if (MediaType.APPLICATION_XML_TYPE.equals((Object)mediaType)) {
                String xmlResponse = ConversionUtil.getOfferReferencesXML(httpRequest, offer);
                return Response.ok((Object)xmlResponse, (String)"application/xml").header(CACHE_CONTROL, (Object)NO_CACHE).build();
            }
            String jsonResponse = ConversionUtil.getOfferReferencesJSON(httpRequest, offer);
            return Response.ok((Object)jsonResponse, (String)"application/json").header(CACHE_CONTROL, (Object)NO_CACHE).build();
        }
        catch (AuthorizationException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (TitleValidationException tex) {
            logger.error((Object)tex);
            return ResponseUtil.createBadRequestResponse(tex.getMessage());
        }
        catch (TitlePersistenceException tvex) {
            logger.error((Object)tvex);
            return ResponseUtil.createBadRequestResponse(tvex.getMessage());
        }
        catch (EJBAccessException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (EJBException e) {
            logger.error((Object)e);
            return ResponseUtil.createBadRequestResponse(e.getMessage());
        }
        catch (NotFoundException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createNotFoundResponse(ex.getMessage());
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return ResponseUtil.createInternalServerErrorResponse(ex.getMessage());
        }
    }

    @Override
    public Response removeTitleFromOffer(HttpServletRequest httpRequest, Request rsRequest, String authorizationHeader, Long offerId, Long titleId) {
        try {
            PartnerUtils.getAuthorizedPartnerIds();
            if (!this.getTitleManager().isActive(offerId)) {
                throw new NotFoundException("The given offer title Id is not active  [" + offerId + "]");
            }
            if (!this.getTitleManager().isActive(titleId)) {
                throw new NotFoundException("The given reference title Id is not active  [" + titleId + "]");
            }
            if (!this.getTitleManager().isOffer(offerId)) {
                return ResponseUtil.createBadRequestResponse("The given title Id is not an offer  [" + offerId + "]");
            }
            if (this.getTitleManager().isOffer(titleId)) {
                return ResponseUtil.createBadRequestResponse("The given reference title Id is an offer  [" + titleId + "]");
            }
            this.getTitleManager().removeTitleFromOffer(titleId, offerId, this.newTitleActionSource());
        }
        catch (AuthorizationException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (TitleValidationException tex) {
            logger.error((Object)tex);
            return ResponseUtil.createBadRequestResponse(tex.getMessage());
        }
        catch (TitlePersistenceException tvex) {
            logger.error((Object)tvex);
            return ResponseUtil.createBadRequestResponse(tvex.getMessage());
        }
        catch (EJBAccessException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (EJBException e) {
            logger.error((Object)e);
            return ResponseUtil.createBadRequestResponse(e.getMessage());
        }
        catch (NotFoundException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createNotFoundResponse(ex.getMessage());
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return ResponseUtil.createInternalServerErrorResponse(ex.getMessage());
        }
        logger.debug((Object)("Remove title " + titleId + " from offer " + offerId + " successful."));
        return ResponseUtil.createNoContentOKResponse();
    }

    private Processes createRequest() {
        return new API.Builder().build().processes();
    }

    @Override
    public Response updateProcessingStatus(HttpServletRequest httpRequest, Request rsRequest, String authorizationHeader, Long titleId, Integer statusCode) {
        logger.info((Object)"Received request to update processing status.");
        logger.debug((Object)("Request parameters: titleId = " + titleId + ", statusCode = " + statusCode + '.'));
        if (Objects.isNull(titleId)) {
            logger.warn((Object)TITLE_ID_IS_NULL);
            return this.getOkResponseForUpdateProcessingStatus(titleId, statusCode, TITLE_ID_IS_NULL);
        }
        if (Objects.isNull(statusCode)) {
            logger.warn((Object)"Status code is null.");
            return this.getOkResponseForUpdateProcessingStatus(titleId, statusCode, "Status code is null.");
        }
        if (titleId <= 0L) {
            logger.warn((Object)TITLE_ID_IS_ZERO_OR_NEGATIVE);
            return this.getOkResponseForUpdateProcessingStatus(titleId, statusCode, TITLE_ID_IS_ZERO_OR_NEGATIVE);
        }
        if (statusCode < 0) {
            logger.warn((Object)"Status code is negative.");
            return this.getOkResponseForUpdateProcessingStatus(titleId, statusCode, "Status code is negative.");
        }
        if (!this.getTitleManager().isActive(titleId)) {
            logger.warn((Object)("Received a request to update processing status of an inactive title [" + titleId + "]. It might be soft/hard deleted."));
            if (this.getTitleManager().isExisting(titleId)) {
                return this.getOkResponseForUpdateProcessingStatus(titleId, statusCode, "The title is soft deleted in the system.");
            }
            return this.getOkResponseForUpdateProcessingStatus(titleId, statusCode, "Title Id [" + titleId + "] is not active.");
        }
        TitleProcessingStatus titleProcessingStatus = this.getProcessStatus(statusCode);
        if (Objects.isNull(titleProcessingStatus)) {
            return this.getOkResponseForUpdateProcessingStatus(titleId, statusCode, "Title processing status is invalid.");
        }
        Title title = this.getTitleManager().get(titleId);
        if (Objects.isNull(title)) {
            return this.getOkResponseForUpdateProcessingStatus(titleId, statusCode, "Can't get title with title id [" + title + ']');
        }
        if (title.isCopy()) {
            return this.getOkResponseForUpdateProcessingStatus(titleId, statusCode, "Update Process Status only handles master titles, it does nothing since this request is from a site title.");
        }
        ProcessingStatusUpdater.updateProcessingStatus((Long)titleId, (TitleProcessingStatus)titleProcessingStatus);
        return this.getOkResponseForUpdateProcessingStatus(titleId, statusCode);
    }

    @Override
    public Response notifyDistributionRetry(HttpServletRequest httpRequest, Request rsRequest, String authorizationHeader, Long titleId, Long workOrderId, String eventType) {
        logger.info((Object)"Received request to retry distribution.");
        logger.debug((Object)("Request parameters: titleId = " + titleId + ", workOrderId = " + workOrderId + ", eventType = " + eventType + '.'));
        if (Objects.isNull(titleId)) {
            logger.warn((Object)TITLE_ID_IS_NULL);
            return this.getOkResponseForNotifyDistributionRetry(titleId, workOrderId, eventType, TITLE_ID_IS_NULL);
        }
        if (titleId <= 0L) {
            logger.warn((Object)TITLE_ID_IS_ZERO_OR_NEGATIVE);
            return this.getOkResponseForNotifyDistributionRetry(titleId, workOrderId, eventType, TITLE_ID_IS_ZERO_OR_NEGATIVE);
        }
        if (Objects.isNull(workOrderId)) {
            logger.warn((Object)"Work order id is null.");
            return this.getOkResponseForNotifyDistributionRetry(titleId, workOrderId, eventType, "Work order id is null.");
        }
        if (workOrderId <= 0L) {
            logger.warn((Object)"Work order id is 0 or negative.");
            return this.getOkResponseForNotifyDistributionRetry(titleId, workOrderId, eventType, "Work order id is 0 or negative.");
        }
        if (Objects.isNull(eventType)) {
            logger.warn((Object)"Event type is null.");
            return this.getOkResponseForNotifyDistributionRetry(titleId, workOrderId, eventType, "Event type is null.");
        }
        if (!this.getTitleManager().isActive(titleId)) {
            logger.warn((Object)("Received a request to update processing status of an inactive title [" + titleId + "]. It might be soft/hard deleted."));
            if (this.getTitleManager().isExisting(titleId)) {
                return this.getOkResponseForNotifyDistributionRetry(titleId, workOrderId, eventType, "The title is soft deleted in the system.");
            }
            return this.getOkResponseForNotifyDistributionRetry(titleId, workOrderId, eventType, "Title Id [" + titleId + "] is not active.");
        }
        Title title = this.getTitleManager().get(titleId);
        if (Objects.isNull(title)) {
            return this.getBadResponseForNotifyDistributionRetry(titleId, workOrderId, eventType, "Can't get title with title id [" + title + ']');
        }
        if (!title.isCopy()) {
            return this.getOkResponseForNotifyDistributionRetry(titleId, workOrderId, eventType, "Notify Distribution Retry only handles site titles, it does nothing since this request is from a master title.");
        }
        DistributionSiteTitle siteTitle = this.getSiteManager().getDistributionSiteTitle(titleId.longValue());
        if (Objects.isNull(siteTitle)) {
            return this.getBadResponseForNotifyDistributionRetry(titleId, workOrderId, eventType, "DistributionSiteTitle for site title id [" + titleId + "] is null.");
        }
        if (Objects.isNull(siteTitle.getStatus()) || DistributionStatus.FAILED != siteTitle.getStatus() && DistributionStatus.IN_PROGRESS != siteTitle.getStatus()) {
            return this.getOkResponseForNotifyDistributionRetry(titleId, workOrderId, eventType, "Distribution status should be FAILED or IN PROGRESS instead of :" + siteTitle.getStatus());
        }
        Long siteTitleId = siteTitle.getTitle().getId();
        if ("FAILED".equalsIgnoreCase(eventType)) {
            this.getSiteManager().executeActionOnFailure(siteTitleId, workOrderId, null);
        } else if ("CANCELLED".equalsIgnoreCase(eventType)) {
            this.getSiteManager().removeSiteTitleAttempts(siteTitleId);
        } else {
            logger.warn((Object)("Event type is " + eventType + " but only FAILED and CANCELLED are valid."));
            return this.getOkResponseForNotifyDistributionRetry(titleId, workOrderId, eventType, "Event type must be FAILED or CANCELLED.");
        }
        return this.getOkResponseForNotifyDistributionRetry(titleId, workOrderId, eventType);
    }

    private TitleProcessingStatus getProcessStatus(Integer statusCode) {
        TitleProcessingStatus[] titleProcessingStatusArray = TitleProcessingStatus.values();
        int n = titleProcessingStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            TitleProcessingStatus status = titleProcessingStatusArray[n2];
            if (statusCode.intValue() == status.ordinal()) {
                return status;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Response listUsers(HttpServletRequest httpRequest, Request rsRequest, String authorizationHeader, Integer start, Integer count, Boolean includeSelfPartnerUsers, Long titleId) {
        TitleListParameterBuilder paramBld = new TitleListParameterBuilder();
        TreeSet<PartnerUser> sortedUsersSet = new TreeSet<PartnerUser>(this.defaultUsersComparator());
        try {
            if (!paramBld.setDetailAndPageInfo("list", start, count)) {
                return paramBld.getErrorResponse();
            }
            if (!this.isTitleExist(titleId)) {
                return ResponseUtil.createNotFoundResponse("Title Id: " + titleId + " is not found");
            }
            sortedUsersSet.addAll(this.getPartnerService().getUsersByTitleId(titleId));
            if (includeSelfPartnerUsers.booleanValue()) {
                sortedUsersSet.addAll(this.getPartnerService().getSelfPartnerUsers());
            }
            List<Object> users = new ArrayList<PartnerUser>(sortedUsersSet);
            int total = users.size();
            users = ConversionUtil.getCurrentPage(users, start, count);
            MediaType mediaType = ResponseTypeUtilities.getMediaTypeFromRequestJSONDefault(httpRequest);
            if (MediaType.APPLICATION_XML_TYPE.equals((Object)mediaType)) {
                Document doc = ConversionUtil.getXMLforUsers(users, httpRequest, start, count, total, this.uri);
                return Response.ok((Object)ConversionUtil.serialize(doc), (String)"application/xml").header(CACHE_CONTROL, (Object)NO_CACHE).build();
            }
            JSONObject obj = ConversionUtil.getJSONForUsers(users, httpRequest, start, count, total, this.uri);
            return Response.ok((Object)obj.toString(), (String)"application/json").header(CACHE_CONTROL, (Object)NO_CACHE).build();
        }
        catch (Exception ex) {
            logger.error((Object)("Error occured while getting users for the titleId: " + titleId), (Throwable)ex);
            return ResponseUtil.createInternalServerErrorResponse(ex.getMessage());
        }
    }

    private Comparator<PartnerUser> defaultUsersComparator() {
        return new Comparator<PartnerUser>(){

            @Override
            public int compare(PartnerUser o1, PartnerUser o2) {
                return o1.getUserName().toLowerCase().compareTo(o2.getUserName().toLowerCase());
            }
        };
    }

    private boolean isTitleExist(Long titleId) {
        TitleFilter filter = new TitleFilter();
        filter.setRootNode((ExpNode)this.getTitleIdCriteria(titleId));
        filter.setCriteriaMode(CriteriaMode.MASTER);
        TitleSearchResult results = this.getTitleSearchService().getSearchResults(filter, new ArrayList(0), new ArrayList());
        if (results.getRows().isEmpty()) {
            filter.setCriteriaMode(CriteriaMode.SITE);
            results = this.getTitleSearchService().getSearchResults(filter, new ArrayList(0), new ArrayList());
        }
        if (results.getRows().isEmpty()) {
            filter.setCriteriaMode(CriteriaMode.SERIES);
            results = this.getTitleSearchService().getSearchResults(filter, new ArrayList(0), new ArrayList());
        }
        return !results.getRows().isEmpty();
    }

    private ExpValue getTitleIdCriteria(Long titleId) {
        List<String> titleIdsStr = Arrays.asList(String.valueOf(titleId));
        PredicateRightValue condition = new PredicateRightValue("id", "", FieldType.PMM_TITLE, titleIdsStr, LogicalOperator.EQUAL, "integer", Boolean.valueOf(false));
        return new ExpValue((Predicate)condition);
    }

    private void checkLicense(String contentClassName) {
        LicenseManager.getInstance().canIngestMasterTitle(LicenseFilter.newBuilder().setContentClassName(contentClassName).build());
    }

    private Response getOkResponseForUpdateProcessingStatus(Long titleId, Integer statusCode, String msg) {
        return JsonResponseBuilder.newInstance().setTitle(titleId).setStatusCode(statusCode).setMsg(msg).build();
    }

    private Response getOkResponseForUpdateProcessingStatus(Long titleId, Integer statusCode) {
        return JsonResponseBuilder.newInstance().setTitle(titleId).setStatusCode(statusCode).build();
    }

    private Response getBadResponseForNotifyDistributionRetry(Long titleId, Long workOrderId, String eventType, String errorMsg) {
        return JsonResponseBuilder.newInstance().setOk(false).setTitle(titleId).setWorkOrderId(workOrderId).setEventType(eventType).setErrorMsg(errorMsg).build();
    }

    private Response getOkResponseForNotifyDistributionRetry(Long titleId, Long workOrderId, String eventType) {
        return JsonResponseBuilder.newInstance().setTitle(titleId).setWorkOrderId(workOrderId).setEventType(eventType).build();
    }

    private Response getOkResponseForNotifyDistributionRetry(Long titleId, Long workOrderId, String eventType, String msg) {
        return JsonResponseBuilder.newInstance().setTitle(titleId).setWorkOrderId(workOrderId).setEventType(eventType).setMsg(msg).build();
    }

    @Transactional
    private boolean validateSiteFilter(List<Integer> filterSiteIds, List<com.ericsson.cms.sites.core.entities.Site> sites) {
        List<Integer> list = filterSiteIds;
        List<com.ericsson.cms.sites.core.entities.Site> list2 = sites;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = TitleServiceNG.class.getDeclaredMethod("validateSiteFilter", List.class, List.class).getAnnotation(Transactional.class);
        }
        return Conversions.booleanValue((Object)TitleServiceNG.validateSiteFilter_aroundBody11$advice(this, list, list2, transactionEnforcer, (Transactional)annotation, null));
    }

    private static final /* synthetic */ void filterSites_aroundBody0(TitleServiceNG ajc$this, List dSites, List tSites, List sites) {
        HashSet childSites = new HashSet();
        for (com.ericsson.cms.sites.core.entities.Site site : sites) {
            if (site.getType() == SiteType.DISTRIBUTION && !dSites.contains(site.getId())) {
                dSites.add(site.getId());
                continue;
            }
            if (site.getType() == SiteType.TRACKING && !tSites.contains(site.getId())) {
                tSites.add(site.getId());
                continue;
            }
            if (site.getType() != SiteType.LOGICAL) continue;
            site = ajc$this.getSiteManager().getSite(site.getId().intValue());
            childSites.addAll(site.getSiteChildren());
        }
        if (!childSites.isEmpty()) {
            ajc$this.filterSites(dSites, tSites, new ArrayList<com.ericsson.cms.sites.core.entities.Site>(childSites));
        }
    }

    private static final /* synthetic */ Object filterSites_aroundBody1$advice(TitleServiceNG ajc$this, List dSites, List tSites, List sites, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleServiceNG.filterSites_aroundBody0(ajc$this, dSites, tSites, sites);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleServiceNG.filterSites_aroundBody0(ajc$this, dSites, tSites, sites);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getCMSTitleList_aroundBody2(TitleServiceNG ajc$this, Long titleId, String type) {
        ArrayList<DistributionSiteTitle> distributeTitles = ajc$this.getSiteManager().getDistributionSiteTitles(titleId.longValue());
        if (distributeTitles == null || distributeTitles.isEmpty()) {
            distributeTitles = new ArrayList<DistributionSiteTitle>();
            DistributionSiteTitle siteTitle = ajc$this.getSiteManager().getDistributionSiteTitle(titleId.longValue());
            if (siteTitle != null) {
                distributeTitles.add(siteTitle);
            }
        }
        return ajc$this.getCMSTitles(distributeTitles, type);
    }

    private static final /* synthetic */ Object getCMSTitleList_aroundBody3$advice(TitleServiceNG ajc$this, Long titleId, String type, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleServiceNG.getCMSTitleList_aroundBody2(ajc$this, titleId, type);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = TitleServiceNG.getCMSTitleList_aroundBody2(ajc$this, titleId, type);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ ISavedTitle updateTitle_aroundBody4(TitleServiceNG ajc$this, Title titleToSave) {
        ISavedTitle result = null;
        NormalizedItem normalizedItem = ajc$this.getTitleManager().normalizeTitle(titleToSave, TreEvent.INGESTED.name());
        Title newTitleToSave = normalizedItem.getTitle();
        ITitleActionSource source = ajc$this.newTitleActionSource();
        try {
            result = ajc$this.getTitleManager().update(newTitleToSave, false, ajc$this.newTitleActionSource());
        }
        catch (TitleValidationException ex) {
            logger.warn((Object)ex);
            result = ajc$this.getTitleManager().update(newTitleToSave, true, ajc$this.newTitleActionSource());
            result = new SaveResult(result.getTitle(), ex.getMessages());
        }
        ajc$this.statusService.sendStatus(newTitleToSave, "NORMALIZED", normalizedItem.getNormalizationChangeInfo(), true, source.getComponentName(), source.getEntityName(), source.getID());
        return result;
    }

    private static final /* synthetic */ Object updateTitle_aroundBody5$advice(TitleServiceNG ajc$this, Title titleToSave, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleServiceNG.updateTitle_aroundBody4(ajc$this, titleToSave);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ISavedTitle object = TitleServiceNG.updateTitle_aroundBody4(ajc$this, titleToSave);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ ISavedTitle uiUpdateTitle_aroundBody6(TitleServiceNG ajc$this, String userName, Title titleToSave) {
        Long requestKey = null;
        String listOfAssetIds = null;
        String action = null;
        SaveResult result = null;
        String ENTITY_NAME = null;
        String meRequestKey = null;
        try {
            result = ajc$this.pmmUIService.updateTitleMetadata(titleToSave, requestKey, action, listOfAssetIds, CONTENT_MANAGEMENT, ENTITY_NAME, userName, meRequestKey);
        }
        catch (TitleValidationException e) {
            logger.info((Object)e);
            Title savedTitle = ajc$this.pmmUIService.updateTitleMetadataAsDraft(titleToSave, CONTENT_MANAGEMENT, ENTITY_NAME, userName);
            result = new SaveResult(savedTitle, e.getMessages());
        }
        return result;
    }

    private static final /* synthetic */ Object uiUpdateTitle_aroundBody7$advice(TitleServiceNG ajc$this, String userName, Title titleToSave, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleServiceNG.uiUpdateTitle_aroundBody6(ajc$this, userName, titleToSave);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ISavedTitle object = TitleServiceNG.uiUpdateTitle_aroundBody6(ajc$this, userName, titleToSave);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Response executeSavedSearch_aroundBody8(TitleServiceNG ajc$this, HttpServletRequest httpRequest, Request rsRequest, String authorizationHeader, Integer searchId, Integer start, Integer count, String detail, String fields, String sortColumnName, String sortOrder) {
        Response.ResponseBuilder builder = null;
        if ((builder = EndpointsAuthorizationUtil.authorizePermissions(httpRequest, builder, TITLE_VIEW)) != null) {
            return builder.build();
        }
        TitleListParameterBuilder paramBld = new TitleListParameterBuilder();
        try {
            TitleFilter titleFilter;
            if (!paramBld.setDetailAndPageInfo(detail, start, count)) {
                return paramBld.getErrorResponse();
            }
            paramBld.setMediaType(rsRequest);
            if (sortColumnName != null && sortColumnName.trim().length() > 0) {
                sortOrder = "ASC".equalsIgnoreCase(sortOrder) ? "ASC" : "DESC";
                paramBld.setSortInfo(sortColumnName, sortOrder);
            } else {
                paramBld.setSortInfo("lastModified", "DESC");
            }
            if (searchId.equals(0)) {
                ExpList rootNode = new ExpListBuilder().build();
                titleFilter = new TitleFilter((ExpNode)rootNode, paramBld.getSortInfo(), paramBld.getPagingInfo());
            } else {
                TitleSearch search = ajc$this.titleSearchService.getTitleSearch((Serializable)searchId);
                if (!search.getShared().booleanValue() && !ajc$this.getCurrentUser().equals(search.getUserName())) {
                    throw new AuthorizationException("You have no permission to execute this search");
                }
                titleFilter = search.getFilter();
                titleFilter.setPageInfo(paramBld.getPagingInfo());
                titleFilter.setSortInfo(paramBld.getSortInfo());
            }
            List<SearchColumn> searchColumns = paramBld.buildSearchColumns(fields);
            if (searchColumns == null) {
                return paramBld.getErrorResponse();
            }
            TitleSearchResult searchResults = ajc$this.getTitleSearchService().getSearchResults(titleFilter, PartnerUtils.getAuthorizedPartnerIds(), searchColumns);
            String hrefStub = HrefHelper.buildHrefToPageStub(httpRequest, count, detail, fields);
            String output = paramBld.getMediaType().equals((Object)MediaType.APPLICATION_JSON_TYPE) ? ajc$this.jsonMarshaller.getResultsAsJson(searchResults, httpRequest, searchColumns, start, count, hrefStub, paramBld.getListDetail()) : ajc$this.xmlMarshaller.getResultsAsXml(searchResults, httpRequest, searchColumns, start, count, hrefStub, paramBld.getListDetail());
            return Response.status((Response.Status)Response.Status.OK).header(CACHE_CONTROL, (Object)NO_CACHE).type(paramBld.getMediaType()).entity((Object)output).build();
        }
        catch (TitleSearchNotFoundException e) {
            logger.error((Object)ERROR, (Throwable)e);
            return ResponseUtil.createNotFoundResponse(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)ERROR, (Throwable)e);
            return ResponseUtil.createBadRequestResponse(e.getMessage());
        }
        catch (AuthorizationException e1) {
            logger.error((Object)ERROR, (Throwable)e1);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (UnauthorizedUserException e) {
            logger.error((Object)ERROR, (Throwable)e);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (EJBAccessException ex) {
            logger.error((Object)ERROR, (Throwable)ex);
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof IllegalArgumentException) {
                return ResponseUtil.createBadRequestResponse(ex.getMessage());
            }
            logger.error((Object)ERROR_HAPPENED, (Throwable)ex);
            return ResponseUtil.createInternalServerErrorResponse(ex.getMessage());
        }
    }

    private static final /* synthetic */ Object executeSavedSearch_aroundBody9$advice(TitleServiceNG ajc$this, HttpServletRequest httpRequest, Request rsRequest, String authorizationHeader, Integer searchId, Integer start, Integer count, String detail, String fields, String sortColumnName, String sortOrder, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleServiceNG.executeSavedSearch_aroundBody8(ajc$this, httpRequest, rsRequest, authorizationHeader, searchId, start, count, detail, fields, sortColumnName, sortOrder);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = TitleServiceNG.executeSavedSearch_aroundBody8(ajc$this, httpRequest, rsRequest, authorizationHeader, searchId, start, count, detail, fields, sortColumnName, sortOrder);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ boolean validateSiteFilter_aroundBody10(TitleServiceNG ajc$this, List filterSiteIds, List sites) {
        if (CollectionUtils.isEmpty((Collection)filterSiteIds)) {
            return true;
        }
        sites.addAll(ajc$this.getSiteManager().getSitesByIds(filterSiteIds));
        return !sites.isEmpty();
    }

    private static final /* synthetic */ Object validateSiteFilter_aroundBody11$advice(TitleServiceNG ajc$this, List filterSiteIds, List sites, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.booleanObject((boolean)TitleServiceNG.validateSiteFilter_aroundBody10(ajc$this, filterSiteIds, sites));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.booleanObject((boolean)TitleServiceNG.validateSiteFilter_aroundBody10(ajc$this, filterSiteIds, sites));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    public static class SiteTitleCount {
        public String type;
        public String siteHref;
        public String name;
        public Integer titleCount;
        public String titleHref;
    }
}

