/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.titles;

import com.ericsson.cms.criteria.SearchColumn;
import com.ericsson.cms.search.TitleSearchResult;
import com.ericsson.cms.sites.core.entities.Site;
import com.tandbergtv.cms.services.data.CMSTitle;
import com.tandbergtv.cms.services.data.TrackingSite;
import com.tandbergtv.cms.services.titles.CategoryService;
import com.tandbergtv.cms.services.titles.HrefHelper;
import com.tandbergtv.cms.services.titles.ListDetail;
import com.tandbergtv.cms.services.titles.SearchColumnExt;
import com.tandbergtv.cms.util.ContentClassUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class XmlMarshaller {
    private static final String ECMF_DOC = "doc";
    private static final String CONTENT_CLASS = "contentClassId";
    private static final String CONTENT_CLASS_TYPE = "contentClassType";
    private static final String XML_DECLARATION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private HrefHelper hrefHelper = new HrefHelper();

    public String getResultsAsXml(TitleSearchResult searchResults, HttpServletRequest request, List<SearchColumn> searchColumns, int start, int count, String hrefStub, ListDetail ld) {
        StringBuffer sb = new StringBuffer();
        long total = searchResults.getCount();
        Map<Long, String> contentClassTypes = ContentClassUtil.getContentClassTypes();
        sb.append(XML_DECLARATION);
        sb.append("<resourceList");
        sb.append(" start=\"").append(start).append("\"");
        sb.append(" count=\"").append(searchResults.getRows().size()).append("\"");
        if (ld == ListDetail.portal) {
            sb.append(" total=\"").append(total).append('\"');
        }
        String hrefStubEncoded = StringEscapeUtils.escapeXml((String)hrefStub);
        if (start > 0) {
            sb.append(" first=\"").append(hrefStubEncoded).append("0\"");
            long prevStart = start - count;
            if (prevStart < 0L) {
                prevStart = 0L;
            } else if (prevStart >= total) {
                prevStart = total - (long)count;
            }
            sb.append(" prev=\"").append(hrefStubEncoded).append(prevStart).append("\"");
        }
        if (searchResults.hasMoreResults()) {
            int nextPageStart = start + count;
            sb.append(" next=\"").append(hrefStubEncoded).append(nextPageStart).append("\"");
        }
        sb.append(">");
        for (TitleSearchResult.SearchRow row : searchResults.getRows()) {
            String posterHref;
            String href = HrefHelper.buildGetHref(request, row.getId());
            sb.append("<cmsTitle href=\"");
            sb.append(href);
            sb.append("\">");
            HashMap<String, String> additionalFields = new HashMap<String, String>();
            int i = 0;
            while (i < row.getFields().size()) {
                SearchColumnExt sc = (SearchColumnExt)searchColumns.get(i);
                String value = row.getFirstValueAsString(i);
                if (!value.isEmpty()) {
                    String displayName = sc.getDisplayName();
                    if (sc.isMultiValue()) {
                        Object obj = row.getValue(i);
                        if (obj instanceof List) {
                            for (Object objValue : (List)obj) {
                                sb.append("<" + displayName + ">");
                                sb.append(StringEscapeUtils.escapeXml((String)objValue.toString()));
                                sb.append("</" + displayName + ">");
                            }
                        } else {
                            sb.append("<" + displayName + ">");
                            sb.append(StringEscapeUtils.escapeXml((String)obj.toString()));
                            sb.append("</" + displayName + ">");
                        }
                    } else if (displayName.startsWith("/ECMFSpec/")) {
                        additionalFields.put(displayName, value);
                    } else if (ld == ListDetail.portal && sc.getFieldName().equals(CONTENT_CLASS)) {
                        sb.append("<").append(CONTENT_CLASS_TYPE).append(">");
                        sb.append(contentClassTypes.get(Long.parseLong(value)));
                        sb.append("</").append(CONTENT_CLASS_TYPE).append(">");
                    } else {
                        sb.append("<").append(displayName).append(">");
                        if (sc.getFieldName().equals(ECMF_DOC) && value.startsWith("<?")) {
                            sb.append(value.substring(value.indexOf("?>") + 2));
                        } else {
                            sb.append(StringEscapeUtils.escapeXml((String)value));
                        }
                        sb.append("</").append(displayName).append(">");
                    }
                }
                ++i;
            }
            if (ld == ListDetail.portal && (posterHref = this.hrefHelper.buildFirstPosterHref(row.getId())) != null) {
                sb.append("<thumbnail servicePath=\"").append(posterHref).append("\" />");
            }
            if (!additionalFields.isEmpty()) {
                this.addFields(additionalFields, sb);
            }
            sb.append("</cmsTitle>");
        }
        sb.append("</resourceList>");
        return sb.toString();
    }

    private void addFields(Map<String, String> additionalFields, StringBuffer sb) {
        sb.append("<extFields>");
        for (Map.Entry<String, String> entry : additionalFields.entrySet()) {
            sb.append("<field>");
            sb.append("<name>").append(StringEscapeUtils.escapeXml((String)entry.getKey())).append("</name>");
            sb.append("<value>").append(StringEscapeUtils.escapeXml((String)entry.getValue())).append("</value>");
            sb.append("</field>");
        }
        sb.append("</extFields>");
    }

    public static String buildDueXml(long[] results) {
        return String.format("<dueStatusSummary> <ready>%d</ready> <committed>%d</committed> <failed>%d</failed> </dueStatusSummary>", results[0], results[1], results[2]);
    }

    public static String buildSiteXml(Set<Site> sitesTargeted, HttpServletRequest request) {
        StringBuffer sb = new StringBuffer(XML_DECLARATION);
        sb.append("<resourceList>");
        Iterator<Site> iterator = sitesTargeted.iterator();
        while (iterator.hasNext()) {
            sb.append("<site href=\"");
            sb.append(StringEscapeUtils.escapeXml((String)HrefHelper.buildSiteHref(iterator.next().getId(), request)));
            sb.append("\" />");
        }
        sb.append("</resourceList>");
        return sb.toString();
    }

    public static String getSiteTitlesResultAsXML(List<CMSTitle> siteTitles, HttpServletRequest request, String type) {
        StringBuffer sb = new StringBuffer();
        sb.append(XML_DECLARATION);
        sb.append("<resourceList>");
        for (CMSTitle siteTitle : siteTitles) {
            sb.append("<cmsTitle href=\"");
            sb.append(StringEscapeUtils.escapeXml((String)HrefHelper.buildGetHref(request, siteTitle.getId())));
            sb.append("\"><site href=\"").append(StringEscapeUtils.escapeXml((String)HrefHelper.buildSiteHref(siteTitle.getSite().getId(), request))).append("\">");
            sb.append("<id>").append(siteTitle.getSite().getId()).append("</id>");
            sb.append("<name>").append(StringEscapeUtils.escapeXml((String)siteTitle.getSite().getName())).append("</name>");
            sb.append("</site>");
            sb.append("<distributionStatus>").append(StringEscapeUtils.escapeXml((String)siteTitle.getDistributionStatus())).append("</distributionStatus>");
            if (StringUtils.equals((String)"all", (String)type)) {
                XmlMarshaller.appendTrackingSite(sb, siteTitle.getTrackingSite(), request);
            }
            sb.append("</cmsTitle>");
        }
        sb.append("</resourceList>");
        return sb.toString();
    }

    private static void appendTrackingSite(StringBuffer sb, List<TrackingSite> list, HttpServletRequest request) {
        if (list == null) {
            return;
        }
        for (TrackingSite ts : list) {
            sb.append("<trackingSite href=\"").append(StringEscapeUtils.escapeXml((String)HrefHelper.buildSiteHref(ts.getId(), request))).append("\">");
            XmlMarshaller.addElement(sb, "id", ts.getId());
            XmlMarshaller.addElement(sb, "name", ts.getName());
            XmlMarshaller.addElement(sb, "status", StringEscapeUtils.escapeXml((String)ts.getStatus()));
            sb.append("</trackingSite>");
        }
    }

    public String getCategoriesAsXml(List<CategoryService.CategoryResponse> categoriesResponse) {
        StringBuffer sb = new StringBuffer();
        sb.append(XML_DECLARATION);
        sb.append("<resourceList>");
        sb.append(this.getChildrenCategoriesAsXml(categoriesResponse));
        sb.append("</resourceList>");
        return sb.toString();
    }

    private String getChildrenCategoriesAsXml(List<CategoryService.CategoryResponse> categoriesResponse) {
        StringBuffer sb = new StringBuffer();
        for (CategoryService.CategoryResponse category : categoriesResponse) {
            sb.append("<category>");
            sb.append("<name>").append(StringEscapeUtils.escapeXml((String)category.name)).append("</name>");
            sb.append("<path>").append(StringEscapeUtils.escapeXml((String)category.path)).append("</path>");
            sb.append("<children>").append(this.getChildrenCategoriesAsXml(category.children)).append("</children>");
            sb.append("</category>");
        }
        return sb.toString();
    }

    private static void addElement(StringBuffer sb, String elementName, Object value) {
        if (sb != null) {
            sb.append("<").append(elementName).append(">").append(value).append("</").append(elementName).append(">");
        }
    }
}

