/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.titles;

import com.tandbergtv.cms.services.titles.HrefHelper;
import com.tandbergtv.cms.services.util.ConversionUtil;
import com.tandbergtv.metadatamanager.exception.TranslationException;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationMessage;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringEscapeUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtil {
    public static Node findFirstChildNode(String path, Node node) {
        return XmlUtil.findFirstChildNode(path.split("/"), 0, node);
    }

    public static Node findFirstChildNode(String[] path, int index, Node node) {
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node childNode = childNodes.item(i);
            String nodeName = childNode.getNodeName();
            if (path[index].equals(nodeName) && path.length == index + 1) {
                return childNode;
            }
            if (path[index].equals(nodeName)) {
                return XmlUtil.findFirstChildNode(path, ++index, childNode);
            }
            ++i;
        }
        return null;
    }

    public static Document convertTitle(Specification spec, HttpServletRequest servletReq, Title title, List<TitleValidationMessage> messages) throws TranslationException {
        ISpecHandler specHandler = spec.getSpecHandler();
        Asset root = title.getAsset();
        Document document = specHandler.convertAssetToXMLDocument(root);
        if (spec.getName().equals("TTV")) {
            Element cmsTitle = document.createElement("cmsTitle");
            cmsTitle.setAttribute("href", HrefHelper.buildGetHref(servletReq, title.getId()));
            Element status = document.createElement("status");
            status.setTextContent(title.getStatus().toString());
            cmsTitle.appendChild(status);
            if (!title.isCopy() && root.getAssetType().equalsIgnoreCase("PACKAGE")) {
                Element distributionStatus = document.createElement("distributionStatus");
                distributionStatus.setTextContent(title.getDistributionStatus().toString());
                cmsTitle.appendChild(distributionStatus);
                if (title.getDistributionDate() != null) {
                    Element distributionDate = document.createElement("distributionDate");
                    distributionDate.setTextContent(title.getDistributionDate().toString());
                    cmsTitle.appendChild(distributionDate);
                }
                Element processingStatus = document.createElement("processingStatus");
                processingStatus.setTextContent(title.getProcessingStatus().toString());
                cmsTitle.appendChild(processingStatus);
            }
            Element metadata = document.createElement("metadata");
            cmsTitle.appendChild(metadata);
            Element ecmf = document.getDocumentElement();
            document.removeChild(ecmf);
            metadata.appendChild(ecmf);
            document.appendChild(cmsTitle);
            if (messages != null && !messages.isEmpty()) {
                cmsTitle.appendChild(XmlUtil.getValidationErrorMessages(messages, document));
            }
        }
        return document;
    }

    public static Element getValidationErrorMessages(List<TitleValidationMessage> messages, Document document) {
        Element validationErrorMessages = document.createElement("TitleValidationMessages");
        for (TitleValidationMessage m : messages) {
            Element me = document.createElement("TitleValidationMessage");
            if (m.getType() != null) {
                me.setAttribute("type", m.getType().name());
            }
            me.setTextContent(StringEscapeUtils.escapeXml((String)m.getMessage()));
            validationErrorMessages.appendChild(me);
        }
        return validationErrorMessages;
    }

    public static Document createPurgeErrorDoc(Map<Title, Exception> result) throws Exception {
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = db.newDocument();
        Element root = doc.createElement("sitetitles");
        doc.appendChild(root);
        for (Map.Entry<Title, Exception> entry : result.entrySet()) {
            Element title = doc.createElement("sitetitle");
            title.appendChild(ConversionUtil.createChild("titleId", entry.getKey().getId(), doc));
            title.appendChild(ConversionUtil.createChild("error", entry.getValue().getLocalizedMessage(), doc));
            root.appendChild(title);
        }
        return doc;
    }

    public static void stripOutEcmfIdentifiers(Document doc) throws XPathExpressionException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        NodeList assetIds = (NodeList)xpath.evaluate("//@assetId", doc, XPathConstants.NODESET);
        int i = 0;
        while (i < assetIds.getLength()) {
            Node assetId = assetIds.item(i);
            ((Attr)assetId).getOwnerElement().removeAttribute("assetId");
            ++i;
        }
        NodeList ecmfSpecs = (NodeList)xpath.evaluate("/ECMFSpec", doc, XPathConstants.NODESET);
        int i2 = 0;
        while (i2 < ecmfSpecs.getLength()) {
            Element ecmfSpec = (Element)ecmfSpecs.item(i2);
            ecmfSpec.removeAttribute("documentId");
            ecmfSpec.removeAttribute("originalDocumentId");
            ecmfSpec.removeAttribute("revision");
            ecmfSpec.removeAttribute("originalDocumentRevision");
            ++i2;
        }
    }

    public static String getDocumentContents(Document document) throws TransformerException {
        DOMSource domSource = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, result);
        return writer.toString();
    }
}

