/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.util;

import javax.ws.rs.core.UriBuilder;

public class PaginableUrlBuilder {
    private final UriBuilder baseUrl;
    private int start = 0;
    private int count = 100;
    private int total;

    public PaginableUrlBuilder(UriBuilder baseUrl) {
        this.baseUrl = baseUrl;
    }

    public PaginableUrlBuilder start(int start) {
        this.start = start;
        return this;
    }

    public PaginableUrlBuilder count(int count) {
        this.count = count;
        return this;
    }

    public PaginableUrlBuilder total(int total) {
        this.total = total;
        return this;
    }

    public PaginableUrlBuilder param(String key, String value) {
        this.baseUrl.queryParam(key, new Object[]{value});
        return this;
    }

    public PaginableUrlBuilder build() {
        return this;
    }

    public boolean isFirst() {
        return this.start == 0;
    }

    public boolean isLast() {
        return this.start + this.count >= this.total;
    }

    public String first() {
        return this.baseUrl.clone().queryParam("start", new Object[]{0}).queryParam("count", new Object[]{this.count > this.total ? this.total : this.count}).build(new Object[0]).toString();
    }

    public String prev() {
        boolean isEnough = this.start - this.count >= 0;
        return this.baseUrl.clone().queryParam("start", new Object[]{!isEnough ? 0 : this.start - this.count}).queryParam("count", new Object[]{!isEnough ? this.start : this.count}).build(new Object[0]).toString();
    }

    public String next() {
        int end = this.start + this.count;
        if (end >= this.total) {
            return this.baseUrl.clone().queryParam("start", new Object[]{this.start}).queryParam("count", new Object[]{this.total - this.start}).build(new Object[0]).toString();
        }
        boolean isEnough = end + this.count <= this.total;
        return this.baseUrl.clone().queryParam("start", new Object[]{end}).queryParam("count", new Object[]{!isEnough ? this.total - end : this.count}).build(new Object[0]).toString();
    }

    public String last() {
        if (this.count >= this.total) {
            return this.baseUrl.clone().queryParam("start", new Object[]{0}).queryParam("count", new Object[]{this.total}).build(new Object[0]).toString();
        }
        int remainder = this.total % this.count;
        int size = remainder == 0 ? this.count : remainder;
        return this.baseUrl.clone().queryParam("start", new Object[]{this.total - size}).queryParam("count", new Object[]{size}).build(new Object[0]).toString();
    }
}

