/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.util;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Variant;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.jettison.mapped.Configuration;
import org.codehaus.jettison.mapped.MappedNamespaceConvention;
import org.codehaus.jettison.mapped.MappedXMLStreamWriter;

public class ResponseTypeUtilities {
    private static final String ACCEPT_HEADER = "accept";

    public static MediaType getMediaTypeFromRequest(@Context Request request) {
        List responseVariants = Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.valueOf((String)"application/xml"), MediaType.valueOf((String)"application/json")}).add().build();
        Variant bestVariant = request.selectVariant(responseVariants);
        if (bestVariant == null) {
            return MediaType.APPLICATION_XML_TYPE;
        }
        MediaType mediaType = bestVariant.getMediaType();
        if (mediaType.isCompatible(MediaType.APPLICATION_XML_TYPE)) {
            return MediaType.APPLICATION_XML_TYPE;
        }
        if (mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
            return MediaType.APPLICATION_JSON_TYPE;
        }
        return MediaType.APPLICATION_XML_TYPE;
    }

    public static MediaType getMediaTypeFromRequestJSONDefault(@Context HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = request.getHeader(key);
            map.put(key, value);
        }
        if (map.containsKey(ACCEPT_HEADER) && ((String)map.get(ACCEPT_HEADER)).equalsIgnoreCase("application/xml")) {
            return MediaType.APPLICATION_XML_TYPE;
        }
        return MediaType.APPLICATION_JSON_TYPE;
    }

    public static String toJSON(Object obj) throws Exception {
        StringWriter writer = new StringWriter();
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{obj.getClass()});
        HashMap<String, String> xmlToJsonNamespaces = new HashMap<String, String>();
        xmlToJsonNamespaces.put("http://satv.ericsson.org/cms/services", "");
        xmlToJsonNamespaces.put("http://www.w3.org/2001/XMLSchema-instance", "");
        Configuration config = new Configuration(xmlToJsonNamespaces);
        config.setSupressAtAttributes(true);
        MappedNamespaceConvention con = new MappedNamespaceConvention(config);
        MappedXMLStreamWriter xmlStreamWriter = new MappedXMLStreamWriter(con, (Writer)writer);
        Marshaller marshaller = jc.createMarshaller();
        marshaller.marshal(obj, (XMLStreamWriter)xmlStreamWriter);
        return writer.toString();
    }
}

