/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.conf;

import com.tandbergtv.watchpoint.pmm.title.conf.AutofillProvider;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import com.tandbergtv.watchpoint.pmm.util.LocalizedMessageUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UISpecification {
    private Type type;
    private TitleConf rootTitleConf;
    private ClassLoader classLoader;
    private String tableConfigurationPath;
    private String bundleBaseName;
    private Map<String, TitleConf> assetMap;
    private List<AutofillProvider> autofillProviders;
    private Object autofillProvidersLock = new Object();
    private LocalizedMessageUtil localizedMessageUtil;

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public TitleConf getRootTitleConf() {
        return this.rootTitleConf;
    }

    public void setRootTitleConf(TitleConf rootTitleConf) {
        this.rootTitleConf = rootTitleConf;
        this.assetMap = new HashMap<String, TitleConf>();
        for (TitleConf asset : this.getAllTitleConf()) {
            this.assetMap.put(asset.getPath(), asset);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String getBundleString(String key) {
        return this.getLocalizedMessageUtil().getMessageValue(key);
    }

    private LocalizedMessageUtil getLocalizedMessageUtil() {
        if (this.localizedMessageUtil == null) {
            this.localizedMessageUtil = new LocalizedMessageUtil(this.bundleBaseName, this.bundleBaseName, this.classLoader);
        }
        return this.localizedMessageUtil;
    }

    public String getTableConfigurationPath() {
        return this.tableConfigurationPath;
    }

    public void setTableConfigurationPath(String tableConfigurationPath) {
        this.tableConfigurationPath = tableConfigurationPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AutofillProvider> getAutofillProviders() {
        Object object = this.autofillProvidersLock;
        synchronized (object) {
            return this.autofillProviders;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutofillProviders(List<AutofillProvider> list) {
        Object object = this.autofillProvidersLock;
        synchronized (object) {
            this.autofillProviders = list;
        }
    }

    public List<TitleConf> getAllTitleConf() {
        ArrayList<TitleConf> allTitleConf = new ArrayList<TitleConf>();
        allTitleConf.add(this.rootTitleConf);
        allTitleConf.addAll(this.rootTitleConf.getAllDescendants());
        return allTitleConf;
    }

    public String getBundleBaseName() {
        return this.bundleBaseName;
    }

    public void setBundleBaseName(String bundleBaseName) {
        this.bundleBaseName = bundleBaseName;
    }

    public InputStream getTableExtensionConfiguration() {
        return this.classLoader.getResourceAsStream(this.tableConfigurationPath);
    }

    public TitleConf findAssetByPath(String path) {
        if (this.assetMap == null) {
            return null;
        }
        return this.assetMap.get(path);
    }

    public static enum Type {
        PACKAGE,
        SERIES;

    }
}

